/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.AsstactType;
import kd.fi.ai.BizAssit;
import kd.fi.ai.BizAssitEntry;
import kd.fi.ai.DataType;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.ai.VchTplBizAssists;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.compiler.AcctItemCompiler;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class BizAssistRefreshGetHandle
extends AbstractGetValueHandle<BizAssitEntry> {
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private Map<String, AcctItemCompiler> acctItemCompilers = new HashMap<String, AcctItemCompiler>(8);
    private String amountEntity;
    private VchTplBizAssists vchTplBizAssists;

    public String getAmountEntity() {
        return this.amountEntity;
    }

    public void setAmountEntity(String amountEntity) {
        this.amountEntity = amountEntity;
    }

    public Map<String, AcctItemCompiler> getAcctItemCompilers() {
        return this.acctItemCompilers;
    }

    public BizAssistRefreshGetHandle(ISingleTaskContext taskContext, VchTplBizAssists vchTplBizAssists) {
        super(taskContext);
        this.vchTplBizAssists = vchTplBizAssists;
        this.preCompile();
    }

    @Override
    public void Compile() {
        List itemList = this.vchTplBizAssists.getItemClassMaps();
        for (AbstractVchTplItemMap itemMap : itemList) {
            ArrayList<VchTplAsstDimFactorSource> assSourceList = new ArrayList<VchTplAsstDimFactorSource>();
            AcctItemCompiler itemComplier = new AcctItemCompiler(this.taskContext, itemMap, assSourceList, true);
            this.acctItemCompilers.put(itemMap.getItemClass(), itemComplier);
            itemComplier.Compolier();
            this.vars.addAll(itemComplier.getSelectedFields().values());
        }
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public BizAssitEntry GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        BizAssitEntry bizAssitEntry = new BizAssitEntry();
        for (Map.Entry<String, AcctItemCompiler> itemEntrySet : this.acctItemCompilers.entrySet()) {
            String value;
            BizAssit bizAssit;
            block16: {
                bizAssit = new BizAssit();
                String itemKey = itemEntrySet.getKey();
                AcctItemCompiler itemComp = itemEntrySet.getValue();
                BuildVchContext ctx = new BuildVchContext();
                ctx.setAsstBizTypes(new HashMap());
                AsstactType asstacttype = BaseDataLoader.loadBizAsstactType((IBuildVchContext)ctx, (Long)Long.valueOf(itemKey));
                Object acctItem = itemComp.getGetItemHandle().GetVchFldValue(fldProperties, sourceRow, extRow);
                String flexField = itemComp.getFlexName();
                bizAssit.setAsstype(flexField);
                String string = value = acctItem != null ? acctItem.toString() : "";
                if (DataType.BASEDATA.getValue().equals(asstacttype.getValueType()) || DataType.ASSISTANT.getValue().equals(asstacttype.getValueType())) {
                    if (!(acctItem instanceof Long)) {
                        value = "";
                    }
                } else if (DataType.NUMERICAL.getValue().equals(asstacttype.getValueType())) {
                    int percision = asstacttype.getPercision();
                    try {
                        if (acctItem != null) {
                            if (percision >= 0) {
                                value = ((BigDecimal)acctItem).setScale(percision, 4) + "";
                                if (percision == 10 && "0E-10".equals(value)) {
                                    value = "0.0000000000";
                                }
                            } else if ("0E-10".equals(value)) {
                                value = "0.0000000000";
                            }
                            break block16;
                        }
                        value = "";
                    }
                    catch (Throwable e) {
                        value = "";
                    }
                } else if (DataType.DATE.getValue().equals(asstacttype.getValueType())) {
                    String format = "1".equals(asstacttype.getShowformat()) ? "yyyy-MM-dd" : "yyyy-MM";
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    value = acctItem instanceof Date ? dateFormat.format(acctItem) : "";
                } else if ("0E-10".equals(value)) {
                    value = "0";
                }
            }
            bizAssit.setAssval(value);
            bizAssitEntry.getBizAssits().add(bizAssit);
        }
        return bizAssitEntry;
    }

    private void preCompile() {
        this.Compile();
    }

    public Map<String, DynamicProperty> getDynamicPropertys(DynamicObjectType dType) {
        List<IVariableMode> variableModes = this.getVars();
        HashMap<String, DynamicProperty> map = new HashMap<String, DynamicProperty>(variableModes.size());
        for (IVariableMode mode : variableModes) {
            DynamicProperty property;
            if (mode instanceof SourceBillFieldMode) {
                SourceBillFieldMode billFieldMode = (SourceBillFieldMode)mode;
                property = dType.getProperty(billFieldMode.getFullPropName());
                map.put(billFieldMode.getVar(), property);
                continue;
            }
            String modeVar = mode.getVar();
            property = dType.getProperty(modeVar);
            map.put(modeVar, property);
        }
        return map;
    }
}

