/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.DynamicTextMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class DynamicTextGetHandle
extends AbstractGetValueHandle<String> {
    private static final String SSC_INNER_MSG = "{sscInnerMsg}";
    private static final String SSC_INNER_MSG_TAG = "\\$sscInnerMsg\\$";
    private static final String SSC_APPROVE_MSG = "{sscApproveMsg}";
    private static final String SSC_APPROVE_MSG_TAG = "\\$sscApproveMsg\\$";
    protected String dynamicText;
    protected String defValue;
    protected IGetValueMode<String> valueMode;
    private boolean hasSscApproveMsg = false;
    private boolean hasSscInnerMsg = false;

    public DynamicTextGetHandle(ISingleTaskContext taskContext, String dynamicText, String defValue) {
        super(taskContext);
        if (dynamicText != null) {
            if (dynamicText.indexOf(SSC_APPROVE_MSG) != -1) {
                dynamicText = dynamicText.replaceAll("\\{sscApproveMsg\\}", SSC_APPROVE_MSG_TAG);
                this.hasSscApproveMsg = true;
            }
            if (dynamicText.indexOf(SSC_INNER_MSG) != -1) {
                dynamicText = dynamicText.replaceAll("\\{sscInnerMsg\\}", SSC_INNER_MSG_TAG);
                this.hasSscInnerMsg = true;
            }
        }
        this.dynamicText = dynamicText;
        this.defValue = defValue;
        this.preCompile();
    }

    public void matchBatchFunction(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        if (this.valueMode instanceof FormulaMode) {
            FormulaMode formualModel = (FormulaMode)this.valueMode;
            formualModel.matchBatchFunction(fldProperties, sourceRow);
        }
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.valueMode.getVars();
    }

    @Override
    public void Compile() {
        if (StringUtils.isBlank((CharSequence)this.dynamicText)) {
            this.valueMode = new ConstMode<String>(this.defValue);
            this.description = ResManager.loadKDString((String)"(\u65e0)", (String)"DynamicTextGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
        } else {
            this.valueMode = new DynamicTextMode(this.taskContext, this.dynamicText);
            this.description = String.format(ResManager.loadKDString((String)"\u52a8\u6001\u6587\u672c\u7684\u503c\u4e3a\uff1a%s", (String)"DynamicTextGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]), this.dynamicText);
        }
    }

    @Override
    public String GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        String msg;
        Long billID;
        String value = this.valueMode.GetValue(fldProperties, sourceRow, extRow);
        if (this.hasSscApproveMsg && value != null) {
            billID = sourceRow.getLong("id");
            msg = this.getSscMsg(billID, SSC_APPROVE_MSG);
            value = value.replaceAll(SSC_APPROVE_MSG_TAG, Matcher.quoteReplacement(msg));
        }
        if (this.hasSscInnerMsg && value != null) {
            billID = sourceRow.getLong("id");
            msg = this.getSscMsg(billID, SSC_INNER_MSG);
            value = value.replaceAll(SSC_INNER_MSG_TAG, Matcher.quoteReplacement(msg));
        }
        return value;
    }

    private String getSscMsg(Long billID, String msgType) {
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"id,innermsg,apprevalmessage", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)billID.toString())}, (String)"completetime desc");
        if (tasks != null && tasks.length > 0) {
            if (SSC_APPROVE_MSG.equals(msgType)) {
                return tasks[0].getString("apprevalmessage");
            }
            return tasks[0].getString("innermsg");
        }
        return "";
    }

    private void preCompile() {
        this.Compile();
    }
}

