/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.VchFlexMappingItem;
import kd.fi.ai.VchSingleFlexMapping;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.FormulaGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.SourceFieldGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.mapping.ISearchParamValueSet;
import kd.fi.v2.fah.models.mapping.MappingMetaCache;
import kd.fi.v2.fah.models.mapping.MappingSearchParam;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.SingleValueDataMappingServiceImpl;

public class VchFlexMappingGetHandle
extends AbstractGetValueHandle<Object> {
    private VchFlexMappingItem flexMappingItem;
    private Long flexMappingId;
    private static final Log logger = LogFactory.getLog(VchFlexMappingGetHandle.class);
    private FlexMappingType mappingType;
    private Map<Long, AbstractGetValueHandle<?>> flexMappingHandles = new HashMap();
    private List<FormulaGetHandle<?>> modes = new ArrayList(2);
    private Long asstTypeId = 0L;
    private Date bookDate;
    private boolean isAutoCheck = false;
    private StringBuilder info = new StringBuilder("kd.fi.ai.mservice.builder.getvaluehandle.VchFlexMappingGetHandle");

    public VchFlexMappingGetHandle(ISingleTaskContext taskContext, VchFlexMappingItem flexMappingItem, Long flexMappingId, FlexMappingType mappingType) {
        super(taskContext);
        this.flexMappingItem = flexMappingItem;
        this.flexMappingId = flexMappingId;
        this.mappingType = mappingType;
        this.preCompile();
    }

    public VchFlexMappingGetHandle(ISingleTaskContext taskContext, VchFlexMappingItem flexMappingItem, Long flexMappingId, FlexMappingType mappingType, Object asstTypeId) {
        this(taskContext, flexMappingItem, flexMappingId, mappingType);
        if (StringUtils.isNotBlank((Object)asstTypeId)) {
            this.asstTypeId = Long.parseLong(asstTypeId.toString());
        }
    }

    @Override
    public List<IVariableMode> getVars() {
        ArrayList<IVariableMode> vars = new ArrayList<IVariableMode>();
        for (AbstractGetValueHandle<?> factorHandle : this.flexMappingHandles.values()) {
            vars.addAll(factorHandle.getVars());
        }
        return vars;
    }

    public void matchFunction(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        if (!this.modes.isEmpty()) {
            for (FormulaGetHandle<?> mode : this.modes) {
                mode.matchFunction(fldProperties, sourceRow);
            }
        }
    }

    @Override
    public void Compile() {
        if (this.flexMappingId == null || this.flexMappingId == 0L) {
            logger.info("--DAP--VchFlexMappingGetHandle.error:" + this.flexMappingItem.getDesc());
            return;
        }
        StringBuilder infoJilu = new StringBuilder();
        infoJilu.append("---start To Compiler FlexMappingType: --flexMappingId:");
        infoJilu.append(this.flexMappingId);
        Map<Long, FlexFieldCfg> inputFlexProp = BuildVoucherUtils.getInputFlexProp(this.flexMappingId);
        for (VchSingleFlexMapping sf : this.flexMappingItem.getDataCol()) {
            if (!inputFlexProp.containsKey(sf.getMappingType())) continue;
            if (StringUtils.isNotBlank((CharSequence)sf.getSourceField())) {
                SourceFieldGetHandle<Object> sourceFieldGetHandle = new SourceFieldGetHandle<Object>(this.taskContext, sf.getSourceField(), null);
                this.flexMappingHandles.put(sf.getMappingType(), sourceFieldGetHandle);
                infoJilu.append("---Compiler FlexMappingType:--getMappingType:");
                infoJilu.append(sf.getMappingType());
                infoJilu.append(";--getMappingName:");
                infoJilu.append(sf.getMappingName());
                infoJilu.append(";--getSourceField:");
                infoJilu.append(sf.getSourceField());
                continue;
            }
            FormulaGetHandle<Long> formulaGetHandle = new FormulaGetHandle<Long>(this.taskContext, sf.getMappingexp(), 0L);
            this.flexMappingHandles.put(sf.getMappingType(), formulaGetHandle);
            this.modes.add(formulaGetHandle);
            infoJilu.append("---Compiler FlexMappingType:--getMappingType:");
            infoJilu.append(sf.getMappingType());
            infoJilu.append(";--getMappingName:");
            infoJilu.append(sf.getMappingName());
            infoJilu.append(";--getMappingexp:");
            infoJilu.append(sf.getMappingexp());
        }
        if (this.isAutoCheck) {
            this.info.append((CharSequence)infoJilu);
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            logger.info(infoJilu.toString());
        }
    }

    public Object GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow, Date bookDate) {
        this.bookDate = bookDate;
        return this.GetVchFldValue(fldProperties, sourceRow, extRow);
    }

    @Override
    public Object GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        StringBuilder infoJilu = new StringBuilder();
        HashMap resultMap = new HashMap(this.flexMappingHandles.size());
        for (Map.Entry<Long, AbstractGetValueHandle<?>> row : this.flexMappingHandles.entrySet()) {
            Long key = row.getKey();
            Object result = row.getValue().GetVchFldValue(fldProperties, sourceRow, extRow);
            resultMap.put(key, result);
        }
        infoJilu.append("---start To GetVchFldValue:--resultMap:");
        infoJilu.append(resultMap);
        Map<Long, FlexFieldCfg> inputFlexProp = BuildVoucherUtils.getInputFlexProp(this.flexMappingId);
        Object[] params = new Object[inputFlexProp.size()];
        for (FlexFieldCfg sflex : inputFlexProp.values()) {
            int index = sflex.getSeq();
            Object result = resultMap.get(sflex.getId());
            params[index] = result;
        }
        MappingSearchParam msp = new MappingSearchParam((IValueSetMeta)MappingMetaCache.getMappingMetaCached((Long)this.flexMappingId, (Object[])new Object[0]));
        msp.setOrgId(Long.valueOf(this.taskContext.getBookInfo().getAcctOrgId()));
        msp.setValues(params);
        if (this.bookDate != null) {
            msp.setQueryDate(this.bookDate);
        } else {
            msp.setQueryDate(this.taskContext.getBookInfo().getSelectDateStart());
        }
        infoJilu.append(";--msp:");
        infoJilu.append(msp.toString());
        infoJilu.append(";--getAcctOrgId:");
        infoJilu.append(this.taskContext.getBookInfo().getAcctOrgId());
        infoJilu.append(";--bookDate:");
        infoJilu.append(this.bookDate);
        SingleValueDataMappingServiceImpl service = new SingleValueDataMappingServiceImpl();
        Object result = null;
        switch (this.mappingType) {
            case ACCOUNT: {
                result = service.searchAcctMapping(this.taskContext.getBookInfo().getSelectDateStart(), this.flexMappingId.longValue(), this.taskContext.getBookInfo().getAccountTableId(), (ISearchParamValueSet)msp);
                infoJilu.append(";--getAccountTableId:");
                infoJilu.append(this.taskContext.getBookInfo().getAccountTableId());
                break;
            }
            case MAINITEMCASHFLOW: 
            case SUPCASHFLOW: {
                result = service.searchCashFlowItemMapping(this.bookDate != null ? this.bookDate : this.taskContext.getBookInfo().getSelectDateStart(), this.flexMappingId.longValue(), (ISearchParamValueSet)msp);
                break;
            }
            case ASSIST: 
            case MAINASSIST: {
                result = service.searchAsstDimMapping(this.bookDate != null ? this.bookDate : this.taskContext.getBookInfo().getSelectDateStart(), this.flexMappingId.longValue(), this.asstTypeId, (ISearchParamValueSet)msp);
                infoJilu.append(";--asstTypeId:");
                infoJilu.append(this.asstTypeId);
            }
        }
        infoJilu.append(";--result:");
        infoJilu.append(result);
        if (this.isAutoCheck) {
            this.info.append((CharSequence)infoJilu);
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            logger.info(infoJilu.toString());
        }
        return result;
    }

    private void preCompile() {
        this.Compile();
    }

    public VchFlexMappingItem getFlexMappingItem() {
        return this.flexMappingItem;
    }

    public Long getFlexMappingId() {
        return this.flexMappingId;
    }

    public Map<Long, AbstractGetValueHandle<?>> getFlexMappingHandles() {
        return this.flexMappingHandles;
    }

    public List<FormulaGetHandle<?>> getModes() {
        return this.modes;
    }

    public String getInfo() {
        return this.info.toString();
    }

    public void setAutoCheck(boolean isAutoCheck) {
        this.isAutoCheck = isAutoCheck;
    }

    public static enum FlexMappingType {
        ACCOUNT,
        ASSIST,
        MAINITEMCASHFLOW,
        SUPCASHFLOW,
        MAINASSIST;

    }
}

