/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.FormulaGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class VchFormulaConditionGetValueHandle<T>
extends AbstractGetValueHandle<T> {
    private VchFormulaFilterset vchFormulaFilterset;
    private List<Tuple<IGetValueMode<Boolean>, FormulaGetHandle<T>>> rules = new ArrayList<Tuple<IGetValueMode<Boolean>, FormulaGetHandle<T>>>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private List<Object> modes = new ArrayList<Object>(2);

    public VchFormulaConditionGetValueHandle(ISingleTaskContext taskContext, VchFormulaFilterset vchFormulaFilterset) {
        super(taskContext);
        this.vchFormulaFilterset = vchFormulaFilterset;
        this.preComplie();
    }

    private void preComplie() {
        this.Compile();
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public void Compile() {
        StringBuilder sBuilder = new StringBuilder();
        int seq = 1;
        for (VchFormulaFilterSetRow item : this.vchFormulaFilterset.getItems()) {
            String logMessage;
            IGetValueMode<Boolean> condition;
            VchTplExpression fieldExp = item.getFieldExp();
            String fieldExpFormula = fieldExp.buildFullFormula(this.taskContext.getSrcEntityType());
            FormulaGetHandle<Object> fieldExpGetValueHandle = new FormulaGetHandle<Object>(this.taskContext, fieldExpFormula, null);
            String filterFormula = null;
            if (item.getFilterSet().getFilterCondition() != null) {
                filterFormula = item.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType());
                item.getFilterSet().setExpression(filterFormula);
                item.getFilterSet().setFilterCondition(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getFilterSet().getExpression())) {
                condition = new ConstMode<Boolean>(true);
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u65e0\u6761\u4ef6\u53d6\u503c{1}", (String)"VchFormulaConditionGetValueHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, fieldExpFormula);
                sBuilder.append(logMessage).append("; ");
            } else {
                condition = new ConditionMode(this.taskContext, item.getFilterSet().getExpression());
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u6ee1\u8db3\u6761\u4ef6\u53d6\u51ed\u8bc1\u7c7b\u578b\uff1a{2}", (String)"VchFormulaConditionGetValueHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, item.getFilterSet().getExpression(), fieldExpFormula);
                sBuilder.append(logMessage).append("; ");
            }
            Tuple rule = new Tuple(condition, fieldExpGetValueHandle);
            this.rules.add(rule);
            this.vars.addAll(fieldExpGetValueHandle.getVars());
            this.vars.addAll(condition.getVars());
            ++seq;
        }
        this.modes = this.rules.stream().map(t -> (IGetValueMode)t.item1).collect(Collectors.toList());
        this.modes.addAll(this.rules.stream().map(t -> ((FormulaGetHandle)t.item2).getValueMode()).collect(Collectors.toList()));
        this.description = sBuilder.toString();
    }

    @Override
    public T GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        T fieldExp = null;
        for (Tuple<IGetValueMode<Boolean>, FormulaGetHandle<T>> ruleItem : this.rules) {
            if (!((Boolean)((IGetValueMode)ruleItem.item1).GetValue(fldProperties, sourceRow, extRow)).booleanValue()) continue;
            fieldExp = ((FormulaGetHandle)ruleItem.item2).GetVchFldValue(fldProperties, sourceRow, extRow);
            break;
        }
        return fieldExp;
    }

    public List<Object> getConditionModes() {
        return this.modes;
    }
}

