/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.VoucherType;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class VchTypeGetHandle
extends AbstractGetValueHandle<Long> {
    private VchTplVoucherTypes vchTypes;
    private List<Tuple<IGetValueMode<Boolean>, Long>> rules = new ArrayList<Tuple<IGetValueMode<Boolean>, Long>>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private List<IGetValueMode<Boolean>> modes = new ArrayList<IGetValueMode<Boolean>>(2);

    public VchTypeGetHandle(ISingleTaskContext taskContext, VchTplVoucherTypes vchTypes) {
        super(taskContext);
        this.vchTypes = vchTypes;
        this.preCompile();
    }

    @Override
    public void Compile() {
        StringBuilder sBuilder = new StringBuilder();
        int seq = 1;
        for (VchTplVoucherType item : this.vchTypes.getItems()) {
            String logMessage;
            IGetValueMode<Boolean> condition;
            Long vchTypeId = item.getVchGrpId();
            if (item.getFilterSet().getFilterCondition() != null) {
                item.getFilterSet().setExpression(item.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType()));
                item.getFilterSet().setFilterCondition(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getFilterSet().getExpression())) {
                condition = new ConstMode<Boolean>(true);
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u65e0\u6761\u4ef6\u53d6\u51ed\u8bc1\u7c7b\u578b{1}", (String)"VchTypeGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, vchTypeId);
                sBuilder.append(logMessage).append("; ");
            } else {
                condition = new ConditionMode(this.taskContext, item.getFilterSet().getExpression());
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u6ee1\u8db3\u6761\u4ef6\u53d6\u51ed\u8bc1\u7c7b\u578b\uff1a{2}", (String)"VchTypeGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, item.getFilterSet().getExpression(), vchTypeId);
                sBuilder.append(logMessage).append("; ");
            }
            Tuple rule = new Tuple(condition, (Object)vchTypeId);
            this.rules.add((Tuple<IGetValueMode<Boolean>, Long>)rule);
            this.vars.addAll(condition.getVars());
            ++seq;
        }
        this.modes = this.rules.stream().map(t -> (IGetValueMode)t.item1).collect(Collectors.toList());
        this.description = sBuilder.toString();
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public Long GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        Long vchTypeId = 0L;
        for (Tuple<IGetValueMode<Boolean>, Long> ruleItem : this.rules) {
            if (!((Boolean)((IGetValueMode)ruleItem.item1).GetValue(fldProperties, sourceRow, extRow)).booleanValue()) continue;
            vchTypeId = (Long)ruleItem.item2;
            break;
        }
        if (vchTypeId != 0L) {
            VoucherType tpVoucherType = null;
            try {
                tpVoucherType = BaseDataLoader.loadVchType((IBuildVchContext)this.taskContext.getBuildVchContext(), (Long)vchTypeId);
            }
            catch (Exception e) {
                this.writeReportDetail(sourceRow.getLong("id"), VoucherCheckItem.VoucherType, VoucherErrLevel.Error, e.getMessage() == null ? ResManager.loadKDString((String)"\u67e5\u8be2\u51ed\u8bc1\u7c7b\u578b\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u7c7b\u578b\u76f8\u5173\u914d\u7f6e\u3002", (String)"VchTypeGetHandle_2", (String)"fi-ai-mservice", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u51ed\u8bc1\u7c7b\u578b\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u7c7b\u578b\u76f8\u5173\u914d\u7f6e: \u201c%s\u201d\u3002", (String)"VchTypeGetHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]), e.getMessage()));
                return 0L;
            }
            long tpOrgID = tpVoucherType.getOrgid();
            long acctOrgID = this.taskContext.getBookInfo().getAcctOrgId();
            if (tpOrgID == acctOrgID) {
                return vchTypeId;
            }
            String tpName = tpVoucherType.getName();
            VoucherType newVoucherType = BaseDataLoader.loadVchTypeByNameAndOrg((IBuildVchContext)this.taskContext.getBuildVchContext(), (String)tpName, (Long)acctOrgID);
            if (newVoucherType != null) {
                return newVoucherType.getId();
            }
        }
        return vchTypeId;
    }

    private void preCompile() {
        this.Compile();
    }

    public List<IGetValueMode<Boolean>> getConditionModes() {
        return this.modes;
    }
}

