/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluemode;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncParser;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.CompoundId;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.Literal;
import kd.bos.formula.excel.MyUnaryExpr;
import kd.bos.formula.excel.Operator;
import kd.bos.formula.excel.Paren;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.UnaryExpr;
import kd.bos.formula.excel.Visitor;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.builder.plugin.events.PlugCustField;
import kd.fi.ai.function.Function;
import kd.fi.ai.mservice.builder.getvaluemode.CustFieldMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.getvaluemode.UnknownVariableMode;
import kd.fi.ai.util.FieldReplaceUtil;
import kd.fi.ai.util.FormulaEngineUtil;

public class FormulaMode<T>
implements IGetValueMode<T> {
    private static final String GET_SUB_ENTRY_VERTICAL_ASS_DATA = "GetSubEntryVerticalAssData";
    private static final String ENTRIES_ACCOUNT = "'\"entries.account\"'";
    private static final String GET_ACC_EVENT_VOUCHER = "GetAccEventVoucher";
    protected String formula;
    protected ISingleTaskContext taskContext;
    protected List<IVariableMode> vars = new ArrayList<IVariableMode>();
    protected FunctionManage funcLib;
    protected CRExpressionContext expContext;
    protected Set<String> funcs = new HashSet<String>();
    protected Expr expr;

    public FormulaMode(ISingleTaskContext taskContext, String formula) {
        if (taskContext.getTemplateEntityName() != null) {
            Map commonAndSourceFieldcol = taskContext.getCommonAndSourceFieldcol();
            for (Map.Entry entry : commonAndSourceFieldcol.entrySet()) {
                String oldvalue = (String)entry.getKey();
                String newValue = (String)entry.getValue();
                if (!formula.contains(oldvalue)) continue;
                formula = FieldReplaceUtil.getReplacedFarmula((String)formula, (String)oldvalue, (String)newValue);
            }
        }
        this.taskContext = taskContext;
        this.funcLib = taskContext.getFuncLib();
        this.preSetFormula(formula);
        this.expContext = new CRExpressionContext(null, null, null);
    }

    public void setFormula(String formula) {
        this.CompileFormula(formula);
    }

    public String getFormula() {
        return this.formula;
    }

    public void matchBatchFunction(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        if (this.formula == null || this.formula.indexOf("(") == -1) {
            return;
        }
        this.expContext.setActiveRow(sourceRow);
        this.expContext.setFldProperties(fldProperties);
        Map<String, Object> varValues = this.getVarValues(this.expContext);
        this.taskContext.addBatchFunVars(this.getFunctions(this.expr, varValues));
        if (StringUtils.isNotBlank((CharSequence)this.formula)) {
            BOSExpression expression = (BOSExpression)ThreadCache.get((Object)("BOSExpression" + this.formula), () -> new BOSExpression(this.formula));
            BatchFuncParser batchFuncParser = new BatchFuncParser();
            this.taskContext.addBosBatchFunVars(batchFuncParser.preCall(expression, (ExpressionContext)this.expContext, this.funcLib));
        }
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public Set<String> getFuncs() {
        return this.funcs;
    }

    @Override
    public T GetValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        FunCall fc;
        this.expContext.setActiveRow(sourceRow);
        this.expContext.setFldProperties(fldProperties);
        T t = null;
        if (!(this.expr instanceof FunCall) || GET_SUB_ENTRY_VERTICAL_ASS_DATA.equals((fc = (FunCall)this.expr).getName())) {
            // empty if block
        }
        Map<String, Object> ctx = this.getVarValues(this.expContext);
        try {
            boolean reCompile;
            boolean hasInnerFunction = false;
            HashMap<Integer, Expr> paramCache = new HashMap<Integer, Expr>(2);
            if (this.expr instanceof FunCall) {
                FunCall fc2 = (FunCall)this.expr;
                if (this.isBatchFunc(fc2)) {
                    Function function = this.toFunction(fc2, ctx, true);
                    if (function != null) {
                        Object result = this.taskContext.getBatchFunValues().get(function);
                        if (result != null) {
                            return (T)result;
                        }
                        if (function.isHasInnerFunction()) {
                            hasInnerFunction = true;
                        }
                    }
                } else if (this.isBosBatchFunc(fc2)) {
                    BatchFuncRunParam bosFunction = this.toBatchFuncRunParam(fc2, ctx);
                    if (this.taskContext.getBosBatchFunValues().containsKey(bosFunction)) {
                        return (T)this.taskContext.getBosBatchFunValues().get(bosFunction);
                    }
                }
                if (hasInnerFunction) {
                    Object re;
                    Function function;
                    Expr[] params = fc2.getParams();
                    for (int i = 0; i < params.length; ++i) {
                        Function function2;
                        Expr epr = params[i];
                        if (!(epr instanceof FunCall)) continue;
                        FunCall fca = (FunCall)epr;
                        Object funcResult = null;
                        if (this.isBatchFunc(fca) && (function2 = this.toFunction(fca, ctx, true)) != null && !function2.isHasInnerFunction()) {
                            funcResult = this.taskContext.getBatchFunValues().get(function2);
                        }
                        if (funcResult == null) continue;
                        paramCache.put(i, params[i]);
                        params[i] = Literal.createString((String)("'" + funcResult.toString() + "'"));
                    }
                    if (paramCache.size() > 0 && (function = this.toFunction(fc2, ctx, true)) != null && (re = this.taskContext.getBatchFunValues().get(function)) != null) {
                        return (T)re;
                    }
                }
            }
            Expr ep = this.expr;
            if (!hasInnerFunction && (reCompile = this.taskContext.getReCompileCache().computeIfAbsent(this.formula, k -> this.needReCompile(this.expr)).booleanValue()) && ThreadCache.exists((Object)"batchFunctionAvailable")) {
                String formula = this.toFormula(this.expr, ctx);
                if (Objects.isNull(formula) || formula.equals("") || formula.equals("''''")) {
                    return null;
                }
                formula = formula.replaceAll("''", "'");
                formula = formula.replaceAll("NULL", "''");
                ep = this.parseFormula(formula);
            }
            BOSUDFunction[] funcInstances = this.createUDFunctions(this.expContext);
            Object v = FormulaEngine.execExcelFormula((Expr)ep, ctx, (UDFunction[])funcInstances);
            if (paramCache.size() > 0) {
                FunCall fc3 = (FunCall)this.expr;
                Function function = this.toFunction(fc3, ctx, true);
                if (function != null) {
                    this.taskContext.getBatchFunValues().put(function, v);
                }
                Expr[] params = fc3.getParams();
                for (Map.Entry ee : paramCache.entrySet()) {
                    params[((Integer)ee.getKey()).intValue()] = (Expr)ee.getValue();
                }
            }
            return (T)v;
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            sb.append(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u53d6\u503c\u51fa\u9519\uff1a%1$s", (String)"FormulaMode_0", (String)"fi-ai-mservice", (Object[])new Object[0]), exp.getMessage()));
            this.addErrorReport(VoucherCheckItem.Other, sb.toString(), 0L);
            return t;
        }
    }

    private boolean isBatchFunc(FunCall fc) {
        return fc.getName().equals(GET_ACC_EVENT_VOUCHER) && ENTRIES_ACCOUNT.equals(fc.getParams()[3].toString()) || ThreadCache.exists((Object)"batchFunctionAvailable") && Function.isBatchFunction((String)fc.getName());
    }

    private boolean isBosBatchFunc(FunCall fc) {
        return ThreadCache.exists((Object)"batchFunctionAvailable") && Function.isBosBatchFunction((String)fc.getName());
    }

    public Expr parseFormula(String formula) {
        return FormulaEngineUtil.parseFormulaFromCache((String)formula, (boolean)this.taskContext.getBuildVchContext().isCacheParseFormula());
    }

    private BOSUDFunction[] createUDFunctions(CRExpressionContext expContext) {
        if (this.getFuncs().isEmpty()) {
            return null;
        }
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
        for (String funcName : this.getFuncs()) {
            if (!this.funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)this.funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[instances.size()]);
    }

    protected Map<String, Object> getVarValues(CRExpressionContext expContext) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (IVariableMode var : this.getVars()) {
            OutValue value = new OutValue();
            if (!expContext.tryGetValue(var.getVar(), value).booleanValue()) {
                if ("Dapfield_newdate".equals(var.getVar())) {
                    ctx.put("Dapfield_newdate", new Date());
                    continue;
                }
                if ("Dapfield_firstdate".equals(var.getVar()) && this.taskContext.getBookInfo() != null) {
                    ctx.put("Dapfield_firstdate", this.taskContext.getBookInfo().getCurrentPeriodBeginDate());
                    continue;
                }
                if ("Dapfield_lastdate".equals(var.getVar()) && this.taskContext.getBookInfo() != null) {
                    ctx.put("Dapfield_lastdate", this.taskContext.getBookInfo().getCurrentPeriodEndDate());
                    continue;
                }
                ctx.put(var.getVar(), null);
                continue;
            }
            Object item = value.get();
            ctx.put(var.getVar(), item);
        }
        return ctx;
    }

    protected Object GetSingleFieldValue(Map<String, DynamicProperty> fldProperties, DynamicObject activeRow, DynamicObject extRow, IVariableMode var) {
        Object fldValue = var.GetValue(fldProperties, activeRow, extRow);
        return fldValue;
    }

    protected void CompileFormula(String formula) {
        UDFunctionVisitor mainEntityType;
        this.formula = formula;
        if (this.taskContext.getTemplateEntityName() != null) {
            Map commonAndSourceFieldcol = this.taskContext.getCommonAndSourceFieldcol();
            for (Map.Entry entry : commonAndSourceFieldcol.entrySet()) {
                String oldvalue = (String)entry.getKey();
                String newValue = (String)entry.getValue();
                if (!formula.contains(oldvalue)) continue;
                formula = FieldReplaceUtil.getReplacedFarmula((String)formula, (String)oldvalue, (String)newValue);
            }
        }
        String[] varStrings = new String[]{};
        try {
            varStrings = FormulaEngineUtil.extractVariablesFromCache((String)this.formula, (boolean)this.taskContext.getBuildVchContext().isCacheExtractVariables());
            this.expr = FormulaEngineUtil.parseFormulaFromCache((String)this.formula, (boolean)this.taskContext.getBuildVchContext().isCacheParseFormula());
            mainEntityType = new UDFunctionVisitor();
            this.expr.accept((Visitor)mainEntityType);
            this.funcs.addAll(mainEntityType.getFuncNames());
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            sb.append(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a%1$s", (String)"FormulaMode_1", (String)"fi-ai-mservice", (Object[])new Object[0]), exp.getMessage()));
            this.addErrorReport(VoucherCheckItem.Other, sb.toString(), 0L);
        }
        mainEntityType = this.taskContext.getSrcEntityType();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            IVariableMode var = this.buildVarMode((MainEntityType)mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    protected IVariableMode buildVarMode(MainEntityType mainEntityType, String varString, String[] keyItems) {
        int funStartIndex;
        IDataEntityProperty property;
        Map commonAndSourceFieldcol;
        IVariableMode var = null;
        if (this.taskContext.getTemplateEntityName() != null && (commonAndSourceFieldcol = this.taskContext.getCommonAndSourceFieldcol()).containsKey(varString)) {
            keyItems[0] = (String)commonAndSourceFieldcol.get(varString);
            varString = (String)commonAndSourceFieldcol.get(varString);
        }
        if ((property = mainEntityType.findProperty(keyItems[0].trim())) == null && keyItems.length > 0 && mainEntityType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)keyItems[0]);
        }
        var = property != null ? new SourceBillFieldMode(varString, keyItems, property) : (this.taskContext.getCustFields().containsKey(keyItems[0]) ? new CustFieldMode(varString, keyItems, (PlugCustField)this.taskContext.getCustFields().get(keyItems[0])) : ((funStartIndex = varString.indexOf("(")) >= 0 ? new FormulaVariableMode(this.taskContext, varString) : new UnknownVariableMode(varString, keyItems)));
        return var;
    }

    protected void addErrorReport(VoucherCheckItem checkItem, String msg, Object sourcebillid) {
        if (this.taskContext.getBuildVchContext() == null || this.taskContext.getBuildVchContext().getReporter() == null) {
            throw new RuntimeException(msg);
        }
        String str = "";
        if (this.taskContext.getBookInfo() != null && this.taskContext.getBookInfo().getBuildVoucherType() != null) {
            str = this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "";
        }
        this.taskContext.getBuildVchContext().getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), sourcebillid, null, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), checkItem, VoucherErrLevel.Warning, msg, this.taskContext.getBuildType(), str);
    }

    private void preSetFormula(String formula2) {
        this.setFormula(formula2);
    }

    private String toFormula(Expr expr, Map<String, Object> varValues) {
        if (expr instanceof FunCall) {
            Function fun;
            FunCall fc = (FunCall)expr;
            if (Function.isBatchFunction((String)fc.getName())) {
                fun = this.toFunction(fc, varValues, true);
                if (fun != null && !fun.isHasInnerFunction()) {
                    Object val = this.taskContext.getBatchFunValues().get(fun);
                    if (val instanceof String) {
                        val = StringUtils.isBlank(val) ? "''''" : "'" + val + "'";
                    }
                    return val == null ? "''''" : val.toString();
                }
            } else if (Function.isBosBatchFunction((String)fc.getName())) {
                fun = this.toBatchFuncRunParam(fc, varValues);
                if (this.taskContext.getBosBatchFunValues().containsKey(fun)) {
                    Object val = this.taskContext.getBosBatchFunValues().get(fun);
                    if (val instanceof String) {
                        val = StringUtils.isBlank(val) ? "''''" : "'" + val + "'";
                    }
                    return val == null ? "''''" : val.toString();
                }
            }
            Expr[] params = fc.getParams();
            Expr[] paramsBak = new Expr[fc.getParams().length];
            System.arraycopy(params, 0, paramsBak, 0, params.length);
            for (int i = 0; i < params.length; ++i) {
                Object val;
                Function fun2;
                Expr p = params[i];
                if (!(p instanceof FunCall)) continue;
                FunCall fp = (FunCall)p;
                if (Function.isBatchFunction((String)fp.getName())) {
                    fun2 = this.toFunction(fp, varValues, true);
                    if (fun2 == null) continue;
                    val = this.taskContext.getBatchFunValues().get(fun2);
                    if (val instanceof String) {
                        val = "'" + val + "'";
                    }
                    if (!fun2.isHasInnerFunction()) {
                        params[i] = Literal.createString((String)(val == null ? "''" : val.toString()));
                        continue;
                    }
                    if (val == null) continue;
                    params[i] = Literal.createString((String)(val == null ? "''" : val.toString()));
                    continue;
                }
                if (!Function.isBosBatchFunction((String)fp.getName())) continue;
                fun2 = this.toBatchFuncRunParam(fp, varValues);
                if (!this.taskContext.getBosBatchFunValues().containsKey(fun2)) continue;
                val = this.taskContext.getBosBatchFunValues().get(fun2);
                if (val instanceof String) {
                    val = "'" + val + "'";
                }
                params[i] = Literal.createString((String)(val == null ? "''" : val.toString()));
            }
            String ret = fc.toString();
            System.arraycopy(paramsBak, 0, params, 0, params.length);
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        if (expr instanceof BinaryExpr) {
            BinaryExpr bexpr = (BinaryExpr)expr;
            String lfv = this.toFormula(bexpr.getLeft(), varValues);
            String rfv = this.toFormula(bexpr.getRight(), varValues);
            sb.append(lfv).append(" ").append(bexpr.getOperator()).append(" ").append(rfv);
            return sb.toString();
        }
        if (expr instanceof Paren) {
            sb.append("(").append(this.toFormula(((Paren)expr).getExpr(), varValues)).append(")");
            return sb.toString();
        }
        if (expr instanceof UnaryExpr) {
            MyUnaryExpr up = new MyUnaryExpr((UnaryExpr)expr);
            Expr expr_up = up.getExpr();
            Operator oper_up = up.getOper();
            sb.append(oper_up.toString()).append(this.toFormula(expr_up, varValues));
            return sb.toString();
        }
        return expr.toString();
    }

    private boolean needReCompile(Expr expr) {
        MyUnaryExpr up;
        Expr expr_up;
        if (expr instanceof FunCall) {
            Expr[] params;
            FunCall fc = (FunCall)expr;
            if (Function.isBatchFunction((String)fc.getName()) || Function.isBosBatchFunction((String)fc.getName())) {
                return true;
            }
            for (Expr p : params = fc.getParams()) {
                if (!(p instanceof FunCall) || !this.needReCompile(p)) continue;
                return true;
            }
        } else if (expr instanceof BinaryExpr) {
            BinaryExpr bexpr = (BinaryExpr)expr;
            if (this.needReCompile(bexpr.getLeft())) {
                return true;
            }
            if (this.needReCompile(bexpr.getRight())) {
                return true;
            }
        } else if (expr instanceof Paren ? this.needReCompile(((Paren)expr).getExpr()) : expr instanceof UnaryExpr && this.needReCompile(expr_up = (up = new MyUnaryExpr((UnaryExpr)expr)).getExpr())) {
            return true;
        }
        return false;
    }

    protected Set<Function> getFunctions(Expr expr, Map<String, Object> varValues) {
        HashSet<Function> funSet = new HashSet<Function>();
        if (expr instanceof FunCall) {
            Expr[] params;
            Function function;
            FunCall fc = (FunCall)expr;
            if (Function.isBatchFunction((String)fc.getName()) && (function = this.toFunction(fc, varValues)) != null) {
                funSet.add(function);
            }
            for (Expr p : params = fc.getParams()) {
                if (!(p instanceof FunCall)) continue;
                funSet.addAll(this.getFunctions(p, varValues));
            }
        } else if (expr instanceof BinaryExpr) {
            BinaryExpr bexpr = (BinaryExpr)expr;
            funSet.addAll(this.getFunctions(bexpr.getLeft(), varValues));
            funSet.addAll(this.getFunctions(bexpr.getRight(), varValues));
        } else if (expr instanceof Paren) {
            funSet.addAll(this.getFunctions(((Paren)expr).getExpr(), varValues));
        } else if (expr instanceof UnaryExpr) {
            MyUnaryExpr up = new MyUnaryExpr((UnaryExpr)expr);
            Expr expr_up = up.getExpr();
            funSet.addAll(this.getFunctions(expr_up, varValues));
        }
        return funSet;
    }

    protected Function toFunction(FunCall funCall, Map<String, Object> varValues) {
        return this.toFunction(funCall, varValues, false);
    }

    protected Function toFunction(FunCall funCall, Map<String, Object> varValues, boolean forGetValue) {
        Expr[] params = funCall.getParams();
        ArrayList<Object> vars = new ArrayList<Object>(params.length);
        Function fun = new Function(funCall.getName(), vars);
        for (int i = 0; i < params.length; ++i) {
            Expr epr = params[i];
            if (epr instanceof CompoundId) {
                String propName = ((CompoundId)epr).toString();
                if (propName == null) continue;
                vars.add(varValues.get(propName));
                continue;
            }
            if (epr instanceof Literal) {
                vars.add(((Literal)epr).getValueObject());
                continue;
            }
            if (!(epr instanceof FunCall)) continue;
            FunCall fcall = (FunCall)epr;
            if (this.isBatchFuncTrans(fcall)) {
                Function function = this.toFunction(fcall, varValues);
                if (function != null) {
                    vars.add(function);
                } else if (forGetValue) {
                    vars.add(fcall);
                } else {
                    return null;
                }
                fun.setInnerFunctionBatch(true);
            } else if (forGetValue) {
                vars.add((FunCall)epr);
            } else {
                return null;
            }
            fun.setHasInnerFunction(true);
        }
        return fun;
    }

    private boolean isBatchFuncTrans(FunCall fc) {
        return fc.getName().equals(GET_ACC_EVENT_VOUCHER) && ENTRIES_ACCOUNT.equals(fc.getParams()[3].toString()) || Function.isBatchFunction((String)fc.getName());
    }

    protected BatchFuncRunParam toBatchFuncRunParam(FunCall funCall, Map<String, Object> varValues) {
        Expr[] params = funCall.getParams();
        ArrayList<Object> vars = new ArrayList<Object>(params.length);
        for (int i = 0; i < params.length; ++i) {
            Expr epr = params[i];
            if (epr instanceof CompoundId) {
                String propName = ((CompoundId)epr).toString();
                if (propName == null) continue;
                vars.add(varValues.get(propName));
                continue;
            }
            if (epr instanceof Literal) {
                vars.add(((Literal)epr).getValueObject());
                continue;
            }
            if (!(epr instanceof FunCall)) continue;
            vars.add((FunCall)epr);
        }
        return new BatchFuncRunParam(funCall.getName(), vars.toArray());
    }
}

