/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.Period;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class AcctBookHelper {
    private Map<Long, DynamicObject> bookObjs = new HashMap<Long, DynamicObject>();
    private static String EntityId_AcctBooks = "gl_accountbook";

    public void LoadMainBookInfor() {
    }

    public void LoadAcctPolicyInfor() {
    }

    public void LoadAcctSysOrgReport() {
    }

    public void LoadOrgPolicyInfor() {
    }

    public AcctBookInfo LoadBookInfor(SelectedAcctBook selectedBook, IBuildVchContext ctx) {
        DynamicObject bookObj;
        long bookId = selectedBook.getBookId();
        AcctBookInfo bookInfo = new AcctBookInfo();
        bookInfo.setBookId(bookId);
        bookInfo.setBizOrgId(selectedBook.getBizOrgId());
        if (this.bookObjs.containsKey(bookId)) {
            bookObj = this.bookObjs.get(bookId);
        } else {
            bookObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (String)EntityId_AcctBooks);
            this.bookObjs.put(bookId, bookObj);
        }
        if (bookObj == null) {
            return bookInfo;
        }
        ILocaleString orgName = bookObj.getLocaleString("org.name");
        ILocaleString bookTypeName = bookObj.getLocaleString("bookstype.name");
        bookInfo.setBookName(orgName.getLocaleValue() + "-" + bookTypeName.getLocaleValue());
        DynamicObject currency = bookObj.getDynamicObject("basecurrency");
        long cyId = (Long)currency.getPkValue();
        bookInfo.setCyId(cyId);
        bookInfo.setAcctPolicyCyId(cyId);
        DynamicObject bookType = bookObj.getDynamicObject("bookstype");
        bookInfo.setBookTypeId(((Long)bookType.getPkValue()).longValue());
        bookInfo.setAcctOrgId(bookObj.getLong("org_id"));
        DynamicObject acctTab = bookObj.getDynamicObject("accounttable");
        bookInfo.setAccountTableId(((Long)acctTab.getPkValue()).longValue());
        bookInfo.setSelectPeriodId(selectedBook.getPeriodId());
        this.SetCalendarInfor(bookInfo, ctx);
        bookInfo.setBuildVoucherType(selectedBook.getBuildVoucherType());
        bookInfo.setCoverGLVoucher(false);
        bookInfo.setPeriodTypeId(bookObj.getLong("periodtype.id"));
        bookInfo.setCurrentPeriod(bookObj.getDynamicObject("curperiod"));
        bookInfo.setExchangeTableID(Long.valueOf(bookObj.getLong("exratetable.id")));
        bookInfo.setEnable(bookObj.getBoolean("enable"));
        bookInfo.setBudget(bookObj.getBoolean("isbudget"));
        return bookInfo;
    }

    public void SetCalendarInfor(AcctBookInfo bookInfo, IBuildVchContext ctx) {
        long periodId = bookInfo.getSelectPeriodId();
        if (periodId == 0L) {
            return;
        }
        Period period = BaseDataLoader.loadPeriod((IBuildVchContext)ctx, (Long)periodId);
        bookInfo.setSelectDateStart(period.getBegindate());
        bookInfo.setSelectDateEnd(period.getEnddate());
    }

    public void SetBookSysParameters(AcctBookInfo bookInfo) {
    }

    public void SetDistributeAccount(AcctBookInfo bookInfo) {
    }
}

