/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.helper;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.fi.ai.VchTplEntryMergeOption;
import kd.fi.ai.builder.BuildVchProgressInfo;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.context.ContextData;
import kd.fi.ai.mservice.builder.helper.MergeVchOperation;
import kd.fi.ai.mservice.builder.helper.NotMergedGLVoucher;
import kd.fi.ai.mservice.builder.helper.OrgOperation;
import kd.fi.ai.mservice.builder.helper.SecondMergeVchOperation;
import kd.fi.ai.mservice.builder.helper.TaskResultData;
import kd.fi.ai.mservice.builder.progresser.OverallProgressInfo;
import kd.fi.ai.mservice.builder.progresser.SimpleProgressInfo;
import kd.fi.ai.mservice.builder.progresser.TaskProgressInfo;
import kd.fi.ai.mservice.builder.reporter.SingleTaskErrReport;

public class CacheHelper {
    private static IAppCache cache = AppCache.get((String)"ai");
    private static AtomicInteger successIndex = new AtomicInteger();

    public static void ClearCache(BuildVchContext context) {
        String transId = context.getTransId();
        CacheHelper.clearCancelFlag(transId);
        CacheHelper.clearContext(transId);
        CacheHelper.clearOverallProgress(transId);
        CacheHelper.clearProgressInfo(transId);
        CacheHelper.clearSimpleProgress(transId);
        for (String taskId : context.getProgresser().getTaskIds()) {
            CacheHelper.clearTaskErrReport(transId, taskId);
            CacheHelper.clearTaskProgress(transId, taskId);
            CacheHelper.clearTaskResult(transId, taskId);
        }
        CacheHelper.clearBookSuccessTaskIds(context);
        cache.remove(MessageFormat.format("{0}.{1}", transId, "billaivchidmap"));
        cache.remove(MessageFormat.format("{0}.{1}", transId, "billglvchidmap"));
        cache.remove(MessageFormat.format("{0}.{1}", transId, "aientryseqmap"));
        cache.remove(MessageFormat.format("{0}.{1}", transId, "glentryseqmap"));
    }

    public static Map<Long, Integer> getGLEntrySeqMap(String transid) {
        String key = MessageFormat.format("{0}.{1}", transid, "glentryseqmap");
        Map billvchmapStr = (Map)cache.get(key, Map.class);
        HashMap<Long, Integer> billvchmap = new HashMap<Long, Integer>();
        if (billvchmapStr != null) {
            for (Map.Entry e : billvchmapStr.entrySet()) {
                Long realKey = null;
                if (e.getKey() instanceof String) {
                    realKey = Long.parseLong((String)e.getKey());
                }
                if (realKey == null) continue;
                billvchmap.put(realKey, (Integer)e.getValue());
            }
        }
        return billvchmap;
    }

    public static void setGLEntrySeqMap(String transid, Map<Long, Integer> map) {
        String key = MessageFormat.format("{0}.{1}", transid, "glentryseqmap");
        cache.put(key, map);
    }

    public static Map<Long, Integer> getAiEntrySeqMap(String transid) {
        String key = MessageFormat.format("{0}.{1}", transid, "aientryseqmap");
        Map billvchmapStr = (Map)cache.get(key, Map.class);
        HashMap<Long, Integer> billvchmap = new HashMap<Long, Integer>();
        if (billvchmapStr != null) {
            for (Map.Entry e : billvchmapStr.entrySet()) {
                Long realKey = null;
                if (e.getKey() instanceof String) {
                    realKey = Long.parseLong((String)e.getKey());
                }
                if (realKey == null) continue;
                billvchmap.put(realKey, (Integer)e.getValue());
            }
        }
        return billvchmap;
    }

    public static void setAiEntrySeqMap(String transid, Map<Long, Integer> map) {
        String key = MessageFormat.format("{0}.{1}", transid, "aientryseqmap");
        cache.put(key, map);
    }

    public static Map<String, Long> getBillAiVchIdMap(String transid) {
        String key = MessageFormat.format("{0}.{1}", transid, "billaivchidmap");
        Map billvchmapStr = (Map)cache.get(key, Map.class);
        HashMap<String, Long> billvchmap = new HashMap<String, Long>();
        if (billvchmapStr != null) {
            for (Map.Entry e : billvchmapStr.entrySet()) {
                billvchmap.put(e.getKey().toString(), (Long)e.getValue());
            }
        }
        return billvchmap;
    }

    public static void setBillAiVchIdMap(String transid, Map<String, Long> map) {
        String key = MessageFormat.format("{0}.{1}", transid, "billaivchidmap");
        cache.put(key, map);
    }

    public static Map<String, Long> getBillGLVchIdMap(String transid) {
        String key = MessageFormat.format("{0}.{1}", transid, "billglvchidmap");
        Map billvchmapStr = (Map)cache.get(key, Map.class);
        HashMap<String, Long> billvchmap = new HashMap<String, Long>();
        if (billvchmapStr != null) {
            for (Map.Entry e : billvchmapStr.entrySet()) {
                billvchmap.put(e.getKey().toString(), (Long)e.getValue());
            }
        }
        return billvchmap;
    }

    public static void setBillGLVchIdMap(String transid, Map<String, Long> map) {
        String key = MessageFormat.format("{0}.{1}", transid, "billglvchidmap");
        cache.put(key, map);
    }

    public static void putContext(BuildVchContext context) {
        DapLocalCache.put((LocalCacheKey)CacheHelper.getLocalCacheKey(context.getTransId(), "context"), (Object)context.getContextData());
    }

    public static void mergeContext(BuildVchContext context) {
        BuildVchContext oldCtx = CacheHelper.getContext(context.getTransId());
        oldCtx.merge(context);
        DapLocalCache.put((LocalCacheKey)CacheHelper.getLocalCacheKey(oldCtx.getTransId(), "context"), (Object)oldCtx.getContextData());
    }

    public static BuildVchContext getContext(String transId) {
        ContextData contextData = new ContextData();
        ContextData initContextData = (ContextData)DapLocalCache.get((LocalCacheKey)CacheHelper.getLocalCacheKey(transId, "context"), ContextData.class);
        if (initContextData != null) {
            contextData.setBooks(initContextData.getBooks());
            contextData.setScheme(initContextData.getScheme());
            contextData.setTransId(initContextData.getTransId());
        }
        BuildVchContext context = new BuildVchContext();
        context.setContextData(contextData);
        return context;
    }

    public static void clearContext(String transId) {
        DapLocalCache.remove((LocalCacheKey)CacheHelper.getLocalCacheKey(transId, "context"));
    }

    public static void putOverallProgress(String transId, OverallProgressInfo progressInfo) {
        String key = MessageFormat.format("{0}.{1}", transId, "overallprogressinfo");
        cache.put(key, (Object)progressInfo);
    }

    public static void putSimpleProgress(String transId, SimpleProgressInfo progressInfo) {
        String key = MessageFormat.format("{0}.{1}", transId, "simpleprogressinfo");
        cache.put(key, (Object)progressInfo);
    }

    public static OverallProgressInfo getOverallProgress(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "overallprogressinfo");
        OverallProgressInfo progressInfo = (OverallProgressInfo)cache.get(key, OverallProgressInfo.class);
        if (progressInfo == null) {
            return new OverallProgressInfo();
        }
        return progressInfo;
    }

    public static SimpleProgressInfo getSimpleProgress(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "simpleprogressinfo");
        SimpleProgressInfo progressInfo = (SimpleProgressInfo)cache.get(key, SimpleProgressInfo.class);
        if (progressInfo == null) {
            return new SimpleProgressInfo();
        }
        return progressInfo;
    }

    public static void clearOverallProgress(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "overallprogressinfo");
        cache.remove(key);
    }

    public static void clearSimpleProgress(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "simpleprogressinfo");
        cache.remove(key);
    }

    public static void putTaskProgress(String transId, TaskProgressInfo taskProgressInfo) {
        String key = MessageFormat.format("{0}.{1}", taskProgressInfo.getTaskInfo().getTaskId(), "taskprogress");
        cache.put(key, (Object)taskProgressInfo);
    }

    public static TaskProgressInfo getTaskProgress(String transId, String taskId) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskprogress");
        TaskProgressInfo taskProgressInfo = (TaskProgressInfo)cache.get(key, TaskProgressInfo.class);
        if (taskProgressInfo == null) {
            return new TaskProgressInfo();
        }
        return taskProgressInfo;
    }

    public static void clearTaskProgress(String transId, String taskId) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskprogress");
        cache.remove(key);
    }

    public static void putProgressInfo(String transId, BuildVchProgressInfo progressInfo) {
        String key = MessageFormat.format("{0}.{1}", transId, "progressInfo");
        cache.put(key, (Object)progressInfo);
    }

    public static BuildVchProgressInfo getProgressInfo(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "progressInfo");
        BuildVchProgressInfo progressInfo = (BuildVchProgressInfo)cache.get(key, BuildVchProgressInfo.class);
        if (progressInfo == null) {
            return new BuildVchProgressInfo();
        }
        return progressInfo;
    }

    public static void clearProgressInfo(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "progressInfo");
        cache.remove(key);
    }

    public static void putCancelFlag(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "cancelflag");
        cache.put(key, (Object)Boolean.toString(true));
    }

    public static Boolean getCancelFlag(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "cancelflag");
        String value = (String)cache.get(key, String.class);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(value);
    }

    public static void clearCancelFlag(String transId) {
        String key = MessageFormat.format("{0}.{1}", transId, "cancelflag");
        cache.remove(key);
    }

    public static void putTaskResult(String transId, String taskId, SingleTaskResult taskResult) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskResult");
        TaskResultData cacheData = new TaskResultData();
        cacheData.setNewBizVouchers(taskResult.getNewBizVouchers());
        cacheData.setHistBizVouchers(taskResult.getHistBizVouchers());
        cacheData.setBizGroupToGlMap(taskResult.getBizGroupToGlMap());
        cacheData.setDelBizVoucherIds(taskResult.getDelBizVoucherIds());
        cacheData.getNewGLVouchers().addAll(taskResult.getNewGLVouchers().values());
        cacheData.setDapTrackers(taskResult.getDapTrackers());
        cacheData.setGroupEntryName(taskResult.getGroupEntryName());
        cacheData.setSecondBillId(taskResult.getSecondBillId());
        cacheData.setCustomKey(taskResult.getCustomKey());
        if (successIndex.get() > 1000) {
            cache.put(key, (Object)cacheData);
        } else {
            DapLocalCache.put((LocalCacheKey)CacheHelper.getLocalCacheKey(taskId), (Object)cacheData);
        }
        successIndex.incrementAndGet();
    }

    public static SingleTaskResult getTaskResult(String transId, String taskId) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskResult");
        TaskResultData cacheData = (TaskResultData)DapLocalCache.get((LocalCacheKey)CacheHelper.getLocalCacheKey(taskId), TaskResultData.class);
        if (cacheData == null && successIndex.get() > 1000) {
            cacheData = (TaskResultData)cache.get(key, TaskResultData.class);
        }
        if (cacheData == null) {
            return new SingleTaskResult();
        }
        SingleTaskResult taskResult = new SingleTaskResult();
        taskResult.setNewBizVouchers(cacheData.getNewBizVouchers());
        taskResult.setHistBizVouchers(cacheData.getHistBizVouchers());
        taskResult.setBizGroupToGlMap(cacheData.getBizGroupToGlMap());
        taskResult.setDelBizVoucherIds(cacheData.getDelBizVoucherIds());
        taskResult.setDapTrackers(cacheData.getDapTrackers());
        taskResult.setGroupEntryName(cacheData.getGroupEntryName());
        taskResult.setSecondBillId(cacheData.getSecondBillId());
        taskResult.setCustomKey(cacheData.getCustomKey());
        for (GLVoucher glVoucher : cacheData.getNewGLVouchers()) {
            taskResult.getNewGLVouchers().put(glVoucher.getGroupKey(), glVoucher);
        }
        return taskResult;
    }

    public static synchronized Set<String> getBookSuccessTaskIds(String transId, long bookId) {
        Set res = (Set)DapLocalCache.get((LocalCacheKey)CacheHelper.getLocalCacheKey(transId, bookId), Set.class);
        if (res == null) {
            return new HashSet<String>(0);
        }
        return res;
    }

    public static synchronized void addBookSuccessTaskIds(String transId, long bookId, String succTaskId) {
        HashSet<String> tasks = (HashSet<String>)DapLocalCache.get((LocalCacheKey)CacheHelper.getLocalCacheKey(transId, bookId), Set.class);
        if (tasks == null) {
            tasks = new HashSet<String>();
        }
        tasks.add(succTaskId);
        DapLocalCache.put((LocalCacheKey)CacheHelper.getLocalCacheKey(transId, bookId), tasks);
    }

    public static synchronized void putBookSuccessTaskIds(String transId, long bookId, Set<String> succTaskIds) {
        DapLocalCache.put((LocalCacheKey)CacheHelper.getLocalCacheKey(transId, bookId), succTaskIds);
    }

    public static void clearBookSuccessTaskIds(BuildVchContext context) {
        context.getBooks().keySet().forEach(k -> DapLocalCache.remove((LocalCacheKey)CacheHelper.getLocalCacheKey(context.getTransId(), k)));
    }

    private static LocalCacheKey getLocalCacheKey(Object ... keys) {
        return LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])keys);
    }

    public static void putNotMergedGLVouchers(String mergeCode, List<GLVoucher> glvouchers) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "notmergedvoucher");
        NotMergedGLVoucher v = new NotMergedGLVoucher();
        v.setVouchers(glvouchers);
        cache.put(key, (Object)v);
    }

    public static List<GLVoucher> getNotMergedGLVouchers(String mergeCode) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "notmergedvoucher");
        NotMergedGLVoucher v = (NotMergedGLVoucher)cache.get(key, NotMergedGLVoucher.class);
        if (v == null) {
            return null;
        }
        return v.getVouchers();
    }

    public static void putEntryMergeOption(String mergeCode, VchTplEntryMergeOption entryMergeOption) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "entrymergeoption");
        cache.put(key, (Object)entryMergeOption);
    }

    public static VchTplEntryMergeOption getEntryMergeOption(String mergeCode) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "entrymergeoption");
        return (VchTplEntryMergeOption)cache.get(key, VchTplEntryMergeOption.class);
    }

    public static void putMergeVchOperation(String mergeCode, String operateKey) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "mergevchoperation");
        MergeVchOperation op = new MergeVchOperation();
        op.setOperateKey(operateKey);
        cache.put(key, (Object)op);
    }

    public static String getMergeVchOperation(String mergeCode) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "mergevchoperation");
        MergeVchOperation v = (MergeVchOperation)cache.get(key, MergeVchOperation.class);
        if (v == null) {
            return null;
        }
        return v.getOperateKey();
    }

    public static void putSecondMergeVchOperation(String mergeCode, String operateKey) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "sortType");
        SecondMergeVchOperation op = new SecondMergeVchOperation();
        op.setOperateKey(operateKey);
        cache.put(key, (Object)op);
    }

    public static String getSecondMergeVchOperation(String mergeCode) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "sortType");
        SecondMergeVchOperation v = (SecondMergeVchOperation)cache.get(key, SecondMergeVchOperation.class);
        if (v == null) {
            return null;
        }
        return v.getOperateKey();
    }

    public static void putOrg(String mergeCode, String operateKey) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "org");
        OrgOperation op = new OrgOperation();
        op.setOperateKey(operateKey);
        cache.put(key, (Object)op);
    }

    public static String getOrg(String mergeCode) {
        String key = MessageFormat.format("{0}.{1}", mergeCode, "org");
        OrgOperation v = (OrgOperation)cache.get(key, OrgOperation.class);
        if (v == null) {
            return null;
        }
        return v.getOperateKey();
    }

    public static void clearMergeCache(String mergeCode) {
        String key1 = MessageFormat.format("{0}.{1}", mergeCode, "entrymergeoption");
        String key2 = MessageFormat.format("{0}.{1}", mergeCode, "notmergedvoucher");
        String key3 = MessageFormat.format("{0}.{1}", mergeCode, "mergevchoperation");
        String key4 = MessageFormat.format("{0}.{1}", mergeCode, "sortType");
        String key5 = MessageFormat.format("{0}.{1}", mergeCode, "org");
        cache.remove(key1);
        cache.remove(key2);
        cache.remove(key3);
        cache.remove(key4);
        cache.remove(key5);
    }

    public static void clearTaskResult(String transId, String taskId) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskResult");
        cache.remove(key);
        DapLocalCache.remove((LocalCacheKey)LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[]{taskId}));
        successIndex.decrementAndGet();
    }

    public static void putTaskErrReport(String transId, String taskId, SingleTaskErrReport taskErrReport) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskErrReport");
        cache.put(key, (Object)taskErrReport);
    }

    public static SingleTaskErrReport getTaskErrReport(String transId, String taskId) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskErrReport");
        SingleTaskErrReport taskErrReport = (SingleTaskErrReport)cache.get(key, SingleTaskErrReport.class);
        if (taskErrReport == null) {
            return new SingleTaskErrReport();
        }
        return taskErrReport;
    }

    public static void clearTaskErrReport(String transId, String taskId) {
        String key = MessageFormat.format("{0}.{1}", taskId, "taskErrReport");
        cache.remove(key);
    }
}

