/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.Plugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.builder.SourceBillCyType;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.util.SysParamConfig;

public class SourceBillHelper {
    private static String EntityId_PlugIn = "ai_buildvchplugin";
    private Map<String, List<Plugin>> pluginDefines = new HashMap<String, List<Plugin>>();
    private Plugin commonPlugin;
    private Plugin billBVPlugin = new Plugin();

    public Plugin getCommonPlugin() {
        return this.commonPlugin;
    }

    public SourceBillHelper() {
        this.billBVPlugin.setClassName("kd.fi.ai.mservice.builder.plugin.BillBVPlugin");
        this.billBVPlugin.setEnabled(true);
        this.billBVPlugin.setType(0);
        String value = SysParamConfig.get((String)"vchExtPlugin");
        if (null != value) {
            Plugin plugin = new Plugin();
            plugin.setClassName(value);
            plugin.setEnabled(true);
            this.commonPlugin = plugin;
        } else {
            Plugin defaultVchPlugin = new Plugin();
            defaultVchPlugin.setClassName("kd.fi.ai.mservice.builder.plugin.DefaultVchPlugin");
            defaultVchPlugin.setEnabled(true);
            defaultVchPlugin.setType(0);
            this.commonPlugin = defaultVchPlugin;
        }
    }

    public static MainEntityType getMainEntityType(String entityId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        return mainEntityType;
    }

    private String getBizappByNum(String num) {
        QFilter bizappidQfilter = new QFilter("number", "=", (Object)num);
        DynamicObjectCollection bizappObj = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{bizappidQfilter});
        if (bizappObj == null || bizappObj.size() == 0) {
            return null;
        }
        return ((DynamicObject)bizappObj.get(0)).getString("id");
    }

    public SourceBillInfo LoadSourceBillInfor(SelectedSourceBill selectedBill) {
        SourceBillInfo sourceBill = new SourceBillInfo();
        sourceBill.setEntityNumber(selectedBill.getEntityNumber());
        sourceBill.setEventClassID(selectedBill.getEventClassID());
        MainEntityType mainEntityType = SourceBillHelper.getMainEntityType(selectedBill.getEntityNumber());
        sourceBill.setBillName(mainEntityType.getDisplayName());
        this.LoadPluginDefines(sourceBill);
        sourceBill.setBillIds(selectedBill.getBillIds());
        sourceBill.setCyType(SourceBillCyType.UnKnown);
        sourceBill.setIgnoreBillNetControl(false);
        sourceBill.setHsCalculate(false);
        sourceBill.setBizAppId(this.getBizappByNum(mainEntityType.getAppId()));
        sourceBill.setBizAppName(this.getBizAppName(sourceBill.getBizAppId(), sourceBill.getEntityNumber()));
        sourceBill.setUnionType(selectedBill.getUnionType());
        sourceBill.setUnionFields(selectedBill.getUnionFields());
        if ("ai_event".equals(selectedBill.getEntityNumber())) {
            sourceBill.setConfig(DapCache.getDapConfigCache((String)"ai_eventclass", (long)sourceBill.getEventClassID()));
        } else {
            sourceBill.setConfig(DapCache.getDapConfigCache((String)selectedBill.getEntityNumber()));
        }
        sourceBill.setMultiDap(selectedBill.isMultiDap());
        sourceBill.setIgnoreTemplateUnique(selectedBill.isIgnoreTemplateUnique());
        sourceBill.setMergeCode(selectedBill.getMergeCode());
        return sourceBill;
    }

    private String getBizAppName(String bizAppId, String entityNumber) {
        String appName;
        if (bizAppId == null) {
            DynamicObject entityInfo = BusinessDataServiceHelper.loadSingle((Object)entityNumber, (String)"bos_entityobject", (String)"bizappid.id,bizappid.name");
            appName = entityInfo.getString("bizappid.name");
        } else {
            DynamicObject bizapp = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp");
            appName = bizapp.getString("name");
        }
        return appName;
    }

    private void LoadPluginDefines(SourceBillInfo sourceBill) {
        ArrayList<Object> plugins = new ArrayList<Object>();
        plugins.add(this.billBVPlugin);
        sourceBill.setVchExtPluginDefine(this.commonPlugin);
        if (this.pluginDefines.containsKey(sourceBill.getEntityNumber())) {
            plugins.addAll((Collection)this.pluginDefines.get(sourceBill.getEntityNumber()));
        } else {
            QFilter qFilter = new QFilter("FSourceBill.id", "=", (Object)sourceBill.getEntityNumber());
            QFilter[] filters = new QFilter[]{qFilter};
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)EntityId_PlugIn, (String)"id,fplugin,fenabled", (QFilter[])filters);
            ArrayList<Plugin> list = new ArrayList<Plugin>(objs.length);
            for (DynamicObject plugObj : objs) {
                Plugin plugin = new Plugin();
                plugin.setClassName(plugObj.getString("fplugin"));
                plugin.setEnabled(plugObj.getBoolean("fenabled"));
                list.add(plugin);
            }
            this.pluginDefines.put(sourceBill.getEntityNumber(), list);
            plugins.addAll(list);
        }
        sourceBill.getPluginDefines().addAll(plugins);
    }
}

