/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.dap.DapBillnoUtil;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.helper.SourceBillHelper;
import kd.fi.ai.mservice.builder.plugin.IVchPlugin;
import kd.fi.ai.mservice.service.helper.VchPluginUtil;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.bd.util.filter.QFilterBuilder;

public class AbstractVchPlugin
implements IVchPlugin {
    private static Log logger = LogFactory.getLog(AbstractVchPlugin.class);

    @Override
    public void setVoucherId(String entity, String tableName, String entryTableName, List<IVoucher<?>> glVouchers, ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        MainEntityType glMainEntityType = SourceBillHelper.getMainEntityType(entity);
        String dbRouteKey = glMainEntityType.getDBRouteKey();
        VchPluginUtil.setVoucherId(dbRouteKey, glVouchers, tableName, taskContext);
        VchPluginUtil.setVoucherEntryId(dbRouteKey, glVouchers, entryTableName, taskContext);
        VchPluginUtil.setAllGLVoucherId(taskResult);
    }

    @Override
    public void setGlvoucherBillNo(List<IVoucher<?>> noMergeVouchers, List<GLVoucher> mergeVouchers, ISingleTaskContext taskContext) {
    }

    @Override
    public Object[] saveGlvoucher(ISingleTaskContext taskContext, List<IVoucher<?>> noMergeVouchers) {
        return null;
    }

    @Override
    public Object[] saveMergeVouchers(ISingleTaskContext taskContext, List<GLVoucher> mergeVouchers) {
        return null;
    }

    @Override
    public DataSet getSubmitVoucherDataset(String entity, List<Object> voucherIds, ISingleTaskContext taskContext) {
        return QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.SaveBookTasksResult", (String)entity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds), new QFilter("billstatus", "=", (Object)"B")}, null);
    }

    @Override
    public DataSet getVoucherDataset(String entity, String join, List<Long> voucherids, ISingleTaskContext taskContext) {
        return QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.SaveBookTasksResult", (String)entity, (String)join, (QFilter[])new QFilter("id", "in", voucherids).toArray(), null);
    }

    @Override
    public void deleteVchEntryByFid(String entryTableName, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)("delete from " + entryTableName + " where fid = ?"), params);
    }

    @Override
    public void deleteVoucherEntry(String entryTableName, List<List<Object[]>> p2s, ISingleTaskContext taskContext) {
        String sql = "delete from " + entryTableName + " where fid=? and fentryid = ?";
        p2s.forEach(e -> DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, (List)e));
    }

    @Override
    public OperationResult executeOperate(String operationCode, String entity, List<Object> glVoucherIdsList, OperateOption option, ISingleTaskContext taskContext) {
        return OperationServiceHelper.executeOperate((String)operationCode, (String)entity, (Object[])glVoucherIdsList.toArray(), (OperateOption)option);
    }

    @Override
    public void deleteVchBySql(String tableName, List<Object[]> voucherIds, ISingleTaskContext taskContext) {
        String sql = "delete from " + tableName + " where fid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, voucherIds);
    }

    @Override
    public void updateVoucherentry(String entryTableName, List<Object[]> params, ISingleTaskContext taskContext) {
        String sql = "update " + entryTableName + " set fid=? where fid=?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, params);
    }

    @Override
    public void saveVouchers(Map<GLVoucherGroupKey, GLVoucher> result, ISingleTaskContext taskContext) {
    }

    @Override
    public void saveGlvoucherEntry(GLVoucher v, ISingleTaskContext taskContext) {
    }

    @Override
    public Long[] genarateGlVoucherId(String tableName, int size, int newGlvoucheSize, ISingleTaskContext taskContext) {
        SequenceReader glReader = new SequenceReader(new DBRoute("gl"));
        return (Long[])glReader.getSequences((Object[])new Long[size], tableName, newGlvoucheSize);
    }

    @Override
    public void setVoucherEntryId(String dbRouteKey, IVoucher<?> voucher, String entryTableName, Long voucherID, int seqStart, ISingleTaskContext taskContext) {
        ArrayList allRows = new ArrayList(voucher.getEntryRows());
        int seq = seqStart;
        for (IVoucherEntry row : voucher.getEntryRows()) {
            row.setSeq(seq);
            row.setId(voucherID.longValue());
            ++seq;
        }
        if (allRows.isEmpty()) {
            return;
        }
        SequenceReader sReader = new SequenceReader(new DBRoute(dbRouteKey));
        Long[] entryIds = (Long[])sReader.getSequences((Object[])new Long[allRows.size()], entryTableName, allRows.size());
        for (int i = 0; i < entryIds.length; ++i) {
            ((IVoucherEntry)allRows.get(i)).setEntryId(entryIds[i].longValue());
        }
    }

    @Override
    public void updateVoucherEntryId(String entryTableName, long id, Long oldID, ISingleTaskContext taskContext) {
        DB.update((DBRoute)DBRoute.of((String)"gl"), (String)("update " + entryTableName + " set fid = ? where fid = ?"), (Object[])new Object[]{id, oldID});
    }

    @Override
    public DynamicObjectCollection getGlVoucherEntry(GLVoucher glVoucher, ISingleTaskContext taskContext) {
        return null;
    }

    @Override
    public DynamicObject getGlvoucherDynamicObject(GLVoucher glVoucher, ISingleTaskContext taskContext) {
        return null;
    }

    @Override
    public SqlBuilder getSqlBuilder(String tableName, Set<Long> allGLVoucherIds) {
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select fid from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn("fid", new ArrayList<Long>(allGLVoucherIds));
        return sbd;
    }

    @Override
    public DynamicObject genVoucherDynamicObject(IVoucher<?> voucher, ISingleTaskContext taskContext) {
        return null;
    }

    @Override
    public OperationResult excuteOperationResult(String operationKey, String entity, Object[] ids, OperateOption option, ISingleTaskContext taskContext) {
        return OperationServiceHelper.executeOperate((String)operationKey, (String)entity, (Object[])ids, (OperateOption)option);
    }

    @Override
    public void deleteVoucher(String entity, Set<Object> ids, ISingleTaskContext taskContext) {
        OperateOption operateOption = BuildVoucherUtils.createDeleteVoucherOpt();
        operateOption.setVariableValue("isFirstOperation", "true");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids.toArray(), (OperateOption)operateOption);
        int size = operationResult.getSuccessPkIds().size();
        logger.info(String.format("\u901a\u8fc7\u5220\u9664\u64cd\u4f5c\u5220\u9664\u7684\u8bb0\u5f55\u6709---%s---\u6761", size));
        if (!operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null && !successPkIds.isEmpty()) {
                for (Object successPkId : successPkIds) {
                    ids.remove(successPkId);
                }
            }
            if (!ids.isEmpty()) {
                size = DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter("id", "in", ids).toArray());
                TempVoucherService.deleteByIds((Long[])ids.toArray(new Long[0]));
                logger.info(String.format("\u901a\u8fc7\u6570\u636e\u5e93\u5220\u9664\u7684\u8bb0\u5f55\u6709---%s---\u6761", size));
                String joinIds = QFilterBuilder.buildSQLParamHolder((int)ids.size());
                logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684\u4e1a\u52a1\u51ed\u8bc1");
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where fglvoucherid in " + joinIds + ")"), (Object[])ids.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucher where fglvoucherid in " + joinIds), (Object[])ids.toArray());
                logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684DAP\u5173\u7cfb");
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptrackerentry where fid in (select fid from t_ai_daptracker where fvoucherid in " + joinIds + ")"), (Object[])ids.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptracker where fvoucherid in " + joinIds), (Object[])ids.toArray());
                logger.info(String.format("\u603b\u8bb0\u5f55\u6709---%s---\u6761", ids.size()));
            }
        }
    }

    @Override
    public void reyGLVoucherBillNo(List<IVoucher<?>> vouchers, ISingleTaskContext taskContext, String entity) {
        logger.info("\u4e8c\u6b21\u5408\u5e76\u56de\u6536\u65ad\u53f7");
        HashMap<Long, IVoucher> dyVoucherMap = new HashMap<Long, IVoucher>();
        List<DynamicObject> glVouchers = DapBillnoUtil.convertToDynamicObject(entity, vouchers, taskContext, dyVoucherMap);
        if (glVouchers == null || glVouchers.isEmpty()) {
            return;
        }
        ICodeRuleService crservice = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        glVouchers.stream().forEach(v -> crservice.recycleNumber(entity, v, v.getString("org_id"), v.getString("billno")));
    }

    @Override
    public String getVoucherEntity(Long voucherid) {
        return "gl_voucher";
    }

    @Override
    public String getPreviewVoucherEntity(Long orgId, Long booktypeId) {
        return "ai_previewvoucher";
    }
}

