/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.plugin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.dap.DapBillnoUtil;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.plugin.AbstractVchPlugin;
import kd.fi.ai.util.VoucherSaveHelper;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;

public class DefaultVchPlugin
extends AbstractVchPlugin {
    public static final String ENTITY_NAME = "gl_voucher";

    @Override
    public void setVoucherId(String entity, String tableName, String entryTableName, List<IVoucher<?>> glVouchers, ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super.setVoucherId(entity, tableName, entryTableName, glVouchers, taskContext, taskResult);
    }

    @Override
    public void setGlvoucherBillNo(List<IVoucher<?>> noMergeVouchers, List<GLVoucher> mergeVouchers, ISingleTaskContext taskContext) {
        String entityName = FahOptimizeControlPanel.getCodeRuleEntity();
        try {
            if (noMergeVouchers.size() > 0) {
                DapBillnoUtil.setGLVoucherBillNo(entityName, noMergeVouchers, taskContext);
            }
            if (mergeVouchers.size() > 0) {
                DapBillnoUtil.setGLVoucherBillNo(entityName, mergeVouchers.stream().map(e -> e).collect(Collectors.toList()), taskContext);
            }
        }
        catch (Exception e2) {
            String errorMessage = ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e73\u53f0\u8bbe\u7f6e\u6682\u5b58\u51ed\u8bc1\u7f16\u53f7\u51fa\u9519\uff0c\u53ef\u80fd\u7f16\u7801\u89c4\u5219\u5df2\u7ecf\u4f7f\u7528\u5b8c\u6bd5\u3002", (String)"DefaultVchPlugin_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
            throw new DapException(errorMessage, (Throwable)e2);
        }
    }

    @Override
    public Object[] saveGlvoucher(ISingleTaskContext taskContext, List<IVoucher<?>> noMergeVouchers) {
        IDataEntityType glVoucherType = OrmUtils.getDataEntityType(GLVoucher.class);
        return SaveServiceHelper.save((IDataEntityType)glVoucherType, (Object[])noMergeVouchers.toArray());
    }

    @Override
    public Object[] saveMergeVouchers(ISingleTaskContext taskContext, List<GLVoucher> mergeVouchers) {
        return SaveServiceHelper.save((DynamicObject[])mergeVouchers.stream().map(gv -> gv.toDynamicObjectVoucher(taskContext)).collect(Collectors.toList()).toArray(new DynamicObject[0]));
    }

    @Override
    public DataSet getVoucherDataset(String entity, String join, List<Long> voucherids, ISingleTaskContext taskContext) {
        return super.getVoucherDataset(entity, join, voucherids, taskContext);
    }

    @Override
    public SqlBuilder getSqlBuilder(String tableName, Set<Long> allGLVoucherIds) {
        return super.getSqlBuilder(tableName, allGLVoucherIds);
    }

    @Override
    public void deleteVchEntryByFid(String entryTableName, List<Object[]> params) {
        super.deleteVchEntryByFid(entryTableName, params);
    }

    @Override
    public void deleteVoucherEntry(String entryTableName, List<List<Object[]>> p2s, ISingleTaskContext taskContext) {
        super.deleteVoucherEntry(entryTableName, p2s, taskContext);
    }

    @Override
    public OperationResult executeOperate(String operationCode, String entity, List<Object> glVoucherIdsList, OperateOption option, ISingleTaskContext taskContext) {
        return super.executeOperate(operationCode, entity, glVoucherIdsList, option, taskContext);
    }

    @Override
    public void deleteVchBySql(String tableName, List<Object[]> voucherIds, ISingleTaskContext taskContext) {
        super.deleteVchBySql(tableName, voucherIds, taskContext);
    }

    @Override
    public void updateVoucherentry(String entryTableName, List<Object[]> params, ISingleTaskContext taskContext) {
        super.updateVoucherentry(entryTableName, params, taskContext);
    }

    @Override
    public void saveVouchers(Map<GLVoucherGroupKey, GLVoucher> result, ISingleTaskContext taskContext) {
        result.values().stream().map(e -> e.toDynamicObjectVoucher(taskContext)).collect(Collectors.toList()).toArray(new DynamicObject[0]);
    }

    @Override
    public void saveGlvoucherEntry(GLVoucher v, ISingleTaskContext taskContext) {
        DynamicObject glD = v.toDynamicObjectVoucher(taskContext);
        VoucherSaveHelper.saveGLVoucherEntries((long)v.getOrgId(), (long)v.getPeriodId(), (List)glD.getDynamicObjectCollection("entries"));
    }

    @Override
    public Long[] genarateGlVoucherId(String tableName, int size, int newGlvoucheSize, ISingleTaskContext taskContext) {
        return super.genarateGlVoucherId(tableName, size, newGlvoucheSize, taskContext);
    }

    @Override
    public void setVoucherEntryId(String dbRouteKey, IVoucher<?> voucher, String entryTableName, Long voucherID, int seqStart, ISingleTaskContext taskContext) {
        super.setVoucherEntryId(dbRouteKey, voucher, entryTableName, voucherID, seqStart, taskContext);
    }

    @Override
    public void updateVoucherEntryId(String entryTableName, long id, Long oldID, ISingleTaskContext taskContext) {
        super.updateVoucherEntryId(entryTableName, id, oldID, taskContext);
    }

    @Override
    public DynamicObjectCollection getGlVoucherEntry(GLVoucher glVoucher, ISingleTaskContext taskContext) {
        return glVoucher.toDynamicObjectVoucher(taskContext).getDynamicObjectCollection("entries");
    }

    @Override
    public DynamicObject getGlvoucherDynamicObject(GLVoucher glVoucher, ISingleTaskContext taskContext) {
        return glVoucher.toDynamicObjectVoucher(taskContext);
    }

    @Override
    public DataSet getSubmitVoucherDataset(String entity, List<Object> voucherIds, ISingleTaskContext taskContext) {
        return super.getSubmitVoucherDataset(entity, voucherIds, taskContext);
    }

    @Override
    public DynamicObject genVoucherDynamicObject(IVoucher<?> voucher, ISingleTaskContext taskContext) {
        return voucher.toDynamicObjectVoucher(taskContext);
    }

    @Override
    public OperationResult excuteOperationResult(String operationKey, String entity, Object[] ids, OperateOption option, ISingleTaskContext taskContext) {
        return super.excuteOperationResult(operationKey, entity, ids, option, taskContext);
    }

    @Override
    public void deleteVoucher(String entity, Set<Object> ids, ISingleTaskContext taskContext) {
        super.deleteVoucher(entity, ids, taskContext);
    }

    @Override
    public void reyGLVoucherBillNo(List<IVoucher<?>> vouchers, ISingleTaskContext taskContext, String entity) {
        super.reyGLVoucherBillNo(vouchers, taskContext, entity);
    }
}

