/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.progresser;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.BuildVchProgressInfo;
import kd.fi.ai.builder.IBuildVchProgresser;
import kd.fi.ai.builder.SingleTaskInfo;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.mservice.builder.helper.CacheHelper;
import kd.fi.ai.mservice.builder.progresser.BookProgressInfo;
import kd.fi.ai.mservice.builder.progresser.OverallProgressInfo;
import kd.fi.ai.mservice.builder.progresser.SimpleProgressInfo;
import kd.fi.ai.mservice.builder.progresser.SrcBillProgressInfo;
import kd.fi.ai.mservice.builder.progresser.TaskProgressInfo;
import kd.fi.ai.mservice.builder.progresser.TplProgressInfo;

public class BuildVchProgresser
implements IBuildVchProgresser {
    private static Log logger = LogFactory.getLog(BuildVchProgresser.class);
    public static final boolean hwpoc = true;
    private String transId;
    private int retention = 5;
    private OverallProgressInfo overallProgressInfo = new OverallProgressInfo();
    private Map<String, TaskProgressInfo> tasks = new HashMap<String, TaskProgressInfo>();
    private TaskProgressInfo currTask;

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public void setCurrTask(TaskProgressInfo currTask) {
        this.currTask = currTask;
    }

    public boolean isCancel() {
        Boolean cancel = CacheHelper.getCancelFlag(this.transId);
        return cancel;
    }

    public void setCancel(boolean cancel) {
        if (cancel) {
            CacheHelper.putCancelFlag(this.transId);
        }
    }

    public void AddBillIds(AcctBookInfo book, SourceBillInfo sourceBill, VCHTemplate template, List<Object> billIds) {
        BookProgressInfo bookProgressInfo = null;
        if (!this.overallProgressInfo.getBooks().containsKey(book.getBookId())) {
            bookProgressInfo = new BookProgressInfo();
            bookProgressInfo.setBookId(book.getBookId());
            this.overallProgressInfo.getBooks().put(book.getBookId(), bookProgressInfo);
        } else {
            bookProgressInfo = this.overallProgressInfo.getBooks().get(book.getBookId());
        }
        SrcBillProgressInfo srcBillProgressInfo = null;
        if (!bookProgressInfo.getSourceBills().containsKey(sourceBill.getEntityNumber())) {
            srcBillProgressInfo = new SrcBillProgressInfo();
            srcBillProgressInfo.setEntityNumber(sourceBill.getEntityNumber());
            bookProgressInfo.getSourceBills().put(sourceBill.getEntityNumber(), srcBillProgressInfo);
        } else {
            srcBillProgressInfo = bookProgressInfo.getSourceBills().get(sourceBill.getEntityNumber());
        }
        TplProgressInfo tplProgressInfo = null;
        for (TplProgressInfo item : srcBillProgressInfo.getTemplates()) {
            if (!item.getTemplateId().equalsIgnoreCase(template.getId())) continue;
            tplProgressInfo = item;
            break;
        }
        if (tplProgressInfo == null) {
            tplProgressInfo = new TplProgressInfo();
            tplProgressInfo.setTemplateId(template.getId());
            srcBillProgressInfo.getTemplates().add(tplProgressInfo);
        }
        tplProgressInfo.getBillIds().addAll(billIds);
    }

    public void AddBizVoucherIds(AcctBookInfo book, SourceBillInfo sourceBill, List<Long> histBizVchIds) {
        BookProgressInfo bookProgressInfo = null;
        Map<Long, BookProgressInfo> books = this.overallProgressInfo.getBooks();
        if (!books.containsKey(book.getBookId())) {
            bookProgressInfo = new BookProgressInfo();
            bookProgressInfo.setBookId(book.getBookId());
            books.put(book.getBookId(), bookProgressInfo);
        } else {
            bookProgressInfo = books.get(book.getBookId());
        }
        SrcBillProgressInfo srcBillProgressInfo = null;
        Map<String, SrcBillProgressInfo> sourceBills = bookProgressInfo.getSourceBills();
        if (!sourceBills.containsKey(sourceBill.getEntityNumber())) {
            srcBillProgressInfo = new SrcBillProgressInfo();
            srcBillProgressInfo.setEntityNumber(sourceBill.getEntityNumber());
            sourceBills.put(sourceBill.getEntityNumber(), srcBillProgressInfo);
        } else {
            srcBillProgressInfo = sourceBills.get(sourceBill.getEntityNumber());
        }
        TplProgressInfo tplProgressInfo = null;
        for (TplProgressInfo item : srcBillProgressInfo.getTemplates()) {
            if (!StringUtils.isBlank((CharSequence)item.getTemplateId())) continue;
            tplProgressInfo = item;
            break;
        }
        if (tplProgressInfo == null) {
            if (srcBillProgressInfo.getTemplates().size() == 0) {
                tplProgressInfo = new TplProgressInfo();
                tplProgressInfo.setTemplateId("ISBIZVOUCHERGENGLVCH");
                srcBillProgressInfo.getTemplates().add(tplProgressInfo);
            } else {
                tplProgressInfo = srcBillProgressInfo.getTemplates().get(0);
            }
        }
        tplProgressInfo.getBizVoucherIds().addAll(histBizVchIds);
    }

    public void EndInitialize() {
        int bookCount = this.overallProgressInfo.getBooks().size();
        int srcBillCount = 0;
        int tplCount = 0;
        int billIdCount = 0;
        for (Map.Entry<Long, BookProgressInfo> entry : this.overallProgressInfo.getBooks().entrySet()) {
            srcBillCount += entry.getValue().getSourceBills().size();
            for (Map.Entry<String, SrcBillProgressInfo> srcBillItem : entry.getValue().getSourceBills().entrySet()) {
                tplCount += srcBillItem.getValue().getTemplates().size();
                for (TplProgressInfo tplProgressInfo : srcBillItem.getValue().getTemplates()) {
                    billIdCount += tplProgressInfo.getBillIds().size();
                    billIdCount += tplProgressInfo.getBizVoucherIds().size();
                }
            }
        }
        this.overallProgressInfo.setBookCount(bookCount);
        this.overallProgressInfo.setSrcBillCount(srcBillCount);
        this.overallProgressInfo.setTplCount(tplCount);
        this.overallProgressInfo.setSrcBillIdCount(billIdCount);
        if (billIdCount != 0) {
            BigDecimal billStep = new BigDecimal((100 - this.retention) / billIdCount);
            this.overallProgressInfo.setBillStep(billStep);
        }
        CacheHelper.putOverallProgress(this.transId, this.overallProgressInfo);
        for (Map.Entry entry : this.tasks.entrySet()) {
            CacheHelper.putTaskProgress(this.transId, (TaskProgressInfo)entry.getValue());
        }
        SimpleProgressInfo spi = new SimpleProgressInfo();
        spi.setAllTask(this.tasks.size());
        CacheHelper.putSimpleProgress(this.transId, spi);
    }

    public void BeginTask(String taskId) {
        this.overallProgressInfo = CacheHelper.getOverallProgress(this.transId);
        this.currTask = CacheHelper.getTaskProgress(this.transId, taskId);
        this.currTask.setLastUpCacheTime(new Date());
        this.currTask.setNoUpCacheCount(0);
    }

    public void FinishTask() {
        this.currTask.setFinished(true);
        CacheHelper.putTaskProgress(this.transId, this.currTask);
        SimpleProgressInfo spi = CacheHelper.getSimpleProgress(this.transId);
        spi.setCompleteTask(spi.getCompleteTask() + 1);
        logger.info("FinishTask - trasnId:" + this.transId + " -- spi.getCompleteTask():" + spi.getCompleteTask() + " -- AllTask:" + spi.getAllTask());
        CacheHelper.putSimpleProgress(this.transId, spi);
    }

    public boolean isBookCompleted() {
        SimpleProgressInfo info = CacheHelper.getSimpleProgress(this.transId);
        logger.info("isBookCompleted - trasnId:" + this.transId + " -- info.getCompleteTask():" + info.getCompleteTask() + " -- AllTask:" + info.getAllTask());
        return info.getCompleteTask() - info.getAllTask() == 0;
    }

    public void Forward(int per, String message) {
        int forwardPer = per;
        if (this.retention > per) {
            this.retention -= per;
        } else {
            forwardPer = this.retention;
        }
        if (forwardPer > 0) {
            BuildVchProgressInfo progressInfo = CacheHelper.getProgressInfo(this.transId);
            BigDecimal newValue = progressInfo.getValue().add(new BigDecimal(forwardPer));
            progressInfo.setValue(newValue);
            progressInfo.setMessage(message);
            CacheHelper.putProgressInfo(this.transId, progressInfo);
        }
    }

    public void FinishSingleBill(Object billId) {
        this.currTask.setNoUpCacheCount(this.currTask.getNoUpCacheCount() + 1);
    }

    public void FinishSingleBizVch(long bizVoucherId) {
        this.currTask.setNoUpCacheCount(this.currTask.getNoUpCacheCount() + 1);
    }

    public BuildVchProgressInfo getProgressInfo() {
        BuildVchProgressInfo progressInfo = CacheHelper.getProgressInfo(this.transId);
        return progressInfo;
    }

    public List<String> getBookTaskIds(AcctBookInfo book) {
        ArrayList<String> taskIds = new ArrayList<String>();
        BookProgressInfo bookProgressInfo = this.overallProgressInfo.getBooks().get(book.getBookId());
        for (Map.Entry<String, SrcBillProgressInfo> entry : bookProgressInfo.getSourceBills().entrySet()) {
            SrcBillProgressInfo billProgressInfo = entry.getValue();
            for (TplProgressInfo tplProgressInfo : billProgressInfo.getTemplates()) {
                taskIds.addAll(tplProgressInfo.getTaskIds());
            }
        }
        return taskIds;
    }

    public void removeTask(long bookId, String taskId) {
        BookProgressInfo bookProgressInfo = this.overallProgressInfo.getBooks().get(bookId);
        for (Map.Entry<String, SrcBillProgressInfo> entry : bookProgressInfo.getSourceBills().entrySet()) {
            SrcBillProgressInfo billProgressInfo = entry.getValue();
            for (TplProgressInfo tplProgressInfo : billProgressInfo.getTemplates()) {
                tplProgressInfo.getTaskIds().remove(taskId);
            }
        }
    }

    private List<String> getCurrBookTaskIds() {
        ArrayList<String> taskIds = new ArrayList<String>();
        BookProgressInfo bookProgressInfo = this.overallProgressInfo.getBooks().get(this.currTask.getTaskInfo().getBookId());
        for (Map.Entry<String, SrcBillProgressInfo> entry : bookProgressInfo.getSourceBills().entrySet()) {
            SrcBillProgressInfo billProgressInfo = entry.getValue();
            for (TplProgressInfo tplProgressInfo : billProgressInfo.getTemplates()) {
                taskIds.addAll(tplProgressInfo.getTaskIds());
            }
        }
        return taskIds;
    }

    public List<String> getTaskIds() {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (BookProgressInfo book : this.overallProgressInfo.getBooks().values()) {
            for (SrcBillProgressInfo srcBill : book.getSourceBills().values()) {
                for (TplProgressInfo tpl : srcBill.getTemplates()) {
                    taskIds.addAll(tpl.getTaskIds());
                }
            }
        }
        return taskIds;
    }

    public SingleTaskInfo getCurrTaskInfo() {
        return this.currTask.getTaskInfo();
    }

    public List<SingleTaskInfo> getTaskInfos() {
        ArrayList<SingleTaskInfo> taskInfos = new ArrayList<SingleTaskInfo>(10);
        for (Map.Entry<String, TaskProgressInfo> taskItem : this.tasks.entrySet()) {
            taskInfos.add(taskItem.getValue().getTaskInfo());
        }
        return taskInfos;
    }

    public void addTaskInfo(SingleTaskInfo taskInfo) {
        TaskProgressInfo taskProgressInfo = new TaskProgressInfo();
        taskProgressInfo.setTaskInfo(taskInfo);
        this.tasks.put(taskInfo.getTaskId(), taskProgressInfo);
        BookProgressInfo bookProgressInfo = this.overallProgressInfo.getBooks().get(taskInfo.getBookId());
        SrcBillProgressInfo srcBillProgressInfo = bookProgressInfo.getSourceBills().get(taskInfo.getEntityNumber());
        String tplId = taskInfo.getTemplateId();
        for (TplProgressInfo tplProgressInfo : srcBillProgressInfo.getTemplates()) {
            if (StringUtils.isBlank((CharSequence)tplId) && StringUtils.isBlank((CharSequence)tplProgressInfo.getTemplateId())) {
                tplProgressInfo.getTaskIds().add(taskInfo.getTaskId());
                break;
            }
            if (tplProgressInfo.getTemplateId().equalsIgnoreCase(taskInfo.getTemplateId())) {
                tplProgressInfo.getTaskIds().add(taskInfo.getTaskId());
                break;
            }
            if (!tplProgressInfo.getTemplateId().equalsIgnoreCase("ISBIZVOUCHERGENGLVCH")) continue;
            tplProgressInfo.getTaskIds().add(taskInfo.getTaskId());
            break;
        }
    }

    private void RefreshAllTaskProgressInfo() {
        this.tasks.clear();
        List<String> allTaskIds = this.getTaskIds();
        for (String otherTaskId : allTaskIds) {
            TaskProgressInfo taskProgressInfo = CacheHelper.getTaskProgress(this.transId, otherTaskId);
            this.tasks.put(otherTaskId, taskProgressInfo);
        }
    }

    private void UpdateFinishedTaskCount() {
        int finishedBookCount = 0;
        int finishedSrcBillCount = 0;
        int finishedTplCount = 0;
        for (Map.Entry<Long, BookProgressInfo> bookItem : this.overallProgressInfo.getBooks().entrySet()) {
            boolean bookIsFinished = true;
            for (Map.Entry<String, SrcBillProgressInfo> srcBillItem : bookItem.getValue().getSourceBills().entrySet()) {
                boolean srcBillIsFinished = true;
                for (TplProgressInfo tplProgressInfo : srcBillItem.getValue().getTemplates()) {
                    boolean tplIsFinished = true;
                    for (String taskId : tplProgressInfo.getTaskIds()) {
                        TaskProgressInfo taskProgressInfo = this.tasks.get(taskId);
                        if (taskProgressInfo.isFinished()) continue;
                        tplIsFinished = false;
                        srcBillIsFinished = false;
                        bookIsFinished = false;
                        break;
                    }
                    if (!tplIsFinished) continue;
                    ++finishedTplCount;
                }
                if (!srcBillIsFinished) continue;
                ++finishedSrcBillCount;
            }
            if (!bookIsFinished) continue;
            ++finishedBookCount;
        }
        BuildVchProgressInfo progressInfo = CacheHelper.getProgressInfo(this.transId);
        int finishedBillIdCount = progressInfo.getFinishedBillIdCount() + this.currTask.getNoUpCacheCount();
        BigDecimal per = this.overallProgressInfo.getBillStep().multiply(new BigDecimal(this.currTask.getNoUpCacheCount()));
        progressInfo.setValue(progressInfo.getValue().add(per));
        this.currTask.setNoUpCacheCount(0);
        progressInfo.setFinishedBookCount(finishedBookCount);
        progressInfo.setFinishedSrcBillCount(finishedSrcBillCount);
        progressInfo.setFinishedTplCount(finishedTplCount);
        progressInfo.setFinishedBillIdCount(finishedBillIdCount);
        progressInfo.setMessage(this.FormatProgressMessage(progressInfo));
        CacheHelper.putProgressInfo(this.transId, progressInfo);
    }

    private void UpdateFinishedBillId() {
        Date now = new Date();
        long diff = now.getTime() - this.currTask.getLastUpCacheTime().getTime();
        if (diff > 2000L) {
            BuildVchProgressInfo progressInfo = CacheHelper.getProgressInfo(this.transId);
            BigDecimal per = this.overallProgressInfo.getBillStep().multiply(new BigDecimal(this.currTask.getNoUpCacheCount()));
            progressInfo.setValue(progressInfo.getValue().add(per));
            progressInfo.setFinishedBillIdCount(progressInfo.getFinishedBillIdCount() + this.currTask.getNoUpCacheCount());
            progressInfo.setMessage(this.FormatProgressMessage(progressInfo));
            CacheHelper.putProgressInfo(this.transId, progressInfo);
            this.currTask.setNoUpCacheCount(0);
            this.currTask.setLastUpCacheTime(now);
        }
    }

    private String FormatProgressMessage(BuildVchProgressInfo progressInfo) {
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u8d26\u7c3f\uff1a{0}/{1}\uff1b\u6765\u6e90\u5355\u636e\uff1a{2}/{3}\uff1b\u51ed\u8bc1\u6a21\u677f\uff1a{4}/{5}\uff1b\u539f\u59cb\u4e1a\u52a1\u5355\u636e\uff1a{6}/{7}", (String)"BuildVchProgresser_0", (String)"fi-ai-mservice", (Object[])new Object[0]), progressInfo.getFinishedBookCount(), this.overallProgressInfo.getBookCount(), progressInfo.getFinishedSrcBillCount(), this.overallProgressInfo.getSrcBillCount(), progressInfo.getFinishedTplCount(), this.overallProgressInfo.getTplCount(), progressInfo.getFinishedBillIdCount(), this.overallProgressInfo.getSrcBillIdCount());
        return message;
    }
}

