/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.reporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.mservice.builder.reporter.ReportEntry;
import kd.fi.ai.mservice.builder.reporter.ReportHeader;

public class BuildVchReportUtils {
    public static final String HAED_ENTITYNAME = "ai_newbuildreporthead";
    public static final String USERNAME = "username";
    public static final String OPNAME = "opname";
    public static final String OPDESC = "opdesc";
    public static final String OPDATE = "opdate";
    public static final String TRANSID = "transid";
    public static final String GLVOUCHER = "glvoucher";
    public static final String GLVOUCHERNO = "glvoucherno";
    public static final String BIZVOUCHER = "bizvoucher";
    public static final String BIZVOUCHERNO = "bizvoucherno";
    public static final String PERIODID = "periodid";
    public static final String PERIOD = "period";
    public static final String SOURCESYS = "sourcesys";
    public static final String SOURCEBILL = "sourcebill";
    public static final String SOURCEBILLNUMBER = "sourcebillnumber";
    public static final String SOURCEBILLNO = "sourcebillno";
    public static final String SOURCEBILLID = "fsourcebillid";
    public static final String BUILDSTATE = "buildstate";
    public static final String ACCOUNTBOOKID = "accountbookid";
    public static final String ACCOUNTBOOK = "accountbook";
    public static final String VCHTEMPLATEID = "vchtemplateid";
    public static final String VCHTEMPLATENO = "vchtemplateno";
    public static final String VCHTEMPLATE = "vchtemplate";
    public static final String ISEXCEPTIONREPORT = "isexceptionreport";
    public static final String BUILDTYPE = "buildtype";
    public static final String ERRORRESULT = "errorresult";
    public static final String BUILDVOUCHERTYPE = "buildvouchertype";
    public static final String ORGID = "orgid";
    public static final String ORG = "org";
    public static final String EXCEPTIONINFO = "exceptioninfo";
    public static final String ENTRY_ENTITYNAME = "ai_newbuildreportentry";
    public static final String BUILDREPORTHRADID = "buildreportheadid";
    public static final String CHECKITEM = "checkitem";
    public static final String ERRLEVEL = "errlevel";
    public static final String MESSAGE = "message";
    public static final String ID = "id";

    public static List<DynamicObject> queryNewVchbuildReportByIds(List<Long> ids) {
        if (ids.isEmpty()) {
            return null;
        }
        LogORM logORM = LogORM.create();
        return logORM.query(HAED_ENTITYNAME, "id,glvoucher,glvoucherno", new QFilter[]{new QFilter(ID, "in", ids)}, 10000000, 0);
    }

    public static List<DynamicObject> queryNewVchbuildReportByGlvoucherIds(List<Long> glvoucherids) {
        if (glvoucherids.isEmpty()) {
            return null;
        }
        LogORM logORM = LogORM.create();
        return logORM.query(HAED_ENTITYNAME, "id,glvoucher,glvoucherno", new QFilter[]{new QFilter(GLVOUCHER, "in", glvoucherids)}, 10000000, 0);
    }

    public static List<DynamicObject> genNewVchBuildReportByHeads(List<ReportHeader> heads) {
        ArrayList<DynamicObject> headLogs = new ArrayList<DynamicObject>(heads.size());
        HashSet<Long> periodSet = new HashSet<Long>(8);
        HashSet<Long> bookTypeSet = new HashSet<Long>(8);
        HashSet<Long> vchtemplateSet = new HashSet<Long>(8);
        HashSet<Long> orgSet = new HashSet<Long>(8);
        HashSet<Long> userSet = new HashSet<Long>(8);
        HashSet<String> billTypeSet = new HashSet<String>(8);
        for (ReportHeader head : heads) {
            periodSet.add(head.getPeriodId());
            bookTypeSet.add(head.getBookId());
            vchtemplateSet.add(Long.parseLong(head.getVchTemplateID()));
            orgSet.add(head.getOrgId());
            userSet.add(head.getCreatorId());
            billTypeSet.add(head.getSourceBill());
        }
        List<Map<Long, String>> periodList = BuildVchReportUtils.getPeriodByIds(periodSet);
        List<Map<Long, String>> bookTypeList = BuildVchReportUtils.getBookTypeByIds(bookTypeSet);
        List<Map<Long, DynamicObject>> vchtemplateList = BuildVchReportUtils.getVchTemplateByIds(vchtemplateSet);
        List<Map<Long, String>> orgList = BuildVchReportUtils.getOrgByIds(orgSet);
        List<Map<Long, String>> userList = BuildVchReportUtils.getUserByIds(userSet);
        List<Map<String, String>> billTypeList = BuildVchReportUtils.getBillTypeByIds(billTypeSet);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)HAED_ENTITYNAME);
        for (ReportHeader head : heads) {
            DynamicObject headLog = new DynamicObject((DynamicObjectType)type);
            headLog.set(ID, (Object)head.getId());
            headLog.set(TRANSID, (Object)head.getTransId());
            headLog.set(GLVOUCHER, (Object)head.getGlVoucherId());
            headLog.set(GLVOUCHERNO, (Object)head.getGlVoucherNo());
            headLog.set(BIZVOUCHER, (Object)head.getBizVoucherId());
            headLog.set(BIZVOUCHERNO, (Object)head.getBizVoucherNo());
            headLog.set(SOURCESYS, (Object)head.getSourceSys());
            headLog.set(SOURCEBILLNO, (Object)head.getSourceBillNo());
            headLog.set(SOURCEBILLID, (Object)head.getSourceBillId());
            headLog.set(BUILDTYPE, (Object)head.getBuildType());
            headLog.set(BUILDVOUCHERTYPE, (Object)head.getBuildVouchertype());
            headLog.set(BUILDSTATE, (Object)head.getBuildState());
            headLog.set(ISEXCEPTIONREPORT, (Object)"0");
            for (Map<Long, String> map : periodList) {
                if (!map.containsKey(head.getPeriodId())) continue;
                headLog.set(PERIODID, (Object)head.getPeriodId());
                headLog.set(PERIOD, (Object)map.get(head.getPeriodId()));
            }
            for (Map<Long, String> map : bookTypeList) {
                if (!map.containsKey(head.getBookId())) continue;
                headLog.set(ACCOUNTBOOKID, (Object)head.getBookId());
                if ("1".equals(map.get(head.getBookId()))) {
                    headLog.set(ACCOUNTBOOK, (Object)ResManager.loadKDString((String)"\u4e3b\u8d26\u7c3f", (String)"BuildVchReportUtils_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    continue;
                }
                headLog.set(ACCOUNTBOOK, (Object)ResManager.loadKDString((String)"\u7ba1\u7406\u8d26\u7c3f", (String)"BuildVchReportUtils_1", (String)"fi-ai-mservice", (Object[])new Object[0]));
            }
            Long templateId = Long.parseLong(head.getVchTemplateID());
            for (Map<Long, DynamicObject> map : vchtemplateList) {
                if (!map.containsKey(templateId)) continue;
                DynamicObject obejct = map.get(templateId);
                headLog.set(VCHTEMPLATEID, (Object)templateId);
                headLog.set(VCHTEMPLATENO, obejct.get("number"));
                headLog.set(VCHTEMPLATE, obejct.get("name"));
            }
            for (Map<Long, Object> map : orgList) {
                if (!map.containsKey(head.getOrgId())) continue;
                headLog.set(ORGID, (Object)head.getOrgId());
                headLog.set(ORG, map.get(head.getOrgId()));
            }
            for (Map<Long, Object> map : userList) {
                if (!map.containsKey(head.getCreatorId())) continue;
                headLog.set(USERNAME, map.get(head.getCreatorId()));
            }
            for (Map<Object, Object> map : billTypeList) {
                if (!map.containsKey(head.getSourceBill())) continue;
                String sourceBillName = (String)map.get(head.getSourceBill());
                headLog.set(SOURCEBILL, (Object)sourceBillName);
                headLog.set(SOURCEBILLNUMBER, (Object)head.getSourceBill());
            }
            headLogs.add(headLog);
        }
        return headLogs;
    }

    public static List<DynamicObject> genNewVchBuildReportByEntrys(List<ReportEntry> entries) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTRY_ENTITYNAME);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        for (ReportEntry entry : entries) {
            DynamicObject entryLog = new DynamicObject((DynamicObjectType)type);
            entryLog.set(ID, (Object)entry.getEntryId());
            entryLog.set(BUILDREPORTHRADID, (Object)entry.getBuildreportheadid());
            entryLog.set(CHECKITEM, (Object)entry.getCheckItem());
            entryLog.set(ERRLEVEL, (Object)entry.getErrLevel());
            entryLog.set(MESSAGE, (Object)entry.getMessage());
            list.add(entryLog);
        }
        return list;
    }

    public static List<Map<Long, String>> getPeriodByIds(Set<Long> ids) {
        ArrayList<Map<Long, String>> list = new ArrayList<Map<Long, String>>();
        HashMap<Long, String> map = new HashMap<Long, String>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bd_period", (String)"id,name", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        for (DynamicObject object : collections) {
            map.put(object.getLong(ID), object.getString("name"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<Long, String>> getBookTypeByIds(Set<Long> ids) {
        ArrayList<Map<Long, String>> list = new ArrayList<Map<Long, String>>();
        String sql = "select a.fid as id ,b.faccounttype as name from t_bd_accountbooks a left join t_bd_accountbookstype b on a.fbookstypeid = b.fid where ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(sql, new Object[0]).appendIn("a.fid", ids.toArray());
        HashMap<Long, String> map = new HashMap<Long, String>();
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.mservice.BuildVchReportUtils", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : queryDataSet) {
                map.put(row.getLong(ID), row.getString("name"));
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<Long, DynamicObject>> getVchTemplateByIds(Set<Long> ids) {
        ArrayList<Map<Long, DynamicObject>> list = new ArrayList<Map<Long, DynamicObject>>();
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ai_vchtemplate");
        for (DynamicObject object : collections) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
            dynamicObject.set("name", (Object)object.getString("name"));
            dynamicObject.set("number", (Object)object.getString("number"));
            map.put(object.getLong(ID), dynamicObject);
            list.add(map);
        }
        return list;
    }

    public static List<Map<Long, String>> getOrgByIds(Set<Long> ids) {
        ArrayList<Map<Long, String>> list = new ArrayList<Map<Long, String>>();
        HashMap<Long, String> map = new HashMap<Long, String>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        for (DynamicObject object : collections) {
            map.put(object.getLong(ID), object.getString("name"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<Long, String>> getUserByIds(Set<Long> ids) {
        ArrayList<Map<Long, String>> list = new ArrayList<Map<Long, String>>();
        HashMap<Long, String> map = new HashMap<Long, String>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        for (DynamicObject object : collections) {
            map.put(object.getLong(ID), object.getString("name"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, String>> getBillTypeByIds(Set<String> ids) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", ids)});
        for (DynamicObject object : collections) {
            map.put(object.getString("number"), object.getString("name"));
            list.add(map);
        }
        return list;
    }
}

