/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.reporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logorm.LogORM;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.DapTracker;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.IBuildVchReporter;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.helper.CacheHelper;
import kd.fi.ai.mservice.builder.reporter.BuildVchReportUtils;
import kd.fi.ai.mservice.builder.reporter.ISetSourceBillId;
import kd.fi.ai.mservice.builder.reporter.ReportEntry;
import kd.fi.ai.mservice.builder.reporter.ReportHeader;
import kd.fi.ai.mservice.builder.reporter.SingleTaskErrReport;
import kd.fi.ai.util.ContextUtil;

public class BuildVchReporter
implements IBuildVchReporter {
    private IBuildVchContext context;
    private ISingleTaskContext taskContext;
    private SingleTaskErrReport taskErrReport = new SingleTaskErrReport();
    private Map<Object, ReportHeader> successReport = new HashMap<Object, ReportHeader>();
    private ISetSourceBillId setBillId;

    public void AddErrorReport(AcctBookInfo book, SourceBillInfo sourceBill, Object sourceBillId, String sourceBillNo, String vchTemplateID, VoucherCheckItem checkItem, VoucherErrLevel errLevel, String errMessage, String buildType, String buildvouchertype) {
        ReportHeader reportHeader;
        if (!this.taskErrReport.getErrorReports().containsKey(sourceBillId)) {
            reportHeader = this.CreateReportHeader(book, sourceBill, sourceBillId, sourceBillNo, vchTemplateID, buildType, buildvouchertype);
            reportHeader.setBuildState("1");
            this.taskErrReport.getErrorReports().put(sourceBillId, reportHeader);
        } else {
            reportHeader = this.taskErrReport.getErrorReports().get(sourceBillId);
            if (kd.bos.fs.util.StringUtils.isNotEmpty((String)sourceBillNo)) {
                reportHeader.setSourceBillNo(sourceBillNo);
            }
            if (kd.bos.fs.util.StringUtils.isNotEmpty((String)vchTemplateID)) {
                reportHeader.setVchTemplateID(vchTemplateID);
            }
        }
        if (reportHeader.getEntryRows().size() > 10 && VoucherErrLevel.Warning == errLevel) {
            return;
        }
        ReportEntry reportEntry = this.CreateReportEntry(checkItem, errLevel, errMessage);
        reportHeader.getEntryRows().add(reportEntry);
    }

    public void AddSuccessReport(AcctBookInfo book, SourceBillInfo sourceBill, Object sourceBillId, String sourceBillNo, String vchTemplateID, long bizVoucherId, long glVoucherId, String glVoucherNo, String bizVoucherNo, String buildType, String buildvouchertype) {
        ReportHeader reportHeader;
        if (!this.successReport.containsKey(sourceBillId)) {
            reportHeader = this.CreateReportHeader(book, sourceBill, sourceBillId, sourceBillNo, vchTemplateID, buildType, buildvouchertype);
            reportHeader.setBuildState("0");
            this.successReport.put(sourceBillId, reportHeader);
        } else {
            reportHeader = this.successReport.get(sourceBillId);
        }
        reportHeader.setBizVoucherId(bizVoucherId);
        reportHeader.setGlVoucherId(glVoucherId);
        if (glVoucherNo != null && glVoucherNo.length() > 30) {
            glVoucherNo = glVoucherNo.substring(0, 30);
        }
        if (bizVoucherNo != null && bizVoucherNo.length() > 80) {
            bizVoucherNo = bizVoucherNo.substring(0, 80);
        }
        reportHeader.setGlVoucherNo(glVoucherNo);
        reportHeader.setBizVoucherNo(bizVoucherNo);
    }

    public void BeginTask(ISingleTaskContext taskContext) {
        this.context = taskContext.getBuildVchContext();
        this.taskContext = taskContext;
        this.BuildSetBillIdFunc();
    }

    public void FinishTask() {
        CacheHelper.putTaskErrReport(this.context.getTransId(), this.taskContext.getTaskId(), this.taskErrReport);
    }

    public void MergeTaskReport(List<String> taskIds, Map<Long, DapTracker> trackers) {
        HashSet<Object> removeKeys = new HashSet<Object>();
        for (Map.Entry<Object, ReportHeader> entry : this.taskErrReport.getErrorReports().entrySet()) {
            DapTracker track = trackers.get(entry.getKey());
            if (track == null) continue;
            String tpID = track.getVchtemplateid();
            if (entry.getValue().getVchTemplateID() == null || entry.getValue().getVchTemplateID().equalsIgnoreCase(tpID)) continue;
            removeKeys.add(entry.getKey());
        }
        for (Map.Entry<Object, ReportHeader> entry : removeKeys) {
            this.taskErrReport.getErrorReports().remove(entry);
        }
        for (String string : taskIds) {
            if (string.equalsIgnoreCase(this.taskContext.getTaskId())) continue;
            SingleTaskErrReport taskErrReport = CacheHelper.getTaskErrReport(this.context.getTransId(), string);
            for (Map.Entry<Object, ReportHeader> entry : taskErrReport.getErrorReports().entrySet()) {
                DapTracker track;
                Object srcBillId = entry.getKey();
                ReportHeader reportHeader = entry.getValue();
                if (this.taskContext.getSrcEntityType().getPrimaryKey() instanceof LongProp) {
                    srcBillId = Long.valueOf(srcBillId.toString());
                }
                if ((track = trackers.get(srcBillId)) != null) {
                    String tpID = track.getVchtemplateid();
                    if (entry.getValue().getVchTemplateID() != null && !entry.getValue().getVchTemplateID().equalsIgnoreCase(tpID)) continue;
                }
                if (this.taskErrReport.getErrorReports().containsKey(srcBillId)) {
                    List<ReportEntry> entryRows = this.taskErrReport.getErrorReports().get(srcBillId).getEntryRows();
                    if (entryRows.size() >= 1000) {
                        entryRows = entryRows.stream().filter(re -> !re.getErrLevel().equals(Integer.toString(VoucherErrLevel.Warning.getValue()))).collect(Collectors.toList());
                    }
                    if (entryRows.size() >= 1000) continue;
                    entryRows.addAll(reportHeader.getEntryRows());
                    continue;
                }
                this.taskErrReport.getErrorReports().put(srcBillId, reportHeader);
            }
        }
    }

    public void SaveReoprt(String dbRouteKey) {
        ArrayList<ReportHeader> reports = new ArrayList<ReportHeader>();
        List<Object> reportsList = new ArrayList();
        ArrayList<ReportEntry> rptRows = new ArrayList<ReportEntry>();
        ArrayList<DynamicObject> rptRowsList = new ArrayList<DynamicObject>();
        Map<Object, ReportHeader> errorReports = this.taskErrReport.getErrorReports();
        Set<Object> succkeys = this.successReport.keySet();
        HashSet<Object> removeObjs = new HashSet<Object>();
        removeObjs.addAll(succkeys);
        for (Map.Entry<Object, ReportHeader> entry : errorReports.entrySet()) {
            Object o = entry.getKey();
            ReportHeader errorRep = entry.getValue();
            if (succkeys.contains(o)) {
                ReportHeader succRep = this.successReport.get(o);
                if (succRep == null) continue;
                this.successReport.get(o).getEntryRows().addAll(errorRep.getEntryRows());
                removeObjs.add(o);
                continue;
            }
            if (o != null && !StringUtils.isEmpty((CharSequence)o.toString())) continue;
            Set<Map.Entry<Object, ReportHeader>> succEntry = this.successReport.entrySet();
            for (Map.Entry<Object, ReportHeader> e2 : succEntry) {
                ReportHeader succRep = e2.getValue();
                if (!succRep.getSourceBill().equalsIgnoreCase(errorRep.getSourceBill())) continue;
                List<ReportEntry> entrys = errorRep.getEntryRows();
                ArrayList<ReportEntry> entrysClone = new ArrayList<ReportEntry>();
                for (ReportEntry entry2 : entrys) {
                    try {
                        entrysClone.add(entry2.clone());
                    }
                    catch (CloneNotSupportedException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                succRep.getEntryRows().addAll(entrysClone);
                removeObjs.add(o);
            }
        }
        for (Map.Entry<Object, ReportHeader> entry : removeObjs) {
            errorReports.remove(entry);
        }
        this.replaceMultiMessageTip(this.taskErrReport.getErrorReports());
        reports.addAll(this.taskErrReport.getErrorReports().values());
        reports.addAll(this.successReport.values());
        if (reports.size() == 0) {
            return;
        }
        SequenceReader sReader = new SequenceReader(new DBRoute(dbRouteKey));
        Long[] longArray = (Long[])sReader.getSequences((Object[])new Long[reports.size()], "T_AI_BuildReport", reports.size());
        for (int i = 0; i < longArray.length; ++i) {
            ArrayList<ReportEntry> rptRowTmp = new ArrayList<ReportEntry>();
            ReportHeader report = (ReportHeader)reports.get(i);
            report.setId(longArray[i]);
            rptRows.addAll(report.getEntryRows());
            rptRowTmp.addAll(report.getEntryRows());
            for (ReportEntry entry : rptRowTmp) {
                entry.setBuildreportheadid(longArray[i]);
            }
        }
        if (rptRows.size() > 0) {
            Long[] entryIds = (Long[])sReader.getSequences((Object[])new Long[rptRows.size()], "T_AI_BuildReportEntry", rptRows.size());
            for (int i = 0; i < entryIds.length; ++i) {
                ReportEntry row = (ReportEntry)rptRows.get(i);
                row.setEntryId(entryIds[i]);
            }
        }
        reports.forEach(e -> {
            int i = 1;
            List<ReportEntry> entries = e.getEntryRows();
            for (ReportEntry re : entries) {
                re.setSeq(i++);
            }
        });
        IDataEntityType dType = OrmUtils.getDataEntityType(ReportHeader.class);
        SaveServiceHelper.save((IDataEntityType)dType, (Object[])reports.toArray());
        LogORM logORM = LogORM.create();
        reportsList = BuildVchReportUtils.genNewVchBuildReportByHeads(reports);
        for (ReportHeader head : reports) {
            rptRowsList.addAll(BuildVchReportUtils.genNewVchBuildReportByEntrys(head.getEntryRows()));
        }
        logORM.insert(reportsList);
        logORM.insert(rptRowsList);
        this.taskErrReport.getErrorReports().clear();
        this.successReport.clear();
    }

    private void replaceMultiMessageTip(Map<Object, ReportHeader> errorReports) {
        for (ReportHeader errorReport : errorReports.values()) {
            HashSet<String> messageCol = new HashSet<String>(errorReport.getEntryRows().size());
            ArrayList<ReportEntry> entryRows = new ArrayList<ReportEntry>(errorReport.getEntryRows());
            for (ReportEntry reportRow : entryRows) {
                if (messageCol.contains(reportRow.getMessage())) {
                    errorReport.getEntryRows().remove(reportRow);
                    continue;
                }
                messageCol.add(reportRow.getMessage());
            }
        }
    }

    private ReportHeader CreateReportHeader(AcctBookInfo book, SourceBillInfo sourceBill, Object sourceBillId, String sourceBillNo, String vchTemplateID, String buildType, String buildvouchertype) {
        ReportHeader reportHeader = new ReportHeader();
        if (this.context != null) {
            reportHeader.setTransId(this.context.getTransId());
        }
        reportHeader.setCreatorId(ContextUtil.getUserId());
        if (book != null) {
            reportHeader.setOrgId(book.getAcctOrgId());
        }
        reportHeader.setCreateTime(TimeServiceHelper.now());
        reportHeader.setBuildType(buildType);
        reportHeader.setBuildVouchertype(buildvouchertype);
        if (book != null) {
            reportHeader.setBookId(book.getBookId());
            reportHeader.setPeriodId(book.getSelectPeriodId());
        }
        reportHeader.setSourceSys(sourceBill.getBizAppName());
        reportHeader.setSourceBill(sourceBill.getEntityNumber());
        reportHeader.setSourceBillNo(sourceBillNo);
        if (this.setBillId != null && sourceBillId != null && StringUtils.isNotBlank((CharSequence)sourceBillId.toString())) {
            this.setBillId.SetValue(reportHeader, sourceBillId);
        } else if (sourceBillId instanceof Long) {
            reportHeader.setSourceBillId((Long)sourceBillId);
        } else if (sourceBillId instanceof String) {
            reportHeader.setStrSourceBillId((String)sourceBillId);
        }
        if (StringUtils.isNotEmpty((CharSequence)vchTemplateID)) {
            reportHeader.setVchTemplateID(vchTemplateID);
        } else {
            reportHeader.setVchTemplateID("0");
        }
        return reportHeader;
    }

    private ReportEntry CreateReportEntry(VoucherCheckItem checkItem, VoucherErrLevel errLevel, String message) {
        ReportEntry reportEntry = new ReportEntry();
        reportEntry.setCheckItem(Integer.toString(checkItem.getValue()));
        reportEntry.setErrLevel(Integer.toString(errLevel.getValue()));
        reportEntry.setMessage(message);
        return reportEntry;
    }

    private void BuildSetBillIdFunc() {
        this.setBillId = this.taskContext.getSrcEntityType().getPrimaryKey() instanceof VarcharProp ? new ISetSourceBillId(){

            @Override
            public void SetValue(ReportHeader report, Object billId) {
                report.setStrSourceBillId((String)billId);
            }
        } : new ISetSourceBillId(){

            @Override
            public void SetValue(ReportHeader report, Object billId) {
                if (billId != null) {
                    report.setSourceBillId((Long)billId);
                }
            }
        };
    }

    public SingleTaskErrReport getTaskErrReport() {
        return this.taskErrReport;
    }

    public void AddErrorReport(AcctBookInfo book, SourceBillInfo sourceBill, Object sourceBillId, String sourceBillNo, String vchTemplateID, VoucherCheckItem checkItem, VoucherErrLevel errLevel, Supplier<String> errMessage, String buildType, String buildvouchertype) {
        ReportHeader reportHeader = this.taskErrReport.getErrorReports().computeIfAbsent(sourceBillId, key -> {
            ReportHeader rh = this.CreateReportHeader(book, sourceBill, sourceBillId, sourceBillNo, vchTemplateID, buildType, buildvouchertype);
            rh.setBuildState("1");
            return rh;
        });
        if (reportHeader.getEntryRows().size() > 100) {
            return;
        }
        ReportEntry reportEntry = this.CreateReportEntry(checkItem, errLevel, errMessage.get());
        reportHeader.getEntryRows().add(reportEntry);
    }

    public void reMoveSuccReport(List<Object> sids) {
        if (sids.isEmpty()) {
            return;
        }
        sids.stream().forEach(v -> this.successReport.remove(v));
    }
}

