/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleBillContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.buildresult.SingleBillResult;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.compiler.SelectedSourceEntity;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;

public abstract class AbstractSingleBillAction {
    protected IBuildVchContext context;
    protected ISingleTaskContext taskContext;
    protected ISingleBillContext billContext;
    protected SingleTaskResult taskResult;
    protected SingleBillResult billResult;

    public AbstractSingleBillAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        this.context = taskContext.getBuildVchContext();
        this.taskContext = taskContext;
        this.taskResult = taskResult;
    }

    public void Do(ISingleBillContext billContext, SingleBillResult billResult) {
        this.billContext = billContext;
        this.billResult = billResult;
        if (!this.billResult.isSkipBuildBizVch()) {
            this.DoAction();
        }
    }

    protected void DoAction() {
    }

    protected void WriteReportDetail(VoucherCheckItem checkItem, VoucherErrLevel errLevel, String message) {
        SelectedSourceEntity selectedEntity;
        Map<String, DynamicProperty> fldProperties;
        DynamicProperty prop;
        String billNo = "";
        String entity = this.taskContext.getSourceBill().getEntityNumber();
        String billNoFormBill = DapBuildVoucherCommonUtil.getBillNoFormBill((String)entity);
        if ("ai_event".equals(entity)) {
            SelectedSourceEntity selectedEntity2;
            Map<String, DynamicProperty> fldProperties2;
            DynamicProperty prop2;
            String name;
            Object srcBillId = this.billContext.getSrcBillId();
            if (srcBillId != null && StringUtils.isNotBlank((CharSequence)(name = this.taskContext.getSrcEntityType().getName())) && (prop2 = (fldProperties2 = (selectedEntity2 = this.billResult.getTaskResult().getSelectedEntities().get(name)).getFldProperties()).get("number")) != null) {
                billNo = (String)prop2.getValueFast((Object)this.billResult.getFirstRow());
            }
        } else if (billNoFormBill != null && this.billResult.getTaskResult() != null && (prop = (fldProperties = (selectedEntity = this.billResult.getTaskResult().getSelectedEntities().get(entity)).getFldProperties()).get(billNoFormBill)) != null) {
            billNo = (String)prop.getValueFast((Object)this.billResult.getFirstRow());
        }
        String aa = this.taskContext.getBookInfo().getBuildVoucherType() != null ? this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "" : "0";
        this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), this.billContext.getSrcBillId(), billNo, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), checkItem, errLevel, message, this.taskContext.getBuildType(), aa);
    }

    protected void WriteInfoLog(String message) {
    }

    protected void WriteWarnLog(String message) {
        this.context.getLogger().warn(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), this.billContext.getSrcBillId().toString(), message);
    }

    protected void WriteErrorLog(String message) {
        this.context.getLogger().error(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), this.billContext.getSrcBillId().toString(), message);
    }

    protected void WriteErrorLog(Throwable exp) {
        this.context.getLogger().error(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), this.billContext.getSrcBillId().toString(), exp);
    }
}

