/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.fi.ai.Currency;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.singlebillaction.AbstractSingleBillAction;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class UpdatePriceOrAmountScale
extends AbstractSingleBillAction {
    public UpdatePriceOrAmountScale(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        List allRows = this.billResult.getNewBizVoucher().getEntryRows();
        for (BizVoucherEntry row : allRows) {
            if (BigDecimal.ZERO.compareTo(row.getQty()) == 0) continue;
            BigDecimal oriAmount = row.getOriDebit().add(row.getOriCredit());
            Currency cu = BaseDataLoader.loadCurrency((IBuildVchContext)this.taskContext.getBuildVchContext(), (Long)row.getOriCurrencyId());
            BigDecimal price = oriAmount.divide(row.getQty(), cu.getPriceprecision() == 0 ? 4 : cu.getPriceprecision(), RoundingMode.HALF_UP);
            row.setPrice(price);
        }
    }
}

