/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;

public abstract class AbstractSingleTaskAction {
    protected IBuildVchContext context;
    protected ISingleTaskContext taskContext;
    protected SingleTaskResult taskResult;

    public AbstractSingleTaskAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        this.context = taskContext.getBuildVchContext();
        this.taskContext = taskContext;
        this.taskResult = taskResult;
    }

    public void Do() {
        if (!this.taskResult.isSkipNextAction()) {
            this.DoAction();
        }
    }

    protected void DoAction() {
    }

    protected void WriteInfoLog(String message) {
        this.context.getLogger().info(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), message);
    }

    protected void WriteWarnLog(String message) {
        this.context.getLogger().warn(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), message);
    }

    protected void WriteErrorLog(String message) {
        this.context.getLogger().error(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), message);
    }

    protected void WriteErrorLog(Throwable exp) {
        this.context.getLogger().error(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), exp);
    }

    protected void addAndSaveErrorReport(VoucherCheckItem checkItem, String msg) {
        this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), (Object)0L, null, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), checkItem, VoucherErrLevel.Warning, msg, this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
        this.context.getReporter().SaveReoprt("gl");
    }
}

