/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;

public class HandleEventBlockAction
extends AbstractSingleTaskAction {
    private static final String ENTITY_AI_EVENT = "ai_event";
    private static final String KEY_GENERATEVOUCHER = "generatevoucher";

    public HandleEventBlockAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5f00\u59cb\uff1a\u5904\u7406\u4f1a\u8ba1\u4e8b\u4ef6\u4f9d\u8d56", (String)"HandleEventBlockAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        ArrayList<GLVoucher> glVouchers = new ArrayList<GLVoucher>();
        glVouchers.addAll(this.taskResult.getBookResult().getGlVouchers().values());
        StringBuilder sbEntityName = new StringBuilder();
        ArrayList<Object> srcBillIds = new ArrayList<Object>();
        HashMap<String, List<Long>> srcBillMap = new HashMap<String, List<Long>>(8);
        for (IVoucher iVoucher : glVouchers) {
            String entityName = iVoucher.getSourceBill();
            if (ENTITY_AI_EVENT.equals(entityName)) {
                srcBillIds.add(iVoucher.getSourceBillId());
                continue;
            }
            if (entityName.startsWith("fah_e_")) {
                srcBillMap.computeIfAbsent(entityName, k -> new LinkedList()).add(iVoucher.getSourceBillId());
                continue;
            }
            sbEntityName.append(entityName);
            sbEntityName.append(',');
        }
        if (srcBillIds.isEmpty() && srcBillMap.isEmpty()) {
            if (sbEntityName.length() > 0) {
                sbEntityName.deleteCharAt(sbEntityName.length() - 1);
            }
            this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u6e90\u5355\u7c7b\u578b\uff1a%s\u4e3a\u975e\u4f1a\u8ba1\u4e8b\u4ef6\uff0c\u7ed3\u675f\u5904\u7406\u4f1a\u8ba1\u4e8b\u4ef6\u4f9d\u8d56\u3002", (String)"HandleEventBlockAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]), sbEntityName.toString()));
            return;
        }
        Map<Long, Long> blockEventMap = this.getEventBlockEventInfoV2(srcBillIds, srcBillMap);
        if (blockEventMap == null || blockEventMap.isEmpty()) {
            this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6e90\u5355ID\uff1a%s\u7684\u963b\u585e\u4e8b\u4ef6\uff0c\u7ed3\u675f\u5904\u7406\u4f1a\u8ba1\u4e8b\u4ef6\u4f9d\u8d56\u3002", (String)"HandleEventBlockAction_2", (String)"fi-ai-mservice", (Object[])new Object[0]), StringUtils.join((Object[])srcBillIds.toArray(), (String)",")));
            return;
        }
        if (AiEventUtil.deleteEventBlock(blockEventMap.keySet())) {
            this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u963b\u585e\u4f1a\u8ba1\u4e8b\u4ef6ID\u201c%s\u201d\u5df2\u5220\u9664\u3002", (String)"HandleEventBlockAction_3", (String)"fi-ai-mservice", (Object[])new Object[0]), StringUtils.join((Object[])blockEventMap.keySet().toArray(), (String)",")));
        }
        try {
            HashSet<Long> hashSet = new HashSet<Long>(blockEventMap.values());
            OperateOption op = OperateOption.create();
            op.setVariableValue("onTime", "true");
            OperationResult opeRet = OperationServiceHelper.executeOperate((String)KEY_GENERATEVOUCHER, (String)ENTITY_AI_EVENT, (Object[])hashSet.toArray(), (OperateOption)op);
            if (!opeRet.isSuccess()) {
                String resultStr = opeRet.getMessage();
                this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f1a\u8ba1\u4e8b\u4ef6ID\u201c%1$s\u201d\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u201c%2$s\u201d\u3002", (String)"HandleEventBlockAction_4", (String)"fi-ai-mservice", (Object[])new Object[0]), StringUtils.join((Object[])hashSet.toArray(), (String)","), resultStr));
            }
        }
        catch (Exception exception) {
            this.WriteErrorLog(String.format(ResManager.loadKDString((String)"\u6267\u884c\u4f1a\u8ba1\u4e8b\u4ef6ID\u201c%1$s\u201d\u751f\u4ea7\u51ed\u8bc1\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u201c%2$s\u201d\u3002", (String)"HandleEventBlockAction_5", (String)"fi-ai-mservice", (Object[])new Object[0]), StringUtils.join((Object[])blockEventMap.values().toArray(), (String)","), exception.getMessage()));
            throw exception;
        }
        finally {
            this.WriteInfoLog(ResManager.loadKDString((String)"\u7ed3\u675f\uff1a\u5904\u7406\u4f1a\u8ba1\u4e8b\u4ef6\u4f9d\u8d56", (String)"HandleEventBlockAction_6", (String)"fi-ai-mservice", (Object[])new Object[0]));
        }
    }

    private Map<Long, Long> getEventBlockEventInfoV2(List<Object> srcBillIds, Map<String, List<Long>> srcBillMap) {
        Map blockEventMapNew = AiEventUtil.getEventBlockEventInfoV2(srcBillMap);
        Map blockEventMap = AiEventUtil.getEventBlockEventInfo(srcBillIds);
        if (null != blockEventMap && blockEventMap.size() > 0) {
            blockEventMapNew.putAll(blockEventMap);
        }
        return blockEventMapNew;
    }
}

