/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.ComAssistData;
import kd.fi.ai.ComAssistResultDataCol;
import kd.fi.ai.CommonAssistItem;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.bd.util.filter.QFilterBuilder;

public class LoadBizVoucherRowsAction
extends AbstractSingleTaskAction {
    public LoadBizVoucherRowsAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u52a0\u8f7d\u9700\u8981\u5904\u7406\u7684\u4e1a\u52a1\u51ed\u8bc1\u8be6\u7ec6\u6570\u636e", (String)"LoadBizVoucherRowsAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        IDataEntityType bizVoucherType = OrmUtils.getDataEntityType(BizVoucher.class);
        Object[] bizVouchers = BusinessDataServiceHelper.load((Object[])this.taskContext.getHistBizVchIds().toArray(), (IDataEntityType)bizVoucherType);
        Long accountTableId = this.taskContext.getBookInfo().getAccountTableId();
        List comAssist = AiCommonFieldUtils.getComAssist((Long)accountTableId);
        Map<String, ComAssistResultDataCol> comassistCache = this.preGetComassistResultData(this.taskContext.getHistBizVchIds(), comAssist);
        Map<Object, List<BizVoucher>> histBizVouchers = this.taskResult.getHistBizVouchers();
        for (Object item : bizVouchers) {
            BizVoucher bizVoucher = (BizVoucher)item;
            bizVoucher.setTmpGuid(UUID.randomUUID().toString());
            long id = bizVoucher.getId();
            List entryRows = bizVoucher.getEntryRows();
            for (BizVoucherEntry er : entryRows) {
                String key = id + "-" + er.getEntryId();
                ComAssistResultDataCol comAssistResultDataCol = comassistCache.get(key);
                er.setComAssist(comAssistResultDataCol);
            }
            Object billId = this.taskResult.getSrcBillIdGetHandle().GetBillId(bizVoucher);
            List<BizVoucher> billBizs = histBizVouchers.get(billId);
            if (billBizs == null) {
                billBizs = new ArrayList<BizVoucher>();
                histBizVouchers.put(billId, billBizs);
            }
            billBizs.add(bizVoucher);
        }
    }

    private Map<String, ComAssistResultDataCol> preGetComassistResultData(List<Long> histBizVchIds, List<CommonAssistItem> comAssist) {
        HashMap<String, ComAssistResultDataCol> comassistCache = new HashMap<String, ComAssistResultDataCol>(16);
        String vs1 = "";
        String vs2 = "";
        for (CommonAssistItem cai : comAssist) {
            if (cai.getSeq() == 1) {
                vs1 = cai.getValuesource().toString();
                continue;
            }
            if (cai.getSeq() != 2) continue;
            vs2 = cai.getValuesource().toString();
        }
        String joinIds = QFilterBuilder.buildSQLParamHolder((int)histBizVchIds.size());
        String sql = "select fid,fentryid,fcomassist1id,fcomassist2id from t_ai_bizvoucherentry where fid in " + joinIds;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.LoadBizVoucherRowsAction", (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])histBizVchIds.toArray());){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                Long id = row.getLong("fid");
                Long eid = row.getLong("fentryid");
                Object cr1 = row.get("fcomassist1id");
                Object cr2 = row.get("fcomassist2id");
                String key = id + "-" + eid;
                ComAssistResultDataCol crd = new ComAssistResultDataCol();
                ComAssistData cad1 = new ComAssistData(1, vs1, cr1);
                ComAssistData cad2 = new ComAssistData(2, vs2, cr2);
                crd.getResult().add(cad1);
                crd.getResult().add(cad2);
                comassistCache.put(key, crd);
            }
        }
        return comassistCache;
    }
}

