/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.ai.DapTracker;
import kd.fi.ai.VchTplEntryMergeOption;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.enums.ZeroAmountSysParamEnum;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntryGroupKey;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleBookResult;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.mservice.builder.helper.CacheHelper;
import kd.fi.ai.mservice.builder.plugin.VchPlugProxy;
import kd.fi.ai.mservice.builder.singlebillaction.UnionGLVoucherHelper;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.VoucherCashFlowUtils;
import kd.fi.ai.util.VoucherSaveHelper;

public class MergeBookTasksResult
extends AbstractSingleTaskAction {
    public static final String BillTemplateSplit = "$@$";
    private static final Log log = LogFactory.getLog(MergeBookTasksResult.class);
    private UnionGLVoucherHelper unionHelper;

    public MergeBookTasksResult(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
        VchTplEntryMergeOption entryMergeOption = taskContext.getTemplate().getEntryMergeOption();
        this.unionHelper = new UnionGLVoucherHelper(taskContext.getBookInfo(), entryMergeOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u672c\u6279\u6b21\u4efb\u52a1\u5904\u7406\u5b8c\u6bd5\uff0c\u628a\u7ed3\u679c\u5b58\u5165\u7f13\u5b58", (String)"MergeBookTasksResult_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        Object lock = this.taskContext.getLock();
        if (this.taskContext.getGroupEntryName() != null) {
            ArrayList bizentries = new ArrayList();
            Collection<BizVoucher> newBizVouchers = this.taskResult.getNewBizVouchers().values();
            Object object = lock;
            synchronized (object) {
                Map<String, Long> billAiVchMap = CacheHelper.getBillAiVchIdMap(this.context.getTransId());
                Map<String, Long> billGLVchMap = CacheHelper.getBillGLVchIdMap(this.context.getTransId());
                HashSet allIDs = new HashSet(this.taskContext.getSrcBillIds().size());
                allIDs.addAll(this.taskResult.getNewBizVouchers().values().stream().map(e -> e.getSourceBillId()).collect(Collectors.toList()));
                int size = allIDs.size();
                if (billAiVchMap == null || !billAiVchMap.containsKey(this.taskContext.getSrcBillIds().get(0) + BillTemplateSplit + this.taskContext.getTemplate().getId()) || size > 1) {
                    if (billAiVchMap == null) {
                        billAiVchMap = new HashMap<String, Long>();
                        billGLVchMap = new HashMap<String, Long>();
                    }
                    if (this.multiTaskMerge()) {
                        boolean bigGLVoucher = false;
                        Collection<GLVoucher> gvList = this.taskResult.getNewGLVouchers().values();
                        for (GLVoucher glVoucher : gvList) {
                            Object[] entryArray = glVoucher.getEntryRows().toArray();
                            if (entryArray.length < 1000) continue;
                            bigGLVoucher = true;
                            break;
                        }
                        if (bigGLVoucher) {
                            this.preMerge();
                            allIDs.addAll(this.taskResult.getNewBizVouchers().values().stream().map(e -> e.getSourceBillId()).collect(Collectors.toList()));
                            size = allIDs.size();
                        }
                        Map<String, String> bizGLMap = this.taskResult.getBizGroupToGlMap();
                        SequenceReader aiReader = new SequenceReader(new DBRoute("ai"));
                        Long[] aiID = (Long[])aiReader.getSequences((Object[])new Long[size], "T_AI_BizVoucher", size);
                        int i = 0;
                        for (Object billid : allIDs) {
                            Long aiVchID = aiID[i];
                            billAiVchMap.put(billid + BillTemplateSplit + this.taskContext.getTemplate().getId(), aiVchID);
                            ++i;
                        }
                        Long[] glID = VchPlugProxy.genarateGlVoucherId(size, this.taskResult.getNewGLVouchers().size(), this.taskContext);
                        Map<String, BizVoucher> bizMap = this.taskResult.getNewBizVouchers();
                        Collection<GLVoucher> glVchs = this.taskResult.getNewGLVouchers().values();
                        int j = 0;
                        block8: for (Map.Entry<String, String> bgmEntry : bizGLMap.entrySet()) {
                            BizVoucher bv = bizMap.get(bgmEntry.getKey());
                            if (bv == null) continue;
                            long billid = bv.getSourceBillId();
                            for (GLVoucher gv : glVchs) {
                                if (!gv.getTmpGuid().equalsIgnoreCase(bgmEntry.getValue())) continue;
                                if (gv.getId() != 0L) {
                                    billGLVchMap.put(billid + BillTemplateSplit + gv.getTemplateId(), gv.getId());
                                    continue block8;
                                }
                                Long glVchID = glID[j++];
                                billGLVchMap.put(billid + BillTemplateSplit + gv.getTemplateId(), glVchID);
                                gv.setId(glVchID.longValue());
                                continue block8;
                            }
                        }
                    } else {
                        SequenceReader aiReader = new SequenceReader(new DBRoute("ai"));
                        Long[] aiID = (Long[])aiReader.getSequences((Object[])new Long[size], "T_AI_BizVoucher", size);
                        Long[] glID = VchPlugProxy.genarateGlVoucherId(size, size, this.taskContext);
                        int i = 0;
                        for (Object billid : allIDs) {
                            Long aiVchID = aiID[i];
                            Long glVchID = glID[i];
                            billAiVchMap.put(billid + BillTemplateSplit + this.taskContext.getTemplate().getId(), aiVchID);
                            billGLVchMap.put(billid + BillTemplateSplit + this.taskContext.getTemplate().getId(), glVchID);
                            ++i;
                        }
                    }
                    CacheHelper.setBillAiVchIdMap(this.context.getTransId(), billAiVchMap);
                    CacheHelper.setBillGLVchIdMap(this.context.getTransId(), billGLVchMap);
                    if (size == 1) {
                        Object billid = this.taskContext.getSrcBillIds().get(0);
                        this.beforeSaveGroupEntries((Long)billid, billAiVchMap.get(billid + BillTemplateSplit + this.taskContext.getTemplate().getId()), billGLVchMap.get(billid + BillTemplateSplit + this.taskContext.getTemplate().getId()), CacheHelper.getAiEntrySeqMap(this.context.getTransId()), CacheHelper.getGLEntrySeqMap(this.context.getTransId()));
                    } else {
                        this.beforeSaveGroupEntries(billAiVchMap, billGLVchMap, CacheHelper.getGLEntrySeqMap(this.context.getTransId()));
                    }
                    this.saveGLVoucherEntriesMax(billGLVchMap);
                    if (this.multiTaskMerge()) {
                        if (!newBizVouchers.isEmpty()) {
                            for (BizVoucher bizVoucher : newBizVouchers) {
                                bizentries.addAll(bizVoucher.toDynamicObjectVoucher(this.taskContext).getDynamicObjectCollection("entryentity"));
                                bizVoucher.getEntryRows().clear();
                            }
                        }
                        this.setTaskResultToCache();
                    }
                } else {
                    Object billid = this.taskContext.getSrcBillIds().get(0);
                    Long aiVchID = billAiVchMap.get(billid + BillTemplateSplit + this.taskContext.getTemplate().getId());
                    Long glVchID = billGLVchMap.get(billid + BillTemplateSplit + this.taskContext.getTemplate().getId());
                    boolean bigGLVoucher = false;
                    Collection<GLVoucher> gvList = this.taskResult.getNewGLVouchers().values();
                    Iterator<GLVoucher> iterator = gvList.iterator();
                    HashSet<String> removeGLTmpIDs = new HashSet<String>(1);
                    while (iterator.hasNext()) {
                        GLVoucher glVoucher = iterator.next();
                        if (!this.isEqualesTpl(glVoucher)) {
                            iterator.remove();
                            removeGLTmpIDs.add(glVoucher.getTmpGuid());
                            continue;
                        }
                        Object[] entryArray = glVoucher.getEntryRows().toArray();
                        if (entryArray.length < 1000) continue;
                        bigGLVoucher = true;
                        break;
                    }
                    Map<String, String> bizToGL = this.taskResult.getBizGroupToGlMap();
                    for (Map.Entry<String, String> mem : bizToGL.entrySet()) {
                        if (!removeGLTmpIDs.contains(mem.getValue())) continue;
                        this.taskResult.getNewBizVouchers().remove(mem.getKey());
                    }
                    if (bigGLVoucher || CacheHelper.getBookSuccessTaskIds(this.context.getTransId(), this.taskContext.getBookInfo().getBookId()).size() >= 500) {
                        this.preMerge();
                    }
                    if (glVchID != null && aiVchID != null) {
                        this.beforeSaveGroupEntries((Long)billid, aiVchID, glVchID, CacheHelper.getAiEntrySeqMap(this.context.getTransId()), CacheHelper.getGLEntrySeqMap(this.context.getTransId()));
                    }
                    this.saveGLVoucherEntriesMax(billGLVchMap);
                    if (!newBizVouchers.isEmpty()) {
                        for (BizVoucher bizVoucher : newBizVouchers) {
                            bizentries.addAll(bizVoucher.toDynamicObjectVoucher(this.taskContext).getDynamicObjectCollection("entryentity"));
                            bizVoucher.getEntryRows().clear();
                        }
                    }
                    this.setTaskResultToCache();
                }
            }
            if (!bizentries.isEmpty()) {
                BizVoucher gv = newBizVouchers.iterator().next();
                VoucherSaveHelper.saveBizVoucherEntries((long)gv.getOrgId(), (long)gv.getPeriodId(), bizentries);
            }
            if (!this.multiTaskMerge()) {
                this.setTaskResultToCache();
            }
        } else {
            this.setTaskResultToCache();
        }
        Object object = lock;
        synchronized (object) {
            this.context.getProgresser().FinishTask();
            this.context.getReporter().FinishTask();
            if (this.taskContext.getBuildVchContext().getProgresser().isBookCompleted()) {
                this.DoMerge();
            } else {
                this.taskResult.setSkipNextAction(true);
            }
        }
    }

    private void saveGLVoucherEntriesMax(Map<String, Long> billGLVchMap) {
        Collection<GLVoucher> gvList = this.taskResult.getNewGLVouchers().values();
        for (GLVoucher glVoucher : gvList) {
            Map<Long, Integer> glEntrySeqMap;
            Integer mapGLSeq;
            int size = glVoucher.getEntryRows().size();
            if (size < 100000) continue;
            long glVchID = billGLVchMap.get(glVoucher.getSourceBillId() + BillTemplateSplit + glVoucher.getTemplateId());
            this.taskContext.getGenVoucherMemoryMergeTask().calculation_voucher_entrySeq_and_entryId((IVoucher)glVoucher, Long.valueOf(glVchID), true, "fi", "");
            VoucherCashFlowUtils.processCashFlowItem((GLVoucher)glVoucher, (IBuildVchContext)this.context);
            DynamicObject glD = VchPlugProxy.getGlvoucherDynamicObject(glVoucher, this.taskContext);
            if (glD != null) {
                VoucherSaveHelper.saveGLVoucherEntries((long)glVoucher.getOrgId(), (long)glVoucher.getPeriodId(), (List)glD.getDynamicObjectCollection("entries"));
                if (this.taskContext.getBookInfo().isBudget()) {
                    List entryRows = glVoucher.getEntryRows();
                    HashSet<Long> entryIdSet = new HashSet<Long>(entryRows.size());
                    for (GLVoucherEntry entry : entryRows) {
                        entryIdSet.add(entry.getEntryId());
                    }
                    this.taskContext.getGenVoucherMemoryMergeTask().addInsertedEntryIdMap(Long.valueOf(glVoucher.getId()), entryIdSet);
                }
            }
            int glseq = (mapGLSeq = (glEntrySeqMap = CacheHelper.getGLEntrySeqMap(this.context.getTransId())).get(glVoucher.getId())) == null ? 1 : mapGLSeq;
            glEntrySeqMap.put(glVoucher.getId(), glseq + size);
            CacheHelper.setGLEntrySeqMap(this.context.getTransId(), glEntrySeqMap);
            BigDecimal debitLoc = BigDecimal.ZERO;
            BigDecimal creditLoc = BigDecimal.ZERO;
            for (GLVoucherEntry entry : glVoucher.getEntryRows()) {
                debitLoc = debitLoc.add(entry.getLocalDebit());
                creditLoc = creditLoc.add(entry.getLocalCredit());
            }
            glVoucher.setCreditlocamount_saved(creditLoc.add(glVoucher.getCreditlocamount_saved()));
            glVoucher.setDebitlocamount_saved(debitLoc.add(glVoucher.getDebitlocamount_saved()));
            glVoucher.getEntryRows().clear();
            glVoucher.setPreSaveEntry(true);
        }
    }

    private boolean multiTaskMerge() {
        return this.taskContext.getSrcBillIds().size() == 1 || GLVoucherUnionType.Single.getValue() != this.taskContext.getTemplate().getUnionType().getValue();
    }

    private void setTaskResultToCache() {
        this.taskResult.setGroupEntryName(this.taskContext.getGroupEntryName());
        CacheHelper.putTaskResult(this.context.getTransId(), this.taskContext.getTaskId(), this.taskResult);
        CacheHelper.addBookSuccessTaskIds(this.context.getTransId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getTaskId());
    }

    private void beforeSaveGroupEntries(Long billID, Long aiVchID, Long glVchID, Map<Long, Integer> aiEntrySeqMap, Map<Long, Integer> glEntrySeqMap) {
        Object mapAiSeq;
        BizVoucher bv;
        Collection<BizVoucher> newBizVouchers = this.taskResult.getNewBizVouchers().values();
        Collection<GLVoucher> newGLVouchers = this.taskResult.getNewGLVouchers().values();
        BizVoucher bizVoucher = null;
        GLVoucher glVoucher = null;
        if (!newBizVouchers.isEmpty() && newGLVouchers.isEmpty()) {
            for (Map.Entry<String, BizVoucher> bizMapEntry : this.taskResult.getNewBizVouchers().entrySet()) {
                bv = bizMapEntry.getValue();
                if (!billID.equals(bv.getSourceBillId()) || !bv.getTemplateId().equalsIgnoreCase(this.taskContext.getTemplate().getId())) continue;
                bizVoucher = bv;
                break;
            }
            if (bizVoucher != null) {
                bizVoucher.setId(aiVchID.longValue());
                bizVoucher.setVdescription(((BizVoucherEntry)bizVoucher.getEntryRows().get(0)).getDescription());
                if (aiEntrySeqMap == null) {
                    aiEntrySeqMap = new HashMap<Long, Integer>();
                    glEntrySeqMap = new HashMap<Long, Integer>();
                }
                int aiseq = (mapAiSeq = aiEntrySeqMap.get(aiVchID)) == null ? 1 : (Integer)mapAiSeq;
                this.setVoucherEntryId("ai", (IVoucher<?>)bizVoucher, "T_AI_BizVoucherEntry", aiVchID, aiseq);
                aiEntrySeqMap.put(aiVchID, aiseq + bizVoucher.getEntryRows().size());
                CacheHelper.setAiEntrySeqMap(this.context.getTransId(), aiEntrySeqMap);
                BigDecimal debitLoc = BigDecimal.ZERO;
                BigDecimal creditLoc = BigDecimal.ZERO;
                for (BizVoucherEntry entry : bizVoucher.getEntryRows()) {
                    entry.setId(aiVchID.longValue());
                    debitLoc = debitLoc.add(entry.getLocalDebit());
                    creditLoc = creditLoc.add(entry.getLocalCredit());
                }
                bizVoucher.setDebitlocamount(debitLoc.add(bizVoucher.getDebitlocamount()));
                bizVoucher.setCreditlocamount(creditLoc.add(bizVoucher.getCreditlocamount()));
            }
        }
        if (!newGLVouchers.isEmpty() && !newBizVouchers.isEmpty()) {
            mapAiSeq = this.taskResult.getNewBizVouchers().entrySet().iterator();
            while (mapAiSeq.hasNext()) {
                Map.Entry<String, BizVoucher> bizMapEntry;
                bizMapEntry = mapAiSeq.next();
                bv = bizMapEntry.getValue();
                if (!billID.equals(bv.getSourceBillId()) || !bv.getTemplateId().equalsIgnoreCase(this.taskContext.getTemplate().getId())) continue;
                bizVoucher = bv;
                glVoucher = newGLVouchers.stream().filter(gv -> gv.getTmpGuid().equalsIgnoreCase(this.taskResult.getBizGroupToGlMap().get(bizMapEntry.getKey()))).findAny().get();
                break;
            }
            if (bizVoucher == null || glVoucher == null) {
                return;
            }
            bizVoucher.setId(aiVchID.longValue());
            glVoucher.setId(glVchID.longValue());
            bizVoucher.setBuildGlVoucher(true);
            bizVoucher.setGlVoucherId(glVoucher.getId());
            glVoucher.setVdescription(((GLVoucherEntry)glVoucher.getEntryRows().get(0)).getDescription());
            bizVoucher.setVdescription(((BizVoucherEntry)bizVoucher.getEntryRows().get(0)).getDescription());
            if (aiEntrySeqMap == null) {
                aiEntrySeqMap = new HashMap<Long, Integer>();
                glEntrySeqMap = new HashMap<Long, Integer>();
            }
            int aiseq = (mapAiSeq = aiEntrySeqMap.get(aiVchID)) == null ? 1 : (Integer)mapAiSeq;
            Integer mapGLSeq = glEntrySeqMap.get(glVchID);
            int glseq = mapGLSeq == null ? 1 : mapGLSeq;
            this.setVoucherEntryId("ai", (IVoucher<?>)bizVoucher, "T_AI_BizVoucherEntry", aiVchID, aiseq);
            VchPlugProxy.setVoucherEntryId("gl", glVoucher, glVchID, glseq, this.taskContext);
            aiEntrySeqMap.put(aiVchID, aiseq + bizVoucher.getEntryRows().size());
            CacheHelper.setAiEntrySeqMap(this.context.getTransId(), aiEntrySeqMap);
            BigDecimal debitLoc = BigDecimal.ZERO;
            BigDecimal creditLoc = BigDecimal.ZERO;
            for (GLVoucherEntry entry : glVoucher.getEntryRows()) {
                debitLoc = debitLoc.add(entry.getLocalDebit());
                creditLoc = creditLoc.add(entry.getLocalCredit());
            }
            glVoucher.setDebitlocamount(debitLoc.add(glVoucher.getDebitlocamount_saved()));
            glVoucher.setCreditlocamount(creditLoc.add(glVoucher.getCreditlocamount_saved()));
            bizVoucher.setDebitlocamount(debitLoc.add(glVoucher.getDebitlocamount_saved()));
            bizVoucher.setCreditlocamount(creditLoc.add(glVoucher.getCreditlocamount_saved()));
        }
    }

    private void beforeSaveGroupEntries(Map<String, Long> billAiVchMap, Map<String, Long> billGLVchMap, Map<Long, Integer> glEntrySeqMap) {
        if (glEntrySeqMap == null) {
            glEntrySeqMap = new HashMap<Long, Integer>();
        }
        HashMap<Long, BizVoucher> bizVchMap = new HashMap<Long, BizVoucher>(this.taskResult.getNewBizVouchers().size());
        for (BizVoucher bv : this.taskResult.getNewBizVouchers().values()) {
            bizVchMap.put(bv.getSourceBillId(), bv);
        }
        if (bizVchMap.isEmpty()) {
            return;
        }
        Collection<GLVoucher> newGLVouchers = this.taskResult.getNewGLVouchers().values();
        Map<String, String> bizToGL = this.taskResult.getBizGroupToGlMap();
        HashMap<String, GLVoucher> glVchs = new HashMap<String, GLVoucher>(newGLVouchers.size());
        for (GLVoucher glVoucher : newGLVouchers) {
            glVchs.put(glVoucher.getTmpGuid(), glVoucher);
        }
        Iterator<GLVoucher> iterator = this.taskResult.getNewBizVouchers().values().iterator();
        while (iterator.hasNext()) {
            BizVoucher bv;
            BizVoucher bizVoucher = bv = (BizVoucher)iterator.next();
            String glVchTmpID = bizToGL.get(bv.getTmpGuid());
            long aiVchID = billAiVchMap.get(bizVoucher.getSourceBillId() + BillTemplateSplit + bizVoucher.getTemplateId());
            bizVoucher.setId(aiVchID);
            bizVoucher.setBuildGlVoucher(true);
            GLVoucher glVoucher = (GLVoucher)glVchs.get(glVchTmpID);
            bizVoucher.setGlVoucherId(glVoucher.getId());
            this.setVoucherEntryId("ai", (IVoucher<?>)bizVoucher, "T_AI_BizVoucherEntry", aiVchID, 1);
        }
        for (GLVoucher glVoucher : newGLVouchers) {
            Integer mapGLSeq;
            long glVchID = billGLVchMap.get(glVoucher.getSourceBillId() + BillTemplateSplit + glVoucher.getTemplateId());
            glVoucher.setId(glVchID);
            if (glVoucher.getEntryRows().size() > 0) {
                glVoucher.setVdescription(((GLVoucherEntry)glVoucher.getEntryRows().get(0)).getDescription());
            }
            int glseq = (mapGLSeq = glEntrySeqMap.get(glVchID)) == null ? 1 : mapGLSeq;
            VchPlugProxy.setVoucherEntryId("gl", glVoucher, glVchID, glseq, this.taskContext);
            BigDecimal debitLoc = BigDecimal.ZERO;
            BigDecimal creditLoc = BigDecimal.ZERO;
            for (GLVoucherEntry entry : glVoucher.getEntryRows()) {
                debitLoc = debitLoc.add(entry.getLocalDebit());
                creditLoc = creditLoc.add(entry.getLocalCredit());
            }
            glVoucher.setDebitlocamount(debitLoc.add(glVoucher.getDebitlocamount_saved()));
            glVoucher.setCreditlocamount(creditLoc.add(glVoucher.getCreditlocamount_saved()));
        }
    }

    private void DoMerge() {
        this.WriteInfoLog(ResManager.loadKDString((String)"\u672c\u8d26\u7c3f\u4e0b\uff0c\u5168\u90e8\u4efb\u52a1\u90fd\u5df2\u7ecf\u5904\u7406\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5408\u5e76\u5904\u7406\u7ed3\u679c", (String)"MergeBookTasksResult_1", (String)"fi-ai-mservice", (Object[])new Object[0]));
        Set<String> succTasks = CacheHelper.getBookSuccessTaskIds(this.context.getTransId(), this.taskContext.getBookInfo().getBookId());
        ArrayList<String> taskIds = new ArrayList<String>(succTasks);
        for (String taskId : taskIds) {
            SingleTaskResult oneTaskResult = CacheHelper.getTaskResult(this.context.getTransId(), taskId);
            this.MergeOneTaskResult(oneTaskResult);
        }
        this.context.getReporter().MergeTaskReport(taskIds, this.taskResult.getBookResult().getDapTrackers());
        HashSet<GLVoucherGroupKey> toRemoveKeys = new HashSet<GLVoucherGroupKey>();
        Map<String, String> bizGroupToGlMap = this.taskResult.getBookResult().getBizGroupToGlMap();
        Map<String, String> glGroupToGlMap = this.taskResult.getBookResult().getGlGroupToGlMap();
        for (Map.Entry<GLVoucherGroupKey, GLVoucher> vchItem : this.taskResult.getBookResult().getGlVouchers().entrySet()) {
            GLVoucher glVoucher = vchItem.getValue();
            if (ZeroAmountSysParamEnum.ALWAYS_GENERATE == this.taskContext.getZeroAmountGenEntryParam() || this.taskContext.getGroupEntryName() != null && (this.taskContext.getGroupEntryName() == null || glVoucher.isPreSaveEntry()) && (this.taskContext.getGroupEntryName() == null || !glVoucher.isPreSaveEntry() || !this.isVoucherEntry(glVoucher))) continue;
            DapBuildVoucherCommonUtil.dealZeroAmountEntry((GLVoucher)glVoucher, (ZeroAmountSysParamEnum)this.taskContext.getZeroAmountGenEntryParam());
            if (!glVoucher.getEntryRows().isEmpty()) continue;
            toRemoveKeys.add(vchItem.getKey());
            Iterator<BizVoucher> bizVit = this.taskResult.getBookResult().getNewBizVouchers().values().iterator();
            while (bizVit.hasNext()) {
                BizVoucher bv = bizVit.next();
                String glTid1 = bizGroupToGlMap.get(bv.getTmpGuid());
                String glTid2 = glGroupToGlMap.get(glTid1);
                boolean isMergeGl = Objects.equals(glTid2, glVoucher.getTmpGuid());
                if (bv.getSourceBillId() != glVoucher.getSourceBillId() && !isMergeGl) continue;
                this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), (Object)bv.getSourceBillId(), bv.getSourceBillNo(), bv.getTemplateId(), VoucherCheckItem.Amount, VoucherErrLevel.Error, ResManager.loadKDString((String)"\u5408\u5e76\u540e\u5206\u5f55\u91d1\u989d\u5747\u4e3a0", (String)"MergeBookTasksResult_2", (String)"fi-ai-mservice", (Object[])new Object[0]), this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
                bizVit.remove();
            }
        }
        for (GLVoucherGroupKey key : toRemoveKeys) {
            this.taskResult.getBookResult().getGlVouchers().remove(key);
        }
        String message = ResManager.loadKDString((String)"\u672c\u8d26\u7c3f\u4e0b\uff0c\u5171\u521b\u5efa{0}\u5f20\u4e1a\u52a1\u51ed\u8bc1\uff0c\u5408\u5e76\u4e3a{1}\u5f20\u603b\u8d26\u51ed\u8bc1", (String)"MergeBookTasksResult_3", (String)"fi-ai-mservice", (Object[])new Object[0]);
        message = MessageFormat.format(message, this.taskResult.getBookResult().getNewBizVouchers().size(), this.taskResult.getBookResult().getGlVouchers().size());
        this.context.getLogger().info(this.taskContext.getBookInfo().getBookId(), message);
    }

    private boolean isVoucherEntry(GLVoucher voucher) {
        HintCondition hintOrg = new HintCondition("forgid", "=", (Object)voucher.getOrgId());
        HintCondition hintPeroid = new HintCondition("fperiodid", "=", (Object)voucher.getPeriodId());
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintOrg, hintPeroid}).prepareShardingIndex();){
            String sql = "select fid from t_gl_voucherentry where fid = " + voucher.getId();
            try (DataSet qd = DB.queryDataSet((String)MergeBookTasksResult.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (String)sql);){
                Iterator it = qd.iterator();
                if (it.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private void preMerge() {
        List taskIds = this.context.getProgresser().getBookTaskIds(this.taskContext.getBookInfo());
        Set<String> succTasks = CacheHelper.getBookSuccessTaskIds(this.context.getTransId(), this.taskContext.getBookInfo().getBookId());
        for (String taskId : taskIds) {
            Iterator oneTaskResult;
            if (!succTasks.contains(taskId) || ((SingleTaskResult)((Object)(oneTaskResult = CacheHelper.getTaskResult(this.context.getTransId(), taskId)))).getGroupEntryName() == null || this.taskContext.getTaskId().equalsIgnoreCase(taskId)) continue;
            if (((SingleTaskResult)((Object)oneTaskResult)).getNewBizVouchers().size() > 0) {
                this.mergeOneTaskResultToCurrentTask((SingleTaskResult)((Object)oneTaskResult));
            }
            CacheHelper.clearTaskResult(this.context.getTransId(), taskId);
            succTasks.remove(taskId);
            this.context.getProgresser().removeTask(this.taskContext.getBookInfo().getBookId(), taskId);
        }
        CacheHelper.putBookSuccessTaskIds(this.context.getTransId(), this.taskContext.getBookInfo().getBookId(), succTasks);
        HashSet toRemoveKeys = new HashSet();
        Map<String, String> bizGroupToGlMap = this.taskResult.getBookResult().getBizGroupToGlMap();
        for (Map.Entry entry : this.taskResult.getBookResult().getGlVouchers().entrySet()) {
            GLVoucher glVoucher = (GLVoucher)entry.getValue();
            if (glVoucher.isPreSaveEntry() && (!glVoucher.isPreSaveEntry() || !this.isVoucherEntry(glVoucher))) continue;
            DapBuildVoucherCommonUtil.dealZeroAmountEntry((GLVoucher)glVoucher, (ZeroAmountSysParamEnum)this.taskContext.getZeroAmountGenEntryParam());
            if (!glVoucher.getEntryRows().isEmpty()) continue;
            toRemoveKeys.add(entry.getKey());
            Iterator<BizVoucher> bizVit = this.taskResult.getBookResult().getNewBizVouchers().values().iterator();
            while (bizVit.hasNext()) {
                BizVoucher bv = bizVit.next();
                boolean isMergeGl = Objects.equals(bizGroupToGlMap.get(bv.getTmpGuid()), glVoucher.getTmpGuid());
                if (bv.getSourceBillId() != glVoucher.getSourceBillId() && !isMergeGl) continue;
                bizVit.remove();
            }
            this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), (Object)glVoucher.getSourceBillId(), null, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), VoucherCheckItem.Amount, VoucherErrLevel.Error, ResManager.loadKDString((String)"\u5408\u5e76\u540e\u5206\u5f55\u91d1\u989d\u5747\u4e3a0", (String)"MergeBookTasksResult_2", (String)"fi-ai-mservice", (Object[])new Object[0]), this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
        }
        for (GLVoucherGroupKey gLVoucherGroupKey : toRemoveKeys) {
            this.taskResult.getBookResult().getGlVouchers().remove(gLVoucherGroupKey);
        }
        String message = ResManager.loadKDString((String)"\u672c\u8d26\u7c3f\u4e0b\uff0c\u5171\u521b\u5efa{0}\u5f20\u4e1a\u52a1\u51ed\u8bc1\uff0c\u5408\u5e76\u4e3a{1}\u5f20\u603b\u8d26\u51ed\u8bc1", (String)"MergeBookTasksResult_3", (String)"fi-ai-mservice", (Object[])new Object[0]);
        message = MessageFormat.format(message, this.taskResult.getBookResult().getNewBizVouchers().size(), this.taskResult.getBookResult().getGlVouchers().size());
        this.context.getLogger().info(this.taskContext.getBookInfo().getBookId(), message);
    }

    private void mergeOneTaskResultToCurrentTask(SingleTaskResult oneTaskResult) {
        SingleTaskResult thisResult = this.taskResult;
        this.removeDuplicateVouchers(oneTaskResult, thisResult.getDapTrackers());
        thisResult.getNewBizVouchers().putAll(oneTaskResult.getNewBizVouchers());
        for (Map.Entry<Object, List<BizVoucher>> entry : oneTaskResult.getHistBizVouchers().entrySet()) {
            BizVoucher histBizVoucher = entry.getValue().get(0);
            String tmpGuid = histBizVoucher.getTmpGuid();
            if (!oneTaskResult.getBizGroupToGlMap().containsKey(tmpGuid) || thisResult.getHistBizVouchers().containsKey(tmpGuid)) continue;
            ArrayList<BizVoucher> list = new ArrayList<BizVoucher>();
            list.add(histBizVoucher);
            thisResult.getHistBizVouchers().put(tmpGuid, list);
        }
        thisResult.getBizGroupToGlMap().putAll(oneTaskResult.getBizGroupToGlMap());
        thisResult.getSecondBillId().putAll(oneTaskResult.getSecondBillId());
        log.info("mergeOneTaskResultToCurrentTask---size:" + oneTaskResult.getSecondBillId());
        thisResult.getDelBizVoucherIds().addAll(oneTaskResult.getDelBizVoucherIds());
        thisResult.getDapTrackers().putAll(oneTaskResult.getDapTrackers());
        for (Map.Entry<Object, List<BizVoucher>> entry : oneTaskResult.getNewGLVouchers().entrySet()) {
            if (thisResult.getNewGLVouchers().containsKey(entry.getKey())) {
                GLVoucher oldVoucher = thisResult.getNewGLVouchers().get(entry.getKey());
                GLVoucher newVoucher = (GLVoucher)entry.getValue();
                Map<GLVoucherEntryGroupKey, GLVoucherEntry> oldRows = BuildVoucherUtils.rebuildEntryGroupKey(oldVoucher, this.unionHelper);
                Map<GLVoucherEntryGroupKey, GLVoucherEntry> newRows = BuildVoucherUtils.rebuildEntryGroupKey(newVoucher, this.unionHelper);
                this.MergeOneVoucher(oldVoucher, oldRows, newVoucher, newRows);
                Map<String, String> bgMap = thisResult.getBizGroupToGlMap();
                HashMap<String, String> newValueMap = new HashMap<String, String>();
                for (Map.Entry<String, String> bgEntry : bgMap.entrySet()) {
                    if (!bgEntry.getValue().equalsIgnoreCase(newVoucher.getTmpGuid())) continue;
                    newValueMap.put(bgEntry.getKey(), oldVoucher.getTmpGuid());
                }
                bgMap.putAll(newValueMap);
                continue;
            }
            GLVoucher glVoucher = (GLVoucher)entry.getValue();
            thisResult.getNewGLVouchers().put((GLVoucherGroupKey)entry.getKey(), glVoucher);
        }
    }

    private void MergeOneTaskResult(SingleTaskResult oneTaskResult) {
        SingleBookResult bookResult = this.taskResult.getBookResult();
        this.removeDuplicateVouchers(oneTaskResult, bookResult.getDapTrackers());
        bookResult.getNewBizVouchers().putAll(oneTaskResult.getNewBizVouchers());
        for (Map.Entry<Object, List<BizVoucher>> entry : oneTaskResult.getHistBizVouchers().entrySet()) {
            BizVoucher histBizVoucher = entry.getValue().get(0);
            String tmpGuid = histBizVoucher.getTmpGuid();
            if (!oneTaskResult.getBizGroupToGlMap().containsKey(tmpGuid) || bookResult.getHistBizVouchers().containsKey(tmpGuid)) continue;
            bookResult.getHistBizVouchers().put(tmpGuid, histBizVoucher);
        }
        bookResult.getBizGroupToGlMap().putAll(oneTaskResult.getBizGroupToGlMap());
        bookResult.getSecondBillId().putAll(oneTaskResult.getSecondBillId());
        bookResult.getCustomKey().putAll(oneTaskResult.getCustomKey());
        bookResult.getRelationshipSourcebillcol().addAll(oneTaskResult.getRelationshipSourcebillcol());
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--oneTaskResult.customkey.size:" + oneTaskResult.getCustomKey().size());
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--bookResult.customkey.size:" + bookResult.getCustomKey().size());
        }
        log.info("mergeOneTaskResultToCurrentTask---size:" + oneTaskResult.getSecondBillId());
        bookResult.getDelBizVoucherIds().addAll(oneTaskResult.getDelBizVoucherIds());
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5408\u5e76DAP\u5173\u7cfb\u8fdb\u5165BookResult\u524d oneTaskResult.getDapTrackers()\uff1a%s", (String)"MergeBookTasksResult_4", (String)"fi-ai-mservice", (Object[])new Object[0]), oneTaskResult.getDapTrackers().size()));
        bookResult.getDapTrackers().putAll(oneTaskResult.getDapTrackers());
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5408\u5e76DAP\u5173\u7cfb\u8fdb\u5165BookResult\u540e bookResult.getDapTrackers()\uff1a%s", (String)"MergeBookTasksResult_5", (String)"fi-ai-mservice", (Object[])new Object[0]), bookResult.getDapTrackers().size()));
        for (Map.Entry<Object, List<BizVoucher>> entry : oneTaskResult.getNewGLVouchers().entrySet()) {
            if (bookResult.getGlVouchers().containsKey(entry.getKey())) {
                GLVoucher oldVoucher = bookResult.getGlVouchers().get(entry.getKey());
                GLVoucher newVoucher = (GLVoucher)entry.getValue();
                Map<GLVoucherEntryGroupKey, GLVoucherEntry> oldRows = bookResult.getGlVoucherRows().get(oldVoucher);
                Map<GLVoucherEntryGroupKey, GLVoucherEntry> newRows = BuildVoucherUtils.rebuildEntryGroupKey(newVoucher, this.unionHelper);
                this.MergeOneVoucher(oldVoucher, oldRows, newVoucher, newRows);
                bookResult.getGlGroupToGlMap().put(newVoucher.getTmpGuid(), oldVoucher.getTmpGuid());
                continue;
            }
            GLVoucher glVoucher = (GLVoucher)entry.getValue();
            bookResult.getGlVouchers().put((GLVoucherGroupKey)entry.getKey(), glVoucher);
            bookResult.getGlVoucherRows().put(glVoucher, BuildVoucherUtils.rebuildEntryGroupKey(glVoucher, this.unionHelper));
            bookResult.getGlGroupToGlMap().put(glVoucher.getTmpGuid(), glVoucher.getTmpGuid());
        }
    }

    private void removeDuplicateVouchers(SingleTaskResult oneTaskResult, Map<Long, DapTracker> trackers) {
        HashSet existVouherIds = new HashSet();
        HashSet<Long> existBillIds = new HashSet<Long>();
        Set<Long> hasBills = trackers.keySet();
        if (hasBills.size() == 0) {
            return;
        }
        for (Map.Entry<String, BizVoucher> bizvoucher : oneTaskResult.getNewBizVouchers().entrySet()) {
            if (!hasBills.contains(bizvoucher.getValue().getSourceBillId())) continue;
            existVouherIds.add(bizvoucher.getKey());
            existBillIds.add(((BizVoucher)bizvoucher.getValue()).getSourceBillId());
        }
        HashSet<String> existGlVouherIds = new HashSet<String>();
        for (String existVouherId : existVouherIds) {
            oneTaskResult.getNewBizVouchers().remove(existVouherId);
            if (this.taskContext.getGroupEntryName() != null) continue;
            existGlVouherIds.add(oneTaskResult.getBizGroupToGlMap().remove(existVouherId));
        }
        HashSet<GLVoucherGroupKey> glKeys = new HashSet<GLVoucherGroupKey>();
        for (Map.Entry<GLVoucherGroupKey, GLVoucher> entry : oneTaskResult.getNewGLVouchers().entrySet()) {
            if (!existGlVouherIds.contains(entry.getValue().getTmpGuid())) continue;
            glKeys.add(entry.getKey());
        }
        for (GLVoucherGroupKey glkey : glKeys) {
            oneTaskResult.getNewGLVouchers().remove(glkey);
        }
        for (Long billid : existBillIds) {
            oneTaskResult.getDapTrackers().remove(billid);
        }
    }

    private void MergeOneVoucher(GLVoucher oldVoucher, Map<GLVoucherEntryGroupKey, GLVoucherEntry> oldRows, GLVoucher newVoucher, Map<GLVoucherEntryGroupKey, GLVoucherEntry> newRows) {
        Map glEntrySeqMap;
        this.unionHelper.MergeHead((IVoucher<?>)oldVoucher, (IVoucher<?>)newVoucher);
        Long oldID = oldVoucher.getId();
        if (newVoucher.getId() != 0L) {
            oldVoucher.setId(newVoucher.getId());
        }
        if (this.taskContext.getGroupEntryName() != null) {
            oldVoucher.setCreditlocamount(oldVoucher.getCreditlocamount().add(newVoucher.getCreditlocamount()));
            oldVoucher.setDebitlocamount(oldVoucher.getDebitlocamount().add(newVoucher.getDebitlocamount()));
        }
        oldVoucher.setCreditlocamount_saved(oldVoucher.getCreditlocamount_saved().add(newVoucher.getCreditlocamount_saved()));
        oldVoucher.setDebitlocamount_saved(oldVoucher.getDebitlocamount_saved().add(newVoucher.getDebitlocamount_saved()));
        for (Map.Entry<GLVoucherEntryGroupKey, GLVoucherEntry> newItem : newRows.entrySet()) {
            if (oldRows.containsKey(newItem.getKey())) {
                GLVoucherEntry oldEntryRow = oldRows.get(newItem.getKey());
                GLVoucherEntry newEntryRow = newItem.getValue();
                this.unionHelper.MergeVchEntryRow((IVoucher<?>)oldVoucher, (IVoucherEntry)oldEntryRow, (IVoucherEntry)newEntryRow);
                continue;
            }
            oldRows.put(newItem.getKey(), newItem.getValue());
            oldVoucher.getEntryRows().add(newItem.getValue());
        }
        if (newVoucher.getId() != 0L && oldID != 0L && (glEntrySeqMap = (Map)ThreadCache.get((Object)("BigVoucherEntryCache" + this.context.getTransId()), () -> CacheHelper.getGLEntrySeqMap(this.context.getTransId()))).containsKey(oldID)) {
            Integer mapGLSeq = (Integer)glEntrySeqMap.get(oldID);
            int glseq = mapGLSeq == null ? 1 : mapGLSeq;
            glEntrySeqMap.put(oldVoucher.getId(), glseq + oldVoucher.getEntryRows().size());
            CacheHelper.setGLEntrySeqMap(this.context.getTransId(), glEntrySeqMap);
            VchPlugProxy.updateVoucherEntryId(oldVoucher.getId(), oldID, this.taskContext);
        }
    }

    private void DelZeroAmountRows(GLVoucher glVoucher) {
        BigDecimal zero = new BigDecimal(Integer.toString(0));
        int rowCount = glVoucher.getEntryRows().size();
        for (int i = rowCount - 1; i >= 0; --i) {
            GLVoucherEntry row = (GLVoucherEntry)glVoucher.getEntryRows().get(i);
            boolean isAmount = row.getLocalDebit().compareTo(zero) == 0 && row.getLocalCredit().compareTo(zero) == 0;
            boolean isQty = BuildHelper.isEquals(row.getQty(), BigDecimal.ZERO);
            if (!isAmount || !isQty) continue;
            glVoucher.getEntryRows().remove(i);
        }
    }

    private void setVoucherEntryId(String dbRouteKey, IVoucher<?> voucher, String entryTableName, Long voucherID, int seqStart) {
        this.WriteInfoLog(ResManager.loadKDString((String)"\u4e3a\u603b\u8d26\u51ed\u8bc1\u5206\u5f55\u586b\u5199\u5185\u7801\u3001\u5e8f\u53f7", (String)"MergeBookTasksResult_6", (String)"fi-ai-mservice", (Object[])new Object[0]));
        ArrayList allRows = new ArrayList();
        allRows.addAll(voucher.getEntryRows());
        int seq = seqStart;
        for (IVoucherEntry row : voucher.getEntryRows()) {
            row.setSeq(seq);
            row.setId(voucherID.longValue());
            ++seq;
        }
        if (allRows.size() == 0) {
            return;
        }
        SequenceReader sReader = new SequenceReader(new DBRoute(dbRouteKey));
        Long[] entryIds = (Long[])sReader.getSequences((Object[])new Long[allRows.size()], entryTableName, allRows.size());
        for (int i = 0; i < entryIds.length; ++i) {
            ((IVoucherEntry)allRows.get(i)).setEntryId(entryIds[i].longValue());
        }
    }

    private boolean isEqualesTpl(GLVoucher glVoucher) {
        Set<String> succTasks = CacheHelper.getBookSuccessTaskIds(this.context.getTransId(), this.taskContext.getBookInfo().getBookId());
        for (String taskId : succTasks) {
            if (Objects.equals(this.taskContext.getTaskId(), taskId)) continue;
            SingleTaskResult oneTaskResult = CacheHelper.getTaskResult(this.context.getTransId(), taskId);
            Collection<BizVoucher> values = oneTaskResult.getNewBizVouchers().values();
            for (BizVoucher value : values) {
                if (!Objects.equals(value.getSourceBillId(), glVoucher.getSourceBillId())) continue;
                return Objects.equals(value.getTemplateId(), this.taskContext.getTemplate().getId());
            }
        }
        return true;
    }

    public void doMergeBookTask() {
        this.DoAction();
    }
}

