/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.dap.DapBillnoUtil;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.helper.SourceBillHelper;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.VoucherSaveHelper;
import kd.fi.bd.util.filter.QFilterBuilder;

public class SaveBizVoucherTaskResult
extends AbstractSingleTaskAction {
    public SaveBizVoucherTaskResult(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        Map<String, BizVoucher> bizvoucherMap = this.taskResult.getBookResult().getNewBizVouchers();
        Collection<BizVoucher> bizVouchers = bizvoucherMap.values();
        this.calcGLVoucherHeadAmt(bizVouchers);
        for (IVoucher iVoucher : bizVouchers) {
            int seq = 1;
            for (IVoucherEntry row : iVoucher.getEntryRows()) {
                row.setSeq(seq);
                ++seq;
            }
        }
        ArrayList<Long> needDelIds = new ArrayList<Long>();
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GENERATE_VOUCHER_INFO, (Object[])new Object[]{this.taskContext.getcurr_succIds_cacheKey()});
        Map cacheMapData = (Map)DapLocalCache.get((LocalCacheKey)cacheKey, Map.class);
        cacheMapData = cacheMapData == null ? new HashMap() : cacheMapData;
        ArrayList<Long> has_save_bizvoucher = new ArrayList<Long>();
        try (TXHandle h = TX.requiresNew();){
            if (this.taskContext.isBuildBizvoucherFromMidle()) {
                this.updateGlVoucherId(bizVouchers, needDelIds, hashMap);
            }
            HashSet<Object> successIds = new HashSet<Object>(this.handleSaveOperation(bizVouchers));
            QFilter fliter = new QFilter("id", "in", successIds);
            DynamicObjectCollection collections = QueryServiceHelper.query((String)"ai_bizvoucher", (String)"id,billno,book.id book,sourcebill,sourcebillno,sourcebillid,glvoucherid", (QFilter[])new QFilter[]{fliter});
            ArrayList<Long> needDelSourceBillIds = new ArrayList<Long>();
            for (DynamicObject obj : collections) {
                if (!successIds.contains(obj.get("id"))) continue;
                Long glVoucherId = obj.getLong("glvoucherid");
                Long id = obj.getLong("id");
                String number = obj.getString("billno");
                Long bookId = obj.getLong("book");
                String source = (String)obj.get("sourcebill");
                String sourceBillNo = obj.getString("sourcebillno");
                Long sourceBillId = obj.getLong("sourcebillid");
                AcctBookInfo bookInfo = (AcctBookInfo)this.context.getBooks().get(bookId);
                SourceBillInfo sourceBill = (SourceBillInfo)bookInfo.getSourceBills().get(source);
                has_save_bizvoucher.add(sourceBillId);
                needDelSourceBillIds.add(sourceBillId);
                this.context.getReporter().AddSuccessReport(bookInfo, sourceBill, (Object)sourceBillId, sourceBillNo, this.taskContext.getTemplate().getId(), id.longValue(), glVoucherId.longValue(), null, number, this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
            }
            cacheMapData.computeIfAbsent(AiCommonFieldUtils.has_save_bizvoucher, v -> new ArrayList()).addAll(has_save_bizvoucher);
            DapLocalCache.put((LocalCacheKey)cacheKey, (Object)cacheMapData);
            MainEntityType glMainEntityType = SourceBillHelper.getMainEntityType("gl_voucher");
            String dbRouteKey = glMainEntityType.getDBRouteKey();
            this.context.getReporter().SaveReoprt(dbRouteKey);
            if (this.taskContext.isBuildBizvoucherFromMidle()) {
                DeleteServiceHelper.delete((String)"ai_midlebizvoucher", (QFilter[])new QFilter[]{new QFilter("id", "in", needDelIds), new QFilter("sourcebillid", "in", needDelSourceBillIds)});
            }
        }
    }

    private void updateGlVoucherId(Collection<BizVoucher> bizVouchers, List<Long> needDelIds, Map<Long, Long> sourcebillAndBizvoucher) {
        String algoKey = "kd.fi.ai.mservice.builder.singletaskaction.SaveBizVoucherTaskResult.updateGlVoucherId";
        ArrayList<Long> billIds = new ArrayList<Long>(bizVouchers.size());
        for (BizVoucher bizVoucher : bizVouchers) {
            billIds.add(bizVoucher.getSourceBillId());
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(8);
        qfilters.add(new QFilter("sourcebillid", "in", billIds));
        qfilters.add(new QFilter("vchtemplateid", "=", (Object)Long.parseLong(this.taskContext.getTemplate().getId())));
        qfilters.add(new QFilter("billtype.id", "=", (Object)this.taskContext.getTemplate().getSourceBill()));
        qfilters.add(new QFilter("org.id", "=", (Object)this.taskContext.getBookInfo().getAcctOrgId()));
        qfilters.add(new QFilter("booktype.id", "=", (Object)this.taskContext.getBookInfo().getBookTypeId()));
        qfilters.add(new QFilter("opr", "=", (Object)this.taskContext.getOpr()));
        qfilters.add(new QFilter("reoper", "=", (Object)this.taskContext.getReOper()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_midlebizvoucher", (String)"id,sourcebillid,voucherid,bizvoucherid", (QFilter[])qfilters.toArray(new QFilter[0]), null);){
            for (Row row : ds) {
                needDelIds.add(row.getLong("id"));
                sourcebillAndBizvoucher.put(row.getLong("sourcebillid"), row.getLong("bizvoucherid"));
            }
        }
    }

    private void calcGLVoucherHeadAmt(Collection<BizVoucher> bizVouchers) {
        for (IVoucher iVoucher : bizVouchers) {
            BizVoucher voucher = (BizVoucher)iVoucher;
            List entries = voucher.getEntryRows();
            BigDecimal debitLoc = BigDecimal.ZERO;
            BigDecimal creditLoc = BigDecimal.ZERO;
            if (entries.size() <= 0) continue;
            for (int i = 0; i < entries.size(); ++i) {
                debitLoc = debitLoc.add(((BizVoucherEntry)entries.get(i)).getLocalDebit());
                creditLoc = creditLoc.add(((BizVoucherEntry)entries.get(i)).getLocalCredit());
                if (i != 0) continue;
                voucher.setVdescription(((BizVoucherEntry)entries.get(i)).getDescription());
            }
            voucher.setDebitlocamount(debitLoc);
            voucher.setCreditlocamount(creditLoc);
        }
    }

    private List<Object> handleSaveOperation(Collection<BizVoucher> bizVouchers) {
        ArrayList voucherList = new ArrayList(100);
        for (BizVoucher bizVoucher : bizVouchers) {
            voucherList.add((IVoucher<?>)bizVoucher);
        }
        if (!this.taskContext.isBuildBizvoucherFromMidle()) {
            DapBillnoUtil.SetGLVoucherBillNo(voucherList, this.taskContext);
        }
        ArrayList voucherDoList = new ArrayList(bizVouchers.size());
        HashSet voucherIds = new HashSet();
        ArrayList bizentries = new ArrayList(bizVouchers.size());
        voucherList.forEach(voucher -> {
            DynamicObject vv = voucher.toDynamicObjectVoucher(this.taskContext);
            bizentries.addAll(vv.getDynamicObjectCollection("entryentity"));
            voucherDoList.add(vv);
            voucherIds.add(voucher.getId());
        });
        HashSet<Object> ids = new HashSet<Object>(voucherDoList.size());
        try (TXHandle x = TX.required();){
            try {
                if (this.taskContext.isBuildBizvoucherFromMidle()) {
                    if (bizentries.size() > 0) {
                        BizVoucher gv = bizVouchers.iterator().next();
                        VoucherSaveHelper.saveBizVoucherEntries((long)gv.getOrgId(), (long)gv.getPeriodId(), bizentries);
                        ids.addAll(voucherIds);
                    }
                } else {
                    Object[] vouchers;
                    for (Object voucher2 : vouchers = SaveServiceHelper.save((DynamicObject[])voucherDoList.toArray(new DynamicObject[0]))) {
                        DynamicObject vch = (DynamicObject)voucher2;
                        ids.add(vch.get("id"));
                    }
                }
            }
            catch (Throwable e) {
                x.markRollback();
                throw e;
            }
            ArrayList<Object> succPks = new ArrayList(ids);
            ArrayList<Long> failPks = new ArrayList<Long>();
            OperateOption option = OperateOption.create();
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ai_bizvoucher", (Object[])ids.toArray(), (OperateOption)option);
            succPks = saveResult.getSuccessPkIds();
            List error = saveResult.getAllErrorOrValidateInfo();
            HashMap<Long, String> idAndBillno = new HashMap<Long, String>();
            HashMap<Long, Long> idAndsourcebillid = new HashMap<Long, Long>();
            HashMap<Long, String> idAndtemplateid = new HashMap<Long, String>();
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.SaveBizVoucherTaskResult.handleSaveOperation", (String)"ai_bizvoucher", (String)"id,sourcebillid,sourcebillno,templateid", (QFilter[])new QFilter("id", "in", ids).toArray(), null);){
                Iterator iterator = queryDataSet.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long id = row.getLong("id");
                    idAndBillno.put(id, row.getString("sourcebillno"));
                    idAndsourcebillid.put(id, row.getLong("sourcebillid"));
                    idAndtemplateid.put(id, row.getString("templateid"));
                }
            }
            if (!error.isEmpty()) {
                for (IOperateInfo info : error) {
                    Long id = (Long)info.getPkValue();
                    failPks.add(id);
                    this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), idAndsourcebillid.get(id), (String)idAndBillno.get(id), (String)idAndtemplateid.get(id), VoucherCheckItem.Other, VoucherErrLevel.Error, info.getMessage(), this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
                }
            }
            if (ids.size() == 0) {
                var18_24 = null;
                try (TXHandle x1 = TX.requiresNew();){
                    this.context.getReporter().SaveReoprt("gl");
                }
                catch (Throwable throwable) {
                    var18_24 = throwable;
                    throw throwable;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u4e1a\u52a1\u51ed\u8bc1\u5206\u5f55\u6570\u636e\u5931\u8d25", (String)"SaveBizVoucherTaskResult_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
            }
            if (this.taskContext.isBuildBizvoucherFromMidle() && failPks.size() > 0) {
                String joinIds = QFilterBuilder.buildSQLParamHolder((int)failPks.size());
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvouchersubentry where fentryid in (select fentryid from t_ai_bizvoucherentry where fid in " + joinIds + ")"), (Object[])failPks.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in " + joinIds), (Object[])failPks.toArray());
            } else {
                DeleteServiceHelper.delete((String)"ai_bizvoucher", (QFilter[])new QFilter("id", "in", failPks).toArray());
            }
            ArrayList<Object> arrayList = succPks;
            return arrayList;
        }
    }
}

