/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletplaction;

import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTplContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.buildresult.SingleTplResult;

public class AbstractSingleTemplateAction {
    protected IBuildVchContext context;
    protected ISingleTplContext templateContext;
    protected SingleTplResult templateResult;

    public void Do(ISingleTplContext templateContext, SingleTplResult templateResult) {
        this.context = templateContext.getBuildVchContext();
        this.templateContext = templateContext;
        this.templateResult = templateResult;
        if (!this.templateResult.isSkipNextAction()) {
            this.DoAction();
        }
    }

    protected void DoAction() {
    }

    protected void WriteInfoLog(String message) {
        this.context.getLogger().info(this.templateContext.getBook().getBookId(), this.templateContext.getSourceBill().getEntityNumber(), this.getTplName(), message);
    }

    protected void WriteWarnLog(String message) {
        this.context.getLogger().warn(this.templateContext.getBook().getBookId(), this.templateContext.getSourceBill().getEntityNumber(), this.getTplName(), message);
    }

    protected void WriteErrorLog(String message) {
        this.context.getLogger().error(this.templateContext.getBook().getBookId(), this.templateContext.getSourceBill().getEntityNumber(), this.getTplName(), message);
    }

    protected void WriteErrorLog(Throwable exp) {
        this.context.getLogger().error(this.templateContext.getBook().getBookId(), this.templateContext.getSourceBill().getEntityNumber(), this.getTplName(), exp);
    }

    private String getTplName() {
        if (this.templateContext.getVchTemplate() == null) {
            return "";
        }
        return this.templateContext.getVchTemplate().getDescription().toString();
    }

    protected void addAndSaveErrorReport(String msg, Object sourceBillId, String sourceBillNo) {
        this.context.getReporter().AddErrorReport(this.templateContext.getBook(), this.templateContext.getSourceBill(), sourceBillId, sourceBillNo, this.templateContext.getVchTemplate() == null ? null : this.templateContext.getVchTemplate().getId(), VoucherCheckItem.Bill, VoucherErrLevel.Error, msg, "", this.templateContext.getBook().getBuildVoucherType().getValue() + "");
        this.context.getReporter().SaveReoprt("gl");
    }
}

