/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletplaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.Period;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.plugin.events.BuildBillFilterEventArgs;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.helper.SourceBillHelper;
import kd.fi.ai.mservice.builder.singletplaction.AbstractSingleTemplateAction;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class BuildFilterAction
extends AbstractSingleTemplateAction {
    private MainEntityType mainEntityType;
    private List<String> filterInfo = new ArrayList<String>(8);
    private static Log log = LogFactory.getLog(BuildFilterAction.class);

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6784\u5efa\u6e90\u5355\u53d6\u6570\u6761\u4ef6", (String)"BuildFilterAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.mainEntityType = SourceBillHelper.getMainEntityType(this.templateContext.getSourceBill().getEntityNumber());
        List<QFilter> qFilters = this.BuildFilter();
        this.templateResult.getQFilters().addAll(qFilters);
    }

    private List<QFilter> BuildFilter() {
        QFilter dateFilter;
        QFilter acctOrgFilter;
        QFilter auditFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter idsFilter = this.BuildIdsFilter(this.templateContext.getSourceBill().getBillIds());
        if (idsFilter != null) {
            qFilters.add(idsFilter);
        }
        BuildVchContext bc = (BuildVchContext)this.context;
        if (!this.templateContext.getSourceBill().isIgnorebillstatus() && (auditFilter = this.BuildAuditFilter()) != null && StringUtils.isBlank((CharSequence)bc.getScheme().getPageId())) {
            qFilters.add(auditFilter);
        }
        if ((acctOrgFilter = this.BuildAcctOrgFilter()) != null) {
            qFilters.add(acctOrgFilter);
        }
        if ((dateFilter = this.BuildDateFilter()) != null) {
            qFilters.add(dateFilter);
        }
        this.templateResult.setqFiltersAlias(StringUtils.join((Object[])this.filterInfo.toArray(), (String)ResManager.loadKDString((String)"\u6216", (String)"BuildFilterAction_10", (String)"fi-ai-mservice", (Object[])new Object[0])));
        qFilters.addAll(this.GetPlugFilters());
        if (!qFilters.isEmpty()) {
            log.info("--DAP--Filter" + ((Object)qFilters).toString());
            log.info("--DAP--FilterSize" + qFilters.size());
        }
        return qFilters;
    }

    private QFilter BuildIdsFilter(Set<Object> billIds) {
        if (billIds == null || billIds.size() == 0) {
            return null;
        }
        BuildVchContext b = (BuildVchContext)this.context;
        Map sourceAndTmp = b.getScheme().getSourceAndTmp();
        ArrayList list = new ArrayList();
        for (Map.Entry entry : sourceAndTmp.entrySet()) {
            if (!this.templateContext.getVchTemplate().getId().equals(entry.getValue() + "")) continue;
            list.add(entry.getKey());
        }
        this.templateContext.getVchTemplate().getId();
        String pkPropName = this.mainEntityType.getPrimaryKey().getName();
        QFilter qFilter = new QFilter(pkPropName, "in", sourceAndTmp.isEmpty() ? billIds : list);
        return qFilter;
    }

    private QFilter BuildAuditFilter() {
        String fldKey;
        IDataEntityProperty prop;
        QFilter qFilter = null;
        BuildVchContext ct = (BuildVchContext)this.context;
        if (ct.getScheme().getOnTimeOperateKey() != null && ct.getScheme().getOnTimeOperateKey().trim().length() > 0 || StringUtils.isNotEmpty((CharSequence)ct.getScheme().getPageId())) {
            return qFilter;
        }
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)this.mainEntityType.getName());
        for (Map map : dataEntityOperate) {
            Map m;
            if (!"audit".equals(map.get("type")) || !(map.get("parameter") instanceof Map) || StringUtils.isEmpty((CharSequence)((CharSequence)(m = (Map)map.get("parameter")).get("statusProp"))) || StringUtils.isEmpty((CharSequence)((CharSequence)m.get("value")))) continue;
            qFilter = new QFilter((String)m.get("statusProp"), ">=", m.get("value"));
            break;
        }
        if ((prop = this.mainEntityType.findProperty(fldKey = "billstatus")) != null) {
            if (qFilter == null) {
                qFilter = new QFilter(fldKey, ">=", (Object)"C");
            }
            this.filterInfo.add(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838", (String)"BuildFilterAction_2", (String)"fi-ai-mservice", (Object[])new Object[0]));
        }
        return qFilter;
    }

    private QFilter BuildAcctSysFilter() {
        return null;
    }

    private QFilter BuildAcctPolicyFilter() {
        return null;
    }

    private QFilter BuildAcctOrgFilter() {
        QFilter qFilter = null;
        String acctOrgFldKey = this.templateContext.getVchTemplate().getAcctOrgSet();
        if (StringUtils.isNotBlank((CharSequence)acctOrgFldKey)) {
            qFilter = new QFilter(acctOrgFldKey, "=", (Object)this.templateContext.getBook().getBizOrgId());
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.templateContext.getBook().getBizOrgId(), (String)"bos_org", (String)"name");
            this.filterInfo.add(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u201c%1$s\u201d", (String)"BuildFilterAction_11", (String)"fi-ai-mservice", (Object[])new Object[0]), org.getString("name")));
        }
        return qFilter;
    }

    private QFilter BuildDateFilter() {
        QFilter qFilter = null;
        BuildVchContext ct = (BuildVchContext)this.context;
        VchExpireDate vchDateSet2 = this.templateContext.getVchTemplate().getVchDateSet2();
        String fldKey = vchDateSet2.getSingleField();
        if (StringUtils.isNotEmpty((CharSequence)fldKey) && StringUtils.isEmpty((CharSequence)ct.getScheme().getPageId())) {
            QFilter filter1 = new QFilter(fldKey, ">=", (Object)this.templateContext.getBook().getSelectDateStart());
            QFilter filter2 = new QFilter(fldKey, "<=", (Object)this.templateContext.getBook().getSelectDateEnd());
            qFilter = filter1.and(filter2);
            Period period = BaseDataLoader.loadPeriod((IBuildVchContext)this.context, (Long)this.templateContext.getBook().getSelectPeriodId());
            this.filterInfo.add(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u65e5\u671f\u4e0d\u5728\u201c%1$s\u201d\u8303\u56f4\u5185", (String)"BuildFilterAction_5", (String)"fi-ai-mservice", (Object[])new Object[0]), period.getName()));
        }
        return qFilter;
    }

    private boolean is_a_word(String str) {
        str = str.trim();
        Pattern p = Pattern.compile("^[A-Za-z]+$");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    private List<QFilter> GetPlugFilters() {
        String qFiltersAlias;
        BuildBillFilterEventArgs eventArgs = new BuildBillFilterEventArgs();
        eventArgs.setTplContext(this.templateContext);
        this.templateContext.getPlugProxy().FireBuildBillFilter(eventArgs);
        List plugFilters = eventArgs.getPlugFilters();
        if (!plugFilters.isEmpty()) {
            qFiltersAlias = this.templateResult.getqFiltersAlias();
            this.templateResult.setqFiltersAlias(qFiltersAlias.equals("") ? qFiltersAlias : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u6ee1\u8db3\uff0c\u6216\u4e0d\u6ee1\u8db3\u81ea\u5b9a\u4e49\u63d2\u4ef6\u8fc7\u6ee4\u6761\u4ef6\uff1a\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BuildFilterAction_12", (String)"fi-ai-mservice", (Object[])new Object[0]), qFiltersAlias, plugFilters.toString()));
        }
        if ("fa_card_fin".equalsIgnoreCase(this.templateContext.getSourceBill().getEntityNumber()) && !(qFiltersAlias = this.templateResult.getqFiltersAlias()).equals("")) {
            QFilter originalFilter = plugFilters.stream().filter(t -> "originaldata".equalsIgnoreCase(t.getProperty())).findFirst().orElse(null);
            String msg = originalFilter == null ? String.format(ResManager.loadKDString((String)"%s\u6216\u8d22\u52a1\u5361\u7247\u662f\u5386\u53f2\u5907\u4efd\u5361\u7247", (String)"BuildFilterAction_13", (String)"fi-ai-mservice", (Object[])new Object[0]), qFiltersAlias) : String.format(ResManager.loadKDString((String)"%s\u6216\u8d22\u52a1\u5361\u7247\u4e0d\u662f\u539f\u59cb\u6570\u636e", (String)"BuildFilterAction_14", (String)"fi-ai-mservice", (Object[])new Object[0]), qFiltersAlias);
            this.templateResult.setqFiltersAlias(msg);
        }
        return plugFilters;
    }
}

