/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.accountref.CheckResult;
import kd.bos.ext.fi.accountref.IAccountTableRefService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.accsys.AcctAsstUtil;

public class AccountTableRefReconPlanService
implements IAccountTableRefService {
    private static final String ENTITY_ASSTTYPE_UPDATE = "bd_asstacttype_update";
    private static final String FIELDS_ASSTTYPE_UPDATE = "id,dataid,entryname,dataentryid,fieldname,befassttype";
    private static final String FIELDS_RECONCILIATION_SCHEME = "id,bizapp,org,accounttable,assistentry.tab1_account,assistentry.mulassist,assistentry.amounttype1,basedataentry.assistacct,basedataentry.amounttype2,basedataentry.mulassist2";
    private static Log logger = LogFactory.getLog(AccountTableRefReconPlanService.class);

    public void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter acctTableFilter = new QFilter("accounttable", "=", (Object)accountIdRef.getNewAccountTableId());
        Map oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        QFilter acctFilter = new QFilter("assistentry.tab1_account.id", "in", oldAndNewAccountRef.values());
        Object[] filters = new QFilter[]{orgFilter, acctTableFilter, acctFilter};
        logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u5f00\u59cb\u542f\u7528\u7248\u672c\u5316\uff0c\u53c2\u6570\uff1a%s", Arrays.toString(filters)));
        Map schemePlans = BusinessDataServiceHelper.loadFromCache((String)"ai_reconciliation_scheme", (String)FIELDS_RECONCILIATION_SCHEME, (QFilter[])filters);
        if (schemePlans == null || schemePlans.isEmpty()) {
            logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u542f\u7528\u64cd\u4f5c\u6267\u884c\u5b8c\u6210\uff0c\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u65b9\u6848\u3002\u53c2\u6570\uff1a%s", Arrays.toString(filters)));
            return;
        }
        ArrayList<DynamicObject> dyUptAsstRecords = new ArrayList<DynamicObject>(schemePlans.size());
        HashSet<DynamicObject> dyUptSchemes = new HashSet<DynamicObject>(schemePlans.size());
        for (Map.Entry ety : schemePlans.entrySet()) {
            DynamicObject scheme = (DynamicObject)ety.getValue();
            DynamicObjectCollection dyAsstEntries = scheme.getDynamicObjectCollection("assistentry");
            for (DynamicObject dyEntry : dyAsstEntries) {
                DynamicObjectCollection dyAssistTypes;
                List<Long> asstTypeIds;
                Set asstIds;
                Long entryId = dyEntry.getLong("id");
                Long acctId = dyEntry.getLong("tab1_account.id");
                Set notExistAsstIds = AcctAsstUtil.filterNotExistAsstTypeInAcct((Long)acctId, asstIds = (asstTypeIds = this.getBaseDataIdList(dyAssistTypes = dyEntry.getDynamicObjectCollection("mulassist"))).stream().map(p -> p).collect(Collectors.toSet()));
                if (notExistAsstIds == null || notExistAsstIds.isEmpty()) continue;
                DynamicObjectCollection dyExistAssistTypes = new DynamicObjectCollection();
                DynamicObjectType asstObjType = dyAssistTypes.getDynamicObjectType();
                for (DynamicObject dyAsstType : dyAssistTypes) {
                    Long asstId = dyAsstType.getLong("fbasedataid_id");
                    if (notExistAsstIds.contains(asstId)) continue;
                    DynamicObject dyAftAsst = new DynamicObject(asstObjType);
                    dyAftAsst.set("fbasedataid_id", (Object)dyAsstType.getLong("fbasedataid_id"));
                    dyExistAssistTypes.add((Object)dyAftAsst);
                }
                if (!dyExistAssistTypes.isEmpty()) {
                    dyEntry.set("mulassist", (Object)dyExistAssistTypes);
                    dyUptSchemes.add(scheme);
                }
                dyUptAsstRecords.add(this.getUptAsstRecord(orgId, scheme, entryId, acctId, notExistAsstIds, dyAssistTypes));
            }
        }
        if (!dyUptAsstRecords.isEmpty()) {
            try (TXHandle handle = TX.requiresNew((String)"fi_ai_enable_reconplan");){
                try {
                    SaveServiceHelper.save((DynamicObject[])dyUptSchemes.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])dyUptAsstRecords.toArray(new DynamicObject[0]));
                    logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u542f\u7528\u6210\u529f\uff0c\u53c2\u6570\uff1aorg=%s, newaccttableid=%s", orgId, accountIdRef.getNewAccountTableId()));
                }
                catch (Exception e) {
                    handle.markRollback();
                    logger.error(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u542f\u7528\u5931\u8d25\uff0c\u53c2\u6570\uff1aorg=%s, newaccttableid=%s\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", orgId, accountIdRef.getNewAccountTableId(), e));
                    throw e;
                }
            }
        }
        logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u542f\u7528\u64cd\u4f5c\u6267\u884c\u5b8c\u6210\uff0c\u53c2\u6570\uff1aorg=%s, newaccttableid=%s", orgId, accountIdRef.getNewAccountTableId()));
    }

    public List<Long> getBaseDataIdList(DynamicObjectCollection mulBaseData) {
        ArrayList<Long> bastdataidList = new ArrayList<Long>();
        for (DynamicObject amountType : mulBaseData) {
            bastdataidList.add(amountType.getLong("fbasedataid.id"));
        }
        return bastdataidList;
    }

    private DynamicObject getUptAsstRecord(long orgId, DynamicObject scheme, Long entryId, Long acctId, Set<Long> notExistAsstIds, DynamicObjectCollection dyAssistTypes) {
        DynamicObject dyUptAsstRecord = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ASSTTYPE_UPDATE);
        dyUptAsstRecord.set("metadata", (Object)"ai_reconciliation_scheme");
        dyUptAsstRecord.set("dataid", scheme.getPkValue());
        dyUptAsstRecord.set("entryname", (Object)"assistentry");
        dyUptAsstRecord.set("dataentryid", (Object)entryId);
        dyUptAsstRecord.set("fieldtype", (Object)"A");
        dyUptAsstRecord.set("fieldname", (Object)"mulassist");
        DynamicObjectCollection dyBefAsstTypes = dyUptAsstRecord.getDynamicObjectCollection("befassttype");
        DynamicObjectType asstObjType = dyBefAsstTypes.getDynamicObjectType();
        for (DynamicObject dyAsst : dyAssistTypes) {
            DynamicObject dyBefAsst = new DynamicObject(asstObjType);
            dyBefAsst.set("fbasedataid_id", (Object)dyAsst.getLong("fbasedataid_id"));
            dyBefAsstTypes.add((Object)dyBefAsst);
        }
        dyUptAsstRecord.set("befassttype", (Object)dyBefAsstTypes);
        dyUptAsstRecord.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dyUptAsstRecord.set("createtime", (Object)new Date());
        dyUptAsstRecord.set("org", (Object)orgId);
        List asstIds = notExistAsstIds.stream().map(p -> p).collect(Collectors.toList());
        dyUptAsstRecord.set("remark_tag", (Object)String.format(ResManager.loadKDString((String)"\u79d1\u76eeID\u4e3a\u201c%1$s\u201d\u7684\u7ef4\u5ea6\u51cf\u5c11\uff1a%2$s", (String)"AccountTableRefReconPlanService_0", (String)"fi-ai-mservice", (Object[])new Object[0]), Long.toString(acctId), StringUtils.join((Object[])asstIds.toArray(), (String)",")));
        return dyUptAsstRecord;
    }

    public CheckResult enableCheck(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }

    public void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        QFilter orgFilter;
        QFilter useOrgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter acctTableFilter = new QFilter("accounttable", "=", (Object)accountIdRef.getOldAccountTableId());
        Map oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
        QFilter acctFilter = new QFilter("assistentry.tab1_account.id", "in", oldAndNewAccountRef.keySet());
        Object[] filters = new QFilter[]{useOrgFilter, acctTableFilter, acctFilter};
        logger.info(String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u5f00\u59cb\u53cd\u542f\u7528\u7248\u672c\u5316\uff0c\u53c2\u6570\uff1a%s\u3002", (String)"AccountTableRefReconPlanService_2", (String)"fi-ai-mservice", (Object[])new Object[0]), Arrays.toString(filters)));
        Map schemePlans = BusinessDataServiceHelper.loadFromCache((String)"ai_reconciliation_scheme", (String)FIELDS_RECONCILIATION_SCHEME, (QFilter[])filters);
        if (schemePlans == null || schemePlans.isEmpty()) {
            logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u53cd\u542f\u7528\u64cd\u4f5c\u6267\u884c\u5b8c\u6210\uff0c\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u65b9\u6848\u3002\u53c2\u6570\uff1a%s", Arrays.toString(filters)));
            return;
        }
        QFilter entityFilter = new QFilter("metadata", "=", (Object)"ai_reconciliation_scheme");
        Set schemeIds = schemePlans.keySet();
        QFilter idFilter = new QFilter("dataid", "in", schemeIds);
        Object[] updateFilters = new QFilter[]{entityFilter, idFilter, orgFilter = new QFilter("org", "=", (Object)orgId)};
        DynamicObject[] dyUpdateRecords = BusinessDataServiceHelper.load((String)ENTITY_ASSTTYPE_UPDATE, (String)FIELDS_ASSTTYPE_UPDATE, (QFilter[])updateFilters);
        if (dyUpdateRecords == null || dyUpdateRecords.length == 0) {
            logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u53cd\u542f\u7528\u64cd\u4f5c\u6267\u884c\u5b8c\u6210\uff0c\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u7ef4\u5ea6\u8bb0\u5f55\u3002\u53c2\u6570\uff1a%s", Arrays.toString(updateFilters)));
            return;
        }
        ArrayList<DynamicObject> updateSchemePlans = new ArrayList<DynamicObject>(schemePlans.size());
        HashSet<Long> updateSchemeIds = new HashSet<Long>(10);
        ArrayList<Object> deleteUptRecords = new ArrayList<Object>(dyUpdateRecords.length);
        for (DynamicObject dyRecord : dyUpdateRecords) {
            Boolean isDelete = Boolean.FALSE;
            Long schemeId = dyRecord.getLong("dataid");
            DynamicObject dySchemePlan = (DynamicObject)schemePlans.get(schemeId);
            if (dySchemePlan == null) continue;
            if (updateSchemeIds.contains(schemeId)) {
                deleteUptRecords.add(dyRecord.getPkValue());
                continue;
            }
            String entryName = dyRecord.getString("entryname");
            long dataEntryId = dyRecord.getLong("dataentryid");
            String fieldName = dyRecord.getString("fieldname");
            DynamicObjectCollection dyBefAsstTypeCls = dyRecord.getDynamicObjectCollection("befassttype");
            DynamicObjectCollection dyEntries = dySchemePlan.getDynamicObjectCollection(entryName);
            for (DynamicObject dyEty : dyEntries) {
                long entryId = dyEty.getLong("id");
                if (dataEntryId != entryId) continue;
                DynamicObjectCollection dyAsstTypeCls = dyEty.getDynamicObjectCollection(fieldName);
                dyAsstTypeCls.clear();
                for (DynamicObject dyAsstType : dyBefAsstTypeCls) {
                    DynamicObject dyAcct = dyAsstTypeCls.addNew();
                    dyAcct.set("fbasedataid_id", (Object)dyAsstType.getLong("fbasedataid_id"));
                    isDelete = Boolean.TRUE;
                }
            }
            if (!isDelete.booleanValue()) continue;
            updateSchemePlans.add(dySchemePlan);
            updateSchemeIds.add(schemeId);
            deleteUptRecords.add(dyRecord.getPkValue());
        }
        if (!deleteUptRecords.isEmpty()) {
            try (TXHandle handle = TX.requiresNew((String)"fi_ai_disenable_reconplan");){
                try {
                    SaveServiceHelper.save((DynamicObject[])updateSchemePlans.toArray(new DynamicObject[0]));
                    DeleteServiceHelper.delete((IDataEntityType)dyUpdateRecords[0].getDataEntityType(), (Object[])deleteUptRecords.toArray(new Object[0]));
                    logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u53cd\u542f\u7528\u6210\u529f\uff0c\u53c2\u6570\uff1aorg=%s, oldaccttableid=%s", orgId, accountIdRef.getOldAccountTableId()));
                }
                catch (Exception e) {
                    handle.markRollback();
                    logger.error(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u53cd\u542f\u7528\u5931\u8d25\uff0c\u53c2\u6570\uff1aorg=%s, oldaccttableid=%s\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", orgId, accountIdRef.getOldAccountTableId(), e));
                    throw e;
                }
            }
        }
        logger.info(String.format("\u5bf9\u8d26\u65b9\u6848\u7248\u672c\u5316\u53cd\u542f\u7528\u64cd\u4f5c\u6267\u884c\u5b8c\u6210\uff0c\u53c2\u6570\uff1aorg=%s, oldaccttableid=%s", orgId, accountIdRef.getOldAccountTableId()));
    }

    public CheckResult disableCheck(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        return new CheckResult();
    }
}

