/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.column.VoucherNoColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.list.column.ComboSearchValue;
import kd.bos.list.column.CompareSearchValue;
import kd.bos.list.column.ListColumnCompare;
import kd.bos.list.column.ListColumnCompareService;
import kd.bos.list.column.ListColumnCompares;
import kd.bos.list.column.ListColumnMeta;
import kd.bos.list.service.ListFormShowParameterIn;
import kd.bos.list.service.PackageDataServiceIn;
import kd.bos.list.service.PackageDataServiceResults;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.ExceedShardingQueryLimit;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.ai.util.VoucherNoUtil;

public class ListColumnServiveImpl
implements ListColumnCompareService {
    private static final String NOGEN = "69";
    private static final String TOGEN = "68";
    private static final String EQUAL = "67";
    private static final String LIKE = "66";
    private static final String IN = "65";
    private static Log logger = LogFactory.getLog(ListColumnServiveImpl.class);

    public ListColumnCompares getListColumnCompares(ListColumnMeta listColumnMeta) {
        ArrayList<ListColumnCompare> columnComboItems = new ArrayList<ListColumnCompare>(10);
        if (listColumnMeta == ListColumnMeta.VoucherNoListColumn) {
            columnComboItems.add(new ListColumnCompare(EQUAL, new LocaleString(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"ListColumnServiveImpl_0", (String)"fi-ai-mservice", (Object[])new Object[0])), 0, "kd.fi.ai.compare.VoucherContant"));
            ListColumnCompare noGen = new ListColumnCompare(TOGEN, new LocaleString(ResManager.loadKDString((String)"\u5f85\u751f\u6210", (String)"ListColumnServiveImpl_1", (String)"fi-ai-mservice", (Object[])new Object[0])), -1, "kd.fi.ai.compare.VoucherContant");
            columnComboItems.add(noGen);
            ListColumnCompare toGen = new ListColumnCompare(NOGEN, new LocaleString(ResManager.loadKDString((String)"\u4e0d\u751f\u6210", (String)"ListColumnServiveImpl_2", (String)"fi-ai-mservice", (Object[])new Object[0])), -1, "kd.fi.ai.compare.VoucherContant");
            columnComboItems.add(toGen);
        }
        return new ListColumnCompares(columnComboItems);
    }

    public ListColumnCompares getSchemeFilterColumnCompares(ListColumnMeta listColumnMeta) {
        if (listColumnMeta == ListColumnMeta.VoucherNoListColumn) {
            ListColumnCompares s = this.getListColumnCompares(listColumnMeta);
            List columnComboItems = s.getColumnComboItems();
            ListColumnCompare incompare = new ListColumnCompare(IN, new LocaleString(ResManager.loadKDString((String)"\u5728\u2026\u2026\u4e2d", (String)"ListColumnServiveImpl_5", (String)"fi-ai-mservice", (Object[])new Object[0])), 0, "kd.fi.ai.compare.VoucherContant");
            incompare.setMulti(true);
            columnComboItems.add(incompare);
            return new ListColumnCompares(columnComboItems);
        }
        return super.getSchemeFilterColumnCompares(listColumnMeta);
    }

    public QFilter search(ComboSearchValue searchValue) {
        block49: {
            if (searchValue.getListColumnMeta() == ListColumnMeta.VoucherNoListColumn && searchValue instanceof CompareSearchValue) {
                String tableName;
                DynamicProperty vp;
                CompareSearchValue cv = (CompareSearchValue)searchValue;
                String cid = cv.getCompareId();
                List values = cv.getValues();
                Map params = cv.getParaMap();
                String voucheridField = null;
                String voucherOperationKey = null;
                if (params != null) {
                    voucheridField = (String)params.get("voucherFieldId");
                    voucherOperationKey = (String)params.get("operationKey");
                }
                logger.info("ListColumnServiceParam,cid={},values={},params={}", new Object[]{cid, values, params});
                String entityKey = searchValue.getEntityId();
                MainEntityType et = EntityMetadataCache.getDataEntityType((String)entityKey);
                if (StringUtils.isNotBlank((CharSequence)voucheridField) && ((vp = et.getProperty(voucheridField)) == null || StringUtils.isBlank((CharSequence)vp.getAlias()))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u5217\u5b57\u6bb5\u7ed1\u5b9a\u7684\u51ed\u8bc1ID\u5b57\u6bb5\u5f02\u5e38\uff0c\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u65e0\u5bf9\u5e94\u6570\u636e\u5e93\u5b57\u6bb5\u3002", (String)"ListColumnServiveImpl_6", (String)"fi-ai-mservice", (Object[])new Object[0]));
                }
                if (EQUAL.equals(cid)) {
                    return this.getEqualFilter(entityKey, values, voucheridField, voucherOperationKey);
                }
                if (TOGEN.equals(cid)) {
                    if (StringUtils.isNotBlank((CharSequence)voucheridField)) {
                        return new QFilter(voucheridField, "is null", null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)entityKey)) {
                        tableName = et.getAlias() + "_dapw";
                        if (DB.exitsTable((DBRoute)DBRoute.of((String)et.getDBRouteKey()), (String)tableName)) {
                            if (StringUtils.isNotBlank((CharSequence)voucherOperationKey)) {
                                return QFilter.sqlExpress((String)"id", (String)"in", (String)("select fsourcebillid from " + tableName + " where foper='" + voucherOperationKey + "'"));
                            }
                            return QFilter.sqlExpress((String)"id", (String)"in", (String)("select fsourcebillid from " + tableName));
                        }
                    }
                } else if (NOGEN.equals(cid)) {
                    if (StringUtils.isNotBlank((CharSequence)entityKey)) {
                        tableName = et.getAlias() + "_dapn";
                        if (DB.exitsTable((DBRoute)DBRoute.of((String)et.getDBRouteKey()), (String)tableName)) {
                            return QFilter.sqlExpress((String)"id", (String)"in", (String)("select fsourcebillid from " + tableName));
                        }
                    }
                } else {
                    if (LIKE.endsWith(cid)) {
                        if (values == null || values.size() == 0) {
                            return null;
                        }
                        if (StringUtils.isNotBlank((CharSequence)voucheridField)) {
                            try (ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();){
                                es.setSkipExceedLimit(true);
                                String maxids = SysParamConfig.get((String)"voucherno.like.maxids", (String)"10000");
                                int max = Integer.parseInt(maxids);
                                List glVoucherids = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("billno", "like", (Object)("%" + (String)values.get(0) + "%"))}, null, (int)(max + 1));
                                if (glVoucherids != null && glVoucherids.size() > 0) {
                                    if (glVoucherids.size() > max) {
                                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6761\u4ef6\u67e5\u8be2\u8fd4\u56de\u51ed\u8bc1\u6570\u91cf\u5927\u4e8e%1$d\uff0c\u8bf7\u4fee\u6539\u6761\u4ef6\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"ListColumnServiveImpl_4", (String)"fi-ai-mservice", (Object[])new Object[0]), max));
                                    }
                                    QFilter qFilter = new QFilter(voucheridField, "in", (Object)glVoucherids);
                                    return qFilter;
                                }
                                break block49;
                            }
                        }
                        HashSet<Long> billids = new HashSet<Long>(8);
                        try (ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();){
                            es.setSkipExceedLimit(true);
                            String maxids = SysParamConfig.get((String)"voucherno.like.maxids", (String)"10000");
                            int max = Integer.parseInt(maxids);
                            List glVoucherids = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("billno", "like", (Object)("%" + (String)values.get(0) + "%"))}, null, (int)(max + 1));
                            if (glVoucherids != null && glVoucherids.size() > 0) {
                                if (glVoucherids.size() > max) {
                                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6761\u4ef6\u67e5\u8be2\u8fd4\u56de\u51ed\u8bc1\u6570\u91cf\u5927\u4e8e%1$d\uff0c\u8bf7\u4fee\u6539\u6761\u4ef6\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"ListColumnServiveImpl_4", (String)"fi-ai-mservice", (Object[])new Object[0]), max));
                                }
                                List pts = DapBuildVoucherCommonUtil.splitbatch((List)glVoucherids, (int)999);
                                for (List gids : pts) {
                                    this.queryBillIds(billids, ListColumnServiveImpl.getSelectTrackerSqlBuilder(voucherOperationKey, entityKey, gids));
                                }
                            }
                        }
                        return new QFilter("id", "in", billids);
                    }
                    if (IN.endsWith(cid)) {
                        return this.getEqualFilter(entityKey, values, voucheridField, voucherOperationKey);
                    }
                }
            }
        }
        return null;
    }

    private static SqlBuilder getSelectTrackerSqlBuilder(String voucherOperationKey, String entityKey, List<Object> gids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsourcebillid from t_ai_daptracker where ", new Object[0]).appendIn(" fvoucherid", gids.toArray()).append(" and fbilltype = ?", new Object[]{entityKey});
        if (StringUtils.isNotBlank((CharSequence)voucherOperationKey)) {
            sqlBuilder.append(" and foper = ?", new Object[]{voucherOperationKey});
        }
        sqlBuilder.append(" union all", new Object[0]);
        sqlBuilder.append(" select FSRC_BILLID fsourcebillid from t_fah_evt_tracker where ", new Object[0]).appendIn("FGL_HEADER_ID ", gids.toArray());
        sqlBuilder.append(" and fsrc_billtype = ?", new Object[]{entityKey});
        sqlBuilder.append(" and fstatus = ?", new Object[]{"4"});
        return sqlBuilder;
    }

    private QFilter getEqualFilter(String billEntityId, List<String> values, String voucheridField, String voucherOperationKey) {
        if (values == null || values.size() == 0) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)voucheridField)) {
            try (ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();){
                es.setSkipExceedLimit(true);
                List glVoucherids = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("billno", "in", values)}, null, (int)-1);
                QFilter qFilter = new QFilter(voucheridField, "in", (Object)glVoucherids);
                return qFilter;
            }
        }
        HashSet<Long> billids = new HashSet<Long>(8);
        try (ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();){
            es.setSkipExceedLimit(true);
            List glVoucherids = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("billno", "in", values)}, null, (int)-1);
            if (glVoucherids != null && glVoucherids.size() > 0) {
                List pts = DapBuildVoucherCommonUtil.splitbatch((List)glVoucherids, (int)999);
                for (List gids : pts) {
                    this.queryBillIds(billids, ListColumnServiveImpl.getSelectTrackerSqlBuilder(voucherOperationKey, billEntityId, gids));
                }
            }
        }
        return new QFilter("id", "in", billids);
    }

    private void queryBillIds(Set<Long> billids, SqlBuilder sqlBuilder) {
        try (DataSet qd = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                billids.add(row.getLong("fsourcebillid"));
            }
        }
    }

    public PackageDataServiceResults packageData(PackageDataServiceIn packageDataServiceIn) {
        return new PackageDataServiceResults(VoucherNoUtil.getVoucherNumber((List)packageDataServiceIn.getPks(), (String)packageDataServiceIn.getEntityId(), (VoucherNoColumnDesc)((VoucherNoColumnDesc)packageDataServiceIn.getAbstractColumnDesc())));
    }

    public FormShowParameter getFormShowParameter(ListFormShowParameterIn listFormShowParameterIn) {
        return VoucherNoUtil.getFormShowParameter((String)listFormShowParameterIn.getBillId(), (String)listFormShowParameterIn.getEntityId(), (String)((String)listFormShowParameterIn.getFormShowParameterIn().get("operationKey")), (String)((String)listFormShowParameterIn.getFormShowParameterIn().get("voucherFieldId")));
    }
}

