/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.bd.service.voucher.TempVoucherService;

public class VchPluginUtil {
    private static Log logger = LogFactory.getLog(VchPluginUtil.class);

    public static void setVoucherId(String dbRouteKey, List<IVoucher<?>> vouchers, String vchTabName, ISingleTaskContext taskContext) {
        logger.info(ResManager.loadKDString((String)"\u4e3a\u51ed\u8bc1\u586b\u5199\u5185\u7801", (String)"SaveBookTasksResult_7", (String)"fi-ai-mservice", (Object[])new Object[0]));
        if (taskContext.getShowInfo().booleanValue()) {
            logger.info("--DAP--" + ResManager.loadKDString((String)"\u4e3a\u51ed\u8bc1\u586b\u5199\u5185\u7801", (String)"SaveBookTasksResult_7", (String)"fi-ai-mservice", (Object[])new Object[0]));
        }
        if (vouchers.size() == 0) {
            return;
        }
        SequenceReader sReader = new SequenceReader(new DBRoute(dbRouteKey));
        Long[] ids = (Long[])sReader.getSequences((Object[])new Long[vouchers.size()], vchTabName, vouchers.size());
        for (int i = 0; i < ids.length; ++i) {
            IVoucher<?> iVoucher = vouchers.get(i);
            if (iVoucher.getId() != 0L) continue;
            iVoucher.setId(ids[i].longValue());
        }
    }

    public static void setVoucherEntryId(String dbRouteKey, List<IVoucher<?>> vouchers, String entryTableName, ISingleTaskContext taskContext) {
        logger.info(ResManager.loadKDString((String)"\u4e3a\u603b\u8d26\u51ed\u8bc1\u5206\u5f55\u586b\u5199\u5185\u7801\u3001\u5e8f\u53f7", (String)"SaveBookTasksResult_9", (String)"fi-ai-mservice", (Object[])new Object[0]));
        if (taskContext.getShowInfo().booleanValue()) {
            logger.info("--DAP--" + ResManager.loadKDString((String)"\u4e3a\u603b\u8d26\u51ed\u8bc1\u5206\u5f55\u586b\u5199\u5185\u7801\u3001\u5e8f\u53f7", (String)"SaveBookTasksResult_9", (String)"fi-ai-mservice", (Object[])new Object[0]));
        }
        ArrayList allRows = new ArrayList();
        for (IVoucher<?> voucher : vouchers) {
            allRows.addAll(voucher.getEntryRows());
            int seq = 1;
            for (IVoucherEntry row : voucher.getEntryRows()) {
                row.setSeq(seq);
                ++seq;
            }
        }
        if (allRows.size() == 0) {
            return;
        }
        SequenceReader sReader = new SequenceReader(new DBRoute(dbRouteKey));
        Long[] entryIds = (Long[])sReader.getSequences((Object[])new Long[allRows.size()], entryTableName, allRows.size());
        for (int i = 0; i < entryIds.length; ++i) {
            ((IVoucherEntry)allRows.get(i)).setEntryId(entryIds[i].longValue());
        }
    }

    public static void setAllGLVoucherId(SingleTaskResult taskResult) {
        HashMap<String, GLVoucher> glVoucherMap = new HashMap<String, GLVoucher>(taskResult.getBookResult().getGlVouchers().size());
        for (GLVoucher glVoucher : taskResult.getBookResult().getGlVouchers().values()) {
            String glTmpGuid = glVoucher.getTmpGuid();
            glVoucherMap.put(glTmpGuid, glVoucher);
        }
        for (BizVoucher bizVoucher : taskResult.getBookResult().getNewBizVouchers().values()) {
            VchPluginUtil.setOneGLVoucherId(glVoucherMap, bizVoucher, taskResult);
        }
        for (BizVoucher histBizVoucher : taskResult.getBookResult().getHistBizVouchers().values()) {
            VchPluginUtil.setOneGLVoucherId(glVoucherMap, histBizVoucher, taskResult);
        }
    }

    public static void deleteVoucher(Set<Object> ids) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isTcc", "true");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])ids.toArray(), (OperateOption)operateOption);
        int size = operationResult.getSuccessPkIds().size();
        logger.info(String.format("\u901a\u8fc7\u5220\u9664\u64cd\u4f5c\u5220\u9664\u7684\u8bb0\u5f55\u6709---%s---\u6761", size));
        if (!operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null && !successPkIds.isEmpty()) {
                for (Object successPkId : successPkIds) {
                    ids.remove(successPkId);
                }
            }
            if (!ids.isEmpty()) {
                size = DeleteServiceHelper.delete((String)"gl_voucher", (QFilter[])new QFilter("id", "in", ids).toArray());
                TempVoucherService.deleteByIds((Long[])ids.toArray(new Long[0]));
                logger.info(String.format("\u901a\u8fc7\u6570\u636e\u5e93\u5220\u9664\u7684\u8bb0\u5f55\u6709---%s---\u6761", size));
                String joinids = StringUtils.join((Object[])ids.toArray(), (char)',');
                logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684\u4e1a\u52a1\u51ed\u8bc1");
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where fglvoucherid in (" + joinids + "))"));
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucher where fglvoucherid in (" + joinids + ")"));
                logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684DAP\u5173\u7cfb");
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptrackerentry where fid in (select fid from t_ai_daptracker where fvoucherid in (" + joinids + "))"));
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptracker where fvoucherid in (" + joinids + ")"));
                logger.info(String.format("\u603b\u8bb0\u5f55\u6709---%s---\u6761", ids.size()));
            }
        }
    }

    private static void setOneGLVoucherId(Map<String, GLVoucher> glVoucherMap, BizVoucher bizVoucher, SingleTaskResult taskResult) {
        String glTmpGuid1;
        Map<String, String> bizGroupToGlMap = taskResult.getBookResult().getBizGroupToGlMap();
        Map<String, String> glGroupToGlMap = taskResult.getBookResult().getGlGroupToGlMap();
        String bizTmpGuid = bizVoucher.getTmpGuid();
        if (bizGroupToGlMap.containsKey(bizTmpGuid) && glGroupToGlMap.containsKey(glTmpGuid1 = bizGroupToGlMap.get(bizTmpGuid))) {
            String glTmgGuid2 = glGroupToGlMap.get(glTmpGuid1);
            GLVoucher glVoucher = glVoucherMap.get(glTmgGuid2);
            bizVoucher.setBuildGlVoucher(true);
            bizVoucher.setGlVoucherId(glVoucher.getId());
        }
    }
}

