/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service.helper;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.util.FieldReplaceUtil;

public class VchTemplateMainData
implements Serializable {
    private static final long serialVersionUID = 8445224199446026197L;
    private VCHTemplate vchTemplate;
    private Long temId;
    private String bizOrgField;
    private VchTplExpression filterExpress;
    private Set<Long> bookTypeIds = new HashSet<Long>(2);
    private Long eventClassId;
    private Set<Long> matchSourcebillid = new HashSet<Long>(16);
    private VchExpireDate vchDateBox;
    private Long accountTableId;
    private String billTypeKey;

    public VchTemplateMainData(VCHTemplate vchTemplate, Set<Long> billids, String billTypeKey) {
        this.billTypeKey = billTypeKey;
        this.vchTemplate = vchTemplate;
        this.temId = Long.parseLong(vchTemplate.getId());
        List typeIds = vchTemplate.getBookTypeIds();
        if (typeIds != null && !typeIds.isEmpty()) {
            this.bookTypeIds = new HashSet<Long>(typeIds);
        } else {
            String sql = "select fid from t_bd_accountbookstype;";
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.mservice.service.helper.VchTemplateMainData", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
                Iterator iterator = queryDataSet.iterator();
                while (iterator.hasNext()) {
                    this.bookTypeIds.add(((Row)iterator.next()).getLong("fid"));
                }
            }
        }
        String templateEntityNumber = vchTemplate.getSourceBill();
        if (!templateEntityNumber.equals(billTypeKey)) {
            Map commonAndSourceFieldcol = FieldReplaceUtil.getCommonAndSourceFieldcol((String)vchTemplate.getSourceBill(), (String)billTypeKey);
            if (commonAndSourceFieldcol.containsKey(vchTemplate.getAcctOrgSet())) {
                vchTemplate.setAcctOrgSet((String)commonAndSourceFieldcol.get(vchTemplate.getAcctOrgSet()));
            }
            if (vchTemplate.getFilterSet() != null) {
                VchTplExpression filterSet = FieldReplaceUtil.replaceFilterSet((VchTplExpression)vchTemplate.getFilterSet(), (Map)commonAndSourceFieldcol);
                vchTemplate.setFilterSet(filterSet);
            }
        }
        this.bizOrgField = vchTemplate.getAcctOrgSet();
        this.filterExpress = vchTemplate.getFilterSet();
        this.eventClassId = vchTemplate.getEventClassId();
        this.matchSourcebillid = new HashSet<Long>(billids);
        this.vchDateBox = vchTemplate.getVchDateSet2();
        this.accountTableId = vchTemplate.getAcctTableId();
    }

    public VCHTemplate getVchTemplate() {
        return this.vchTemplate;
    }

    public void setVchTemplate(VCHTemplate vchTemplate) {
        this.vchTemplate = vchTemplate;
    }

    public Long getTemId() {
        return this.temId;
    }

    public void setTemId(Long temId) {
        this.temId = temId;
    }

    public String getBizOrgField() {
        return this.bizOrgField;
    }

    public void setBizOrgField(String bizOrgField) {
        this.bizOrgField = bizOrgField;
    }

    public VchTplExpression getFilterExpress() {
        return this.filterExpress;
    }

    public void setFilterExpress(VchTplExpression filterExpress) {
        this.filterExpress = filterExpress;
    }

    public Set<Long> getBookTypeIds() {
        return this.bookTypeIds;
    }

    public void setBookTypeIds(Set<Long> bookTypeIds) {
        this.bookTypeIds = bookTypeIds;
    }

    public Long getEventClassId() {
        return this.eventClassId;
    }

    public void setEventClassId(Long eventClassId) {
        this.eventClassId = eventClassId;
    }

    public Set<Long> getMatchSourcebillid() {
        return this.matchSourcebillid;
    }

    public void setMatchSourcebillid(Set<Long> matchSourcebillid) {
        this.matchSourcebillid = matchSourcebillid;
    }

    public VchExpireDate getVchDateBox() {
        return this.vchDateBox;
    }

    public void setVchDateBox(VchExpireDate vchDateBox) {
        this.vchDateBox = vchDateBox;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }
}

