/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BatchFuncParser;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.AcctBook;
import kd.fi.ai.BuildSchemaErrorCode;
import kd.fi.ai.SingleSplitAcctBook;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.dap.DapWriteAndBlackOpSetUtil;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.context.SingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.VchExpireDateGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.reporter.BuildVchReporter;
import kd.fi.ai.mservice.service.helper.VchTemplateMainData;
import kd.fi.ai.operation.VchDateComplier;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.FieldReplaceUtil;
import kd.fi.ai.util.PeriodUtil;

public class AutoBuildVchSchemeHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildVchScheme buildScheme(Deque<DynamicObject> templates, String entityNumber, AcctBook acctBook, Set<Long> billids, boolean multiDap, boolean ignoreTemplateUnique, String mergeCode, String cacheKeyId, Long eventClass, String previewpageid, String buildType, String reoper, String buildVoucherType, boolean isBizGenGlVch, boolean ignorebillstatus) {
        BuildVchScheme scheme = new BuildVchScheme();
        scheme.setTransId(UUID.randomUUID().toString());
        scheme.setBatchCacheId(cacheKeyId);
        scheme.setIgnorebillstatus(ignorebillstatus);
        HashMap<Long, DynamicObject> periodCache = new HashMap<Long, DynamicObject>();
        HashSet<String> tempCache = new HashSet<String>(templates.size());
        Date now = VchExpireDate.getNowByUserTimeZone();
        ArrayList<BuildSchemaErrorCode> templateValiError = new ArrayList<BuildSchemaErrorCode>(templates.size());
        for (DynamicObject template : templates) {
            String acctOrg;
            Map commonAndSourceFieldcol;
            String msg;
            VCHTemplate vchTemplate;
            Long temId = template.getLong("id");
            ArrayList<Long> billIds = new ArrayList<Long>(billids);
            BuildSchemaErrorCode bsErrorCode = new BuildSchemaErrorCode(temId, billIds);
            templateValiError.add(bsErrorCode);
            String toJson = template.getString("fxml");
            if (StringUtils.isBlank((CharSequence)toJson)) {
                String msg2 = ResManager.loadKDString((String)"\u6a21\u677fFXML\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6a21\u677f\u5f02\u5e38\u3002", (String)"AutoBuildVchSchemeHelper_11", (String)"fi-ai-mservice", (Object[])new Object[0]);
                bsErrorCode.setTemplateErrorMessage(msg2);
                continue;
            }
            try {
                vchTemplate = DapCache.getTemplate((Long)temId, (String)toJson);
            }
            catch (Exception e) {
                msg = ResManager.loadKDString((String)"\u6a21\u677f\u53cd\u5e8f\u5217\u5316\u51fa\u9519\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u5efa\u6a21\u677f\u3002", (String)"AutoBuildVchSchemeHelper_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
                bsErrorCode.setTemplateErrorMessage(msg);
                continue;
            }
            if (!vchTemplate.getSourceBill().equals(entityNumber) && (commonAndSourceFieldcol = FieldReplaceUtil.getCommonAndSourceFieldcol((String)vchTemplate.getSourceBill(), (String)entityNumber)).containsKey(acctOrg = vchTemplate.getAcctOrgSet())) {
                vchTemplate.setAcctOrgSet((String)commonAndSourceFieldcol.get(acctOrg));
            }
            if (!acctBook.getBizOrgField().equalsIgnoreCase(vchTemplate.getAcctOrgSet())) {
                String msg3 = null;
                bsErrorCode.setTemplateErrorMessage(msg3);
                continue;
            }
            VchExpireDate vchDateBox = vchTemplate.getVchDateSet2();
            if (vchDateBox == null) {
                msg = ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u8bbe\u7f6e\u7684\u51ed\u8bc1\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u3002", (String)"AutoBuildVchSchemeHelper_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
                bsErrorCode.setTemplateErrorMessage(msg);
                continue;
            }
            String vchDateSet = "";
            if (StringUtils.isNotBlank((Object)vchDateBox)) {
                vchDateSet = vchDateBox.getExp();
            }
            SingleTaskContext taskContext = new SingleTaskContext();
            if (eventClass == 0L) {
                taskContext.setSrcEntityType(EntityMetadataCache.getDataEntityType((String)entityNumber));
            } else {
                taskContext.setSrcEntityType(AiEventMetaUtil.getEntityType((Object)eventClass));
            }
            taskContext.setBuildVchContext(new BuildVchContext());
            taskContext.setBookInfo(new AcctBookInfo());
            VchDateComplier vchDateComplier = new VchDateComplier(taskContext, vchDateBox);
            DynamicObjectCollection bookFromAccSyss = AutoBuildVchSchemeHelper.loadBook(acctBook, vchTemplate);
            if (bookFromAccSyss == null || bookFromAccSyss.isEmpty()) {
                String msg4 = ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u672a\u8bbe\u7f6e\u6838\u7b97\u4f53\u7cfb\u6216\u4f1a\u8ba1\u8d26\u7c3f\u672a\u8bbe\u7f6e\u3002", (String)"AutoBuildVchSchemeHelper_3", (String)"fi-ai-mservice", (Object[])new Object[0]);
                bsErrorCode.setTemplateErrorMessage(msg4);
                continue;
            }
            for (DynamicObject bookFromAccSys : bookFromAccSyss) {
                Long bookid = bookFromAccSys.getLong("id");
                long acctOrgAccountTableID = bookFromAccSys.getLong("accounttable.id");
                String tempCacheKey = vchDateSet + bookFromAccSys.getString("bookstypeid");
                if (tempCache.contains(tempCacheKey)) {
                    for (SelectedAcctBook book : scheme.getSelectedBooks()) {
                        if (book.getBookId() != bookFromAccSys.getLong("id")) continue;
                        ((SelectedSourceBill)book.getSelectedSourceBills().get(0)).getTemplateIds().add(template.getLong("id"));
                    }
                    continue;
                }
                tempCache.add(tempCacheKey);
                long periodTypeID = bookFromAccSys.getLong("periodtype.id");
                Long[] ids = billids.toArray(new Long[billids.size()]);
                HashSet<Long> idbatch = new HashSet<Long>(ids.length);
                Date lastDate = null;
                Date begindate = bookFromAccSys.getDate("begindate");
                taskContext.getBookInfo().setCurrentPeriodBeginDate(begindate);
                lastDate = bookFromAccSys.getDate("enddate");
                taskContext.getBookInfo().setCurrentPeriodEndDate(lastDate);
                for (int i = 1; i < ids.length + 1; ++i) {
                    idbatch.add(ids[i - 1]);
                    if (i % 500 != 0 && i != ids.length) continue;
                    HashSet errids = new HashSet(idbatch);
                    DapWriteAndBlackOpSetUtil.preCheckBillidsToReoper(idbatch, (String)reoper, (String)entityNumber, (Long)bookFromAccSys.getLong("bookstypeid"), (Long)bookFromAccSys.getLong("orgid"));
                    errids.removeAll(idbatch);
                    String opermsg = ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5355\u636e\u5728\u5168\u90e8\u64cd\u4f5c\u4e0b\u5747\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"AutoBuildVchSchemeHelper_17", (String)"fi-ai-mservice", (Object[])new Object[0]);
                    errids.stream().forEach(v -> bsErrorCode.getBillErrorMessage().put(v, opermsg));
                    String selector = null;
                    selector = eventClass == 0L ? kd.fi.ai.util.DapBuildVoucherCommonUtil.getBillNoFormBill((String)entityNumber) : "number billno";
                    selector = selector + "," + vchDateComplier.getSelectedSourceEntity().getSelectString();
                    DynamicObjectCollection bills = null;
                    bills = eventClass == 0L ? QueryServiceHelper.query((String)entityNumber, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", idbatch)}) : DataSourceFactory.getDataSource().getEventObjectCollection((Object)eventClass, idbatch, selector);
                    vchDateComplier.buildSourceRowPropsDictory(bills.getDynamicObjectType());
                    Map<String, DynamicProperty> fldProperties = vchDateComplier.getSelectedSourceEntity().getFldProperties();
                    for (DynamicObject bill : bills) {
                        VchExpireDateGetHandle vchDateGetHandle = vchDateComplier.getDateGetHandler();
                        List<Object> vchDateModes = vchDateGetHandle.getConditionModes();
                        for (Object object : vchDateModes) {
                            IGetValueMode gm = (IGetValueMode)object;
                            if (gm instanceof ConditionMode) {
                                ((FormulaMode)gm).matchBatchFunction(fldProperties, bill);
                                continue;
                            }
                            if (!(gm instanceof FormulaMode)) continue;
                            ((FormulaMode)gm).matchBatchFunction(fldProperties, bill);
                        }
                    }
                    AutoBuildVchSchemeHelper.batchCallFunction(taskContext);
                    try {
                        ThreadCache.put((Object)"batchFunctionAvailable", (Object)"batchFunctionAvailable");
                        for (DynamicObject billObj : bills) {
                            Object bookDate = null;
                            Long billid = billObj.getLong("id");
                            if (vchDateBox.ifFix() && vchDateBox.getConstDate() != null && StringUtils.isEmpty((CharSequence)vchDateBox.getExp())) {
                                bookDate = vchDateBox.getConstDate();
                            } else if ("newdate".equalsIgnoreCase(vchDateSet)) {
                                bookDate = now;
                            } else if ("lastdate".equalsIgnoreCase(vchDateSet)) {
                                bookDate = lastDate;
                            } else {
                                bookDate = vchDateComplier.getDateGetHandler().GetVchFldValue((Map)fldProperties, billObj, (DynamicObject)null);
                                if (null == bookDate) {
                                    if (StringUtils.isEmpty((CharSequence)previewpageid)) {
                                        String msg5 = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u201c%s\u201d[\u8bb0\u8d26\u65e5\u671f]\u914d\u7f6e\u53ca\u5bf9\u5e94\u5355\u636e\u6570\u636e\u3002", (String)"AutoBuildVchSchemeHelper_5", (String)"fi-ai-mservice", (Object[])new Object[0]), template.getString("name"));
                                        bsErrorCode.getBillErrorMessage().put(billid, msg5);
                                        continue;
                                    }
                                    bookDate = new Date();
                                }
                            }
                            boolean existBook = false;
                            for (SelectedAcctBook book : scheme.getSelectedBooks()) {
                                DynamicObject period;
                                if (book.getBookId() != bookFromAccSys.getLong("id") || ((Date)bookDate).compareTo((period = (DynamicObject)periodCache.get(book.getPeriodId())).getDate("begindate")) < 0 || ((Date)bookDate).compareTo(period.getDate("enddate")) > 0) continue;
                                ((SelectedSourceBill)book.getSelectedSourceBills().get(0)).getBillIds().add(billObj.getLong("id"));
                                Deque templateIds = ((SelectedSourceBill)book.getSelectedSourceBills().get(0)).getTemplateIds();
                                if (!templateIds.contains(template.getLong("id"))) {
                                    templateIds.add(template.getLong("id"));
                                }
                                existBook = true;
                                break;
                            }
                            if (existBook) continue;
                            DynamicObject dynamicObject = PeriodUtil.getPeriodByDate((Date)bookDate, (long)periodTypeID, (Long)bookFromAccSys.getLong("curperiod.id"));
                            if (null == dynamicObject) {
                                String msg6 = String.format(ResManager.loadKDString((String)"\u6839\u636e\u65e5\u671f\u201c%s\u201d\u83b7\u53d6\u5bf9\u5e94\u671f\u95f4\u7c7b\u578b\u7684\u4f1a\u8ba1\u671f\u95f4\u51fa\u9519\u3002", (String)"AutoBuildVchSchemeHelper_8", (String)"fi-ai-mservice", (Object[])new Object[0]), bookDate);
                                bsErrorCode.getBillErrorMessage().put(billid, msg6);
                                continue;
                            }
                            periodCache.put(dynamicObject.getLong("id"), dynamicObject);
                            SelectedAcctBook sAcctBook = new SelectedAcctBook();
                            sAcctBook.setBizOrgId(acctBook.getBizOrgID());
                            sAcctBook.setBookId(bookFromAccSys.getLong("id"));
                            sAcctBook.setPeriodId(dynamicObject.getLong("id"));
                            sAcctBook.setCoverGLVoucher(false);
                            sAcctBook.setBuildVoucherType(BuildVoucherType.BizAndGLVoucher);
                            if (isBizGenGlVch) {
                                sAcctBook.setBuildVoucherType(BuildVoucherType.OnlyGLVoucher);
                            }
                            if ("1".equals(buildVoucherType)) {
                                sAcctBook.setBuildVoucherType(BuildVoucherType.OnlyBizVoucher);
                            } else if (!"2".equals(buildVoucherType) && "4".equals(buildVoucherType)) {
                                sAcctBook.setBuildVoucherType(BuildVoucherType.preVoucher);
                            }
                            if (0 == sAcctBook.getBuildVoucherType().getValue() && kd.fi.ai.util.DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam((Long)acctBook.getBizOrgID()).booleanValue()) {
                                sAcctBook.setBuildVoucherType(BuildVoucherType.BillToBizAndGLVoucher);
                            }
                            SelectedSourceBill sourceBill = new SelectedSourceBill();
                            sourceBill.setEntityNumber(entityNumber);
                            sourceBill.getBillIds().add(billid);
                            sourceBill.setUnionType(GLVoucherUnionType.Single);
                            sourceBill.setUnionFields(null);
                            sourceBill.setMultiDap(multiDap);
                            sourceBill.setIgnoreTemplateUnique(ignoreTemplateUnique);
                            sourceBill.setMergeCode(mergeCode);
                            sourceBill.getTemplateIds().add(template.getLong("id"));
                            sAcctBook.getSelectedSourceBills().add(sourceBill);
                            scheme.getSelectedBooks().add(sAcctBook);
                        }
                    }
                    finally {
                        ThreadCache.remove((Object)"batchFunctionAvailable");
                    }
                    idbatch.clear();
                }
                String msg7 = ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u4e0b\u7684\u6240\u6709\u6a21\u677f\u6784\u9020\u65b9\u6848\u5747\u5931\u8d25\u3002", (String)"AutoBuildVchSchemeHelper_14", (String)"fi-ai-mservice", (Object[])new Object[0]);
                if (ids.length != bsErrorCode.getBillErrorMessage().size()) continue;
                bsErrorCode.getBookErrorMessage().put(bookid, msg7);
            }
            if (bookFromAccSyss.size() != bsErrorCode.getBookErrorMessage().size()) continue;
            bsErrorCode.setBuildStatus(Boolean.valueOf(false));
        }
        List notfails = templateValiError.stream().filter(v -> v.getBuildStatus()).collect(Collectors.toList());
        if (notfails.isEmpty()) {
            Boolean ec = eventClass != 0L;
            AutoBuildVchSchemeHelper.buildErrorReport(templateValiError, entityNumber, ec, buildType, buildVoucherType);
            return null;
        }
        if (scheme.getSelectedBooks().size() == 0) {
            return null;
        }
        return scheme;
    }

    private static void buildErrorReport(List<BuildSchemaErrorCode> templateValiError, String billtype, Boolean eventClass, String buildType, String buildVoucherType) {
        if (templateValiError.isEmpty()) {
            return;
        }
        BuildVchReporter reporter = new BuildVchReporter();
        SourceBillInfo billInfo = new SourceBillInfo();
        billInfo.setEntityNumber(billtype);
        List sids = templateValiError.get(0).getBillIds();
        String billno = eventClass != false ? "number" : kd.fi.ai.util.DapBuildVoucherCommonUtil.getBillNoFormBill((String)billtype);
        String selectcol = "id," + billno;
        HashMap<Object, String> idAndNo = new HashMap<Object, String>(sids.size());
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)billtype, (String)selectcol, (QFilter[])new QFilter("id", "in", (Object)sids).toArray(), null);){
            for (Row row : queryDataSet) {
                Object id = row.get("id");
                String no = row.getString(billno);
                idAndNo.put(id, no);
            }
        }
        for (BuildSchemaErrorCode tve : templateValiError) {
            List billIds = tve.getBillIds();
            Long templateid = tve.getTemplateid();
            String msg = tve.getTemplateErrorMessage();
            for (Long billid : billIds) {
                Map bookErrorMessage;
                if (msg == null) {
                    String string = msg = tve.getBillErrorMessage().get(billid) != null ? tve.getBillErrorMessage().get(billid).toString() : msg;
                }
                if (msg == null && !(bookErrorMessage = tve.getBookErrorMessage()).isEmpty()) {
                    List messagecol = bookErrorMessage.entrySet().stream().map(v -> v.getValue() != null ? v.getValue().toString() : "").collect(Collectors.toList());
                    msg = String.join((CharSequence)";", messagecol);
                }
                if (msg == null) continue;
                reporter.AddErrorReport(null, billInfo, billid, (String)idAndNo.get(billid), String.valueOf(templateid), VoucherCheckItem.Bill, VoucherErrLevel.Error, msg, buildType, buildVoucherType);
            }
        }
        reporter.SaveReoprt("gl");
    }

    private static void throwException(int templateDateInValid, String expMsg) throws Exception {
        if (templateDateInValid > 0) {
            throw new Exception(ResManager.loadKDString((String)"\u83b7\u53d6\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f[\u8bb0\u8d26\u65e5\u671f]\u914d\u7f6e\u53ca\u5bf9\u5e94\u5355\u636e\u6570\u636e\u3002", (String)"AutoBuildVchSchemeHelper_10", (String)"fi-ai-mservice", (Object[])new Object[0]));
        }
        throw new Exception(expMsg);
    }

    private static DynamicObjectCollection loadBook(AcctBook book, VCHTemplate vchTemplate) {
        List<Long> orgIds = Collections.singletonList(book.getAcctOrgID());
        List bookTypeList = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter bookTypeFilter = null;
        if (bookTypeList != null) {
            bookTypeFilter = new QFilter("bookstype", "in", (Object)bookTypeList);
        }
        if (book.getBookID() != 0L) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "=", (Object)book.getBookID()));
            if (bookTypeFilter != null) {
                qFilters.add(bookTypeFilter);
            }
            DynamicObjectCollection bookFromAccSys = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,number,org.id orgid,periodtype.id,curperiod.id,accounttable.id,bookstype.id bookstypeid,curperiod.enddate enddate,curperiod.begindate begindate", (QFilter[])qFilters.toArray(new QFilter[0]));
            return bookFromAccSys;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)book.getAcctOrgID()));
        if (!vchTemplate.getBookTypeIds().isEmpty()) {
            qFilters.add(new QFilter("bookstype", "in", (Object)vchTemplate.getBookTypeIds()));
        }
        if (bookTypeFilter != null) {
            qFilters.add(bookTypeFilter);
        }
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection bookFromAccSys = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,number,org.id orgid,periodtype.id,curperiod.id,accounttable.id,bookstype.id bookstypeid,curperiod.enddate enddate,curperiod.begindate begindate", (QFilter[])qFilters.toArray(new QFilter[0]));
        return bookFromAccSys;
    }

    private static void buildErrorReport(BuildSchemaErrorCode templateValiError, String billtype, Boolean eventClass, String buildType, String buildVoucherType) {
        BuildVchReporter reporter = new BuildVchReporter();
        SourceBillInfo billInfo = new SourceBillInfo();
        billInfo.setEntityNumber(billtype);
        List sids = templateValiError.getBillIds();
        String billno = eventClass != false ? "number" : kd.fi.ai.util.DapBuildVoucherCommonUtil.getBillNoFormBill((String)billtype);
        String selectcol = "id," + billno;
        HashMap<Object, String> idAndNo = new HashMap<Object, String>(sids.size());
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)billtype, (String)selectcol, (QFilter[])new QFilter("id", "in", (Object)sids).toArray(), null);
        Object object = null;
        try {
            for (Row row : queryDataSet) {
                Object id = row.get("id");
                String no = row.getString(billno);
                idAndNo.put(id, no);
            }
        }
        catch (Throwable iterator) {
            object = iterator;
            throw iterator;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable iterator) {
                        ((Throwable)object).addSuppressed(iterator);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        Long templateid = templateValiError.getTemplateid();
        for (Long billid : sids) {
            Map bookErrorMessage;
            String msg = templateValiError.getTemplateErrorMessage();
            if (msg == null) {
                String string = msg = templateValiError.getBillErrorMessage().get(billid) != null ? templateValiError.getBillErrorMessage().get(billid).toString() : msg;
            }
            if (msg == null && !(bookErrorMessage = templateValiError.getBookErrorMessage()).isEmpty()) {
                List messagecol = bookErrorMessage.entrySet().stream().map(v -> v.getValue() != null ? v.getValue().toString() : "").collect(Collectors.toList());
                msg = String.join((CharSequence)";", messagecol);
            }
            if (msg == null) continue;
            reporter.AddErrorReport(null, billInfo, billid, (String)idAndNo.get(billid), String.valueOf(templateid), VoucherCheckItem.Bill, VoucherErrLevel.Error, msg, buildType, buildVoucherType);
        }
        reporter.SaveReoprt("gl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildVchScheme buildScheme(VCHTemplate vchTemplate, String billtype, SingleSplitAcctBook acctBook, Set<Long> billids, boolean multiDap, boolean ignoreTemplateUnique, String mergeCode, Long eventClass, String previewpageid, String buildType, String reoper, String buildVoucherType, boolean isBizGenGlVch, VchTemplateMainData vchtemplateDataCache) {
        BuildVchScheme scheme = new BuildVchScheme();
        scheme.setTransId(UUID.randomUUID().toString());
        HashMap<Long, DynamicObject> periodCache = new HashMap<Long, DynamicObject>();
        Date now = VchExpireDate.getNowByUserTimeZone();
        Boolean ec = eventClass != 0L;
        Long temId = Long.parseLong(vchTemplate.getId());
        BuildSchemaErrorCode bsErrorCode = new BuildSchemaErrorCode(temId, new ArrayList<Long>(billids));
        VchExpireDate vchDateBox = vchtemplateDataCache.getVchDateBox();
        if (vchDateBox == null) {
            String msg = ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u8bbe\u7f6e\u7684\u51ed\u8bc1\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u3002", (String)"AutoBuildVchSchemeHelper_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
            bsErrorCode.setTemplateErrorMessage(msg);
            AutoBuildVchSchemeHelper.buildErrorReport(bsErrorCode, billtype, ec, buildType, buildVoucherType);
            return null;
        }
        String vchDateSet = "";
        if (StringUtils.isNotBlank((Object)vchDateBox)) {
            vchDateSet = vchDateBox.getExp();
        }
        SingleTaskContext taskContext = new SingleTaskContext();
        if (eventClass == 0L) {
            taskContext.setSrcEntityType(EntityMetadataCache.getDataEntityType((String)billtype));
        } else {
            taskContext.setSrcEntityType(AiEventMetaUtil.getEntityType((Object)eventClass));
        }
        taskContext.setBuildVchContext(new BuildVchContext());
        taskContext.setBookInfo(new AcctBookInfo());
        VchDateComplier vchDateComplier = new VchDateComplier(taskContext, vchDateBox);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)acctBook.getBookID()));
        qFilters.add(new QFilter("bookstype", "=", (Object)acctBook.getBookTypeID()));
        DynamicObject bookData = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,number,periodtype.id,org.id orgid,curperiod.id,accounttable.id,bookstype.id bookstypeid,curperiod.enddate enddate,curperiod.begindate begindate", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (bookData == null) {
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u672a\u8bbe\u7f6e\u6838\u7b97\u4f53\u7cfb\u3002", (String)"AutoBuildVchSchemeHelper_18", (String)"fi-ai-mservice", (Object[])new Object[0]);
            bsErrorCode.setTemplateErrorMessage(msg);
            AutoBuildVchSchemeHelper.buildErrorReport(bsErrorCode, billtype, ec, buildType, buildVoucherType);
            return null;
        }
        long periodTypeID = bookData.getLong("periodtype.id");
        Date lastDate = null;
        Date begindate = bookData.getDate("begindate");
        taskContext.getBookInfo().setCurrentPeriodBeginDate(begindate);
        lastDate = bookData.getDate("enddate");
        taskContext.getBookInfo().setCurrentPeriodEndDate(lastDate);
        String billno = eventClass != 0L ? "number billno" : kd.fi.ai.util.DapBuildVoucherCommonUtil.getBillNoFormBill((String)billtype);
        String selector = billno + "," + vchDateComplier.getSelectedSourceEntity().getSelectString();
        List splitbatch = DapBuildVoucherCommonUtil.splitbatch(new ArrayList<Long>(billids), (int)500);
        for (List midids : splitbatch) {
            HashSet errids = new HashSet(midids);
            HashSet ids = new HashSet(midids);
            DapWriteAndBlackOpSetUtil.preCheckBillidsToReoper(ids, (String)reoper, (String)billtype, (Long)bookData.getLong("bookstypeid"), (Long)bookData.getLong("orgid"));
            errids.removeAll(ids);
            String opermsg = ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5355\u636e\u5728\u5168\u90e8\u64cd\u4f5c\u4e0b\u5747\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"AutoBuildVchSchemeHelper_17", (String)"fi-ai-mservice", (Object[])new Object[0]);
            errids.stream().forEach(v -> bsErrorCode.getBillErrorMessage().put(v, opermsg));
            DynamicObjectCollection bills = null;
            bills = eventClass == 0L ? QueryServiceHelper.query((String)billtype, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}) : DataSourceFactory.getDataSource().getEventObjectCollection((Object)eventClass, ids, selector);
            vchDateComplier.buildSourceRowPropsDictory(bills.getDynamicObjectType());
            Map<String, DynamicProperty> fldProperties = vchDateComplier.getSelectedSourceEntity().getFldProperties();
            for (DynamicObject bill : bills) {
                VchExpireDateGetHandle vchDateGetHandle = vchDateComplier.getDateGetHandler();
                List<Object> vchDateModes = vchDateGetHandle.getConditionModes();
                for (Object object : vchDateModes) {
                    IGetValueMode gm = (IGetValueMode)object;
                    if (gm instanceof ConditionMode) {
                        ((FormulaMode)gm).matchBatchFunction(fldProperties, bill);
                        continue;
                    }
                    if (!(gm instanceof FormulaMode)) continue;
                    ((FormulaMode)gm).matchBatchFunction(fldProperties, bill);
                }
            }
            AutoBuildVchSchemeHelper.batchCallFunction(taskContext);
            try {
                ThreadCache.put((Object)"batchFunctionAvailable", (Object)"batchFunctionAvailable");
                for (DynamicObject bill : bills) {
                    Object bookDate = null;
                    Long billid = bill.getLong("id");
                    bookDate = vchDateComplier.getDateGetHandler().GetVchFldValue((Map)fldProperties, bill, (DynamicObject)null);
                    if (null == bookDate) {
                        if (StringUtils.isEmpty((CharSequence)previewpageid)) {
                            String msg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u201c%s\u201d[\u8bb0\u8d26\u65e5\u671f]\u914d\u7f6e\u53ca\u5bf9\u5e94\u5355\u636e\u6570\u636e\u3002", (String)"AutoBuildVchSchemeHelper_5", (String)"fi-ai-mservice", (Object[])new Object[0]), vchTemplate.getName());
                            bsErrorCode.getBillErrorMessage().put(billid, msg);
                            continue;
                        }
                        bookDate = new Date();
                    }
                    boolean existBook = false;
                    for (SelectedAcctBook book : scheme.getSelectedBooks()) {
                        DynamicObject period;
                        if (book.getBookId() != bookData.getLong("id") || ((Date)bookDate).compareTo((period = (DynamicObject)periodCache.get(book.getPeriodId())).getDate("begindate")) < 0 || ((Date)bookDate).compareTo(period.getDate("enddate")) > 0) continue;
                        ((SelectedSourceBill)book.getSelectedSourceBills().get(0)).getBillIds().add(bill.getLong("id"));
                        Deque templateIds = ((SelectedSourceBill)book.getSelectedSourceBills().get(0)).getTemplateIds();
                        if (!templateIds.contains(temId)) {
                            templateIds.add(temId);
                        }
                        existBook = true;
                        break;
                    }
                    if (existBook) continue;
                    DynamicObject dynamicObject = PeriodUtil.getPeriodByDate((Date)bookDate, (long)periodTypeID, (Long)bookData.getLong("curperiod.id"));
                    if (null == dynamicObject) {
                        String msg = String.format(ResManager.loadKDString((String)"\u6839\u636e\u65e5\u671f\u201c%s\u201d\u83b7\u53d6\u5bf9\u5e94\u671f\u95f4\u7c7b\u578b\u7684\u4f1a\u8ba1\u671f\u95f4\u51fa\u9519\u3002", (String)"AutoBuildVchSchemeHelper_8", (String)"fi-ai-mservice", (Object[])new Object[0]), bookDate);
                        bsErrorCode.getBillErrorMessage().put(billid, msg);
                        continue;
                    }
                    periodCache.put(dynamicObject.getLong("id"), dynamicObject);
                    SelectedAcctBook sAcctBook = new SelectedAcctBook();
                    sAcctBook.setBizOrgId(acctBook.getBizOrgID());
                    sAcctBook.setBookId(bookData.getLong("id"));
                    sAcctBook.setPeriodId(dynamicObject.getLong("id"));
                    sAcctBook.setCoverGLVoucher(false);
                    sAcctBook.setBuildVoucherType(BuildVoucherType.BizAndGLVoucher);
                    if (isBizGenGlVch) {
                        sAcctBook.setBuildVoucherType(BuildVoucherType.OnlyGLVoucher);
                    }
                    if ("1".equals(buildVoucherType)) {
                        sAcctBook.setBuildVoucherType(BuildVoucherType.OnlyBizVoucher);
                    } else if (!"2".equals(buildVoucherType) && "4".equals(buildVoucherType)) {
                        sAcctBook.setBuildVoucherType(BuildVoucherType.preVoucher);
                    }
                    if (0 == sAcctBook.getBuildVoucherType().getValue() && kd.fi.ai.util.DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam((Long)acctBook.getBizOrgID()).booleanValue()) {
                        sAcctBook.setBuildVoucherType(BuildVoucherType.BillToBizAndGLVoucher);
                    }
                    SelectedSourceBill sourceBill = new SelectedSourceBill();
                    sourceBill.setEntityNumber(billtype);
                    sourceBill.getBillIds().add(billid);
                    sourceBill.setUnionType(GLVoucherUnionType.Single);
                    sourceBill.setUnionFields(null);
                    sourceBill.setMultiDap(multiDap);
                    sourceBill.setIgnoreTemplateUnique(ignoreTemplateUnique);
                    sourceBill.setMergeCode(mergeCode);
                    sourceBill.getTemplateIds().add(temId);
                    sourceBill.setEventClassID(eventClass.longValue());
                    sAcctBook.getSelectedSourceBills().add(sourceBill);
                    scheme.getSelectedBooks().add(sAcctBook);
                }
            }
            finally {
                ThreadCache.remove((Object)"batchFunctionAvailable");
            }
        }
        if (!bsErrorCode.getBillErrorMessage().isEmpty()) {
            AutoBuildVchSchemeHelper.buildErrorReport(bsErrorCode, billtype, ec, buildType, buildVoucherType);
        }
        if (scheme.getSelectedBooks().size() == 0) {
            return null;
        }
        return scheme;
    }

    private static void batchCallFunction(ISingleTaskContext taskContext) {
        Map batchFunValues = taskContext.getBatchFunValues();
        HashMap<String, Set> batchFunMap = new HashMap<String, Set>();
        for (Function function : batchFunValues.keySet()) {
            Set fcSet = batchFunMap.computeIfAbsent(function.getName(), key -> new HashSet());
            fcSet.add(function);
        }
        for (Map.Entry entry : batchFunMap.entrySet()) {
            IBatchFunctionHandler handler = Function.getBatchFunctionHandler((String)((String)entry.getKey()));
            Map vals = handler.execute((Set)entry.getValue());
            if (vals == null) continue;
            batchFunValues.putAll(vals);
        }
        Map bosBatchFunValues = taskContext.getBosBatchFunValues();
        BatchFuncParser batchFuncParser = new BatchFuncParser();
        Map batchRunResult = batchFuncParser.batchCall(bosBatchFunValues.keySet(), (ExpressionContext)new CRExpressionContext(null, null, null), taskContext.getFuncLib());
        bosBatchFunValues.putAll(batchRunResult);
    }
}

