/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.job;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.constant.enums.event.EventReverseStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventStageEnum;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.event.EventGenerateParam;
import kd.fi.v2.fah.event.FahEvtTaskParam;
import kd.fi.v2.fah.event.mservice.service.BuildEventBizDataServiceImpl3;
import kd.fi.v2.fah.event.mservice.service.BuildEvtDataServiceImpl3;
import kd.fi.v2.fah.event.mservice.service.BuildXLADataServiceImpl;
import kd.fi.v2.fah.event.mservice.service.MatchEventRuleServiceImpl2;
import kd.fi.v2.fah.event.mservice.service.VoucherGroupMergePushService;
import kd.fi.v2.fah.job.FahJobContext;
import kd.fi.v2.fah.job.IFahJobContext;
import kd.fi.v2.fah.log.FahBgTaskLogger;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.util.BuildEvtDataUtil;
import kd.fi.v2.fah.util.EventGenTaskUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class JobManagerCenter3 {
    private static final Log logger = LogFactory.getLog(JobManagerCenter3.class);
    private final int sqlExecuteBatchSize;
    private final int createBizDataSyncMaxSize;
    private final Map<String, Object> params;
    private int totalBillCnt;
    private final long requestId;
    private final AtomicInteger taskBatchSeq = new AtomicInteger();
    private final boolean fisPreview;
    private final FahEventGenOprEnum eventGenOprEnum;
    private final boolean toGL;
    private final boolean onlyToGL;
    private final boolean createEvt;
    private final boolean createTmpEvt;
    private final FahJobContext fahJobContext;
    private static final String EVENT_STATUS = "event_status";
    private final Map<String, Set<Long>> lockedBillsMap = new HashMap<String, Set<Long>>(16);
    private final Map<String, Set<Long>> processingBillsMap = new HashMap<String, Set<Long>>(16);
    private final BuildEvtDataServiceImpl3 buildEvtDataServiceImpl3;

    public JobManagerCenter3(Map<String, Object> params) {
        this.sqlExecuteBatchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.sqlExecuteBatchSize", (String)"2000"));
        this.createBizDataSyncMaxSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.createBizDataSyncMaxSize", (String)"1000"));
        this.params = params;
        Map option = (Map)params.get("option");
        this.requestId = Long.parseLong(option.get("taskid").toString());
        this.fisPreview = Boolean.parseBoolean(null == option.get("fispreview") ? "false" : option.get("fispreview").toString());
        String buildEventMode = option.get("buildeventmode").toString();
        this.eventGenOprEnum = FahEventGenOprEnum.byCode((String)buildEventMode);
        switch (this.eventGenOprEnum) {
            case CREATE_EVENT: {
                this.createEvt = true;
                this.createTmpEvt = false;
                this.toGL = false;
                this.onlyToGL = false;
                break;
            }
            case CREATE_EVENT_DELIVER_GL: {
                this.createEvt = true;
                this.createTmpEvt = false;
                this.toGL = true;
                this.onlyToGL = false;
                break;
            }
            case DELIVER_GL: {
                this.createEvt = false;
                this.createTmpEvt = false;
                this.toGL = true;
                this.onlyToGL = true;
                break;
            }
            case CREATE_TMP_EVENT: {
                this.createEvt = true;
                this.createTmpEvt = true;
                this.toGL = false;
                this.onlyToGL = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("not define buildEventMode: " + buildEventMode);
            }
        }
        this.fahJobContext = new FahJobContext();
        this.fahJobContext.setRequestId(Long.valueOf(this.requestId));
        AtomicInteger partitionGrpCode = new AtomicInteger();
        this.fahJobContext.setPartitionGrpCode(partitionGrpCode);
        this.fahJobContext.setFisPreview(this.fisPreview);
        this.fahJobContext.setBigEntrySizeConfig(FahOptimizeControlPanel.getBigEntrySize());
        this.fahJobContext.setFahBgTaskLogger(new FahBgTaskLogger(this.requestId, BackgroundTaskTypeEnum.Common_Create_Event));
        this.fahJobContext.getFahBgTaskLogger().createNewTask();
        this.buildEvtDataServiceImpl3 = new BuildEvtDataServiceImpl3(this.requestId, this.eventGenOprEnum);
        this.buildEvtDataServiceImpl3.setExecuteFunctions(this::buildEvtLineByTaskAndEvtHeadIds);
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_JobManagerCenter.init, requestId: %1$d, eventGenOprEnum: %2$s, toGL: %3$b, createEvent: %4$b, createTmpEvent: %5$b, params: %6$s", this.requestId, this.eventGenOprEnum.name(), this.toGL, this.createEvt, this.createTmpEvt, params));
        logger.info("buildEventData_JobManagerCenter.init, requestId: {}, toGL: {}, createEvent: {}, createTmpEvent: {}, params: {}", new Object[]{this.requestId, this.toGL, this.createEvt, this.createTmpEvt, params});
    }

    public void buildEvt(String billType, Collection<Long> billIds) {
        logger.info("buildEventData_buildEvt, billType: {}, params: {}, billIds: {}", new Object[]{billType, this.params, FahBgTaskLogger.logSizeOrDetail(billIds)});
        if (CollectionUtils.isEmpty(billIds)) {
            String noEvtMsg = ResManager.loadKDString((String)"\u672c\u6279\u6b21\u6ca1\u6709\u53ef\u521b\u5efa\u4e8b\u4ef6\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5df2\u521b\u5efa\u6700\u7ec8\u4e8b\u4ef6\u3001\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6216\u52a0\u9501\u5931\u8d25\u3002", (String)"JobManagerCenter3_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr(noEvtMsg);
            return;
        }
        if (StringUtils.isEmpty((String)billType) || CollectionUtils.isEmpty(billIds)) {
            return;
        }
        this.fahJobContext.addDetailEntry(billType, billIds.size());
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvt start, billType: %1$s, billIds: %2$s", billType, FahBgTaskLogger.logSizeOrDetail(billIds)));
        MatchEventRuleServiceImpl2 matchEventRuleService = new MatchEventRuleServiceImpl2(this.eventGenOprEnum);
        try {
            long start = System.currentTimeMillis();
            matchEventRuleService.dispatchSchemeEvtRules(billType, billIds, (IFahJobContext)this.fahJobContext, this::buildEvtDataHead);
            long end = System.currentTimeMillis();
            this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_dispatchSchemeEvtRules end, billType: %1$s, cost: %2$d ms, billIds: %3$s", billType, end - start, FahBgTaskLogger.logSizeOrDetail(billIds)));
        }
        catch (Exception e) {
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_dispatchSchemeEvtRules err: " + e.getMessage());
            logger.error("buildEventData_matchEventRule, requestId: {}", (Object)this.requestId, (Object)e);
            throw e;
        }
    }

    private void buildEvtDataHead(EventGenerateParam task) {
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtDataHead start, requestId: %1$d, BillType: %2$s, RuleId: %3$d, billIds: %4$s", this.requestId, task.getBillType(), task.getRuleId(), FahBgTaskLogger.logSizeOrDetail((Collection)task.getBillIds())));
        long start = System.currentTimeMillis();
        this.buildEvtDataServiceImpl3.buildEvtData(task, (IFahJobContext)this.fahJobContext);
        long end = System.currentTimeMillis();
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtDataHead end, requestId: %1$d, evt head & line & xla cost: %2$d ms, billIds: %3$s", this.requestId, end - start, FahBgTaskLogger.logSizeOrDetail((Collection)task.getBillIds())));
    }

    private void updateFahRequestFinal(long requestId) {
        try {
            BuildEvtDataUtil.updateFahRequestFinal((long)requestId, (int)this.totalBillCnt);
        }
        catch (Exception e) {
            logger.error("buildEventData_updateFahRequestFinal async err, requestId: {}, ", (Object)requestId, (Object)e);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_updateFahRequestFinal, err:" + e.getMessage());
        }
    }

    private void buildEvtLineByTaskAndEvtHeadIds(FahEvtTaskParam fahEvtTaskParam, List<Long> evtHeadIds) {
        logger.info("buildEventData_buildEvtLineByTaskAndEvtHeadIds start, requestId: {}, evtHeadIds.size: {}", (Object)this.requestId, (Object)evtHeadIds.size());
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtLineByTaskAndEvtHeadIds start, requestId: %1$d, evtHeadIds.size: %2$d", this.requestId, evtHeadIds.size()));
        long start = System.currentTimeMillis();
        Collection<Long> successEvtHeadIds = this.buildEvtDataServiceImpl3.buildEvtLineByRequest(evtHeadIds, this.requestId, this.fahJobContext);
        HashSet<Long> evtHeadIdsFailedSet = new HashSet<Long>(evtHeadIds);
        evtHeadIdsFailedSet.removeAll(successEvtHeadIds);
        Map evtHeadAccountMap = BuildEvtDataUtil.queryEvtHeadAccountMap(successEvtHeadIds);
        BuildEvtDataUtil.saveFailBillsByEvtIds((Long)this.requestId, (FahEvtTaskParam)fahEvtTaskParam, evtHeadIdsFailedSet, (BillDataProcessErrorCategoryEnum)BillDataProcessErrorCategoryEnum.EVT_HAS_FAILED);
        long end = System.currentTimeMillis();
        logger.info("buildEventData_buildEvtLineByTaskAndEvtHeadIds end, requestId: {}, evt line cost: {} ms, successEvtHeadIds.size: {}", new Object[]{this.requestId, end - start, successEvtHeadIds.size()});
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtLineByTaskAndEvtHeadIds end, requestId: %1$d, evt line cost: %2$d ms, successEvtHeadIds.size: %3$d", this.requestId, end - start, successEvtHeadIds.size()));
        Set<Long> accountSuccessEvtHeadIds = evtHeadAccountMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        this.createXLAData(accountSuccessEvtHeadIds, fahEvtTaskParam);
        long end2 = System.currentTimeMillis();
        logger.info("buildEventData_buildEvtLineByTaskAndEvtHeadIds end, requestId: {}, evt line & xla cost: {} ms, evtHeadIds.size: {}", new Object[]{this.requestId, end2 - start, evtHeadIds.size()});
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtLineByTaskAndEvtHeadIds end, requestId: %1$d, evt line & xla cost: %2$d ms, evtHeadIds.size: %3$d", this.requestId, end2 - start, successEvtHeadIds.size()));
    }

    private void createXLAData(Collection<Long> successEvtHeadIds, FahEvtTaskParam fahEvtTaskParam) {
        if (CollectionUtils.isEmpty(successEvtHeadIds)) {
            return;
        }
        this.buildEvtXlaByTaskAndEvtHeadIds(this.requestId, fahEvtTaskParam, successEvtHeadIds);
    }

    private void buildEvtXlaByTaskAndEvtHeadIds(Long requestId, FahEvtTaskParam fahEvtTaskParam, Collection<Long> evtHeadIds) {
        logger.info("buildEventData_buildEvtXlaByTaskAndEvtHeadIds start, requestId: {}, evtHeadIds.size: {}", (Object)requestId, (Object)evtHeadIds.size());
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtXlaByTaskAndEvtHeadIds start, requestId: %1$d, evtHeadIds.size: %2$d", requestId, evtHeadIds.size()));
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(evtHeadIds)) {
            return;
        }
        Collection<Long> successEvtHeadIds = new BuildXLADataServiceImpl(requestId, this.fisPreview, this.eventGenOprEnum).generateXLAData(evtHeadIds);
        HashSet<Long> evtHeadIdsFailedSet = new HashSet<Long>(evtHeadIds);
        evtHeadIdsFailedSet.removeAll(successEvtHeadIds);
        long end = System.currentTimeMillis();
        logger.info("buildEventData_buildEvtXlaByTaskAndEvtHeadIds end, requestId: {}, evtHeadIds.size: {}, evtHeadIdsFailedSet.size: {}, cost: {} ms", new Object[]{requestId, evtHeadIds.size(), evtHeadIdsFailedSet.size(), end - start});
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtXlaByTaskAndEvtHeadIds end, requestId: %1$d, evtHeadIds.size: %2$d,, evtHeadIdsFailedSet.size: %3$d, cost: %4$d ms", requestId, evtHeadIds.size(), evtHeadIdsFailedSet.size(), end - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildEvtBizDataByTaskWithTryCatch(Long requestId) {
        try (TXHandle h = TX.notSupported();){
            BuildEvtDataUtil.updateFahRequestTaskStatusToBizDataRunning((Long)requestId);
            this.buildEvtBizDataByTask(requestId);
            BuildEvtDataUtil.updateFahRequestTaskStatusToBizDataEnd((Long)requestId);
        }
        catch (Exception e) {
            logger.error("buildEventData_buildEvtBizDataByTask err, requestId: {}, ", (Object)requestId, (Object)e);
            String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr(String.format("buildEventData_buildEvtBizDataByTask err, %s", traceMessage));
            EventGenTaskUtils.updateFahRequestTaskWithBizDataErr((Long)requestId, (String)traceMessage);
        }
        finally {
            this.fahJobContext.setBizDataTaskUsing(false);
            this.fahJobContext.close();
        }
    }

    private void buildEvtBizDataByTask(Long requestId) {
        long start = System.currentTimeMillis();
        int totalEvtCnt = 0;
        logger.info("buildEventData_buildEvtBizDataByTask_async start, requestId: {}", (Object)requestId);
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtBizDataByTask_async start, requestId: %1$d", requestId));
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fpartitiongrpcode from t_fah_event_header a", new Object[0]);
        sqlBuilder.append("where a.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append("and a.fstatus = ?", new Object[]{"4"});
        sqlBuilder.appendIn("and a.fcreatestage", new Object[]{FahEventStageEnum.CREATING_SL.getStage(), FahEventStageEnum.CREATING_GL.getStage()});
        sqlBuilder.append(" group by a.fpartitiongrpcode order by a.fpartitiongrpcode", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"buildEvtLineByTask", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long partitionGrpCode = row.getLong("fpartitiongrpcode");
                this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEventBizDimDataByGrp start, requestId: %1$d, partitionGrpCode: %2$d", requestId, partitionGrpCode));
                int evtCnt = new BuildEventBizDataServiceImpl3(new OperationResult()).buildEventBizDimDataByGrp(requestId, partitionGrpCode);
                totalEvtCnt += evtCnt;
            }
        }
        long end = System.currentTimeMillis();
        logger.info("buildEventData_buildEvtBizDataByTask_async end, requestId: {}, cost: {} ms, totalEvtCnt: {}", new Object[]{requestId, end - start, totalEvtCnt});
        this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtBizDataByTask_async end, requestId: %1$d, cost: %2$d ms, totalEvtCnt: %3$d", requestId, end - start, totalEvtCnt));
    }

    public String buildEvtV3(String billType, Collection<Long> billIds) {
        try {
            this.fahJobContext.addDetailEntry(billType, billIds.size());
            String string = this.buildEvtV3WithTryCatch(billType, billIds);
            return string;
        }
        catch (Exception e) {
            logger.error("buildEventData_buildEvtV3 err, requestId: {}, ", (Object)this.requestId, (Object)e);
            String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            EventGenTaskUtils.updateFahRequestTask((Long)this.requestId, (String)traceMessage);
            this.writeBackBillVchStatus(this.requestId, true);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr(String.format("buildEventData_buildEvtV3 err: %s", traceMessage));
            throw e;
        }
        finally {
            BuildEvtDataUtil.releaseLock(this.lockedBillsMap);
            this.fahJobContext.addEndLog();
            this.fahJobContext.setMainTaskUsing(false);
            this.fahJobContext.close();
        }
    }

    private void writeBackBillVchStatus(long requestId, boolean isException) {
        try {
            this.fahJobContext.setWriteBackTaskUsing(true);
            BuildEvtDataUtil.writeBackBillVchStatus((long)requestId, (boolean)isException, this.processingBillsMap, (FahEventGenOprEnum)this.eventGenOprEnum, (FahJobContext)this.fahJobContext);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_updateBillEventStatus end, requestId: %1$d, writeBack: %2$b", requestId, true));
        }
        catch (Exception e) {
            logger.error("buildEventData_updateBillEventStatus err, requestId: {}, ", (Object)requestId, (Object)e);
            String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_updateBillEventStatus,err:" + traceMessage);
            this.fahJobContext.setWriteBackTaskUsing(false);
        }
    }

    public String buildEvtV3WithTryCatch(String billType, Collection<Long> billIds) {
        BuildEvtDataUtil.updateFahRequestTaskStatusToRunning((Long)this.requestId);
        Iterator<PairTuple<String, Collection<Long>>> billIdsIterator = this.getBillIdsIterator(billType, billIds);
        try {
            while (billIdsIterator.hasNext()) {
                PairTuple<String, Collection<Long>> billTypeAndBillIds = billIdsIterator.next();
                if (CollectionUtils.isEmpty((Collection)((Collection)billTypeAndBillIds.getValue()))) continue;
                this.totalBillCnt += ((Collection)billTypeAndBillIds.getValue()).size();
                this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_billIdsIterator, totalBillCnt: %1$d, billType: %2$s, billIds: %3$s", this.totalBillCnt, billTypeAndBillIds.getKey(), FahBgTaskLogger.logSizeOrDetail((Collection)((Collection)billTypeAndBillIds.getValue()))));
                if (this.onlyToGL) {
                    this.beForeOnlyToGL((String)billTypeAndBillIds.getKey(), (Collection)billTypeAndBillIds.getValue());
                    continue;
                }
                this.buildEvtV3Inner((String)billTypeAndBillIds.getKey(), (Collection)billTypeAndBillIds.getValue());
            }
        }
        catch (Exception e) {
            logger.error("buildEventData_buildEvtV3WithTryCatch, before to gl err: {}", (Object)e.getMessage());
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_buildEvtV3WithTryCatch, before to gl err:" + e.getMessage());
            throw e;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!this.fisPreview) {
                    this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_FahGenerateXLADataDao.fullCoverageFormal start, requestId: %1$d", this.requestId));
                    FahGenerateXLADataDao.fullCoverageFormal((Long)this.requestId);
                    this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_FahGenerateXLADataDao.fullCoverageFormal end, requestId: %1$d", this.requestId));
                }
            }
            catch (Exception e) {
                logger.error("buildEventData_buildEvtV3WithTryCatch, fullCoverageFormal err: {}", (Object)e.getMessage());
                this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_buildEvtV3WithTryCatch, fullCoverageFormal err:" + e.getMessage());
                throw e;
            }
        }
        if (this.toGL) {
            this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_VoucherGroupMergePushService start, requestId: %1$d", this.requestId));
            new VoucherGroupMergePushService(this.requestId, EventReverseStatusEnum.DEFAULT).doExecute();
            this.fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_VoucherGroupMergePushService end, requestId: %1$d", this.requestId));
        }
        this.writeBackBillVchStatus(this.requestId, false);
        try {
            this.fahJobContext.setBizDataTaskUsing(true);
            if (this.totalBillCnt > this.createBizDataSyncMaxSize) {
                ThreadPools.executeOnce((String)"buildEvtBizDataByTask", () -> this.buildEvtBizDataByTaskWithTryCatch(this.requestId));
            } else {
                this.buildEvtBizDataByTaskWithTryCatch(this.requestId);
            }
        }
        catch (Exception e) {
            logger.error("buildEventData_buildEvtBizDataByTask async err, requestId: {}, ", (Object)this.requestId, (Object)e);
            this.fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_buildEvtBizDataByTask_async, err:" + e.getMessage());
            this.fahJobContext.setBizDataTaskUsing(false);
        }
        this.updateFahRequestFinal(this.requestId);
        return "";
    }

    private String transStatus(String createStage, String createStatus) {
        return "1";
    }

    private void saveFahTaskBatch(String billType, Collection<Long> billIds) {
        try (TXHandle h = TX.requiresNew();){
            try {
                BuildEvtDataUtil.saveFahTaskBatch((long)this.requestId, (int)this.taskBatchSeq.getAndIncrement(), (String)billType, billIds);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void beForeOnlyToGL(String billType, Collection<Long> billIds) {
        this.doValidateBillIds(billType, billIds);
    }

    private Iterator<PairTuple<String, Collection<Long>>> getBillIdsIterator(String billType, Collection<Long> billIds) {
        return BuildEvtDataUtil.getBillIdsIterator(this.params, (String)billType, billIds);
    }

    private void buildEvtV3Inner(String billType, Collection<Long> billIds) {
        Collection<Long> validateBillIds = this.doValidateBillIds(billType, billIds);
        this.deleteTmpEvtOrFailedEvt(billType, validateBillIds);
        BuildEvtDataUtil.updateBillVchStatusProcessing((String)billType, validateBillIds);
        this.processingBillsMap.computeIfAbsent(billType, k -> new HashSet(billIds.size())).addAll(billIds);
        this.buildEvt(billType, validateBillIds);
    }

    private void deleteTmpEvtOrFailedEvt(String billType, Collection<Long> billIds) {
        if (StringUtils.isEmpty((String)billType) || CollectionUtils.isEmpty(billIds)) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                BuildEvtDataUtil.deleteTmpEvtOrFailedEvt((String)billType, billIds, (int)this.sqlExecuteBatchSize);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private Collection<Long> doValidateBillIds(String billType, Collection<Long> billIds) {
        HashMap<BillDataProcessErrorCategoryEnum, Collection> skipBillIdsMap = new HashMap<BillDataProcessErrorCategoryEnum, Collection>(4);
        PairTuple lockedAndUnlockedBillIds = BuildEvtDataUtil.lockBillIds((String)billType, billIds);
        skipBillIdsMap.computeIfAbsent(BillDataProcessErrorCategoryEnum.LOCK_FAILED, k -> new LinkedList()).addAll((Collection)lockedAndUnlockedBillIds.getValue());
        this.lockedBillsMap.computeIfAbsent(billType, k -> new HashSet(billIds.size())).addAll((Collection)lockedAndUnlockedBillIds.getKey());
        PairTuple statusPassOrNotIds = this.eventGenOprEnum == FahEventGenOprEnum.CREATE_TMP_EVENT ? new PairTuple(lockedAndUnlockedBillIds.getKey(), (Object)Collections.EMPTY_LIST) : BuildEvtDataUtil.checkBillStatus((String)billType, (Collection)((Collection)lockedAndUnlockedBillIds.getKey()));
        skipBillIdsMap.computeIfAbsent(BillDataProcessErrorCategoryEnum.BILL_STATUS_ERROR, k -> new LinkedList()).addAll((Collection)statusPassOrNotIds.getValue());
        PairTuple evtAndVchStatusBillIds = BuildEvtDataUtil.checkBillEvtAndVchStatus((String)billType, (Collection)((Collection)statusPassOrNotIds.getKey()));
        Collection resultBillIds = (Collection)evtAndVchStatusBillIds.getKey();
        skipBillIdsMap.computeIfAbsent(BillDataProcessErrorCategoryEnum.VCH_CREATED, k -> new LinkedList()).addAll((Collection)evtAndVchStatusBillIds.getValue());
        BuildEvtDataUtil.saveSkipBills((long)this.requestId, (String)billType, skipBillIdsMap);
        return resultBillIds;
    }
}

