/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.flex.FlexProperty;
import kd.fi.v2.fah.models.xla.XLAAccount;
import kd.fi.v2.fah.models.xla.XLAAccountBook;
import kd.fi.v2.fah.models.xla.XLACashFlowItem;
import kd.fi.v2.fah.services.dto.SingleGenXLADataSource;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;

public class XLADataContext
implements Serializable {
    private static final long serialVersionUID = 4048115038756818905L;
    private Map<String, Long> xlaHeadIdMap = new HashMap<String, Long>();
    private Set<Long> xlaErrorHeadIds = new HashSet<Long>();
    private Map<Long, Set<Long>> xlaHeadAndLineMap = new HashMap<Long, Set<Long>>();
    private SingleGenXLADataSource singleGenXLADataSource;
    private Map<String, Collection<XLAAccountBook>> orgAndAcctBookMap = new HashMap<String, Collection<XLAAccountBook>>();
    private Map<Long, XLAAccount> idAndAccountMap = new HashMap<Long, XLAAccount>();
    private Map<Long, XLACashFlowItem> idAndCashFlowItemMap = new HashMap<Long, XLACashFlowItem>();
    private Map<String, FlexProperty> asstAndFlexProperty = new HashMap<String, FlexProperty>();
    private Set<Long> eventErrorHeadIds = new HashSet<Long>();
    private BuildVoucherReportInfoContext reportContext;

    public XLADataContext(SingleGenXLADataSource singleGenXLADataSource, BuildVoucherReportInfoContext reportContext) {
        this.singleGenXLADataSource = singleGenXLADataSource;
        this.reportContext = reportContext;
    }

    public Map<String, Long> getXlaHeadIdMap() {
        return this.xlaHeadIdMap;
    }

    public void setXlaHeadIdMap(Map<String, Long> xlaHeadIdMap) {
        this.xlaHeadIdMap = xlaHeadIdMap;
    }

    public void putXlaHeadIdMap(String key, Long value) {
        this.xlaHeadIdMap.put(key, value);
    }

    public Map<Long, Set<Long>> getXlaHeadAndLineMap() {
        return this.xlaHeadAndLineMap;
    }

    public void setXlaHeadAndLineMap(Map<Long, Set<Long>> xlaHeadAndLineMap) {
        this.xlaHeadAndLineMap = xlaHeadAndLineMap;
    }

    public void putXlaHeadAndLineMap(Long key, Set<Long> value) {
        this.xlaHeadAndLineMap.put(key, value);
    }

    public SingleGenXLADataSource getSingleGenXLADataSource() {
        return this.singleGenXLADataSource;
    }

    public Map<String, Collection<XLAAccountBook>> getOrgAndAcctBookMap() {
        return this.orgAndAcctBookMap;
    }

    public void setOrgAndAcctBookMap(Map<String, Collection<XLAAccountBook>> orgAndAcctBookMap) {
        this.orgAndAcctBookMap = orgAndAcctBookMap;
    }

    public void putOrgAndAcctBookMap(String key, Collection<XLAAccountBook> value) {
        this.orgAndAcctBookMap.put(key, value);
    }

    public String createKey(Long eventId, Long accountPurposeId, Long acctBookId) {
        return eventId + "-" + accountPurposeId + "-" + acctBookId;
    }

    public Map<Long, Long> getBookIdAndAcctTableIdMap() {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (Collection<XLAAccountBook> acctBooks : this.orgAndAcctBookMap.values()) {
            acctBooks.stream().forEach(f -> result.put(f.getId(), f.getAccountTableId()));
        }
        return result;
    }

    public Map<Long, XLAAccount> getIdAndAccountMap() {
        return this.idAndAccountMap;
    }

    public void setIdAndAccountMap(Map<Long, XLAAccount> idAndAccountMap) {
        this.idAndAccountMap = idAndAccountMap;
    }

    public void addIdAndAccountMap(Long accountId, XLAAccount accountInfo) {
        this.idAndAccountMap.put(accountId, accountInfo);
    }

    public Map<String, FlexProperty> getAsstAndFlexProperty() {
        return this.asstAndFlexProperty;
    }

    public void setAsstAndFlexProperty(Map<String, FlexProperty> asstAndFlexProperty) {
        this.asstAndFlexProperty = asstAndFlexProperty;
    }

    public Map<Long, XLACashFlowItem> getIdAndCashFlowItemMap() {
        return this.idAndCashFlowItemMap;
    }

    public void setIdAndCashFlowItemMap(Map<Long, XLACashFlowItem> idAndCashFlowItemMap) {
        this.idAndCashFlowItemMap = idAndCashFlowItemMap;
    }

    public Set<Long> getXlaErrorHeadIds() {
        return this.xlaErrorHeadIds;
    }

    public void setXlaErrorHeadIds(Set<Long> xlaErrorHeadIds) {
        this.xlaErrorHeadIds = xlaErrorHeadIds;
    }

    public void addXlaErrorHeadIds(Long xlaErrorHeadId) {
        this.xlaErrorHeadIds.add(xlaErrorHeadId);
    }

    public Set<Long> getEventErrorHeadIds() {
        return this.eventErrorHeadIds;
    }

    public void setEventErrorHeadIds(Set<Long> eventErrorHeadIds) {
        this.eventErrorHeadIds = eventErrorHeadIds;
    }

    public BuildVoucherReportInfoContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(BuildVoucherReportInfoContext reportContext) {
        this.reportContext = reportContext;
    }
}

