/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.ai.service.IBuildVoucherService;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.FahGenerateVoucherDataDao;

public class BuildGLVoucherServiceImpl
implements IBuildVoucherService {
    private OperationResult opResult;
    private static Log logger = LogFactory.getLog(BuildGLVoucherServiceImpl.class);
    private static final String INSERT_GL_VOUCHER_SQL = "INSERT INTO t_gl_voucher(fid,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fdescription,fbizdate,fbookeddate,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fattachments,fsourcebilltype,fsourcebillid,fdebitlocamount,fcreditlocamount,floccurrency) select fid,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fdescription,fbizdate,fbookeddate,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fattachments,fsrc_billtype,fsrc_billid,floc_debitamt,floc_creditamt,floc_currencyid from t_fah_ae_headers where fid = ? and fstatus = '4'";
    private static final String INSERT_GL_VOUCHERENTRY_SQL = "INSERT INTO t_gl_voucherentry (fentryid,fid,faccountid,fcurrencyid,fmeasureunitid,fassgrpid,foriginaldebit,foriginalcredit,flocaldebit,flocalcredit,fquantity,fprice,fseq,fdescription,fmaincfitemid,fmaincfassgrpid,fsuppcfitemid,fsuppcfamount,fmaincfamount,fexpiredate,fbusinessnum,flocalexchangerate,fentrydc) select fentryid,fid,faccountid,fcurrencyid,fmeasureunitid,fassgrpid,fori_debit,fori_credit,flocal_debit,flocal_credit,fquantity,fprice,fseq,fdescription,fmaincf_itemid,fmaincf_assgrpid,fsupcf_itemid,fsupcf_amount,fmaincf_amount,fexpire_date,fbusinessnum,flocal_exchangerate,fentrydc from t_fah_ae_lines where fid = ?";
    private static final String UPDATE_HEAD_SQL = "update t_gl_voucher set fnumber= ?,fbillstatus = ?,fsourcetype = ?,fsourcesys = ?,fvdescription = ?,fmainstatus=?,fsuppstatus= ?  where fid = ?";
    private static final String UPDATE_LINE_SQL = "update t_gl_voucherentry set fisdap = ?,forgid = ?,fperiodid = ? where fid = ?";

    public BuildGLVoucherServiceImpl(OperationResult opResult) {
        this.opResult = opResult;
    }

    public boolean generateVoucher(Set<Long> eventIds) {
        Boolean result = true;
        if (eventIds.isEmpty()) {
            return result;
        }
        if (this.opResult == null) {
            this.opResult = new OperationResult();
        }
        Map xlaHeadIdAndGLVoucherNo = FahGenerateVoucherDataDao.preGenGLVoucherBillno(eventIds);
        ArrayList xlaHeadId = new ArrayList(eventIds.size());
        ArrayList xlaUpdateHead = new ArrayList(eventIds.size());
        ArrayList xlaUpdateLine = new ArrayList(eventIds.size());
        HashMap headIdAndEventIdMap = new HashMap(eventIds.size());
        FahGenerateVoucherDataDao.getXLAHeaderId(eventIds, xlaHeadId, xlaUpdateHead, xlaUpdateLine, headIdAndEventIdMap, (Map)xlaHeadIdAndGLVoucherNo);
        String errorMessage = null;
        try (TXHandle h = TX.required();){
            try {
                if (!xlaHeadId.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)INSERT_GL_VOUCHER_SQL, xlaHeadId);
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)INSERT_GL_VOUCHERENTRY_SQL, xlaHeadId);
                }
                if (!xlaUpdateHead.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)UPDATE_HEAD_SQL, xlaUpdateHead);
                }
                if (!xlaUpdateLine.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)UPDATE_LINE_SQL, xlaUpdateLine);
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.info("--BuildGLVoucherServiceImpl--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorMessage = e.getMessage();
            }
        }
        if (errorMessage != null) {
            this.opResult.setSuccess(false);
            this.opResult.setMessage(errorMessage);
            this.opResult.setShowMessage(true);
            this.opResult.getSuccessPkIds().clear();
        }
        Set ids = xlaHeadId.stream().map(m -> Long.parseLong(m[0].toString())).collect(Collectors.toSet());
        OperateOption option = OperateOption.create();
        option.setVariableValue("isdap", "true");
        option.setVariableValue("isFirstOperation", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (Object[])ids.toArray(), (OperateOption)option);
        List successPkIds = saveResult.getSuccessPkIds();
        this.opResult.setSuccessPkIds(successPkIds);
        result = saveResult.isSuccess();
        HashSet<Object> failIds = new HashSet<Object>(eventIds.size());
        HashSet<Long> eids = new HashSet<Long>(eventIds.size());
        if (!result.booleanValue()) {
            for (IOperateInfo op : saveResult.getAllErrorOrValidateInfo()) {
                Object pkValue = op.getPkValue();
                String message = op.getMessage();
                failIds.add(pkValue);
                Long eventId = (Long)headIdAndEventIdMap.get(pkValue);
                if (eids.contains(eventId)) continue;
                eids.add(eventId);
                this.opResult.setSuccess(false);
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(message);
                errorInfo.setTitle(ResManager.loadKDString((String)"\u521b\u5efa\u603b\u8d26\u51ed\u8bc1", (String)"BuildGLVoucherServiceImpl_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
                errorInfo.setPkValue((Object)eventId);
                this.opResult.addErrorInfo(errorInfo);
                this.opResult.setShowMessage(true);
            }
        }
        if (!failIds.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])failIds.toArray(), (OperateOption)BuildVoucherUtils.createDeleteVoucherOpt());
        }
        return result;
    }

    public boolean generateMergeVoucher(Set<Long> xlaIds) {
        return false;
    }
}

