/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.service.IMatchEventRuleService;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.cache.threadcache.EvtRuleThreadCache;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.dao.event.FahNoEvtBillsDao;
import kd.fi.v2.fah.datasource.QueryDataSourceFactory;
import kd.fi.v2.fah.dto.FahTaskNoEvtBillInfo;
import kd.fi.v2.fah.event.EventDispatchResult;
import kd.fi.v2.fah.event.EventGenerateParam;
import kd.fi.v2.fah.event.FahEvtTaskParam;
import kd.fi.v2.fah.job.IFahJobContext;
import kd.fi.v2.fah.models.event.dispatch.ConditionField;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchRuleData;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchScheme;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchSchemeCollection;
import kd.fi.v2.fah.models.event.dispatch.EventGenRuleGrp;
import kd.fi.v2.fah.models.event.dispatch.ValueZone;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.util.BuildEvtDataUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class MatchEventRuleServiceImpl2
implements IMatchEventRuleService {
    private static final Log logger = LogFactory.getLog(MatchEventRuleServiceImpl2.class);
    private final FahEventGenOprEnum eventGenOprEnum;
    private final int dispatchResultBatchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.dispatchResultBatchSize", (String)"999"));
    private final int maxUnMatchEvtRuleMsgCount = Integer.parseInt(SysParamConfig.get((String)"fah.evt.maxUnMatchEvtRuleMsgCount", (String)"100"));

    public MatchEventRuleServiceImpl2(FahEventGenOprEnum eventGenOprEnum) {
        this.eventGenOprEnum = eventGenOprEnum;
    }

    public void dispatchSchemeEvtRules(String billType, Collection<Long> billIds, IFahJobContext fahJobContext, Consumer<EventGenerateParam> consumer) {
        Long dispatchId;
        HashMap<Long, EventDispatchResult> resultMap = new HashMap<Long, EventDispatchResult>(8);
        PairTuple<Integer, Long> srcSysTuple = this.getSrcSystemInfo(billType);
        EventDispatchSchemeCollection eventDispatchSchemeCollection = EvtRuleThreadCache.getEvtDisSchemeCollCfgCached((String)billType);
        if (null == eventDispatchSchemeCollection || StringUtils.isEmpty((String)eventDispatchSchemeCollection.getBillOrgValueSource()) || null == eventDispatchSchemeCollection.getOrgToDispatchScheme() || CollectionUtils.isEmpty(eventDispatchSchemeCollection.getOrgToDispatchScheme().keySet())) {
            String noFoundEnableDispatchRule = ResManager.loadKDString((String)"\u5355\u636e\u672a\u914d\u7f6e\u5206\u6d41\u89c4\u5219\uff0c\u6216\u5206\u6d41\u89c4\u5219\u88ab\u7981\u7528\uff0c\u6216\u672a\u914d\u7f6e\u7ec4\u7ec7\u53d6\u503c\u5b57\u6bb5\u3002", (String)"MatchEventRuleServiceImpl_02", (String)"fi-ai-mservice", (Object[])new Object[0]);
            fahJobContext.getFahBgTaskLogger().addDetailEntryErr(noFoundEnableDispatchRule);
            HashMap<BillDataProcessErrorCategoryEnum, Collection<Long>> skipBillIdsMap = new HashMap<BillDataProcessErrorCategoryEnum, Collection<Long>>(1);
            skipBillIdsMap.put(BillDataProcessErrorCategoryEnum.UNMATCHED_DISPATCH_RULE, billIds);
            BuildEvtDataUtil.saveSkipBills((long)fahJobContext.getRequestId(), (String)billType, skipBillIdsMap);
            return;
        }
        Map<Long, Map<Long, List<Long>>> orgDispatchBillIds = this.getDispatchBillIds(eventDispatchSchemeCollection, billIds);
        PairTuple<Map<Long, Set<Long>>, Set<Long>> matchedAndUnMatchDispatchRuleBillIds = this.checkUnMatchDispatchRule(billIds, orgDispatchBillIds);
        if (((Set)matchedAndUnMatchDispatchRuleBillIds.getValue()).size() > 0) {
            logger.info("buildEventData_unMatchDispatchRuleBillIds.size:{}", (Object)((Set)matchedAndUnMatchDispatchRuleBillIds.getValue()).size());
            fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_unMatchDispatchRuleBillIds.size: %d", ((Set)matchedAndUnMatchDispatchRuleBillIds.getValue()).size()));
            HashMap skipBillIdsMap = new HashMap(1);
            skipBillIdsMap.put(BillDataProcessErrorCategoryEnum.UNMATCHED_DISPATCH_RULE, matchedAndUnMatchDispatchRuleBillIds.getValue());
            BuildEvtDataUtil.saveSkipBills((long)fahJobContext.getRequestId(), (String)billType, (Map)skipBillIdsMap);
        }
        if (((Map)matchedAndUnMatchDispatchRuleBillIds.getKey()).size() > 0) {
            for (Map.Entry dispatchGroups : ((Map)matchedAndUnMatchDispatchRuleBillIds.getKey()).entrySet()) {
                logger.info("buildEventData_DispatchRuleId: {}, matchDispatchRuleBillIds.size: {}", dispatchGroups.getKey(), (Object)((Set)dispatchGroups.getValue()).size());
                fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_DispatchRuleId: %d, matchDispatchRuleBillIds.size: %d", dispatchGroups.getKey(), ((Set)dispatchGroups.getValue()).size()));
            }
        }
        Date date = new Date();
        HashMap unMatchEvtRuleBillIdsMap = new HashMap(orgDispatchBillIds.size());
        ArrayList<FahTaskNoEvtBillInfo> noEvtBillInfoList = new ArrayList<FahTaskNoEvtBillInfo>(8);
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : orgDispatchBillIds.entrySet()) {
            dispatchId = entry.getKey();
            Map<Long, List<Long>> billIdOrgGroup = entry.getValue();
            Set allBillIds = billIdOrgGroup.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            HashMap<Long, Set> unMatchBillIds = new HashMap<Long, Set>(allBillIds.size());
            unMatchEvtRuleBillIdsMap.put(dispatchId, unMatchBillIds);
            EventDispatchScheme eventDispatchScheme = EvtRuleThreadCache.getEvtDisSchemeCfgCached((Long)dispatchId);
            for (ValueZone valueZone : eventDispatchScheme.getDefinedValueZones()) {
                DataSet dataSet = BuildEvtDataUtil.getDatasetForDispatch((String)eventDispatchScheme.getSrcBillType(), (String)valueZone.getSelector(), (String)valueZone.getOrderBy(), (String)eventDispatchScheme.getBillPkField(), allBillIds);
                Throwable throwable = null;
                try {
                    while (dataSet.hasNext()) {
                        BaseMutableArrayMapStorage eventDispatchRuleDataMap;
                        EventDispatchRuleData eventDispatchRuleData;
                        Row row = dataSet.next();
                        Long billId = row.getLong("fid");
                        String billNo = row.getString(eventDispatchScheme.getBillNoField());
                        Long billEntryId = row.getLong(valueZone.getBillEntryIdAlias());
                        Long orgId = row.getLong("forgid");
                        LinkedList<String> conditionValueList = new LinkedList<String>();
                        List conditionFields = valueZone.getOrgConditionFieldList();
                        if (CollectionUtils.isNotEmpty((Collection)conditionFields)) {
                            for (ConditionField conditionField : conditionFields) {
                                conditionValueList.add(row.getString(conditionField.getAlias()));
                            }
                        }
                        EventDispatchRuleData eventDispatchRuleData2 = eventDispatchRuleData = null == (eventDispatchRuleDataMap = (BaseMutableArrayMapStorage)valueZone.getLookupRuleMap().get(orgId)) ? null : (EventDispatchRuleData)eventDispatchRuleDataMap.get(conditionValueList);
                        if (null == eventDispatchRuleData) {
                            eventDispatchRuleDataMap = (BaseMutableArrayMapStorage)valueZone.getLookupRuleMap().get(eventDispatchScheme.getDefaultOrg());
                            EventDispatchRuleData eventDispatchRuleData3 = eventDispatchRuleData = null == eventDispatchRuleDataMap ? null : (EventDispatchRuleData)eventDispatchRuleDataMap.get(conditionValueList);
                        }
                        if (null != eventDispatchRuleData && (eventDispatchRuleData.getEffectDate().after(date) || eventDispatchRuleData.getExpireDate().before(date))) {
                            eventDispatchRuleData = null;
                        }
                        if (null == eventDispatchRuleData || "1".equals(eventDispatchRuleData.getNeedGenEvt()) && (null == eventDispatchRuleData.getEventGenRuleGrp() || CollectionUtils.isEmpty((Collection)eventDispatchRuleData.getEventGenRuleGrp().getTargetEvtGenRules()))) {
                            String unMatchConditionFieldValue = BuildEvtDataUtil.buildUnMatchConditionFieldValue((String)billType, (ValueZone)valueZone, (List)conditionFields, conditionValueList);
                            Set msgSet = unMatchBillIds.computeIfAbsent(billId, k -> new LinkedHashSet());
                            if (msgSet.size() < this.maxUnMatchEvtRuleMsgCount) {
                                msgSet.add(unMatchConditionFieldValue);
                            }
                            if (!DebugTrace.enable()) continue;
                            String dispatchUnMatchGenRule = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u914d\u7f6e\u6216\u65e5\u671f\u914d\u7f6e\uff0c\u5355\u636eID\uff1a\u201c%2$d\u201d\uff0c\u5355\u636e\u4f53\u201c%3$s\u201dID\uff1a\u201c%4$d\u201d\u3002", (String)"MatchEventRuleServiceImpl_01", (String)"fi-ai-mservice", (Object[])new Object[0]), unMatchConditionFieldValue, billId, valueZone.getEntityName(), billEntryId);
                            fahJobContext.getFahBgTaskLogger().addDetailEntryErr(dispatchUnMatchGenRule);
                            continue;
                        }
                        if ("1".equals(eventDispatchRuleData.getNeedGenEvt())) {
                            EventGenRuleGrp eventGenRuleGrp = eventDispatchRuleData.getEventGenRuleGrp();
                            this.handleDispatchResult(resultMap, consumer, eventDispatchScheme.getSrcBillType(), valueZone.getEntityName(), billId, billEntryId, eventGenRuleGrp, srcSysTuple, fahJobContext);
                            continue;
                        }
                        String noNeedGenEvtConditionFieldValue = BuildEvtDataUtil.buildConditionFieldValue((List)conditionFields, conditionValueList);
                        FahTaskNoEvtBillInfo noEvtBillInfo = new FahTaskNoEvtBillInfo();
                        noEvtBillInfo.setRequestId(fahJobContext.getRequestId());
                        noEvtBillInfo.setBillInfo(billType, billId, billNo, valueZone.getEntityName(), billEntryId);
                        noEvtBillInfo.setDispatchIdAndVersion(dispatchId, 0);
                        noEvtBillInfo.setMsg(noNeedGenEvtConditionFieldValue);
                        noEvtBillInfoList.add(noEvtBillInfo);
                        if (!DebugTrace.enable()) continue;
                        String noNeedGenEvtConditionFieldValueLog = BuildEvtDataUtil.buildNoNeedGenEvtConditionFieldValue((String)billType, (ValueZone)valueZone, (List)conditionFields, conditionValueList);
                        String noNeedGenEvtLogMsg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5355\u636eID\uff1a\u201c%2$d\u201d\uff0c\u5355\u636e\u4f53\u201c%3$s\u201dID\uff1a\u201c%4$d\u201d\u3002", (String)"MatchEventRuleServiceImpl_03", (String)"fi-ai-mservice", (Object[])new Object[0]), noNeedGenEvtConditionFieldValueLog, billId, valueZone.getEntityName(), billEntryId);
                        fahJobContext.getFahBgTaskLogger().addDetailEntryWarning(noNeedGenEvtLogMsg);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSet.close();
                }
            }
        }
        for (EventDispatchResult eventDispatchResult : resultMap.values()) {
            this.buildEventGenerateParams(eventDispatchResult, srcSysTuple, consumer, fahJobContext);
        }
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : unMatchEvtRuleBillIdsMap.entrySet()) {
            dispatchId = entry.getKey();
            Map<Long, List<Long>> unMatchAnyEvtRuleBillIds = entry.getValue();
            logger.info("buildEventData_unMatchEvtRuleBillIds.size:{} , dispatchId: {}", (Object)unMatchAnyEvtRuleBillIds.size(), (Object)dispatchId);
            if (unMatchAnyEvtRuleBillIds.isEmpty()) continue;
            fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_unMatchEvtRuleBillIds.size: %d, dispatchId: %d, unMatchAnyEvtRuleBillIds: %s", unMatchAnyEvtRuleBillIds.size(), dispatchId, unMatchAnyEvtRuleBillIds));
            BuildEvtDataUtil.saveFailBillsUnMatchEvtRule((Long)fahJobContext.getRequestId(), (String)billType, (long)dispatchId, (int)0, unMatchAnyEvtRuleBillIds, (BillDataProcessErrorCategoryEnum)BillDataProcessErrorCategoryEnum.UNMATCHED_GEN_RULE);
        }
        FahNoEvtBillsDao.saveNoEvtBillInfoList(noEvtBillInfoList);
    }

    private PairTuple<Map<Long, Set<Long>>, Set<Long>> checkUnMatchDispatchRule(Collection<Long> ids, Map<Long, Map<Long, List<Long>>> orgDispatchBillIds) {
        HashSet<Long> matched = new HashSet<Long>(ids.size());
        HashMap<Long, Set> matchedMap = new HashMap<Long, Set>(orgDispatchBillIds.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> dispatchMapEntry : orgDispatchBillIds.entrySet()) {
            for (List<Long> matchedIds : dispatchMapEntry.getValue().values()) {
                if (matchedIds.size() == 0) continue;
                matched.addAll(matchedIds);
                matchedMap.computeIfAbsent(dispatchMapEntry.getKey(), k -> new HashSet(16)).addAll(matchedIds);
            }
        }
        HashSet<Long> idSet = new HashSet<Long>(ids);
        idSet.removeAll(matched);
        return new PairTuple(matchedMap, idSet);
    }

    private void handleDispatchResult(Map<Long, EventDispatchResult> resultMap, Consumer<EventGenerateParam> consumer, String srcBillType, String entityName, Long fid, Long billEntryId, EventGenRuleGrp eventGenRuleGrp, PairTuple<Integer, Long> srcSysTuple, IFahJobContext fahJobContext) {
        EventDispatchResult eventDispatchResult = resultMap.computeIfAbsent(eventGenRuleGrp.getId(), k -> new EventDispatchResult(eventGenRuleGrp.getDispatchId(), eventGenRuleGrp.getId(), srcBillType, (Collection)eventGenRuleGrp.getTargetEvtGenRules(), entityName));
        eventDispatchResult.getBillIds().add(fid);
        eventDispatchResult.getBillEntryIds().add(billEntryId);
        eventDispatchResult.getBillEntryIdMap().computeIfAbsent(fid, k -> new LinkedList()).add(billEntryId);
        if (eventDispatchResult.getBillEntryIds().size() >= this.dispatchResultBatchSize) {
            this.buildEventGenerateParams(eventDispatchResult, srcSysTuple, consumer, fahJobContext);
        }
    }

    private void buildEventGenerateParams(EventDispatchResult eventDispatchResult, PairTuple<Integer, Long> srcSysTuple, Consumer<EventGenerateParam> consumer, IFahJobContext fahJobContext) {
        if (eventDispatchResult.getBillEntryIds().isEmpty()) {
            return;
        }
        for (Long genRuleId : eventDispatchResult.getGenRuleIds()) {
            EventGenerateParam eventGenerateParam = new EventGenerateParam();
            eventGenerateParam.setFahEvtTaskParam(new FahEvtTaskParam(eventDispatchResult.getDispatchId(), Integer.valueOf(0), eventDispatchResult.getBillType()));
            eventGenerateParam.setRuleId(genRuleId);
            eventGenerateParam.setSrcSysType((Integer)srcSysTuple.getKey());
            eventGenerateParam.setSrcSysId((Long)srcSysTuple.getValue());
            eventGenerateParam.setBillIds(new LinkedHashSet(eventDispatchResult.getBillIds()));
            eventGenerateParam.setSourceEntry(eventDispatchResult.getSourceEntry());
            eventGenerateParam.setBillEntryIds(new LinkedHashSet(eventDispatchResult.getBillEntryIds()));
            consumer.accept(eventGenerateParam);
            if (!DebugTrace.enable()) continue;
            fahJobContext.getFahBgTaskLogger().addDetailEntry("eventGenerateParam:" + JSON.toJSONString((Object)eventGenerateParam));
        }
        eventDispatchResult.getBillIds().clear();
        eventDispatchResult.getBillEntryIds().clear();
    }

    private Map<Long, Map<Long, List<Long>>> getDispatchBillIds(EventDispatchSchemeCollection eventDispatchSchemeCollection, Collection<Long> ids) {
        String select = String.join((CharSequence)",", eventDispatchSchemeCollection.getPrimaryKey(), eventDispatchSchemeCollection.getBillOrgValueSource());
        QFilter orgIdsFilter = eventDispatchSchemeCollection.getOrgToDispatchScheme().size() < 5000 ? new QFilter(eventDispatchSchemeCollection.getBillOrgValueSource(), "in", eventDispatchSchemeCollection.getOrgToDispatchScheme().keySet()) : null;
        LinkedHashMap<Long, Map<Long, List<Long>>> orgDispatchBillIds = new LinkedHashMap<Long, Map<Long, List<Long>>>();
        try (DataSet dataset = QueryDataSourceFactory.getQueryDataSource((String)eventDispatchSchemeCollection.getSrcBillType()).queryBillDataInfo(new ArrayList<Long>(ids), orgIdsFilter, select, null, -1);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long useOrgId = row.getLong(eventDispatchSchemeCollection.getBillOrgValueSource());
                Long dispatchId = (Long)eventDispatchSchemeCollection.getOrgToDispatchScheme().get(useOrgId);
                if (null == dispatchId) continue;
                orgDispatchBillIds.computeIfAbsent(dispatchId, k -> new LinkedHashMap()).computeIfAbsent(useOrgId, k -> new LinkedList()).add(row.getLong(eventDispatchSchemeCollection.getPrimaryKey()));
            }
        }
        return orgDispatchBillIds;
    }

    private PairTuple<Integer, Long> getSrcSystemInfo(String billType) {
        PairTuple tuple;
        long srcSysId = 0L;
        Integer srcSysType = billType.startsWith("fah_e_") ? 1 : 0;
        if (srcSysType != 0) {
            srcSysId = 1001L;
            tuple = new PairTuple((Object)srcSysType, (Object)srcSysId);
        } else {
            tuple = new PairTuple((Object)srcSysType, (Object)srcSysId);
        }
        return tuple;
    }
}

