/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.v2.fah.constant.enums.event.EventReverseStatusEnum;
import kd.fi.v2.fah.dao.FahGroupMergeDataDao;
import kd.fi.v2.fah.job.FahJobContext;
import kd.fi.v2.fah.job.IFahJobContext;
import kd.fi.v2.fah.log.FahBgTaskLogger;
import kd.fi.v2.fah.models.context.FahVoucherTrackerContext;
import kd.fi.v2.fah.models.context.GLTaskVoucherPushContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;
import kd.fi.v2.fah.voucherprocess.service.VoucherDataProcessFactory;
import kd.fi.v2.fah.voucherprocess.util.VoucherDataProcessUtil;

public class VoucherGroupMergePushService {
    private static final Log logger = LogFactory.getLog(VoucherGroupMergePushService.class);
    private final Long requestId;
    private final EventReverseStatusEnum reverseStatusEnum;
    private final IFahJobContext fahJobContext;
    private final int bigEntrySize;

    public VoucherGroupMergePushService(Long requestId, EventReverseStatusEnum reverseStatusEnum) {
        this.requestId = requestId;
        this.reverseStatusEnum = reverseStatusEnum;
        this.fahJobContext = FahJobContext.getIFahJobContext((Long)this.requestId);
        this.bigEntrySize = FahOptimizeControlPanel.getBigEntrySize();
    }

    public void doExecute() {
        this.addLogDetail(this.getClass().getName() + ": doExecute start");
        List xlaIds = FahGroupMergeDataDao.getCurrRequestXLAData((Long)this.requestId, (Boolean)true, (EventReverseStatusEnum)this.reverseStatusEnum);
        BuildVoucherReportInfoContext reportContext = new BuildVoucherReportInfoContext(this.requestId, "", BuildVoucherReportInfoContext.ReportBuildType.GROUPMERGEVOUCHER);
        String xlaIdsMsg = String.format("----FAH----VoucherGroupMergePushService---requestId: %d;xlaIds.size : %d;xlaIds: %s", this.requestId, xlaIds.size(), FahBgTaskLogger.logSizeOrDetail((Collection)xlaIds));
        this.addLogDetail(xlaIdsMsg);
        if (xlaIds.isEmpty()) {
            return;
        }
        ArrayList<Long> bigEntryIds = new ArrayList<Long>();
        Map<Long, List<List<Long>>> batchTask = VoucherDataProcessUtil.intelligentBatchTask(xlaIds, bigEntryIds, this.bigEntrySize);
        String batchTaskMsg = String.format("----FAH----batchTask.size:%d, mergeRules: %s, bigEntryIds:%s;", batchTask.size(), batchTask.keySet(), FahBgTaskLogger.logSizeOrDetail(bigEntryIds));
        this.addLogDetail(batchTaskMsg);
        FahVoucherTrackerContext tracker = new FahVoucherTrackerContext(this.requestId);
        boolean isReverse = this.reverseStatusEnum == EventReverseStatusEnum.REVERSED;
        try {
            HashSet<Long> bigEntryIdSet = new HashSet<Long>(bigEntryIds);
            int totalMergeServiceCount = 0;
            long mergeStart = System.currentTimeMillis();
            for (Map.Entry<Long, List<List<Long>>> entry : batchTask.entrySet()) {
                Long mergeRuleId = entry.getKey();
                List<List<Long>> splitData = entry.getValue();
                long start = System.currentTimeMillis();
                String mergeMsgStart = String.format("----FAH----mergeRuleId:%d, splitData:%s;", mergeRuleId, FahBgTaskLogger.logSizeOrDetail(splitData));
                this.addLogDetail(mergeMsgStart);
                int batch = 0;
                for (List<Long> batchData : splitData) {
                    long oneBatchStart = System.currentTimeMillis();
                    boolean isBigEntry = batchData.size() == 1 && bigEntryIdSet.contains(batchData.get(0));
                    boolean mergeVoucher = VoucherDataProcessFactory.getVoucherMergeService(false, tracker, isBigEntry, mergeRuleId, batchData, reportContext, isReverse).doMerge();
                    long oneBatchEnd = System.currentTimeMillis();
                    String mergeMsgOneBatch = String.format("----FAH----mergeRuleId: %d, isBigEntry: %b,mergeVoucher: %b, batch: %d , MergeServiceCount: %d , cost: %d ms batchData: %s;", mergeRuleId, isBigEntry, mergeVoucher, ++batch, ++totalMergeServiceCount, oneBatchEnd - oneBatchStart, isBigEntry ? batchData : FahBgTaskLogger.logSizeOrDetail(batchData));
                    this.addLogDetail(mergeMsgOneBatch);
                    if (mergeVoucher) continue;
                }
                if (splitData.size() > 1) {
                    String secondMergeMsg = String.format("----FAH----secondMerge, mergeRuleId: %d, splitData.size: %d,MergeServiceCount: %d;", mergeRuleId, splitData.size(), ++totalMergeServiceCount);
                    this.addLogDetail(secondMergeMsg);
                    VoucherDataProcessFactory.getVoucherMergeService(true, tracker, true, 0L, null, reportContext, isReverse).doMerge();
                }
                long end = System.currentTimeMillis();
                String mergeMsgEnd = String.format("----FAH----mergeRuleId:%d, cost:%d ms;", mergeRuleId, end - start);
                this.addLogDetail(mergeMsgEnd);
            }
            long mergeEnd = System.currentTimeMillis();
            String beforePushVoucherMsg = String.format("----FAH----before pushTracker:%d, totalMergeServiceCount: %d, cost: %d ms", tracker.getVoucherIdAndXlaIdMap().size(), totalMergeServiceCount, mergeEnd - mergeStart);
            this.addLogDetail(beforePushVoucherMsg);
            GLTaskVoucherPushContext context = new GLTaskVoucherPushContext(new ArrayList(tracker.getVoucherIdAndXlaIdMap().keySet()), this.reverseStatusEnum, FahOptimizeControlPanel.putVoucherMaxSizeData(), this.fahJobContext);
            context.setTracker(tracker);
            context.setReportContext(new BuildVoucherReportInfoContext(this.requestId, "", BuildVoucherReportInfoContext.ReportBuildType.PUSHGLVOUCHER));
            context.setPreSaveMaxSize(FahOptimizeControlPanel.preSaveDBEntrySize());
            VoucherDataProcessFactory.getVoucherPushService((ITaskVoucherPushContext)context).pushVoucher();
        }
        catch (Exception e) {
            logger.error("----FAH----VoucherGroupMergePushService:--error--: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            reportContext.genStackErrorMessage(e);
            throw e;
        }
    }

    private void addLogDetail(String msg) {
        logger.info(msg);
        if (null != this.fahJobContext) {
            this.fahJobContext.getFahBgTaskLogger().addDetailEntry(msg);
        }
    }
}

