/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.dim.service.DimValueSaveService;
import kd.fi.v2.fah.meta.BizDataSimpleTableMeta;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpItemDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpTypeCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimTypeCustomCfgDTO;

public class BuildEventBizDataUtil {
    public static void activateDimValAndUpdateStatus1(Map<Long, Tuple<String, Boolean>> eventNumAndBizDataStatus, Long transId, int maxDimCnt) {
        LinkedList<Long> noNeedEvtIds = new LinkedList<Long>();
        LinkedList<Long> successEvtIds = new LinkedList<Long>();
        LinkedList<Long> failedEvtIds = new LinkedList<Long>();
        for (Map.Entry<Long, Tuple<String, Boolean>> entry : eventNumAndBizDataStatus.entrySet()) {
            if (null == entry.getValue().item2) {
                noNeedEvtIds.add(entry.getKey());
                continue;
            }
            if (((Boolean)entry.getValue().item2).booleanValue()) {
                successEvtIds.add(entry.getKey());
                continue;
            }
            failedEvtIds.add(entry.getKey());
        }
        DimValueSaveService saveService = new DimValueSaveService();
        saveService.activateDimValTmpData(transId, successEvtIds, maxDimCnt);
        saveService.deactivateDimValTmpData(transId, failedEvtIds);
        saveService.updateBizDataStatus(noNeedEvtIds, successEvtIds, failedEvtIds);
    }

    public static BizDataSimpleTableMeta getBizDataSimpleTableMeta(BizDimGrpTypeCfgDTO dimGrpTypeCfg, long transId) {
        BizDataSimpleTableMeta bizDataSimpleTableMeta = new BizDataSimpleTableMeta();
        bizDataSimpleTableMeta.setTransId(transId);
        bizDataSimpleTableMeta.setDimGrpTypeId(dimGrpTypeCfg.getId().longValue());
        bizDataSimpleTableMeta.setKey((Object)dimGrpTypeCfg.getId());
        bizDataSimpleTableMeta.addFixPosColumn("batchId", "ftrans_batch_id");
        bizDataSimpleTableMeta.addFixPosColumn("evtLineId", "evtLineId");
        bizDataSimpleTableMeta.addFixPosColumn("dimcnt", "fdimcnt");
        bizDataSimpleTableMeta.addFixPosColumn("status", "fstatus");
        bizDataSimpleTableMeta.addFixPosColumn("errMsg", "fmsg");
        for (BizDimGrpItemDTO dimGrpItemDTO : dimGrpTypeCfg) {
            bizDataSimpleTableMeta.addFlexColumn(dimGrpItemDTO.getNumber(), dimGrpItemDTO.getAlias(), (Long)dimGrpItemDTO.getId(), dimGrpItemDTO.getDimDataType(), dimGrpItemDTO.getDimDataType() == DataValueTypeEnum.BaseProp ? (String)dimGrpItemDTO.getRefEntityNum() : null, dimGrpItemDTO.getIndex());
        }
        return bizDataSimpleTableMeta;
    }

    public static void createMessage(OperationResult opResult, Map<Long, Tuple<String, Boolean>> eventNumAndBizDataStatus) {
        if (null == eventNumAndBizDataStatus) {
            return;
        }
        opResult.setBillCount(eventNumAndBizDataStatus.size());
        for (Map.Entry<Long, Tuple<String, Boolean>> entry : eventNumAndBizDataStatus.entrySet()) {
            if (null != entry.getValue().item2 && !((Boolean)entry.getValue().item2).booleanValue()) {
                opResult.setSuccess(false);
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u521b\u5efa\u4e1a\u52a1\u7ef4\u5ea6\u5931\u8d25\u3002", (String)"BuildEventBizDataUtil_1", (String)"fi-ai-mservice", (Object[])new Object[0]), entry.getValue().item1));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u521b\u5efa\u4e1a\u52a1\u7ef4\u5ea6", (String)"BuildEventBizDataUtil_2", (String)"fi-ai-mservice", (Object[])new Object[0]));
                errorInfo.setPkValue((Object)entry.getKey());
                opResult.addErrorInfo(errorInfo);
                opResult.setShowMessage(true);
                continue;
            }
            opResult.setSuccess(true);
            opResult.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u521b\u5efa\u4e1a\u52a1\u7ef4\u5ea6\u6210\u529f\u3002", (String)"BuildEventBizDataUtil_3", (String)"fi-ai-mservice", (Object[])new Object[0]), entry.getValue().item1));
            opResult.addSuccessPkId((Object)entry.getKey());
            opResult.setShowMessage(true);
        }
    }

    public static BizDimTypeCustomCfgDTO getBizDimTypeCusCfg(BizDimGrpTypeCfgDTO dimGrpTypeCfg, long orgId) {
        BizDimTypeCustomCfgDTO bizDimTypeCusCfg = (BizDimTypeCustomCfgDTO)dimGrpTypeCfg.getCustOrgLookupIdx().get(orgId);
        if (null == bizDimTypeCusCfg) {
            bizDimTypeCusCfg = (BizDimTypeCustomCfgDTO)dimGrpTypeCfg.getCustOrgLookupIdx().get(0L);
        }
        return bizDimTypeCusCfg;
    }

    public static Collection<Long> queryEvtIdsByGrp(Long requestId, Long partitionGrpCode) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid from t_fah_event_header a", new Object[0]);
        sqlBuilder.append("where a.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append("and a.fpartitiongrpcode = ?", new Object[]{partitionGrpCode});
        sqlBuilder.append("and a.fstatus = ?", new Object[]{"4"});
        sqlBuilder.append(" order by a.fid", new Object[0]);
        LinkedList<Long> evtIds = new LinkedList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"queryEvtIdsByGrp", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                evtIds.add(row.getLong("fid"));
            }
        }
        return evtIds;
    }
}

