/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.flex.FlexService;
import kd.fi.v2.fah.constant.enums.xla.FahXLAHeadField;
import kd.fi.v2.fah.constant.enums.xla.FahXLALineField;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.FahCheckXLADataDao;
import kd.fi.v2.fah.event.mservice.context.SingleXLATaskContext;
import kd.fi.v2.fah.event.mservice.context.XLADataContext;
import kd.fi.v2.fah.models.xla.GenerateXLAErrorCode;
import kd.fi.v2.fah.models.xla.XLAAccount;
import kd.fi.v2.fah.models.xla.XLAAccountBook;
import kd.fi.v2.fah.models.xla.XLACashFlowItem;
import kd.fi.v2.fah.models.xla.XLAPeriod;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.storage.impl.SupplementaryField;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;

public class XLABusinessDataCheckUtil {
    public static Map<Long, Long> checkAndUpdateAccountData(Set<Long> acctountIds, Long orgId, Long acctTableId, Date bookedDate, Map<Long, String> errorMap) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(acctountIds.size());
        if (acctountIds.isEmpty() || orgId == null || acctTableId == null || bookedDate == null) {
            return result;
        }
        FahCheckXLADataDao.loadAccountByOrgId(acctountIds, (Long)orgId, (Long)acctTableId, result);
        acctountIds.stream().filter(f -> !result.containsKey(f)).forEach(actId -> errorMap.put((Long)actId, GenerateXLAErrorCode.XLA_LINE_ACCOUNT_NOTORG.getErrorMessage()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Long> checkAndUpdateAsstData(List<Object[]> asstInfoDatas, Map<Long, XLAAccount> idAndAccountMap, Map<Long, XLACashFlowItem> idAndCashFlowItemMap, Map<String, FlexProperty> asstAndFlexProperty, Boolean isaccount, Map<Long, String> errorMap) {
        FlexEntireData flexEntireData;
        HashMap<Long, Long> result = new HashMap<Long, Long>(asstInfoDatas.size());
        if (isaccount.booleanValue()) {
            Set query_accountIds = asstInfoDatas.stream().filter(f -> !idAndAccountMap.containsKey(f[0])).map(m -> Long.parseLong(m[0].toString())).collect(Collectors.toSet());
            FahCheckXLADataDao.queryAccountInfo(query_accountIds, idAndAccountMap);
        } else {
            Set query_mainItemIds = asstInfoDatas.stream().filter(f -> !idAndCashFlowItemMap.containsKey(f[0])).map(m -> Long.parseLong(m[0].toString())).collect(Collectors.toSet());
            FahCheckXLADataDao.queryMainItemInfo(query_mainItemIds, idAndCashFlowItemMap);
        }
        ArrayList<FlexEntireData> flexDataList = new ArrayList<FlexEntireData>(asstInfoDatas.size());
        for (Object[] param : asstInfoDatas) {
            Object accountId = param[0];
            Object asst = param[1];
            flexEntireData = null;
            Set flexNumber = new HashSet();
            HashSet mustFlexNumber = new HashSet();
            if (isaccount.booleanValue()) {
                XLAAccount xlaAccount = idAndAccountMap.get(accountId);
                if (xlaAccount == null) continue;
                flexNumber = xlaAccount.getAssgrpFlexNumber();
                mustFlexNumber = new HashSet(xlaAccount.getMustNumber());
            } else {
                XLACashFlowItem xlaCashFlowItem = idAndCashFlowItemMap.get(accountId);
                if (xlaCashFlowItem == null) continue;
                flexNumber = xlaCashFlowItem.getAssgrpFlexNumber();
                mustFlexNumber = new HashSet(xlaCashFlowItem.getMustNumber());
            }
            if (asst instanceof Map) {
                flexEntireData = new FlexEntireData();
                Map asstMap = (Map)asst;
                ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>(asstMap.size());
                for (Map.Entry entry : asstMap.entrySet()) {
                    FlexEntireData.FlexFieldDataType flexFieldDataType;
                    String flexName = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null || value instanceof Long && (Long)value == 0L || StringUtils.isBlank(value) || !flexNumber.contains(flexName)) continue;
                    FlexProperty fp = null;
                    if (asstAndFlexProperty.containsKey(flexName)) {
                        fp = asstAndFlexProperty.get(flexName);
                    } else {
                        fp = FlexEntityMetaUtils.getFlexProperty((String)flexName);
                        asstAndFlexProperty.put(flexName, fp);
                    }
                    mustFlexNumber.remove(flexName);
                    FlexEntireData.FlexData flexData = null;
                    Boolean isTextValue = "3".equals(fp.getValueType());
                    if (isTextValue.booleanValue()) {
                        FlexEntireData flexEntireData2 = flexEntireData;
                        flexEntireData2.getClass();
                        flexData = new FlexEntireData.FlexData(flexEntireData2, fp, (Object)String.valueOf(value));
                        flexFieldDataType = FlexEntireData.FlexFieldDataType.STRING;
                        flexData.setDbType(flexFieldDataType);
                    } else {
                        FlexEntireData flexEntireData3 = flexEntireData;
                        flexEntireData3.getClass();
                        flexData = new FlexEntireData.FlexData(flexEntireData3, fp, (Object)Long.parseLong(value.toString()));
                        flexFieldDataType = FlexEntireData.FlexFieldDataType.LONG;
                        flexData.setDbType(flexFieldDataType);
                    }
                    flexDatas.add(flexData);
                }
                flexEntireData.setFlexDatas(flexDatas);
                flexDataList.add(flexEntireData);
            }
            param[2] = flexEntireData;
            if (mustFlexNumber.isEmpty()) continue;
            errorMap.put(Long.parseLong(param[3].toString()), GenerateXLAErrorCode.XLA_LINE_ASSGRP_ISMUST.getErrorMessage());
        }
        Iterator<Object[]> iterator = XLABusinessDataCheckUtil.class;
        synchronized (XLABusinessDataCheckUtil.class) {
            try {
                FlexService.batchSaveFlexData((int)2, flexDataList);
            }
            catch (Exception e) {
                FlexService.batchSaveFlexData((int)2, flexDataList);
            }
            for (Object[] param : asstInfoDatas) {
                Object flexData = param[2];
                Long lineId = Long.parseLong(param[3].toString());
                if (flexData == null) continue;
                flexEntireData = (FlexEntireData)flexData;
                result.put(lineId, flexEntireData.getId());
            }
            return result;
        }
    }

    private static void processAccountAndAsstData(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        HashMap<Long, String> errorMap;
        Map<Long, Long> bam = xlaContext.getBookIdAndAcctTableIdMap();
        List sqlParams_head = xlaHeadData.getSqlParams();
        List sqlParams_line = xlaLineData.getSqlParams();
        Set headIds = sqlParams_line.stream().map(m -> m[FahXLALineField.FID.getReadIndex()]).filter(f -> f != null).collect(Collectors.toSet());
        HashMap<Long, SupplementaryField> cache_info = new HashMap<Long, SupplementaryField>(sqlParams_head.size());
        for (Object param_head : sqlParams_head) {
            if (!headIds.contains(param_head[FahXLAHeadField.FID.getIndex()])) continue;
            long orgId = Long.parseLong(param_head[FahXLAHeadField.FORGID.getIndex()].toString());
            Date date = (Date)param_head[FahXLAHeadField.FBOOKEDDATE.getIndex()];
            Long acctTableId = bam.get(param_head[FahXLAHeadField.FBOOKID.getIndex()]);
            cache_info.put(Long.parseLong(param_head[FahXLAHeadField.FID.getIndex()].toString()), new SupplementaryField(Long.valueOf(orgId), date, acctTableId));
        }
        HashMap<SupplementaryField, Set> accountCacheMap = new HashMap<SupplementaryField, Set>(cache_info.size());
        for (Object[] param_line : sqlParams_line) {
            SupplementaryField supplementaryField = (SupplementaryField)cache_info.get(param_line[FahXLALineField.FID.getReadIndex()]);
            Object object = param_line[FahXLALineField.FACCOUNTID.getReadIndex()];
            if (object != null) {
                accountCacheMap.computeIfAbsent(supplementaryField, m -> new HashSet()).add(Long.parseLong(object.toString()));
                continue;
            }
            param_line[FahXLALineField.FISERROR.getReadIndex()] = "1";
            param_line[FahXLALineField.FERRORMESSAGE.getReadIndex()] = GenerateXLAErrorCode.XLA_LINE_ACCOUNT_RULE.getErrorMessage();
        }
        HashMap<SupplementaryField, Map> account_repMap = new HashMap<SupplementaryField, Map>(accountCacheMap.size());
        HashMap<SupplementaryField, Map> account_errorMap = new HashMap<SupplementaryField, Map>(accountCacheMap.size());
        for (Map.Entry entry : accountCacheMap.entrySet()) {
            SupplementaryField sf = (SupplementaryField)entry.getKey();
            HashMap<Long, String> errorMap2 = new HashMap<Long, String>();
            Map<Long, Long> newAccountMap = XLABusinessDataCheckUtil.checkAndUpdateAccountData((Set)entry.getValue(), sf.getOrgId(), sf.getAccountTableId(), sf.getBookDate(), errorMap2);
            account_repMap.put(sf, newAccountMap);
            account_errorMap.put(sf, errorMap2);
        }
        HashMap<Long, List> asstCacheMap = new HashMap<Long, List>(cache_info.size());
        for (Object[] param_line : sqlParams_line) {
            Object headId = param_line[FahXLALineField.FID.getReadIndex()];
            SupplementaryField supplementaryField = (SupplementaryField)cache_info.get(headId);
            Map actMap = account_repMap.computeIfAbsent(supplementaryField, m -> new HashMap());
            errorMap = account_errorMap.computeIfAbsent(supplementaryField, m -> new HashMap());
            Object acctount = param_line[FahXLALineField.FACCOUNTID.getReadIndex()];
            if (acctount != null) {
                Long newAccountId = (Long)actMap.get(acctount);
                String errorMessage = (String)errorMap.get(acctount);
                if (newAccountId != null) {
                    param_line[FahXLALineField.FACCOUNTID.getReadIndex()] = newAccountId;
                    Object[] asstInfo = new Object[]{newAccountId, param_line[FahXLALineField.FASSGRPID.getReadIndex()], null, param_line[xlaLineData.getPK_Column_Index()]};
                    asstCacheMap.computeIfAbsent(supplementaryField.getOrgId(), m -> new LinkedList()).add(asstInfo);
                    continue;
                }
                param_line[FahXLALineField.FACCOUNTID.getReadIndex()] = 0L;
                param_line[FahXLALineField.FISERROR.getReadIndex()] = "1";
                param_line[FahXLALineField.FERRORMESSAGE.getReadIndex()] = errorMessage == null ? GenerateXLAErrorCode.XLA_LINE_ACCOUNT_RULE.getErrorMessage() : errorMessage;
                continue;
            }
            param_line[FahXLALineField.FACCOUNTID.getReadIndex()] = 0L;
        }
        HashMap<Long, Map<Long, Long>> hashMap = new HashMap<Long, Map<Long, Long>>(asstCacheMap.size());
        HashMap<Long, HashMap<Long, String>> asst_errorMap = new HashMap<Long, HashMap<Long, String>>(asstCacheMap.size());
        for (Map.Entry asstMap : asstCacheMap.entrySet()) {
            Long orgId = (Long)asstMap.getKey();
            errorMap = new HashMap<Long, String>(asstCacheMap.size());
            Map<Long, Long> checkAndUpdateAsstData = XLABusinessDataCheckUtil.checkAndUpdateAsstData((List)asstMap.getValue(), xlaContext.getIdAndAccountMap(), new HashMap<Long, XLACashFlowItem>(), xlaContext.getAsstAndFlexProperty(), true, errorMap);
            hashMap.put(orgId, checkAndUpdateAsstData);
            asst_errorMap.put(orgId, errorMap);
        }
        for (Object[] param_line : sqlParams_line) {
            XLAAccount xlaAccount;
            Object acctount;
            HashMap asstMap;
            Object headId = param_line[FahXLALineField.FID.getReadIndex()];
            SupplementaryField supplementaryField = (SupplementaryField)cache_info.get(headId);
            Map map = supplementaryField != null ? (hashMap.get(supplementaryField.getOrgId()) != null ? (Map)hashMap.get(supplementaryField.getOrgId()) : new HashMap()) : (asstMap = new HashMap());
            HashMap errorMap3 = supplementaryField != null ? (asst_errorMap.get(supplementaryField.getOrgId()) != null ? (Map)asst_errorMap.get(supplementaryField.getOrgId()) : new HashMap()) : new HashMap();
            Object lineId = param_line[xlaLineData.getPK_Column_Index()];
            Long assgrpId = (Long)asstMap.get(lineId);
            String errorMessage = (String)errorMap3.get(lineId);
            param_line[FahXLALineField.FASSGRPID.getReadIndex()] = assgrpId != null ? assgrpId : Long.valueOf(0L);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                param_line[FahXLALineField.FISERROR.getReadIndex()] = "1";
                param_line[FahXLALineField.FERRORMESSAGE.getReadIndex()] = errorMessage;
            }
            if ((acctount = param_line[FahXLALineField.FACCOUNTID.getReadIndex()]) == null || Long.parseLong(acctount.toString()) == 0L || (xlaAccount = xlaContext.getIdAndAccountMap().get(acctount)) == null) continue;
            if (!xlaAccount.getIsleaf().booleanValue()) {
                param_line[FahXLALineField.FISERROR.getReadIndex()] = "1";
                param_line[FahXLALineField.FERRORMESSAGE.getReadIndex()] = GenerateXLAErrorCode.XLA_LINE_ACCOUNT_NOTLEAF.getErrorMessage();
            }
            if (xlaAccount.getEnable().booleanValue()) continue;
            param_line[FahXLALineField.FISERROR.getReadIndex()] = "1";
            param_line[FahXLALineField.FERRORMESSAGE.getReadIndex()] = GenerateXLAErrorCode.XLA_LINE_ACCOUNT_STATUS.getErrorMessage();
        }
    }

    public static void checkAndUpdateXLAData(SingleXLATaskContext context) {
        XLABusinessDataCheckUtil.processAccountAndAsstData(context.getXlaContext(), context.getXLAHeadData(), context.getXLALineData());
        XLABusinessDataCheckUtil.processSumAmountData(context.getXlaContext(), context.getXLAHeadData(), context.getXLALineData());
    }

    private static void processSumAmountData(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        List sqlParams_head = xlaHeadData.getSqlParams();
        List sqlParams_line = xlaLineData.getSqlParams();
        HashMap<Long, BigDecimal> deMap = new HashMap<Long, BigDecimal>(sqlParams_head.size());
        HashMap<Long, BigDecimal> crMap = new HashMap<Long, BigDecimal>(sqlParams_head.size());
        for (Object[] param_line : sqlParams_line) {
            Object localDebit = param_line[FahXLALineField.FLOCAL_DEBIT.getReadIndex()];
            Object localCredit = param_line[FahXLALineField.FLOCAL_CREDIT.getReadIndex()];
            Object fid = param_line[FahXLALineField.FID.getReadIndex()];
            if (fid == null || localDebit == null || localCredit == null) continue;
            Long id = Long.parseLong(fid.toString());
            BigDecimal de = deMap.computeIfAbsent(id, v -> new BigDecimal(0));
            BigDecimal cr = crMap.computeIfAbsent(id, v -> new BigDecimal(0));
            de = localDebit instanceof BigDecimal ? de.add((BigDecimal)localDebit) : de.add(new BigDecimal(localDebit.toString()));
            cr = localCredit instanceof BigDecimal ? cr.add((BigDecimal)localCredit) : cr.add(new BigDecimal(localCredit.toString()));
            deMap.put(id, de);
            crMap.put(id, cr);
        }
        for (Object[] param_head : sqlParams_head) {
            Object fid = param_head[FahXLAHeadField.FID.getIndex()];
            if (fid == null) continue;
            Long id = Long.parseLong(fid.toString());
            BigDecimal de = (BigDecimal)deMap.get(id);
            BigDecimal cr = (BigDecimal)crMap.get(id);
            if (de == null || cr == null) continue;
            BigDecimal locCredit = (BigDecimal)param_head[FahXLAHeadField.FLOC_CREDITAMT.getIndex()];
            BigDecimal locDebit = (BigDecimal)param_head[FahXLAHeadField.FLOC_DEBITAMT.getIndex()];
            locCredit = locCredit.add(cr);
            locDebit = locDebit.add(de);
            param_head[FahXLAHeadField.FLOC_CREDITAMT.getIndex()] = locCredit;
            param_head[FahXLAHeadField.FLOC_DEBITAMT.getIndex()] = locDebit;
            if (locCredit.compareTo(locDebit) == 0) continue;
            param_head[FahXLAHeadField.FISERROR.getIndex()] = "1";
            param_head[FahXLAHeadField.FERRORMESSAGE.getIndex()] = GenerateXLAErrorCode.XLA_HEAD_AMONTSUM_ERROR.getErrorMessage();
        }
    }

    public static void XLADataProcessing(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        XLABusinessDataCheckUtil.processAccountAndAsstData(xlaContext, xlaHeadData, xlaLineData);
        XLABusinessDataCheckUtil.processAmountData(xlaContext, xlaHeadData, xlaLineData);
        XLABusinessDataCheckUtil.procecssOrgPermission(xlaContext, xlaHeadData, xlaLineData);
        XLABusinessDataCheckUtil.processCashFlowAsstAndAmountData(xlaContext, xlaHeadData, xlaLineData);
        XLABusinessDataCheckUtil.processSumAmountData(xlaContext, xlaHeadData, xlaLineData);
        XLABusinessDataCheckUtil.procecssFieldMustCheck(xlaContext, xlaHeadData, xlaLineData);
    }

    private static void procecssFieldMustCheck(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        List sqlParams_line = xlaLineData.getSqlParams();
        for (Object[] param_line : sqlParams_line) {
            Object desc = param_line[FahXLALineField.FDESCRIPTION.getReadIndex()];
            if (!StringUtils.isBlank((Object)desc)) continue;
            param_line[FahXLALineField.FDESCRIPTION.getReadIndex()] = "";
            param_line[FahXLALineField.FISERROR.getReadIndex()] = "1";
            param_line[FahXLALineField.FERRORMESSAGE.getReadIndex()] = GenerateXLAErrorCode.XLA_LINE_DESC_NULL.getErrorMessage();
        }
    }

    private static void procecssOrgPermission(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        List sqlParams_head = xlaHeadData.getSqlParams();
        List sqlParams_line = xlaLineData.getSqlParams();
        Set headIds = sqlParams_line.stream().map(m -> m[FahXLALineField.FID.getReadIndex()]).filter(f -> f != null).collect(Collectors.toSet());
        HashMap<Long, Long> cache_info = new HashMap<Long, Long>(sqlParams_head.size());
        for (Object param_head : sqlParams_head) {
            if (!headIds.contains(param_head[FahXLAHeadField.FID.getIndex()])) continue;
            long orgId = Long.parseLong(param_head[FahXLAHeadField.FORGID.getIndex()].toString());
            cache_info.put(Long.parseLong(param_head[FahXLAHeadField.FID.getIndex()].toString()), orgId);
        }
        HashMap<Long, Set> orgAndItemMap = new HashMap<Long, Set>(sqlParams_line.size());
        for (Object[] param_line : sqlParams_line) {
            Long orgId = (Long)cache_info.get(param_line[FahXLALineField.FID.getReadIndex()]);
            Object mainItem = param_line[FahXLALineField.FMAINCF_ITEMID.getReadIndex()];
            Object supItem = param_line[FahXLALineField.FSUPCF_ITEMID.getReadIndex()];
            if (mainItem != null) {
                orgAndItemMap.computeIfAbsent(orgId, m -> new HashSet()).add(Long.parseLong(mainItem.toString()));
            }
            if (supItem == null) continue;
            orgAndItemMap.computeIfAbsent(orgId, m -> new HashSet()).add(Long.parseLong(supItem.toString()));
        }
        HashMap<Long, Map> item_repMap = new HashMap<Long, Map>(orgAndItemMap.size());
        for (Map.Entry actMap : orgAndItemMap.entrySet()) {
            Long orgId = (Long)actMap.getKey();
            HashMap newItemMap = new HashMap(((Set)actMap.getValue()).size());
            FahCheckXLADataDao.loadItemByOrgId((Set)((Set)actMap.getValue()), (Long)orgId, newItemMap);
            item_repMap.put(orgId, newItemMap);
        }
        for (Object[] param_line : sqlParams_line) {
            Object headId = param_line[FahXLALineField.FID.getReadIndex()];
            Long orgId = (Long)cache_info.get(headId);
            Map itemMap = item_repMap.computeIfAbsent(orgId, m -> new HashMap());
            Object mainItem = param_line[FahXLALineField.FMAINCF_ITEMID.getReadIndex()];
            Object supItem = param_line[FahXLALineField.FSUPCF_ITEMID.getReadIndex()];
            Long new_mainItem = (Long)itemMap.get(mainItem);
            Long new_supItem = (Long)itemMap.get(supItem);
            param_line[FahXLALineField.FMAINCF_ITEMID.getReadIndex()] = new_mainItem != null ? new_mainItem : Long.valueOf(0L);
            if (new_supItem != null) {
                param_line[FahXLALineField.FSUPCF_ITEMID.getReadIndex()] = new_supItem;
                continue;
            }
            param_line[FahXLALineField.FSUPCF_ITEMID.getReadIndex()] = 0L;
        }
    }

    private static void processCashFlowAsstAndAmountData(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        List sqlParams_line = xlaLineData.getSqlParams();
        Map<Long, XLACashFlowItem> idAndCashFlowItemMap = xlaContext.getIdAndCashFlowItemMap();
        Map<Long, XLAAccount> idAndAccountMap = xlaContext.getIdAndAccountMap();
        ArrayList<Object[]> AssgrpList = new ArrayList<Object[]>(sqlParams_line.size());
        for (Object[] param_line : sqlParams_line) {
            if (param_line[FahXLALineField.FID.getReadIndex()] == null) continue;
            AssgrpList.add(new Object[]{param_line[FahXLALineField.FMAINCF_ITEMID.getReadIndex()], param_line[FahXLALineField.FMAINCF_ASSGRPID.getReadIndex()], null, param_line[xlaLineData.getPK_Column_Index()]});
        }
        HashMap<Long, String> errorMap = new HashMap<Long, String>(AssgrpList.size());
        Map<Long, Long> checkAndUpdateAsstData = XLABusinessDataCheckUtil.checkAndUpdateAsstData(AssgrpList, idAndAccountMap, idAndCashFlowItemMap, xlaContext.getAsstAndFlexProperty(), false, errorMap);
        for (Object[] param_line : sqlParams_line) {
            XLACashFlowItem cfi;
            if (param_line[FahXLALineField.FID.getReadIndex()] == null) continue;
            Object lineId = param_line[xlaLineData.getPK_Column_Index()];
            Object accountId = param_line[FahXLALineField.FACCOUNTID.getReadIndex()];
            Object mainItem = param_line[FahXLALineField.FMAINCF_ITEMID.getReadIndex()];
            Object supItem = param_line[FahXLALineField.FSUPCF_ITEMID.getReadIndex()];
            if (mainItem != null && (Long)mainItem != 0L) {
                BigDecimal cr = (BigDecimal)param_line[FahXLALineField.FLOCAL_CREDIT.getReadIndex()];
                BigDecimal de = (BigDecimal)param_line[FahXLALineField.FLOCAL_DEBIT.getReadIndex()];
                String dc = (String)param_line[FahXLALineField.FENTRYDC.getReadIndex()];
                cfi = idAndCashFlowItemMap.get(mainItem);
                if (cfi == null) {
                    param_line[FahXLALineField.FMAINCF_AMOUNT.getReadIndex()] = new BigDecimal(0);
                    param_line[FahXLALineField.FMAINCF_ASSGRPID.getReadIndex()] = 0L;
                    continue;
                }
                BigDecimal cfDC = "o".equals(cfi.getDirection()) ? BigDecimal.ONE.negate() : BigDecimal.ONE;
                BigDecimal mainfcamount = BigDecimal.ZERO;
                mainfcamount = dc.equals("1") ? de.negate().multiply(cfDC) : cr.multiply(cfDC);
                Long assgrpId = checkAndUpdateAsstData.get(lineId) != null ? checkAndUpdateAsstData.get(lineId) : Long.valueOf(0L);
                param_line[FahXLALineField.FMAINCF_AMOUNT.getReadIndex()] = mainfcamount;
                param_line[FahXLALineField.FMAINCF_ASSGRPID.getReadIndex()] = assgrpId;
            } else {
                param_line[FahXLALineField.FMAINCF_AMOUNT.getReadIndex()] = new BigDecimal(0);
                param_line[FahXLALineField.FMAINCF_ASSGRPID.getReadIndex()] = 0L;
                param_line[FahXLALineField.FMAINCF_ITEMID.getReadIndex()] = 0L;
            }
            if (supItem != null && (Long)supItem != 0L) {
                BigDecimal supCfAmount;
                XLAAccount xlaAccount = idAndAccountMap.get(accountId);
                if (xlaAccount == null) {
                    param_line[FahXLALineField.FSUPCF_AMOUNT.getReadIndex()] = new BigDecimal(0);
                    continue;
                }
                BigDecimal cr = (BigDecimal)param_line[FahXLALineField.FLOCAL_CREDIT.getReadIndex()];
                BigDecimal de = (BigDecimal)param_line[FahXLALineField.FLOCAL_DEBIT.getReadIndex()];
                if (xlaAccount.isProfitAndLoss()) {
                    supCfAmount = de.subtract(cr);
                    param_line[FahXLALineField.FSUPCF_AMOUNT.getReadIndex()] = supCfAmount;
                    continue;
                }
                if (mainItem != null && (Long)mainItem != 0L) {
                    cfi = idAndCashFlowItemMap.get(mainItem);
                    if (cfi != null) {
                        BigDecimal maincfAmount = (BigDecimal)param_line[FahXLALineField.FMAINCF_AMOUNT.getReadIndex()];
                        BigDecimal supCfAmount2 = "o".equals(cfi.getDirection()) ? maincfAmount.negate() : maincfAmount;
                        param_line[FahXLALineField.FSUPCF_AMOUNT.getReadIndex()] = supCfAmount2;
                        continue;
                    }
                    BigDecimal supCfAmount3 = cr.subtract(de);
                    param_line[FahXLALineField.FSUPCF_AMOUNT.getReadIndex()] = supCfAmount3;
                    continue;
                }
                supCfAmount = cr.subtract(de);
                param_line[FahXLALineField.FSUPCF_AMOUNT.getReadIndex()] = supCfAmount;
                continue;
            }
            param_line[FahXLALineField.FSUPCF_ITEMID.getReadIndex()] = 0L;
            param_line[FahXLALineField.FSUPCF_AMOUNT.getReadIndex()] = new BigDecimal(0);
        }
    }

    private static void processAmountData(XLADataContext xlaContext, BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData) {
        List sqlParams_head = xlaHeadData.getSqlParams();
        List sqlParams_line = xlaLineData.getSqlParams();
        Set headIds = sqlParams_line.stream().map(m -> m[FahXLALineField.FID.getReadIndex()]).filter(f -> f != null).collect(Collectors.toSet());
        HashMap<Long, Long> headIdAndCurrencyIdMap = new HashMap<Long, Long>(sqlParams_head.size());
        for (Object[] param_head : sqlParams_head) {
            if (!headIds.contains(param_head[FahXLAHeadField.FID.getIndex()])) continue;
            headIdAndCurrencyIdMap.put(Long.parseLong(param_head[FahXLAHeadField.FID.getIndex()].toString()), Long.parseLong(param_head[FahXLAHeadField.FLOC_CURRENCYID.getIndex()].toString()));
        }
        for (Object[] param_line : sqlParams_line) {
            Object headId = param_line[FahXLALineField.FID.getReadIndex()];
            Long currencyId = (Long)headIdAndCurrencyIdMap.get(headId);
            if (currencyId == null) continue;
        }
    }

    public static Boolean checkAcctPurpData(Long accountPurposeId, BuildVoucherReportInfoContext reportContext, Set<Long> eventIds) {
        if (accountPurposeId == 0L) {
            reportContext.genBatchErrorMessage(eventIds, GenerateXLAErrorCode.XLA_ACCTPURP_ERROR_STATUS);
            return false;
        }
        boolean exists = FahCheckXLADataDao.checkAcctPurpDataFromThreadCache((long)accountPurposeId);
        if (!exists) {
            reportContext.genBatchErrorMessage(eventIds, GenerateXLAErrorCode.XLA_ACCTPURP_ERROR_STATUS);
            return false;
        }
        return true;
    }

    public static Boolean checkAcctBook(XLAAccountBook acctBook, ISqlParamBuffer sqlParamBuffer, BuildVoucherReportInfoContext reportContext, Long eventId) {
        if (acctBook.getOrgId() == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTORG_ERROR_RULE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTORG_ERROR_RULE);
            return false;
        }
        if (acctBook.getCurrencyId() == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_CURRENCY.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_CURRENCY);
            return false;
        }
        boolean exists = FahCheckXLADataDao.checkCurrencyFromThreadCache((Long)acctBook.getCurrencyId());
        if (!exists) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_CURRENCY.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_CURRENCY);
            return false;
        }
        if (acctBook.getBookTypeId() == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_BOOKTYPE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_BOOKTYPE);
            return false;
        }
        if (acctBook.getAccountTableId() == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_ACCCTTABLE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_ACCCTTABLE);
            return false;
        }
        if (acctBook.getPeriodTypeId() == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_PERIODTYPE_ERROR_RULE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_PERIODTYPE_ERROR_RULE);
            return false;
        }
        if (acctBook.getRateTableId() == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_RATETABLE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_RATETABLE);
            return false;
        }
        return true;
    }

    public static boolean checkPeriodAndDate(Date bizDate, Date bookedDate, XLAPeriod period, ISqlParamBuffer sqlParamBuffer, BuildVoucherReportInfoContext reportContext, Long eventId) {
        if (bizDate == null) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTDATE_ERROR_BIZ_DATE.getErrorMessage());
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTDATE_ERROR_BIZ_DATE);
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            return false;
        }
        if (bookedDate == null) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_ACCTDATE_ERROR_RULE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTDATE_ERROR_RULE);
            return false;
        }
        if (period == null) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_PERIOD_ERROR_RULE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_PERIOD_ERROR_RULE);
            return false;
        }
        return true;
    }

    public static boolean checkOrgData(Long bizOrgId, BuildVoucherReportInfoContext reportContext, Long eventId) {
        if (bizOrgId == 0L) {
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTORG_ERROR_RULE);
            return false;
        }
        boolean exists = FahCheckXLADataDao.checkOrgDataFromThreadCache((Long)bizOrgId);
        if (!exists) {
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTORG_ERROR_NOTACCOUNTORG);
            return false;
        }
        return true;
    }

    public static boolean checkVoucherType(Object pre_voucherType, ISqlParamBuffer sqlParamBuffer, Long orgId, BuildVoucherReportInfoContext reportContext, Long eventId) {
        if (pre_voucherType == null || Long.parseLong(pre_voucherType.toString()) == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_VOUCHERTYPE_ERROR_RULE.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_VOUCHERTYPE_ERROR_RULE);
            return false;
        }
        boolean checkVoucherTypeByOrgId = FahCheckXLADataDao.checkVoucherTypeFromThreadCache((Long)Long.parseLong(pre_voucherType.toString()), (Long)orgId);
        if (!checkVoucherTypeByOrgId) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_VOUCHERTYPE_ERROR_STATUS.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_VOUCHERTYPE_ERROR_STATUS);
            return false;
        }
        return true;
    }

    public static void genBuildXLAResult(BaseInsertSqlBuilder xlaHeadData, BaseInsertSqlBuilder xlaLineData, BuildVoucherReportInfoContext reportContext, Set<Long> succIds, Set<Long> failIds, Set<Long> xlaHeadSuccIds) {
        Long eId;
        Object headId;
        List sqlParams_head = xlaHeadData.getSqlParams();
        List sqlParams_line = xlaLineData.getSqlParams();
        HashMap<Long, Long> headAndEventIdMap = new HashMap<Long, Long>(sqlParams_head.size());
        for (Object[] param_head : sqlParams_head) {
            headId = param_head[FahXLAHeadField.FID.getIndex()];
            Object eventId = param_head[FahXLAHeadField.FSRCEVENTID.getIndex()];
            if (headId == null || eventId == null) continue;
            eId = ObjectConverterFactory.getLong((Object)eventId);
            if ("1".equals(param_head[FahXLAHeadField.FISERROR.getIndex()])) {
                failIds.add(eId);
                continue;
            }
            succIds.add(eId);
            xlaHeadSuccIds.add(ObjectConverterFactory.getLong((Object)headId));
            headAndEventIdMap.put(ObjectConverterFactory.getLong((Object)headId), eId);
        }
        for (Object[] param_line : sqlParams_line) {
            headId = param_line[FahXLALineField.FID.getReadIndex()];
            Object eventLineId = param_line[FahXLALineField.FSRC_EVENTLINEID.getReadIndex()];
            if (headId == null || eventLineId == null || !"1".equals(param_line[FahXLALineField.FISERROR.getReadIndex()]) || !headAndEventIdMap.containsKey(headId)) continue;
            eId = ObjectConverterFactory.getLong(headAndEventIdMap.get(headId));
            succIds.remove(eId);
            failIds.add(eId);
        }
    }

    public static boolean checkCreator(ISqlParamBuffer sqlParamBuffer, BuildVoucherReportInfoContext reportContext, Long eventId) {
        Object creator = sqlParamBuffer.get(FahXLAHeadField.FCREATORID.getIndex());
        if (!(creator instanceof Number) || Long.parseLong(creator.toString()) == 0L) {
            sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)GenerateXLAErrorCode.XLA_CREATOR_ERROR_NULL.getErrorMessage());
            sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
            reportContext.genErrorMessage(eventId, GenerateXLAErrorCode.XLA_CREATOR_ERROR_NULL);
            return false;
        }
        return true;
    }
}

