/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.ai.util.BigdecimalUtil;
import kd.fi.v2.fah.dao.FahGenerateVoucherDataDao;
import kd.fi.v2.fah.event.mservice.context.GroupMergeDataContext;
import kd.fi.v2.fah.models.groupmerge.FahVoucherEntryGroupKey;
import kd.fi.v2.fah.models.groupmerge.GroupAndMergeRuleModel;
import kd.fi.v2.fah.models.groupmerge.RebuildFieldHandle;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.models.voucher.FahGLVoucherEntry;
import kd.fi.v2.fah.models.voucher.XLAVoucher;
import kd.fi.v2.fah.models.voucher.XLAVoucherEntry;
import kd.fi.v2.fah.voucherprocess.util.VoucherDataProcessUtil;

public class SingleVoucherMergeTashService {
    private List<XLAVoucher> srcData;
    private GroupAndMergeRuleModel mergeModel;
    private FahGLVoucher targetVoucher;
    private GroupMergeDataContext context;

    public SingleVoucherMergeTashService(List<XLAVoucher> srcData, GroupAndMergeRuleModel mergeModel, GroupMergeDataContext context) {
        this.srcData = srcData;
        this.mergeModel = mergeModel;
        this.context = context;
        this.doFirstMerge();
    }

    public FahGLVoucher doMerge() {
        if (this.targetVoucher == null) {
            return null;
        }
        BigDecimal creditSum = new BigDecimal(0);
        BigDecimal debitSum = new BigDecimal(0);
        RebuildFieldHandle handle = new RebuildFieldHandle(this.mergeModel.getParam());
        HashMap<FahVoucherEntryGroupKey, List> groupEntryMap = new HashMap<FahVoucherEntryGroupKey, List>(16);
        for (XLAVoucher data : this.srcData) {
            creditSum = creditSum.add(data.getCreditlocamount());
            debitSum = debitSum.add(data.getDebitlocamount());
            handle.rebuildCreator(data.getCreatorId(), new Object[0]);
            handle.rebuildAttment(data.getAttachment(), new Object[]{data.getSourceBillId(), data.getSrcEventId()});
            handle.rebuildBookedDate(data.getBookedDate(), new Object[]{data.getPeriodId()});
            handle.rebuildBizDate(data.getBizDate(), new Object[]{data.getPeriodId()});
            this.context.getTracker().putVoucherIdAndXlaIdMap(Long.valueOf(this.targetVoucher.getId()), Long.valueOf(data.getId()));
            List rows = data.getEntryRows();
            for (XLAVoucherEntry row : rows) {
                FahVoucherEntryGroupKey key = new FahVoucherEntryGroupKey(this.mergeModel, row);
                groupEntryMap.computeIfAbsent(key, v -> new ArrayList()).add(row);
            }
        }
        ArrayList<FahGLVoucherEntry> entryRows = new ArrayList<FahGLVoucherEntry>(16);
        int seq = 1;
        for (Map.Entry entrySet : groupEntryMap.entrySet()) {
            List mergeData = (List)entrySet.getValue();
            FahGLVoucherEntry entry = VoucherDataProcessUtil.mergeFahVoucherEntry(mergeData, this.targetVoucher, this.mergeModel, this.context);
            entry.setGrpKeyHash(Long.valueOf(Long.parseLong(String.valueOf(((FahVoucherEntryGroupKey)entrySet.getKey()).hashCode()))));
            entry.setSeq(seq++);
            if (BigdecimalUtil.isEquals((BigDecimal)entry.getLocalCredit().add(entry.getLocalDebit()), (BigDecimal)BigDecimal.ZERO) && BigdecimalUtil.isEquals((BigDecimal)entry.getQty(), (BigDecimal)BigDecimal.ZERO)) {
                if (!this.mergeModel.getIsClearZeroAmount().booleanValue()) {
                    entryRows.add(entry);
                    continue;
                }
                --seq;
                continue;
            }
            entryRows.add(entry);
        }
        this.targetVoucher.setCreditlocamount(creditSum);
        this.targetVoucher.setDebitlocamount(debitSum);
        if (handle.isRebuildCreator().booleanValue()) {
            this.targetVoucher.setCreatorId(handle.getCreatorId());
        }
        if (handle.isRebuildattment().booleanValue()) {
            this.targetVoucher.setAttachment(handle.getAttachment());
        }
        if (handle.isRebuildBookedDate().booleanValue()) {
            this.targetVoucher.setBookedDate(handle.getBookedDate());
        }
        if (handle.isRebuildBizDate().booleanValue()) {
            this.targetVoucher.setBizDate(handle.getBizDate());
        }
        this.targetVoucher.setEntryRows(entryRows);
        if (!this.targetVoucher.getZeroPushGL().booleanValue()) {
            this.context.getTracker().putNotPushVoucherIds_maybe(Long.valueOf(this.targetVoucher.getId()));
        }
        return this.targetVoucher;
    }

    private void doFirstMerge() {
        this.targetVoucher = new FahGLVoucher();
        if (this.srcData.isEmpty()) {
            return;
        }
        XLAVoucher vch = this.srcData.get(0);
        this.targetVoucher.setId(vch.getId());
        this.targetVoucher.setBookId(vch.getBookId());
        this.targetVoucher.setBooktypeId(vch.getBookTypeId());
        this.targetVoucher.setOrgId(vch.getOrgId());
        this.targetVoucher.setPeriodId(vch.getPeriodId());
        this.targetVoucher.setVchTypeId(vch.getVchTypeId());
        this.targetVoucher.setLocalcur(vch.getLocalCurrencyId());
        this.targetVoucher.setBillStatus("A");
        this.targetVoucher.setDescription(vch.getDescription());
        this.targetVoucher.setVdescription(vch.getDescription());
        this.targetVoucher.setBizDate(vch.getBizDate());
        this.targetVoucher.setBookedDate(vch.getBookedDate());
        this.targetVoucher.setCreatorId(vch.getCreatorId());
        this.targetVoucher.setCreateTime(vch.getCreateTime());
        this.targetVoucher.setModifierId(vch.getCreatorId());
        this.targetVoucher.setModifyTime(vch.getCreateTime());
        this.targetVoucher.setSourceBill(vch.getSourceBillType());
        this.targetVoucher.setSourceBillId(vch.getSourceBillId());
        this.targetVoucher.setSourceSys(FahGenerateVoucherDataDao.getBizappByNum((String)vch.getSourceBillType(), this.context.getBillNameAndsys()));
        this.targetVoucher.setSourceType("4");
        this.targetVoucher.setMergeKey(vch.getBillMergeField());
        this.targetVoucher.setSourcebillno(vch.getSourceBillNo());
        this.targetVoucher.setZeroPushGL(Boolean.valueOf(this.mergeModel.getIsClearZeroAmount() == false));
    }
}

