/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.dao.FahGroupMergeDataDao;
import kd.fi.v2.fah.models.context.GLTaskVoucherPushContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.sqlbuilder.CreateSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.voucherprocess.service.AbstractVoucherDataPushService;

public class GLPushVoucherDataService
extends AbstractVoucherDataPushService {
    private static final Log logger = LogFactory.getLog(GLPushVoucherDataService.class);

    public GLPushVoucherDataService(AbstractVoucherDataPushService next) {
        super(next);
    }

    public GLPushVoucherDataService() {
    }

    @Override
    public void doAction(ITaskVoucherPushContext context) {
        GLTaskVoucherPushContext glContext = (GLTaskVoucherPushContext)context;
        Map voucherIdMap = glContext.getTracker().getVoucherIdAndXlaIdMap();
        if (glContext.getHasSaveVoucherIds().isEmpty() && glContext.getNotPushVoucher().isEmpty()) {
            glContext.getInterFaceTableIds().forEach(f -> glContext.getReportContext().genBatchErrorMessage((Set)voucherIdMap.get(f), ""));
            return;
        }
        boolean hasRollBack = false;
        glContext.getInterFaceTableIds().stream().filter(f -> !glContext.getHasSaveVoucherIds().contains(f) && !glContext.getNotPushVoucher().contains(f)).forEach(f -> glContext.getReportContext().genBatchErrorMessage((Set)voucherIdMap.get(f), ""));
        try (TXHandle h = TX.requiresNew();){
            try {
                this.operationAndVoucherDeal(glContext);
                this.createTrackerInfo(glContext);
                if (glContext.isTransactionNeedRollback()) {
                    h.markRollback();
                    hasRollBack = true;
                }
            }
            catch (Exception e) {
                logger.error("--GenMergeGLVoucherDataServiceImpl--Exception: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                glContext.getReportContext().genStackErrorMessage(e);
                h.markRollback();
                throw e;
            }
        }
        if (glContext.isTransactionNeedRollback() && hasRollBack) {
            h = TX.requiresNew();
            var6_6 = null;
            try {
                try {
                    OperateOption operateOption = BuildVoucherUtils.createDeleteVoucherOpt();
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])glContext.getHasSaveVoucherIds().toArray(), (OperateOption)operateOption);
                }
                catch (Exception e) {
                    logger.info("--GenMergeGLVoucherDataServiceImpl--hasRollBackException: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (var6_6 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        glContext.getReportContext().taskToEnd();
    }

    private void createTrackerInfo(GLTaskVoucherPushContext glContext) {
        if (!glContext.isAllTaskStatus()) {
            return;
        }
        List successPkIds = glContext.getOpation().getSuccessPkIds();
        List notPushVoucher = glContext.getNotPushVoucher();
        this.createEvtTracker(successPkIds, glContext, true);
        this.createEvtTracker(notPushVoucher, glContext, false);
    }

    private void createEvtTracker(Collection<?> successPkIds, GLTaskVoucherPushContext glContext, boolean isPostToGL) {
        if (CollectionUtils.isEmpty(successPkIds)) {
            return;
        }
        Map voucherIdAndXlaIdMap = glContext.getTracker().getVoucherIdAndXlaIdMap();
        HashSet successXLAIds = new HashSet();
        successPkIds.forEach(f -> successXLAIds.addAll((Collection)voucherIdAndXlaIdMap.get(f)));
        if (CollectionUtils.isEmpty(successXLAIds)) {
            return;
        }
        BaseInsertSqlBuilder trackerHead = CreateSqlBuilder.createFahTrackerHead();
        BaseInsertSqlBuilder trackerLine = CreateSqlBuilder.createFahTrackerLine();
        if (successXLAIds.size() > 100000) {
            List idsBatch = DapBuildVoucherCommonUtil.splitSet(successXLAIds, (int)10000);
            idsBatch.forEach(f -> FahGroupMergeDataDao.createEvtTracker((BaseInsertSqlBuilder)trackerHead, (BaseInsertSqlBuilder)trackerLine, (Set)f, (GLTaskVoucherPushContext)glContext, (boolean)isPostToGL));
        } else {
            FahGroupMergeDataDao.createEvtTracker((BaseInsertSqlBuilder)trackerHead, (BaseInsertSqlBuilder)trackerLine, successXLAIds, (GLTaskVoucherPushContext)glContext, (boolean)isPostToGL);
        }
        FahGroupMergeDataDao.saveTrackerData((BaseInsertSqlBuilder)trackerHead, (BaseInsertSqlBuilder)trackerLine);
    }

    private void operationAndVoucherDeal(GLTaskVoucherPushContext glContext) {
        Set hasSaveTempVoucherIds = glContext.getHasSaveVoucherIds();
        if (CollectionUtils.isEmpty((Collection)hasSaveTempVoucherIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isdap", "true");
        option.setVariableValue("isFirstOperation", "true");
        long start = System.currentTimeMillis();
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"gl_voucher", (Object[])hasSaveTempVoucherIds.toArray(), (OperateOption)option);
        glContext.setOpation(submitResult);
        long end = System.currentTimeMillis();
        String msg = String.format("buildEventData_GLPushVoucherDataService_operationAndVoucherDeal cost: %d ms, hasSaveTempVoucherIds.size: %d, submitResult: %s", end - start, hasSaveTempVoucherIds.size(), DebugTrace.enable() ? submitResult : Integer.valueOf(submitResult.getSuccessPkIds().size()));
        this.addLogDetail(msg, logger, (ITaskVoucherPushContext)glContext);
        List allErrorOrValidateInfo = submitResult.getAllErrorOrValidateInfo();
        if (!allErrorOrValidateInfo.isEmpty()) {
            Map voucherIdMap = glContext.getTracker().getVoucherIdAndXlaIdMap();
            this.deleteFailVoucher(glContext, submitResult);
            allErrorOrValidateInfo.forEach(f -> glContext.getReportContext().genBatchErrorMessage((Set)voucherIdMap.get(f.getPkValue()), f.getMessage()));
            if (submitResult.getSuccessPkIds().isEmpty()) {
                glContext.setAllTaskStatus(false);
                this.currBatchVoucherAllError(glContext, submitResult);
                return;
            }
            boolean hasMergeMatch = allErrorOrValidateInfo.stream().anyMatch(f -> ((Set)voucherIdMap.get(f.getPkValue())).size() > 1);
            if (!hasMergeMatch) {
                HashSet srcIds = new HashSet(allErrorOrValidateInfo.size());
                allErrorOrValidateInfo.stream().forEach(f -> srcIds.addAll((Collection)voucherIdMap.get(f.getPkValue())));
                boolean bl = hasMergeMatch = !FahGroupMergeDataDao.queryAndCheckOneToOneMerge(srcIds);
            }
            if (hasMergeMatch) {
                glContext.setAllTaskStatus(false);
                this.currBatchVoucherAllError(glContext, submitResult);
            }
        }
    }

    private void deleteFailVoucher(GLTaskVoucherPushContext context, OperationResult submitResult) {
        List data = submitResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).collect(Collectors.toList());
        if (!data.isEmpty()) {
            OperateOption operateOption = BuildVoucherUtils.createDeleteVoucherOpt();
            operateOption.setVariableValue("isFirstOperation", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])data.toArray(), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                context.setTransactionNeedRollback(true);
            }
        }
    }

    private void currBatchVoucherAllError(GLTaskVoucherPushContext context, OperationResult submitResult) {
        if (!submitResult.getSuccessPkIds().isEmpty()) {
            OperateOption operateOption = BuildVoucherUtils.createDeleteVoucherOpt();
            operateOption.setVariableValue("isFirstOperation", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                context.setTransactionNeedRollback(true);
            }
        }
    }

    @Override
    public void pollingTask(ITaskVoucherPushContext context) {
    }
}

