/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.util.DateUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.dao.FahGenerateVoucherDataDao;
import kd.fi.v2.fah.models.context.GLTaskVoucherPushContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.voucherprocess.service.AbstractVoucherDataPushService;

public class GLTransVoucherDataService
extends AbstractVoucherDataPushService {
    private static final Log logger = LogFactory.getLog(GLTransVoucherDataService.class);

    public GLTransVoucherDataService(AbstractVoucherDataPushService next) {
        super(next);
    }

    public GLTransVoucherDataService() {
    }

    @Override
    public void doAction(ITaskVoucherPushContext context) {
        List currBatchSrcVoucher = context.getCurrBatchSrcVoucher();
        if (currBatchSrcVoucher.isEmpty()) {
            return;
        }
        List<DynamicObject> voucherCol = currBatchSrcVoucher.stream().map(m -> m.toGLVoucherDynamicObject("gl_voucher")).collect(Collectors.toList());
        Map voucherno = FahGenerateVoucherDataDao.genVoucherno(voucherCol);
        boolean dateTruncate = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.GLTransVoucherDataService.dateTruncate", (String)"true"));
        for (DynamicObject vch : voucherCol) {
            Long vid = vch.getLong("id");
            String billno = (String)voucherno.get(vid);
            vch.set("billno", (Object)billno);
            if (!dateTruncate) continue;
            vch.set("bizdate", (Object)DateUtil.dateTruncate_YYYY_MM_DD((Date)vch.getDate("bizdate")));
            vch.set("bookeddate", (Object)DateUtil.dateTruncate_YYYY_MM_DD((Date)vch.getDate("bookeddate")));
        }
        long start = System.currentTimeMillis();
        Object[] vouchers = null;
        boolean useRequiresNew = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.GLTransVoucherDataService.useRequiresNew", (String)"true"));
        try (TXHandle x = TX.requiresNew();){
            try {
                vouchers = SaveServiceHelper.save((DynamicObject[])voucherCol.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                logger.error("#handleOperation\u4fdd\u5b58\u51ed\u8bc1\u8fdb\u5165\u6570\u636e\u5e93\u5931\u8d25");
                logger.error(e);
                x.markRollback();
                throw e;
            }
        }
        GLTaskVoucherPushContext glContext = (GLTaskVoucherPushContext)context;
        int vchHeadSaveSuccessCount = vouchers.length;
        int vchLineSaveSuccessCount = 0;
        for (Object voucher : vouchers) {
            DynamicObject vch = (DynamicObject)voucher;
            vchLineSaveSuccessCount += vch.getDynamicObjectCollection("entries").size();
            glContext.getHasSaveVoucherIds().add(vch.getLong("id"));
        }
        glContext.getCurrBatchSrcVoucher().clear();
        long end = System.currentTimeMillis();
        String saveTmpGlVoucherMsg = String.format("----FAH----saveTmpGlVoucher_SaveServiceHelper.save, useRequiresNew: %b, vchHeadSaveSuccessCount: %d, vchLineSaveSuccessCount: %d, cost: %d ms", useRequiresNew, vchHeadSaveSuccessCount, vchLineSaveSuccessCount, end - start);
        this.addLogDetail(saveTmpGlVoucherMsg, logger, context);
    }

    @Override
    public void pollingTask(ITaskVoucherPushContext context) {
    }
}

