/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.util.DateUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.dao.FahGenerateVoucherDataDao;
import kd.fi.v2.fah.models.context.GLTaskVoucherPushContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.sqlbuilder.CreateSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.voucherprocess.service.AbstractVoucherDataPushService;

public class GLTransVoucherDataService2
extends AbstractVoucherDataPushService {
    private static final Log logger = LogFactory.getLog(GLTransVoucherDataService2.class);

    public GLTransVoucherDataService2(AbstractVoucherDataPushService next) {
        super(next);
    }

    public GLTransVoucherDataService2() {
    }

    @Override
    public void doAction(ITaskVoucherPushContext context) {
        int vchLineSaveSuccessCount;
        int vchHeadSaveSuccessCount;
        if (context.getCurrBatchSrcVoucher().isEmpty()) {
            return;
        }
        List voucherCol = context.getCurrBatchSrcVoucher().stream().map(m -> m.toGLVoucherDynamicObject("gl_voucher")).collect(Collectors.toList());
        List currBatchSrcVoucher = context.getCurrBatchSrcVoucher();
        Map voucherno = FahGenerateVoucherDataDao.genVoucherno(voucherCol);
        for (Object vch : voucherCol) {
            Long vid = vch.getLong("id");
            String billno = (String)voucherno.get(vid);
            vch.set("billno", (Object)billno);
        }
        boolean dateTruncate = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.GLTransVoucherDataService.dateTruncate", (String)"true"));
        for (FahGLVoucher fahGLVoucher : currBatchSrcVoucher) {
            fahGLVoucher.setNumber((String)voucherno.get(fahGLVoucher.getId()));
            if (!dateTruncate) continue;
            fahGLVoucher.setBizDate(DateUtil.dateTruncate_YYYY_MM_DD((Date)fahGLVoucher.getBizDate()));
            fahGLVoucher.setBookedDate(DateUtil.dateTruncate_YYYY_MM_DD((Date)fahGLVoucher.getBookedDate()));
        }
        long start = System.currentTimeMillis();
        BaseInsertSqlBuilder glVoucherHeadSqlBuilder = CreateSqlBuilder.createGlVoucherHead();
        BaseInsertSqlBuilder glVoucherLineSqlBuilder = CreateSqlBuilder.createGLVoucherLine();
        for (FahGLVoucher voucher : currBatchSrcVoucher) {
            voucher.appendVoucherData(glVoucherHeadSqlBuilder, null);
            voucher.getEntryRows().forEach(f -> f.appendVoucherData(glVoucherLineSqlBuilder));
        }
        boolean useRequiresNew = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.GLTransVoucherDataService.useRequiresNew", (String)"true"));
        try (TXHandle x = useRequiresNew ? TX.requiresNew() : TX.required();){
            try {
                int[] headInsertResult = BaseFlexFieldDao.doInsert((IInsertSqlBuilder)glVoucherHeadSqlBuilder);
                int[] lineInsertResult = BaseFlexFieldDao.doInsert((IInsertSqlBuilder)glVoucherLineSqlBuilder);
                vchHeadSaveSuccessCount = headInsertResult.length;
                vchLineSaveSuccessCount = lineInsertResult.length;
            }
            catch (Throwable e) {
                logger.error("#handleOperation save temp gl voucher err", e);
                x.markRollback();
                throw e;
            }
        }
        long end = System.currentTimeMillis();
        String saveTmpGlVoucherMsg = String.format("----FAH----saveTmpGlVoucher_sqlBuilder_insert, useRequiresNew: %b, vchHeadSaveSuccessCount: %d, vchLineSaveSuccessCount: %d, cost: %d ms", useRequiresNew, vchHeadSaveSuccessCount, vchLineSaveSuccessCount, end - start);
        this.addLogDetail(saveTmpGlVoucherMsg, logger, context);
        GLTaskVoucherPushContext glContext = (GLTaskVoucherPushContext)context;
        for (FahGLVoucher voucher : currBatchSrcVoucher) {
            glContext.getHasSaveVoucherIds().add(voucher.getId());
        }
        glContext.getCurrBatchSrcVoucher().clear();
    }

    @Override
    public void pollingTask(ITaskVoucherPushContext context) {
    }
}

