/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service.impl;

import java.util.LinkedList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.dao.FahGroupMergeDataDao;
import kd.fi.v2.fah.models.context.GLTaskVoucherPushContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.voucherprocess.service.AbstractVoucherDataPushService;
import kd.fi.v2.fah.voucherprocess.service.IVoucherDataPushService;
import kd.fi.v2.fah.voucherprocess.service.impl.GLPushVoucherDataService;
import kd.fi.v2.fah.voucherprocess.service.impl.GLResultDealService;
import kd.fi.v2.fah.voucherprocess.service.impl.GLTransVoucherDataService;
import kd.fi.v2.fah.voucherprocess.service.impl.GLTransVoucherDataService2;
import kd.fi.v2.fah.voucherprocess.service.impl.GLValidateVoucherDataService;
import kd.fi.v2.fah.voucherprocess.service.impl.VoucherDataLoadService;

public class GLVoucherDataPushServiceImpl
implements IVoucherDataPushService {
    private static final Log log = LogFactory.getLog(GLVoucherDataPushServiceImpl.class);
    private final GLTaskVoucherPushContext context;

    public GLVoucherDataPushServiceImpl(GLTaskVoucherPushContext context) {
        this.context = context;
    }

    @Override
    public void pushVoucher() {
        long serviceTime;
        this.addLogDetail(this.getClass().getName() + ": pushVoucher start");
        if (!FahGroupMergeDataDao.checkContext((GLTaskVoucherPushContext)this.context).booleanValue()) {
            return;
        }
        if (this.context.getNextBatchIds().size() > 10000) {
            // empty if block
        }
        long totalTime = System.currentTimeMillis();
        int totalServiceCnt = 0;
        LinkedList<AbstractVoucherDataPushService> genDataExcuteChain = new LinkedList<AbstractVoucherDataPushService>();
        genDataExcuteChain.add(new VoucherDataLoadService());
        genDataExcuteChain.add(new GLValidateVoucherDataService());
        if (Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.GLTransVoucherDataService.version.new", (String)"false"))) {
            genDataExcuteChain.add(new GLTransVoucherDataService2());
        } else {
            genDataExcuteChain.add(new GLTransVoucherDataService());
        }
        while (!this.context.getNextBatchIds().isEmpty()) {
            for (AbstractVoucherDataPushService abstractVoucherDataPushService : genDataExcuteChain) {
                serviceTime = System.currentTimeMillis();
                abstractVoucherDataPushService.doPushData((ITaskVoucherPushContext)this.context);
                String GenDataMsg = String.format("[GenData] Execute Service %s : timecost=%dms, ServiceCnt: %d", abstractVoucherDataPushService.getClass().getSimpleName(), System.currentTimeMillis() - serviceTime, ++totalServiceCnt);
                this.addLogDetail(GenDataMsg);
            }
        }
        LinkedList<AbstractVoucherDataPushService> pushDataExcuteChain = new LinkedList<AbstractVoucherDataPushService>();
        pushDataExcuteChain.add(new GLPushVoucherDataService());
        pushDataExcuteChain.add(new GLResultDealService());
        for (AbstractVoucherDataPushService service : pushDataExcuteChain) {
            serviceTime = System.currentTimeMillis();
            service.doPushData((ITaskVoucherPushContext)this.context);
            String PushDataMsg = String.format("[PushData] Execute Service %s : timecost=%dms, ServiceCnt: %d", service.getClass().getSimpleName(), System.currentTimeMillis() - serviceTime, ++totalServiceCnt);
            this.addLogDetail(PushDataMsg);
        }
        String string = String.format("Execute Service [%d]: Total TimeCost=%dms", totalServiceCnt, System.currentTimeMillis() - totalTime);
        this.addLogDetail(string);
    }

    private void addLogDetail(String msg) {
        log.info(msg);
        if (null != this.context.getFahJobContext()) {
            this.context.getFahJobContext().getFahBgTaskLogger().addDetailEntry(msg);
        }
    }
}

