/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.Currency;
import kd.fi.ai.ExchangeRate;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.ExchangeRateUtil;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.v2.fah.dao.FahCheckXLADataDao;
import kd.fi.v2.fah.dao.FahGenerateVoucherDataDao;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.dao.FahGroupMergeDataDao;
import kd.fi.v2.fah.event.mservice.context.GroupMergeDataContext;
import kd.fi.v2.fah.models.groupmerge.GroupAndMergeRuleModel;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.models.voucher.FahGLVoucherEntry;
import kd.fi.v2.fah.models.voucher.XLAVoucher;
import kd.fi.v2.fah.models.voucher.XLAVoucherEntry;
import kd.fi.v2.fah.models.xla.XLAAccount;
import kd.fi.v2.fah.models.xla.XLAAccountBook;
import kd.fi.v2.fah.models.xla.XLACashFlowItem;

public class VoucherDataProcessUtil {
    public static FahGLVoucherEntry mergeFahVoucherEntry(List<XLAVoucherEntry> mergeData, FahGLVoucher voucherHead, GroupAndMergeRuleModel mergeModel, GroupMergeDataContext context) {
        FahGLVoucherEntry result = new FahGLVoucherEntry();
        if (mergeData.isEmpty() || mergeModel == null) {
            return result;
        }
        VoucherDataProcessUtil.doFirstEntryMerge(result, mergeData.get(0), voucherHead, context);
        BigDecimal localAmount = new BigDecimal(0);
        BigDecimal oriAmount = new BigDecimal(0);
        BigDecimal qty = new BigDecimal(0);
        BitSet reCalField = mergeModel.getGroupDimensionAndReCalField();
        if (reCalField.get(6)) {
            result.setDcDirectory(1);
        }
        for (XLAVoucherEntry data : mergeData) {
            localAmount = localAmount.add(data.getDcDirectory() == 1 ? data.getLocalDebit() : (reCalField.get(6) ? data.getLocalCredit().negate() : data.getLocalCredit()));
            oriAmount = oriAmount.add(data.getDcDirectory() == 1 ? data.getOriDebit() : (reCalField.get(6) ? data.getOriCredit().negate() : data.getOriCredit()));
            qty = qty.add(data.getQty());
            context.getTracker().putVchEntryIDAndXlaEntryIdMap(Long.valueOf(result.getEntryId()), Long.valueOf(data.getEntryId()));
        }
        if (result.getDcDirectory() == -1) {
            result.setLocalCredit(localAmount);
            result.setOriCredit(oriAmount);
        } else {
            result.setLocalDebit(localAmount);
            result.setOriDebit(oriAmount);
        }
        result.setQty(qty);
        if (reCalField.get(4)) {
            BigDecimal rate = VoucherDataProcessUtil.rebuildRate(localAmount, oriAmount, result.getOriCurrencyId(), voucherHead.getLocalcur(), context, voucherHead.getBookId(), voucherHead.getBookedDate());
            result.setLocalExchangeRate(rate);
        }
        if (reCalField.get(5)) {
            BigDecimal price = VoucherDataProcessUtil.rebuildPrice(qty, oriAmount, result.getOriCurrencyId(), context);
            result.setPrice(price);
        }
        VoucherDataProcessUtil.rebuildMainAndSupItemAmount(result, context, voucherHead.getOrgId(), voucherHead.getBookedDate());
        return result;
    }

    public static FahGLVoucherEntry mergeFahVoucherEntry(List<FahGLVoucherEntry> mergeData, GroupAndMergeRuleModel mergeModel, GroupMergeDataContext context, Long mergeId) {
        FahGLVoucherEntry result = new FahGLVoucherEntry();
        if (mergeData.isEmpty() || mergeModel == null) {
            return result;
        }
        result = mergeData.get(0);
        result.setId(mergeId.longValue());
        BigDecimal localAmount = new BigDecimal(0);
        BigDecimal oriAmount = new BigDecimal(0);
        BigDecimal qty = new BigDecimal(0);
        BitSet reCalField = mergeModel.getGroupDimensionAndReCalField();
        if (reCalField.get(6)) {
            result.setDcDirectory(1);
        }
        HashSet newIds = new HashSet();
        for (FahGLVoucherEntry data : mergeData) {
            localAmount = localAmount.add(data.getDcDirectory() == 1 ? data.getLocalDebit() : (reCalField.get(6) ? data.getLocalCredit().negate() : data.getLocalCredit()));
            oriAmount = oriAmount.add(data.getDcDirectory() == 1 ? data.getOriDebit() : (reCalField.get(6) ? data.getOriCredit().negate() : data.getOriCredit()));
            qty = qty.add(data.getQty());
            Set currIds = (Set)context.getTracker().getVchEntryIDAndXlaEntryIdMap().get(data.getEntryId());
            newIds.addAll(currIds);
            context.getTracker().getVchEntryIDAndXlaEntryIdMap().remove(data.getEntryId());
        }
        Object[] value = context.getHeadKeyValueCache().get(result.getId());
        if (value == null) {
            value = FahGroupMergeDataDao.getFahHeadKeyValueInfo((Long)result.getId());
            context.getHeadKeyValueCache().put(result.getId(), value);
        }
        if (result.getDcDirectory() == 1) {
            result.setLocalCredit(localAmount);
            result.setOriCredit(oriAmount);
        } else {
            result.setLocalDebit(localAmount);
            result.setOriDebit(oriAmount);
        }
        result.setQty(qty);
        if (reCalField.get(4)) {
            BigDecimal rate = VoucherDataProcessUtil.rebuildRate(localAmount, oriAmount, result.getOriCurrencyId(), Long.parseLong(value[1].toString()), context, Long.parseLong(value[2].toString()), (Date)value[3]);
            result.setLocalExchangeRate(rate);
        }
        if (reCalField.get(5)) {
            BigDecimal price = VoucherDataProcessUtil.rebuildPrice(qty, oriAmount, result.getOriCurrencyId(), context);
            result.setPrice(price);
        }
        VoucherDataProcessUtil.rebuildMainAndSupItemAmount(result, context, Long.parseLong(value[0].toString()), (Date)value[3]);
        context.getTracker().getVchEntryIDAndXlaEntryIdMap().put(result.getEntryId(), newIds);
        return result;
    }

    private static void rebuildMainAndSupItemAmount(FahGLVoucherEntry entry, GroupMergeDataContext context, Long orgId, Date bookedDate) {
        boolean isLocalSet = CashflowLocalSetUtil.isLocalSetThread((long)orgId, (Date)bookedDate);
        if (entry.getMaincfitemID() != 0L) {
            XLACashFlowItem cashFlowItem;
            if (!context.getCashFlowCache().containsKey(entry.getMaincfitemID())) {
                HashSet<Long> ids = new HashSet<Long>(1);
                ids.add(entry.getMaincfitemID());
                FahCheckXLADataDao.queryMainItemInfo(ids, context.getCashFlowCache());
            }
            BigDecimal cfDC = "o".equals((cashFlowItem = context.getCashFlowCache().get(entry.getMaincfitemID())).getDirection()) ? BigDecimal.ONE.negate() : BigDecimal.ONE;
            BigDecimal mainfcamount = BigDecimal.ZERO;
            BigDecimal localAmount = entry.getLocalCredit().add(entry.getLocalDebit());
            mainfcamount = entry.getDcDirectory() == 1 ? localAmount.negate().multiply(cfDC) : localAmount.multiply(cfDC);
            entry.setMaincfamount(isLocalSet ? mainfcamount.negate() : mainfcamount);
        }
        if (entry.getSupcfitemID() != 0L) {
            BigDecimal supCfAmount;
            XLAAccount account;
            Long accountId = entry.getAccountId();
            if (!context.getAccountCache().containsKey(accountId)) {
                HashSet<Long> ids = new HashSet<Long>(1);
                ids.add(accountId);
                FahCheckXLADataDao.queryAccountInfo(ids, context.getAccountCache());
            }
            if ((account = context.getAccountCache().get(accountId)).isProfitAndLoss()) {
                supCfAmount = entry.getLocalDebit().subtract(entry.getLocalCredit());
                entry.setSupcfamount(supCfAmount);
            } else if (entry.getMaincfitemID() == 0L) {
                supCfAmount = entry.getLocalCredit().subtract(entry.getLocalDebit());
                entry.setSupcfamount(supCfAmount);
            } else {
                BigDecimal supCfAmount2;
                XLACashFlowItem cashFlowItem;
                if (!context.getCashFlowCache().containsKey(entry.getMaincfitemID())) {
                    HashSet<Long> ids = new HashSet<Long>(1);
                    ids.add(entry.getMaincfitemID());
                    FahCheckXLADataDao.queryMainItemInfo(ids, context.getCashFlowCache());
                }
                if ((cashFlowItem = context.getCashFlowCache().get(entry.getMaincfitemID())) != null) {
                    supCfAmount2 = "o".equals(cashFlowItem.getDirection()) ? entry.getMaincfamount().negate() : entry.getMaincfamount();
                    entry.setSupcfamount(supCfAmount2);
                } else {
                    supCfAmount2 = entry.getLocalCredit().subtract(entry.getLocalDebit());
                    entry.setSupcfamount(supCfAmount2);
                }
            }
        }
    }

    private static BigDecimal rebuildPrice(BigDecimal qty, BigDecimal oriAmount, Long oriCurrencyId, GroupMergeDataContext context) {
        if (qty.compareTo(BigDecimal.ZERO) == 0 || oriAmount.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        Currency currency = new Currency();
        if (context.getCurrencyCache().containsKey(oriCurrencyId)) {
            currency = context.getCurrencyCache().get(oriCurrencyId);
        } else {
            DynamicObject cy = BusinessDataServiceHelper.loadSingleFromCache((Object)oriCurrencyId, (String)"bd_currency", (String)"id,amtprecision,priceprecision");
            if (cy != null) {
                currency.setId(oriCurrencyId.longValue());
                currency.setAmtprecision(cy.getInt("amtprecision"));
                currency.setPriceprecision(cy.getInt("priceprecision"));
                context.getCurrencyCache().put(oriCurrencyId, currency);
            }
        }
        BigDecimal price = oriAmount.divide(qty, currency.getPriceprecision() == 0 ? 4 : currency.getPriceprecision(), RoundingMode.HALF_UP);
        return price;
    }

    private static BigDecimal rebuildRate(BigDecimal localAmount, BigDecimal oriAmount, Long oriCurrencyId, Long localCurrencyId, GroupMergeDataContext context, Long bookId, Date bookedDate) {
        if (localAmount.compareTo(BigDecimal.ZERO) == 0 || oriAmount.compareTo(BigDecimal.ZERO) == 0 || oriCurrencyId == 0L || localCurrencyId == 0L) {
            return new BigDecimal(1);
        }
        Long exchangeTableId = 0L;
        if (context.getBookCache().containsKey(bookId)) {
            exchangeTableId = context.getBookCache().get(bookId).getRateTableId();
        } else {
            XLAAccountBook acctBook = FahGenerateXLADataDao.getAcctBook((Long)bookId);
            exchangeTableId = acctBook.getRateTableId();
            context.getBookCache().put(bookId, acctBook);
        }
        StringBuilder key = new StringBuilder();
        key.append(exchangeTableId).append(oriCurrencyId).append(localCurrencyId).append(bookedDate.getTime());
        ExchangeRate exchangeRate = new ExchangeRate();
        if (context.getRateCache().containsKey(key.toString())) {
            exchangeRate = context.getRateCache().get(key.toString());
        } else {
            exchangeRate = ExchangeRateUtil.getNewExchangeRateEntity((Long)exchangeTableId, (Long)oriCurrencyId, (Long)localCurrencyId, (Date)bookedDate);
            context.getRateCache().put(key.toString(), exchangeRate);
        }
        BigDecimal calRate = exchangeRate.getRateType().getRateCalculator().calRate(oriAmount, localAmount, exchangeRate.getPrecision().intValue());
        calRate = calRate != null ? calRate : new BigDecimal(0);
        return calRate;
    }

    private static void doFirstEntryMerge(FahGLVoucherEntry entry, XLAVoucherEntry xlaEntry, FahGLVoucher voucherHead, GroupMergeDataContext context) {
        entry.setAccountId(xlaEntry.getAccountId());
        entry.setAssgrpId(xlaEntry.getAssgrpId());
        entry.setBusinessNum(xlaEntry.getBusinessnum());
        entry.setDcDirectory(xlaEntry.getDcDirectory());
        entry.setDescription(xlaEntry.getDescription());
        entry.setEntryId(xlaEntry.getEntryId());
        entry.setExpireDate(xlaEntry.getExpireDate());
        entry.setForgid(xlaEntry.getOrgId().longValue());
        entry.setFperiodid(xlaEntry.getPeriodId().longValue());
        entry.setId(voucherHead.getId());
        entry.setLocalCredit(new BigDecimal(0));
        entry.setLocalDebit(new BigDecimal(0));
        entry.setMaincfamount(new BigDecimal(0));
        entry.setOriDebit(new BigDecimal(0));
        entry.setOriCredit(new BigDecimal(0));
        entry.setSupcfamount(new BigDecimal(0));
        entry.setLocalExchangeRate(xlaEntry.getLocalExchangeRate());
        entry.setMaincfassgrp(xlaEntry.getMaincfassgrp());
        entry.setMaincfitemID(xlaEntry.getMaincfitemID());
        entry.setOriCurrencyId(xlaEntry.getOriCurrencyId());
        entry.setPrice(xlaEntry.getPrice());
        entry.setQty(new BigDecimal(0));
        entry.setSourceBillNo(xlaEntry.getSrcBillno());
        entry.setSupcfitemID(xlaEntry.getSupcfitemID());
        entry.setUnitId(xlaEntry.getUnitId());
        entry.setLineTypeId(Long.valueOf(xlaEntry.getLineTypeId()));
        entry.setMerge(xlaEntry.isNeedMerge());
    }

    public static Map<Long, List<List<Long>>> intelligentBatchTask(List<Long> ids, List<Long> bigEntryIds, int bigEntrySize) {
        HashMap<Long, List<List<Long>>> splitData = new HashMap<Long, List<List<Long>>>();
        if (ids.isEmpty()) {
            return splitData;
        }
        Map xlaBaseInfo = FahGroupMergeDataDao.queryXLABaseInfo(ids, (int)bigEntrySize, bigEntryIds);
        if (xlaBaseInfo.isEmpty()) {
            return splitData;
        }
        xlaBaseInfo.entrySet().forEach(f -> {
            Long key = (Long)f.getKey();
            Tuple value = (Tuple)f.getValue();
            List data = splitData.computeIfAbsent(key, v -> new ArrayList());
            List splitbatch = DapBuildVoucherCommonUtil.splitbatch((List)((List)value.item1), (int)1000);
            data.addAll(splitbatch);
            data.addAll((Collection)value.item2);
        });
        return splitData;
    }

    public static List<List<Long>> intelligentBatchTask(Map<Long, Integer> entrySize, Map<Long, List<Long>> needMergeIds, int maxSize, List<Object[]> updateParam) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        ArrayList needRemoveIds = new ArrayList(8);
        for (Map.Entry<Long, Integer> entry : entrySize.entrySet()) {
            if ((Integer)entry.getValue() <= maxSize) continue;
            needRemoveIds.addAll(needMergeIds.entrySet().stream().filter(f -> ((List)f.getValue()).contains(entry.getKey())).map(m -> (Long)m.getKey()).collect(Collectors.toList()));
        }
        for (Long removeId : needRemoveIds) {
            List<Long> value = needMergeIds.remove(removeId);
            value.forEach(f -> updateParam.add(new Object[]{removeId, f}));
        }
        if (needMergeIds.isEmpty()) {
            return result;
        }
        HashMap mergeEntrySize = new HashMap(needMergeIds.size());
        needMergeIds.entrySet().stream().forEach(f -> {
            int sum_entrysize = 0;
            for (Long id : (List)f.getValue()) {
                sum_entrysize += ((Integer)entrySize.get(id)).intValue();
            }
            mergeEntrySize.put(f.getKey(), sum_entrysize);
        });
        int currSumSize = 0;
        ArrayList currBatchIds = new ArrayList();
        for (Map.Entry entrySet : mergeEntrySize.entrySet()) {
            Long key = (Long)entrySet.getKey();
            int value = (Integer)entrySet.getValue();
            if (value > 2 * maxSize) {
                result.add(needMergeIds.get(key).stream().collect(Collectors.toList()));
                continue;
            }
            currBatchIds.addAll(needMergeIds.get(key));
            if ((currSumSize += value) <= 2 * maxSize) continue;
            result.add(new ArrayList(currBatchIds));
            currSumSize = 0;
            currBatchIds.clear();
        }
        return result;
    }

    public static void oneToMergeVoucher(List<FahGLVoucher> voucherResult, List<XLAVoucher> dataSource, GroupMergeDataContext context) {
        if (dataSource.isEmpty()) {
            return;
        }
        for (XLAVoucher data : dataSource) {
            FahGLVoucher newVoucher = new FahGLVoucher();
            newVoucher.setAttachment(data.getAttachment());
            newVoucher.setBillStatus("A");
            newVoucher.setBizDate(data.getBizDate());
            newVoucher.setBookedDate(data.getBookedDate());
            newVoucher.setBookId(data.getBookId());
            newVoucher.setBooktypeId(data.getBookTypeId());
            newVoucher.setCreateTime(data.getCreateTime());
            newVoucher.setCreatorId(data.getCreatorId());
            newVoucher.setCreditlocamount(data.getCreditlocamount());
            newVoucher.setDebitlocamount(data.getDebitlocamount());
            newVoucher.setDescription(data.getDescription());
            newVoucher.setId(data.getId());
            newVoucher.setLocalcur(data.getLocalCurrencyId());
            newVoucher.setMergeKey(data.getBillMergeField());
            newVoucher.setModifierId(data.getCreatorId());
            newVoucher.setModifyTime(data.getCreateTime());
            newVoucher.setOrgId(data.getOrgId());
            newVoucher.setPeriodId(data.getPeriodId());
            newVoucher.setSourceBill(data.getSourceBillType());
            newVoucher.setSourceBillId(data.getSourceBillId());
            newVoucher.setSourceSys(FahGenerateVoucherDataDao.getBizappByNum((String)data.getSourceBillType(), context.getBillNameAndsys()));
            newVoucher.setSourceType("4");
            newVoucher.setVchTypeId(data.getVchTypeId());
            newVoucher.setVdescription(data.getDescription());
            newVoucher.setSourcebillno(data.getSourceBillNo());
            newVoucher.setGrpKeyHashCode(Long.valueOf(Long.parseLong(String.valueOf(data.hashCode()))));
            ArrayList<FahGLVoucherEntry> entryRows = new ArrayList<FahGLVoucherEntry>(data.getEntryRows().size());
            for (XLAVoucherEntry entry : data.getEntryRows()) {
                FahGLVoucherEntry newEntry = new FahGLVoucherEntry();
                newEntry.setAccountId(entry.getAccountId());
                newEntry.setAssgrpId(entry.getAssgrpId());
                newEntry.setBusinessNum(entry.getBusinessnum());
                newEntry.setDcDirectory(entry.getDcDirectory());
                newEntry.setDescription(entry.getDescription());
                newEntry.setEntryId(entry.getEntryId());
                newEntry.setExpireDate(entry.getExpireDate());
                newEntry.setForgid(entry.getOrgId().longValue());
                newEntry.setFperiodid(entry.getPeriodId().longValue());
                newEntry.setId(entry.getId());
                newEntry.setLocalCredit(entry.getLocalCredit());
                newEntry.setLocalDebit(entry.getLocalDebit());
                newEntry.setLocalExchangeRate(entry.getLocalExchangeRate());
                newEntry.setMaincfamount(entry.getMaincfamount());
                newEntry.setMaincfassgrp(entry.getMaincfassgrp());
                newEntry.setMaincfitemID(entry.getMaincfitemID());
                newEntry.setOriCredit(entry.getOriCredit());
                newEntry.setOriCurrencyId(entry.getOriCurrencyId());
                newEntry.setOriDebit(entry.getOriDebit());
                newEntry.setPrice(entry.getPrice());
                newEntry.setQty(entry.getPrice());
                newEntry.setSeq(entry.getSeq());
                newEntry.setSourceBillNo(entry.getSrcBillno());
                newEntry.setSupcfamount(entry.getSupcfamount());
                newEntry.setSupcfitemID(entry.getSupcfitemID());
                newEntry.setUnitId(entry.getUnitId());
                newEntry.setLineTypeId(Long.valueOf(entry.getLineTypeId()));
                newEntry.setGrpKeyHash(Long.valueOf(Long.parseLong(String.valueOf(entry.hashCode()))));
                entryRows.add(newEntry);
                context.getTracker().getVchEntryIDAndXlaEntryIdMap().computeIfAbsent(newEntry.getEntryId(), v -> new HashSet()).add(entry.getEntryId());
            }
            newVoucher.setEntryRows(entryRows);
            voucherResult.add(newVoucher);
            context.getTracker().getVoucherIdAndXlaIdMap().computeIfAbsent(newVoucher.getId(), v -> new HashSet()).add(data.getId());
        }
    }
}

