/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.api;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.event.BuildVoucherMqUtil;
import kd.fi.v2.fah.cache.cacheservice.FAHDataCacheMgr;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.context.ExtDataSaveCtx;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataSaveHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.log.FahPoaFeatureMonitor;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DateValueUtils;
import kd.fi.v2.fah.utils.ExtDataSdoHelper;
import kd.fi.v2.fah.utils.SdoUtil;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validator.MsgInfo;

public class AppendAiEventApiService
extends AbstractBillWebApiPlugin {
    private static final String EVENTCLASS = "eventclass";
    private static final String EVENTNUMBER = "eventnumber";
    private static final String ENTRYNAME = "entryname";
    private static final String ENTRYDATA = "entrydata";
    private static final String COMMIT = "commit";

    public ApiResult doCustomService(Map<String, Object> params) {
        String eventclass = (String)params.get(EVENTCLASS);
        if (kd.bos.util.StringUtils.isEmpty((String)eventclass)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AppendAiEventApiService_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        String eventnumber = (String)params.get(EVENTNUMBER);
        if (kd.bos.util.StringUtils.isEmpty((String)eventnumber)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AppendAiEventApiService_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        String entryname = (String)params.get(ENTRYNAME);
        if (kd.bos.util.StringUtils.isEmpty((String)entryname)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5206\u5f55\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AppendAiEventApiService_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        List dataList = (List)params.get(ENTRYDATA);
        if (dataList == null || dataList.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AppendAiEventApiService_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        boolean exsit = QueryServiceHelper.exists((String)"ai_eventclass", (QFilter[])new QFilter("number", "=", (Object)eventclass).toArray());
        if (!exsit) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5916\u90e8\u6570\u636e\u6a21\u578b\u3002", (String)"AppendAiEventApiService_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventclass));
        }
        DynamicObject aiEventDO = this.queryExtData(eventclass, eventnumber);
        if (aiEventDO == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u201c%1$s\u201d\u7f16\u7801\u201c%2$s\u201d\u7684\u5916\u90e8\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AppendAiEventApiService_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventclass, eventnumber));
        }
        if (!EventPagingEnum.NO_COMMIT.getStatus().equals(aiEventDO.getString("paging"))) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e3a\u201c%1$s\u201d\u4e14\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u5916\u90e8\u6570\u636e\u4e0d\u4e3a\u672a\u63d0\u4ea4\u7c7b\u578b\u5916\u90e8\u6570\u636e\uff0c\u4e0d\u80fd\u8ffd\u52a0\u6570\u636e\u3002", (String)"AppendAiEventApiService_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventclass, eventnumber));
        }
        Long eventId = aiEventDO.getLong("id");
        Long orgId = aiEventDO.getLong("org");
        String modelNum = eventclass;
        DynamicObject modelInfo = DataModelDaoImpl.queryDataModelByNumberCommon((String)modelNum);
        boolean saveDefault = false;
        boolean isNewModel = String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(modelInfo.getString("appversion"));
        ApiResult apiResult = null;
        if (isNewModel) {
            boolean entryNumExists = this.checkentryNumExists(modelNum, entryname);
            if (!entryNumExists) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5206\u5f55\u6807\u8bc6\u3002", (String)"AppendAiEventApiService_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), entryname));
            }
            DynamicObjectCollection extDataEntries = QueryServiceHelper.query((String)DataModelDaoImpl.getMetaEntityNumber((String)modelNum), (String)(entryname + ".id,savedefault"), (QFilter[])new QFilter("id", "=", (Object)eventId).toArray());
            saveDefault = ((DynamicObject)extDataEntries.get(0)).getBoolean("savedefault");
            int currentEntrySize = extDataEntries.size();
            String msgResult = this.checkNewModelEntryData(modelNum, orgId, eventId, eventnumber, saveDefault, entryname, params.get(ENTRYDATA), aiEventDO, currentEntrySize);
            if (kd.bos.util.StringUtils.isNotEmpty((String)msgResult)) {
                apiResult = ApiResult.fail((String)msgResult, (String)entryname);
            }
            if (null != apiResult && !saveDefault) {
                return apiResult;
            }
        } else {
            DynamicObjectCollection eventclassdyns = QueryServiceHelper.query((String)"ai_eventclass", (String)"fieldentryentity.fieldname fieldname", (QFilter[])new QFilter("number", "=", (Object)eventclass).toArray());
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (DynamicObject dyn : eventclassdyns) {
                fieldNames.add(dyn.getString("fieldname"));
            }
            HashSet fieldsNameSet = new HashSet(fieldNames);
            if (!fieldsNameSet.contains(entryname)) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5206\u5f55\u6807\u8bc6\u3002", (String)"AppendAiEventApiService_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), entryname));
            }
            String message = this.entryIsMustInput(eventclass, entryname, params.get(ENTRYDATA));
            if (!kd.bos.util.StringUtils.isEmpty((String)message)) {
                return ApiResult.fail((String)message);
            }
            message = this.entryFormatValidate(eventclass, entryname, params.get(ENTRYDATA));
            if (!kd.bos.util.StringUtils.isEmpty((String)message)) {
                return ApiResult.fail((String)message);
            }
        }
        DynamicObject aiEventEnDyn = BusinessDataServiceHelper.newDynamicObject((String)"ai_event_en");
        aiEventEnDyn.set(ENTRYNAME, (Object)entryname);
        aiEventEnDyn.set("eventid", (Object)eventId);
        aiEventEnDyn.set("entrydata_tag", (Object)SerializationUtils.toJsonString((Object)params.get(ENTRYDATA)));
        Object commit = params.get(COMMIT);
        try (TXHandle t = TX.requiresNew((String)"AppendAiEventApiService.doCustomService");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{aiEventEnDyn});
                DynamicObject aiEvent = BusinessDataServiceHelper.loadSingle((Object)eventId, (String)"ai_event", (String)"id,paging,status");
                if (commit != null && Boolean.parseBoolean(commit.toString()) || isNewModel && null != apiResult && !"3".equals(aiEvent.getString("status"))) {
                    if (commit != null && Boolean.parseBoolean(commit.toString())) {
                        aiEvent.set("paging", (Object)EventPagingEnum.COMMIT.getStatus());
                    }
                    if (isNewModel) {
                        DynamicObject aiEventExtData = BusinessDataServiceHelper.loadSingle((Object)eventId, (String)DataModelDaoImpl.getMetaEntityNumber((String)modelNum), (String)"id,paging,billstatus");
                        if (null != apiResult && !"3".equals(aiEvent.getString("status"))) {
                            aiEvent.set("status", (Object)"3");
                            aiEventExtData.set("billstatus", (Object)"F");
                        }
                        if (commit != null && Boolean.parseBoolean(commit.toString())) {
                            aiEventExtData.set("paging", (Object)false);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{aiEventExtData});
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{aiEvent});
                }
                if (isNewModel) {
                    SimpleDynamicObject sdo = this.getAppendSdo();
                    ExtDataSaveHelper.appendEntries((SimpleDynamicObject)sdo);
                    if (saveDefault) {
                        List<MsgInfo> allErrorMsgInfo = this.getAllErrorMsgInfo();
                        ExtDataSaveHelper.saveErrorMsg(allErrorMsgInfo);
                    }
                }
            }
            catch (Exception ex) {
                t.markRollback();
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        }
        if (commit != null && Boolean.parseBoolean(commit.toString()) && null == apiResult) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(aiEventEnDyn.get("eventid"));
            BuildVoucherMqUtil.buildVoucherByMq(list);
        }
        if (null == apiResult) {
            apiResult = ApiResult.success((Object)ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6210\u529f", (String)"AppendAiEventApiService_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        this.poaFeatureMonitor_output(1);
        return apiResult;
    }

    private String checkNewModelEntryData(String modelNum, Long orgId, Long eventId, String eventnumber, boolean saveDefault, String entryname, Object entryData, DynamicObject aiEventDO, int currentEntrySize) {
        ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.createExtDataSaveCtx();
        extDataSaveCtx.initCtx(modelNum, orgId);
        ExtDataSdoHelper extDataSdoHelper = extDataSaveCtx.getExtDataSdoHelper();
        extDataSdoHelper.setApiTypeAppendEntries();
        SimpleDynamicObject sdo = extDataSdoHelper.create(extDataSaveCtx.getCurrentModelNum());
        sdo.set("id", (Object)eventId);
        sdo.set("number", (Object)eventnumber);
        sdo.set("savedefault", (Object)saveDefault);
        extDataSdoHelper.parseAppendEntries(sdo, entryname, JSON.parseArray((String)JSON.toJSONString((Object)entryData)), currentEntrySize);
        extDataSaveCtx.getConverterHelper().finishCollect();
        extDataSdoHelper.convertBasedata(sdo);
        extDataSaveCtx.addExtData(eventnumber, new ExtendedDataEntity(aiEventDO, 0, 0, eventnumber));
        extDataSaveCtx.addSuccessOrFailedExtDataSdo(sdo, sdo.getBoolean("savedefault"));
        List allErrorMsgInfo = extDataSaveCtx.getAllErrorMsgInfo();
        StringBuilder allMsg = new StringBuilder();
        for (MsgInfo msgInfo : allErrorMsgInfo) {
            allMsg.append(msgInfo.getMsg()).append(";");
        }
        return allMsg.toString();
    }

    private boolean checkentryNumExists(String modelNum, String entryNum) {
        DataModelCfg modelCfg = (DataModelCfg)FAHDataCacheMgr.instance.getDataModelCfgCacheService().loadFromCache((Object)modelNum, new Object[0]);
        for (DataModelFieldCollection fieldCollection : (BaseMutableArrayMapStorage)modelCfg.getCollections()) {
            if (DefaultDataFieldGroupEnum.ENTRY != fieldCollection.getGroupType() || 1 != fieldCollection.getGroupLevel() || !entryNum.equals(StringUtils.getHeaderOrTailWord((String)fieldCollection.getNumber(), (char)'|', (boolean)false))) continue;
            return true;
        }
        return false;
    }

    private DynamicObject queryExtData(String modelNum, String dataNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("eventclass.number", "=", (Object)modelNum));
        QFilter oldQFilter = new QFilter("eventclass.appversion", "=", (Object)String.valueOf(AppVersionEnum.OLD_APP.getCode()));
        QFilter newQFilter = new QFilter("eventclass.appversion", "=", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode()));
        oldQFilter.or(newQFilter);
        newQFilter.and("eventclass.latestversion", "=", (Object)"1").and("eventclass.enable", "=", (Object)"1").and("eventclass.status", "=", (Object)StatusEnum.PUBLISHED.getCode());
        filters.add(oldQFilter);
        filters.add(new QFilter("number", "=", (Object)dataNumber));
        filters.add(new QFilter("status", "!=", (Object)Character.valueOf('2')));
        return QueryServiceHelper.queryOne((String)"ai_event", (String)"id,paging,org", (QFilter[])filters.toArray(new QFilter[0]));
    }

    private List<MsgInfo> getAllErrorMsgInfo() {
        ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.getExtDataSaveCtx();
        return extDataSaveCtx.getAllErrorMsgInfoNeedSave();
    }

    private SimpleDynamicObject getAppendSdo() {
        ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.getExtDataSaveCtx();
        Map allSuccessExtDatasdoMap = extDataSaveCtx.getAllSuccessExtDataSdoMap();
        if (allSuccessExtDatasdoMap.size() > 0) {
            return (SimpleDynamicObject)((List)allSuccessExtDatasdoMap.values().iterator().next()).get(0);
        }
        Map allFailedExtDataSdoMap = extDataSaveCtx.getAllFailedExtDataSdoMap();
        if (allFailedExtDataSdoMap.size() > 0) {
            return (SimpleDynamicObject)((List)allFailedExtDataSdoMap.values().iterator().next()).get(0);
        }
        return null;
    }

    private String entryFormatValidate(String eventclass, String entryname, Object object) {
        String message = "";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "=", (Object)eventclass));
        filters.add(new QFilter("fieldentryentity.fieldname", "=", (Object)entryname));
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"ai_eventclass", (String)"fieldentryentity.entryentity.entryfieldname entryfieldname,fieldentryentity.entryentity.entryfieldtype entryfieldtype", (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject dyn : dyns) {
            map.put(dyn.getString("entryfieldname"), dyn.getString("entryfieldtype"));
        }
        if (!map.isEmpty()) {
            List list = (List)object;
            int count = 0;
            for (Map datamap : list) {
                ++count;
                for (Map.Entry entry : map.entrySet()) {
                    Object obj = datamap.get(entry.getKey());
                    if (obj != null && !kd.bos.util.StringUtils.isEmpty((String)(message = this.getMessage(obj, (String)entry.getValue(), count, (String)entry.getKey())))) {
                        return message;
                    }
                    if (obj == null || !"".equals(obj.toString()) || !"number".equals(entry.getValue())) continue;
                    datamap.put(entry.getKey(), null);
                }
            }
        }
        return message;
    }

    private String getMessage(Object obj, String format, int count, String key) {
        String message = "";
        switch (format) {
            case "txt": 
            case "basedata": 
            case "event": {
                if (obj instanceof String) break;
                message = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u6761\u6570\u636e\u7684\u201c%2$s\u201d\u5b57\u6bb5\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"AppendAiEventApiService_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), count, key);
                break;
            }
            case "number": {
                if (obj instanceof BigDecimal || obj instanceof Integer || obj instanceof Double || obj instanceof Long) break;
                try {
                    if (kd.bos.util.StringUtils.isEmpty((String)obj.toString())) break;
                    Double.parseDouble(obj.toString());
                }
                catch (Exception e) {
                    message = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u6761\u6570\u636e\u7684\u201c%2$s\u201d\u5b57\u6bb5\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"AppendAiEventApiService_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), count, key);
                }
                break;
            }
            case "date": {
                String dateStr = obj + "";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    sdf.parse(dateStr);
                    break;
                }
                catch (ParseException e) {
                    message = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u6761\u6570\u636e\u7684\u201c%2$s\u201d\u5b57\u6bb5\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"AppendAiEventApiService_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), count, key);
                    return message;
                }
            }
            case "boolean": {
                if (obj instanceof Boolean) break;
                message = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u6761\u6570\u636e\u7684\u201c%2$s\u201d\u5b57\u6bb5\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"AppendAiEventApiService_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), count, key);
                break;
            }
        }
        return message;
    }

    private String entryIsMustInput(Object eventclass, String entryname, Object object) {
        String message = null;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("number", "=", eventclass));
        qFilters.add(new QFilter("fieldentryentity.entryentity.entryismustinput", "=", (Object)true));
        qFilters.add(new QFilter("fieldentryentity.fieldtype", "=", (Object)"entry"));
        qFilters.add(new QFilter("fieldentryentity.ismustinput", "=", (Object)true));
        qFilters.add(new QFilter("fieldentryentity.fieldname", "=", (Object)entryname));
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"ai_eventclass", (String)"fieldentryentity.entryentity.entryfieldname entryfieldname", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dyns == null || dyns.isEmpty()) {
            return message;
        }
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject dyn : dyns) {
            set.add(dyn.getString("entryfieldname"));
        }
        List list = (List)object;
        for (Map map : list) {
            for (String str : set) {
                if (map.containsKey(str) && map.get(str) != null) continue;
                message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u3002", (String)"AppendAiEventApiService_10", (String)"fi-ai-formplugin", (Object[])new Object[0]), str);
                return message;
            }
        }
        return message;
    }

    private void poaFeatureMonitor_output(int dataCount) {
        Map allSuccessExtDataSdoMap = ExtDataSaveCtxHelper.getExtDataSaveCtx().getAllSuccessExtDataSdoMap();
        HashMap<String, String> varMap = new HashMap<String, String>(allSuccessExtDataSdoMap.size());
        varMap.put("API", "appendAiEventEntry");
        int entryCount = 0;
        for (Map.Entry entry : allSuccessExtDataSdoMap.entrySet()) {
            entryCount += SdoUtil.countAllDataLine((SimpleDynamicObject[])((List)entry.getValue()).toArray(new SimpleDynamicObject[0]));
            varMap.put((String)entry.getKey(), String.valueOf(((List)entry.getValue()).size()));
        }
        varMap.put("entryCount", String.valueOf(entryCount));
        long cost = DateValueUtils.cost();
        FahPoaFeatureMonitor.output(null, (String)"EAH-2023-ZT02-TX01", (int)dataCount, (Long)cost, (String)"ai_event", varMap);
    }
}

