/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.formplugin.botp.ConditionEdit;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.DapEntityTypeUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class AIEventConditionEdit
extends ConditionEdit {
    private static Log logger = LogFactory.getLog(AIEventConditionEdit.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        MainEntityType entityType = this.getEventType();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean readEntry = Objects.equals(customParams.get("readentry"), "true");
        List filterColumns = DapEntityTypeUtil.getFilterColumns((IDataEntityType)entityType, (boolean)false, (boolean)readEntry);
        customParams.put("treenodes", this.setFieldNodes(entityType, readEntry));
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.setFilterColumns(filterColumns);
        super.afterCreateNewData(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < 10; ++i) {
            if (stackTrace[i].toString().indexOf("kd.bos.form.control.FilterGrid.getMainEntityType") != 0) continue;
            e.setNewEntityType(this.getEventType());
            return;
        }
    }

    @Override
    public void click(EventObject evt) {
        try {
            IDataModel model = this.getModel();
            Control ctlSource = (Control)evt.getSource();
            MainEntityType type = this.getModel().getDataEntityType();
            if (!type.getName().equals("ai_condition")) {
                Field field = model.getClass().getSuperclass().getDeclaredField("mainEntityType");
                ReflectionUtils.makeAccessible((Field)field);
                field.set(model, null);
            }
            if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
                this.checkOutEntry();
            } else {
                super.click(evt);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void checkOutEntry() {
        String conditonJson = "";
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.getFormulaObj(formulaObj);
        try {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"AIEventConditionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return;
        }
        catch (Throwable exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"AIEventConditionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getMessage()));
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
        this.getView().close();
    }

    private MainEntityType getEventType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject dyo = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)(customParams.get("entityInfo") + ""), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ai_eventclass"))[0];
        if (StringUtils.isEmpty((Object)dyo.get("number"))) {
            dyo.set("number", (Object)"001");
        }
        return AiEventMetaUtil.getEntityTypeForDyn((DynamicObject)dyo);
    }

    @Override
    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        MainEntityType mainType = this.getEventType();
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = kd.bos.dataentity.utils.StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"AIEventConditionEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    private String setFieldNodes(MainEntityType entityType, boolean readEntry) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)entityType);
        option.setReadEntryEntity(readEntry);
        option.setExprType(ExpressionType.Condition);
        option.setFieldType(null);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        return SerializationUtils.toJsonString((Object)tree);
    }
}

