/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.metadata.edit.AccountEdit;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AssistantEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.formplugin.AcctTableField;
import kd.fi.ai.formplugin.DSField;
import kd.fi.ai.formplugin.FactorInfo;
import kd.fi.ai.formplugin.importhandler.AccountMapTypeImportHandler;
import kd.fi.ai.formplugin.service.AccountMapTypeService;
import kd.fi.ai.util.AiDynamicObjectSerializeUtil;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.DynamicModifyViewAndModelUtil;
import kd.fi.ai.util.GLUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class AccountMapTypeEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String ORIGINAL_ENTITY = "originalEntity";
    private static final String ORIGINAL_TYPE = "originalType";
    private static final String ACCFIELDSHOW = "accfieldshow";
    private static final String ASSTFACTORSHOW = "asstfactorshow";
    private static final String BASEFACTORSHOW = "basefactorshow";
    private static final String ENTRY_SHOWENTITY = "entryentityshow";
    private static final String ENTRY_ACCTMAPENTRY = "acctmapentry";
    private static final String DS_FIELDS = "DSFields";
    private static final String ENTRY_SAVEENTITY = "entryentity";
    private static final String Key_FactorF7 = "factorname";
    private static final String Key_FactorValue = "factorvalue";
    private static final String Key_FactorValue_BaseData = "factorvalue_basedata";
    private static final String Key_FactorValue_AsstData = "factorvalue_asstdata";
    private static final String ENTRY_FIELDMAPENTRY = "fieldmapentry";
    private static final String KEY_MULACCTTABLE = "mulaccttable";

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        Set<Object> accFieldKeySet = new HashSet();
        try {
            accFieldKeySet = this.getAcctTableFieldKeyFromModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (key.startsWith(BASEFACTORSHOW)) {
            BasedataEdit fieldEdit = new BasedataEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(this.getView());
            fieldEdit.setEntryKey(ENTRY_SHOWENTITY);
            e.setControl((Control)fieldEdit);
        } else if (key.startsWith(ASSTFACTORSHOW)) {
            AssistantEdit fieldEdit = new AssistantEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(this.getView());
            fieldEdit.setEntryKey(ENTRY_SHOWENTITY);
            e.setControl((Control)fieldEdit);
        } else if (accFieldKeySet.contains(key)) {
            AccountEdit fieldEdit = new AccountEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(this.getView());
            fieldEdit.setEntryKey(ENTRY_SHOWENTITY);
            e.setControl((Control)fieldEdit);
        }
    }

    private Set<String> getAcctTableFieldKeyFromModel() {
        HashSet<String> fieldKeySet = new HashSet<String>();
        DynamicObjectCollection acctMapdatas = this.getModel().getEntryEntity(ENTRY_ACCTMAPENTRY);
        for (DynamicObject map : acctMapdatas) {
            fieldKeySet.add(map.getString("acctfieldkey"));
        }
        return fieldKeySet;
    }

    private Set<String> getFactorFieldKeyFromModel() {
        HashSet<String> fieldKeySet = new HashSet<String>();
        DynamicObjectCollection acctMapdatas = this.getModel().getEntryEntity(ENTRY_FIELDMAPENTRY);
        for (DynamicObject map : acctMapdatas) {
            fieldKeySet.add(map.getString("fieldkey"));
        }
        return fieldKeySet;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OperationStatus stat = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)stat)) {
            this.addClickListeners(new String[]{Key_FactorF7});
        }
        Set<Object> accFieldKeySet = new HashSet();
        try {
            accFieldKeySet = this.getAcctTableFieldKeyFromModel();
            this.getModel().updateCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : accFieldKeySet) {
            BasedataEdit accFieldEdit = (BasedataEdit)this.getControl(string);
            if (accFieldEdit == null) continue;
            accFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit mulaccttableEdit = (BasedataEdit)this.getControl(KEY_MULACCTTABLE);
        mulaccttableEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        new AccountMapTypeImportHandler().beforeImporChecktData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        new AccountMapTypeImportHandler().setSourceDataToModel(this.getModel(), this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "save": {
                this.handleSaveAccountMap(args);
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        String factorValue;
        super.afterLoadData(e);
        this.loadData();
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconbaritemap4", "advconbaritemap11", "advconbaritemap21", "batchfillentry", "bar_save"});
        }
        if (StringUtils.isNotEmpty((CharSequence)(factorValue = (String)this.getModel().getValue(Key_FactorValue)))) {
            String[] factorValues = factorValue.split(",");
            Object[] factorNames = FahEntityMetaHelper.batchGetFactorName((String[])factorValues);
            String nameStr = StringUtils.join((Object[])factorNames, (String)",");
            this.getModel().setValue(Key_FactorF7, (Object)nameStr);
        }
    }

    public void loadData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Set<String> fieldKeySet = this.getFactorFieldKeyFromModel();
        Set<String> accFieldKeySet = this.getAcctTableFieldKeyFromModel();
        Map<Long, String> accFieldMap = this.getAcctTableFieldMapFromModel();
        DynamicObjectCollection saveEntity = model.getEntryEntity(ENTRY_SAVEENTITY);
        if (null != saveEntity && !saveEntity.isEmpty() && ((DynamicObject)saveEntity.get(0)).getInt("rowindex") == 0) {
            Long id = (Long)model.getValue("id");
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ai_accountmaptype");
            DynamicObjectCollection entrys = dyn.getDynamicObjectCollection(ENTRY_SAVEENTITY);
            for (int i = 0; i < entrys.size(); ++i) {
                ((DynamicObject)entrys.get(i)).set("rowindex", (Object)(i + 1));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
            saveEntity = entrys;
        }
        if (null == saveEntity) {
            model.batchCreateNewEntryRow(ENTRY_SHOWENTITY, vs);
            return;
        }
        int fieldColIndex = 0;
        HashMap<String, Integer> fieldKeyMap = new HashMap<String, Integer>(16);
        for (String fieldKey : fieldKeySet) {
            vs.addField(fieldKey, new Object[0]);
            fieldKeyMap.put(fieldKey, fieldColIndex++);
        }
        for (String accFieldKey : accFieldKeySet) {
            vs.addField(accFieldKey, new Object[0]);
            fieldKeyMap.put(accFieldKey, fieldColIndex++);
        }
        HashSet<Integer> indexSet = new HashSet<Integer>();
        int rows = fieldKeySet.size() + accFieldKeySet.size();
        for (DynamicObject saveRow : saveEntity) {
            int rowIndex = saveRow.getInt("rowindex");
            Object[] rowVal = new Object[rows];
            for (String fieldKey : fieldKeySet) {
                rowVal[((Integer)fieldKeyMap.get((Object)fieldKey)).intValue()] = saveRow.get(fieldKey.replace("show", "") + "_id");
            }
            DynamicObject acct = saveRow.getDynamicObject(ACCFIELDSHOW.replace("show", ""));
            if (acct != null) {
                String accFieldKey = accFieldMap.get(acct.get("accounttable_id"));
                if (accFieldKey == null) continue;
                long acctId = acct.getLong("id");
                rowVal[((Integer)fieldKeyMap.get((Object)accFieldKey)).intValue()] = acctId;
                if (indexSet.contains(rowIndex)) {
                    vs.set(accFieldKey, (Object)acctId, rowIndex - 1);
                    continue;
                }
                vs.addRow(rowVal);
                indexSet.add(rowIndex);
                continue;
            }
            vs.addRow(rowVal);
            indexSet.add(rowIndex);
        }
        model.batchCreateNewEntryRow(ENTRY_SHOWENTITY, vs);
    }

    private void handleSaveAccountMap(BeforeDoOperationEventArgs args) {
        if (args.isCancel()) {
            return;
        }
        args.setCancel(true);
        BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
        String formId = baseparam.getFormId();
        DynamicObject saveObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection showEntity = saveObj.getDynamicObjectCollection(ENTRY_SHOWENTITY);
        DynamicObjectCollection saveEntity = saveObj.getDynamicObjectCollection(ENTRY_SAVEENTITY);
        saveEntity.clear();
        Set<String> fieldKeySet = this.getFactorFieldKeyFromModel();
        Set<String> accFieldKeySet = this.getAcctTableFieldKeyFromModel();
        HashMap<String, Object> saveValMap = new HashMap<String, Object>(16);
        int seq = 1;
        for (DynamicObject showRow : showEntity) {
            saveValMap.clear();
            for (String fieldKey : fieldKeySet) {
                Object value = showRow.get(fieldKey);
                saveValMap.put(fieldKey, value);
            }
            for (String accFieldKey : accFieldKeySet) {
                DynamicObject row = saveEntity.addNew();
                row.set("seq", (Object)seq++);
                for (String fieldKey : fieldKeySet) {
                    String saveFieldKey = fieldKey.replace("show", "");
                    row.set(saveFieldKey, saveValMap.get(fieldKey));
                }
                DynamicObject accVal = showRow.getDynamicObject(accFieldKey);
                if (accVal == null) continue;
                String accField = ACCFIELDSHOW.replace("show", "");
                row.set(accField, (Object)accVal);
                row.set(accField + "_id", (Object)accVal.getLong("id"));
            }
        }
        DynamicObject originObj = null;
        long pkId = saveObj.getLong("id");
        if (pkId != 0L) {
            originObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
            this.copyDynamicObjectData(saveObj, originObj);
        } else {
            originObj = saveObj;
        }
        Save save = (Save)args.getSource();
        OperateOption option = save.getOption();
        option = option == null ? OperateOption.create() : option;
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)formId, (DynamicObject[])new DynamicObject[]{originObj}, (OperateOption)option);
        if (!result.isSuccess()) {
            if (result.isShowMessage()) {
                this.getView().showOperationResult(result);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AccountMapTypeEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            List pkIdList = result.getSuccessPkIds();
            this.getModel().setValue("id", pkIdList.get(0));
            this.getModel().setDataChanged(false);
        }
    }

    public void copyDynamicObjectData(DynamicObject from, DynamicObject to) {
        DataEntityPropertyCollection propColl = to.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : propColl) {
            DynamicObjectCollection toColl;
            DynamicObjectCollection fromColl;
            String propName = prop.getName();
            if (ENTRY_SHOWENTITY.equals(propName)) continue;
            if (prop instanceof DynamicCollectionProperty && !(prop instanceof DynamicLocaleProperty)) {
                fromColl = from.getDynamicObjectCollection(propName);
                toColl = to.getDynamicObjectCollection(propName);
                toColl.clear();
                for (DynamicObject fromRow : fromColl) {
                    DynamicObject toRow = toColl.addNew();
                    this.copyDynamicObjectData(fromRow, toRow);
                }
                continue;
            }
            if (prop instanceof DynamicLocaleProperty) {
                fromColl = from.getDynamicObjectCollection(propName);
                toColl = to.getDynamicObjectCollection(propName);
                toColl.clear();
                DataEntityPropertyCollection fromPropColl = fromColl.getDynamicObjectType().getProperties();
                DataEntityPropertyCollection toPropColl = toColl.getDynamicObjectType().getProperties();
                for (DynamicObject fromRow : fromColl) {
                    DynamicObject toRow = toColl.addNew();
                    for (int i = 0; i < toPropColl.size(); ++i) {
                        IDataEntityProperty toProp = (IDataEntityProperty)toPropColl.get(i);
                        IDataEntityProperty fromProp = (IDataEntityProperty)fromPropColl.get(i);
                        toRow.set(toProp, fromRow.get(fromProp));
                    }
                }
                continue;
            }
            to.set(propName, from.get(propName));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equals(Key_FactorF7)) {
            if (this.getModel().getEntryRowCount(ENTRY_SAVEENTITY) > 1000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5904\u7406\u91cf\u8d85\u8fc71000\u884c\uff0c\u8bf7\u901a\u8fc7\u5bfc\u51fa\u5bfc\u5165\u6570\u636e\u65b9\u5f0f\u6dfb\u52a0\u5f71\u54cd\u56e0\u7d20\u6216\u79d1\u76ee\u8868\u3002", (String)"AccountMapTypeEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showFactorList();
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        DynamicObject copyFrom = BusinessDataServiceHelper.loadSingle((Object)param.getPkId(), (String)"ai_accountmaptype");
        DataEntityPropertyCollection propColl = copyFrom.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : propColl) {
            if (!(prop instanceof DynamicCollectionProperty)) continue;
            this.clearEntryPkValue(copyFrom, prop.getName());
        }
        this.copyDynamicObjectData(copyFrom, this.getModel().getDataEntity(true));
        this.loadData();
        this.getModel().setValue("id", null);
        this.getModel().setValue("number", null);
        this.getModel().setValue("name", null);
        this.getModel().setValue("masterid", null);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dataStr = this.getPageCache().get(ORIGINAL_ENTITY);
        if (dataStr != null) {
            String typeStr = this.getPageCache().get(ORIGINAL_TYPE);
            DynamicObjectType type = (DynamicObjectType)SerializationUtils.deSerializeFromBase64((String)typeStr);
            DynamicObject editdata = AiDynamicObjectSerializeUtil.deserialize(dataStr, type);
            IDataModel model = this.getModel();
            DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection(ENTRY_FIELDMAPENTRY);
            ArrayList<DSField> list = new ArrayList<DSField>();
            for (DynamicObject map : mapdatas) {
                DSField ds = new DSField();
                ds.setDataType(map.getString("datatype"));
                ds.setEntityId(map.getString("entityid"));
                ds.setFieldKey(map.getString("fieldkey"));
                ds.setFieldName(new LocaleString(map.getString("fieldname")));
                list.add(ds);
            }
            this.saveFactorDataToModel(list);
            DynamicObjectCollection acctMapdatas = editdata.getDynamicObjectCollection(ENTRY_ACCTMAPENTRY);
            ArrayList<AcctTableField> acctTblist = new ArrayList<AcctTableField>();
            for (DynamicObject map : acctMapdatas) {
                AcctTableField field = new AcctTableField();
                DynamicObject acctTb = map.getDynamicObject("entryaccttable");
                field.setAcctTableId(acctTb.getLong("id"));
                field.setAcctTableName(acctTb.getString("name"));
                field.setFieldKey(map.getString("acctfieldkey"));
                acctTblist.add(field);
            }
            this.saveAcctTableMapToModel(acctTblist);
            DynamicObjectCollection coll = editdata.getDynamicObjectCollection(ENTRY_SHOWENTITY);
            this.copyDynamicObjectData(editdata, model.getDataEntity(true));
            HashMap<Long, String> tableKeyMap = new HashMap<Long, String>(16);
            for (AcctTableField acctTableField : acctTblist) {
                tableKeyMap.put(acctTableField.getAcctTableId(), acctTableField.getFieldKey());
            }
            if (coll != null && coll.size() > 0) {
                int[] index = model.batchCreateNewEntryRow(ENTRY_SHOWENTITY, coll.size());
                int i = 0;
                DynamicObjectType collType = coll.getDynamicObjectType();
                DataEntityPropertyCollection props = collType.getProperties();
                for (DynamicObject row : coll) {
                    DynamicObject fieldData;
                    for (DSField field : list) {
                        String fieldKey = field.getFieldKey();
                        if (collType.getProperty(fieldKey) == null || (fieldData = row.getDynamicObject(fieldKey)) == null) continue;
                        model.setValue(fieldKey, (Object)fieldData.getLong("id"), index[i]);
                    }
                    for (IDataEntityProperty prop : props) {
                        long acctTabId;
                        String fieldKey;
                        String propName = prop.getName();
                        if (!propName.startsWith(ACCFIELDSHOW) || propName.endsWith("_id") || (fieldData = row.getDynamicObject(propName)) == null || (fieldKey = (String)tableKeyMap.get(acctTabId = fieldData.getLong("accounttable_id"))) == null) continue;
                        model.setValue(fieldKey, (Object)fieldData.getLong("id"), index[i]);
                    }
                    ++i;
                }
            }
            model.updateCache();
            this.getView().updateView();
        } else {
            DynamicObject org;
            Long currentSignOrgId = 0L;
            currentSignOrgId = this.getPageCache().get("orgID") != null ? Long.valueOf(this.getPageCache().get("orgID")) : Long.valueOf(Long.parseLong(this.getModel().getValue("createorg_id") + ""));
            DynamicObject book = this.getMainBook(currentSignOrgId);
            if (book == null && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
                book = this.getMainBook(org.getLong("id"));
            }
            if (book != null) {
                this.getModel().setValue("booktype", (Object)book.getLong("bookstype.id"));
                this.getModel().setValue("accttable", (Object)book.getLong("accounttable.id"));
            }
        }
    }

    private DynamicObject getMainBook(Long currentSignOrgId) {
        QFilter h = new QFilter("org", "=", (Object)currentSignOrgId);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,bookstype.id,accounttable.id,org.id", (QFilter[])new QFilter[]{h, k});
        return book;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getView().getModel();
        Object ret = e.getReturnData();
        if (ret != null && e.getActionId().equals("ai_accountfactorlistf7")) {
            List factorItems = (List)ret;
            if (factorItems.size() > 10) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u6700\u591a10\u4e2a\u5f71\u54cd\u56e0\u7d20\u3002", (String)"AccountMapTypeEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().updateCache();
            String entityNumber = "";
            String entityName = "";
            String fbdtype = "0";
            String baseDataEntity = "";
            String asstDataEntity = "";
            ArrayList<DSField> fields = new ArrayList<DSField>(10);
            int i = 0;
            int j = 0;
            Map<String, String> fieldMaps = this.getFieldMap(factorItems);
            for (Map map : factorItems) {
                entityNumber = entityNumber + (String)map.get("fsrcentitynumber") + ",";
                entityName = entityName + (String)map.get("fsrcentityname") + ",";
                fbdtype = (String)map.get("fbdtype");
                if ("0".equals(fbdtype)) {
                    baseDataEntity = baseDataEntity + (String)map.get("fsrcentitynumber") + ",";
                } else if ("1".equals(fbdtype)) {
                    asstDataEntity = asstDataEntity + (String)map.get("fsrcentitynumber") + ",";
                }
                DSField field = new DSField();
                String entity = (String)map.get("fsrcentitynumber");
                field.setDataType(fbdtype);
                field.setEntityId(entity);
                if (fieldMaps.get(entity) != null) {
                    field.setFieldKey(fieldMaps.get(entity));
                } else {
                    String fieldF = "";
                    if ("0".equals(fbdtype)) {
                        fieldF = BASEFACTORSHOW + i;
                        while (fieldMaps.containsValue(fieldF)) {
                            fieldF = BASEFACTORSHOW + ++i;
                        }
                        field.setFieldKey(fieldF);
                        ++i;
                    } else if ("1".equals(fbdtype)) {
                        fieldF = ASSTFACTORSHOW + j;
                        while (fieldMaps.containsValue(fieldF)) {
                            fieldF = ASSTFACTORSHOW + ++j;
                        }
                        field.setFieldKey(fieldF);
                        ++j;
                    }
                }
                field.setFieldName(new LocaleString((String)map.get("fsrcentityname")));
                fields.add(field);
            }
            if (factorItems.size() > 0) {
                entityNumber = entityNumber.substring(0, entityNumber.length() - 1);
                entityName = entityName.substring(0, entityName.length() - 1);
            }
            if (baseDataEntity.endsWith(",")) {
                baseDataEntity = baseDataEntity.substring(0, baseDataEntity.length() - 1);
            }
            if (asstDataEntity.endsWith(",")) {
                asstDataEntity = asstDataEntity.substring(0, asstDataEntity.length() - 1);
            }
            model.setValue(Key_FactorF7, (Object)entityName);
            model.setValue(Key_FactorValue, (Object)entityNumber);
            model.setValue(Key_FactorValue_BaseData, (Object)baseDataEntity);
            model.setValue(Key_FactorValue_AsstData, (Object)asstDataEntity);
            this.saveFactorDataToModel(fields);
            List<AcctTableField> acctFieldList = this.getAcctTableFieldFromModel();
            this.rebuildDataEntity(fields, acctFieldList);
        }
    }

    private void rebuildDataEntity(List<DSField> dsList, List<AcctTableField> accTabList) {
        IDataModel model = this.getModel();
        DynamicObject oriEntity = model.getDataEntity(true);
        String dataStr = AiDynamicObjectSerializeUtil.serialize(oriEntity, oriEntity.getDynamicObjectType());
        this.getPageCache().put(ORIGINAL_ENTITY, dataStr);
        String typeStr = SerializationUtils.serializeToBase64((Object)oriEntity.getDynamicObjectType());
        this.getPageCache().put(ORIGINAL_TYPE, typeStr);
        this.reBuildModelAndGrid(dsList, accTabList, this.getModel().getDataEntityType(), true);
        model.beginInit();
        model.createNewData((Object)new DynamicObject((DynamicObjectType)model.getDataEntityType()));
        model.endInit();
    }

    private void showFactorList() {
        DynamicObjectCollection fieldmapentry;
        IDataModel model = this.getModel();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_accountfactorlistf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection billTypes = (DynamicObjectCollection)this.getModel().getValue("billtypes");
        if (billTypes != null && billTypes.size() > 0) {
            Set propEntitys = null;
            if (billTypes.size() == 1) {
                propEntitys = DapUtil.getBillPropEntitys((String)((DynamicObject)billTypes.get(0)).getString("fbasedataid_id"));
            } else if (billTypes.size() > 1) {
                for (DynamicObject billType : billTypes) {
                    Set propEntitysTmp = DapUtil.getBillPropEntitys((String)billType.getString("fbasedataid_id"));
                    if (propEntitys == null) {
                        propEntitys = propEntitysTmp;
                        continue;
                    }
                    propEntitys.retainAll(propEntitysTmp);
                }
            }
            DynamicObject dataMappings = BusinessDataServiceHelper.load((String)"ai_basedatamapping", (String)"id,destbasedata.id", null);
            if (propEntitys != null) {
                for (DynamicObject dataMap : dataMappings) {
                    propEntitys.add(dataMap.getString("destbasedata.id"));
                }
            }
            showParameter.setCustomParam("EntitySet", (Object)SerializationUtils.toJsonString((Object)propEntitys));
        }
        if ((fieldmapentry = model.getEntryEntity(ENTRY_FIELDMAPENTRY)).size() != 0) {
            HashMap<String, FactorInfo> factorInfoMap = new HashMap<String, FactorInfo>();
            FactorInfo info = null;
            for (DynamicObject dyn : fieldmapentry) {
                info = new FactorInfo();
                info.setBDType(Integer.parseInt(dyn.getString("datatype")));
                info.setSrcEntityNumber(dyn.getString("entityid"));
                info.setSrcPropKey(dyn.getString("entityid"));
                String fieldname = 0 == info.getBDType() ? FahEntityMetaHelper.getEntityName((Object)info.getSrcEntityNumber()) : (1 == info.getBDType() ? FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)info.getSrcEntityNumber())) : dyn.getString("fieldname"));
                info.setSrcEntityName(fieldname);
                info.setFactorName(fieldname);
                factorInfoMap.put(dyn.getString("entityid"), info);
            }
            showParameter.setCustomParam("info", (Object)GLUtil.toSerializedString(factorInfoMap));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ai_accountfactorlistf7");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String pName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("billtypes".equals(pName)) {
            DynamicObjectCollection oldValue = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
            ArrayList<String> ovl = new ArrayList<String>();
            for (DynamicObject dyn : oldValue) {
                ovl.add(dyn.getString("fbasedataid_id"));
            }
            Object[] newValue = null;
            if (e.getChangeSet()[0].getNewValue() instanceof Object[]) {
                newValue = (Object[])e.getChangeSet()[0].getNewValue();
            } else {
                HashMap newValueColl = (HashMap)e.getChangeSet()[0].getNewValue();
                if (newValueColl != null) {
                    newValue = newValueColl.keySet().toArray();
                }
            }
            if (newValue != null && newValue.length > 0) {
                HashMap<Integer, String> basRow = new HashMap<Integer, String>();
                ArrayList<Integer> auxiliaryRowIndex = new ArrayList<Integer>();
                DynamicObjectCollection fieldmapentry = model.getEntryEntity(ENTRY_FIELDMAPENTRY);
                for (int i = 0; i < fieldmapentry.size(); ++i) {
                    if (((DynamicObject)fieldmapentry.get(i)).getString("datatype").equals("0")) {
                        basRow.put(i, ((DynamicObject)fieldmapentry.get(i)).getString("entityid"));
                        continue;
                    }
                    auxiliaryRowIndex.add(i);
                }
                ArrayList<Integer> deleteRows = new ArrayList<Integer>();
                Set<String> aftPropEntitys = null;
                aftPropEntitys = this.getpropEntitys(newValue);
                if (auxiliaryRowIndex.size() != 0 && aftPropEntitys != null && !aftPropEntitys.contains("bos_assistantdatagroup")) {
                    deleteRows.addAll(auxiliaryRowIndex);
                }
                for (Map.Entry ety : basRow.entrySet()) {
                    if (aftPropEntitys == null || aftPropEntitys.contains(basRow.get(ety.getKey()))) continue;
                    deleteRows.add((Integer)ety.getKey());
                }
                this.getPageCache().put("deleteRows", GLUtil.toSerializedString(deleteRows));
                this.getPageCache().put("oldValue", GLUtil.toSerializedString(ovl));
                if (deleteRows != null && deleteRows.size() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u9002\u7528\u5355\u636e\u7c7b\u578b\u540e\uff0c\u5c06\u5220\u9664\u5355\u636e\u8303\u56f4\u5916\u7684\u5f71\u54cd\u56e0\u7d20\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"AccountMapTypeEdit_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("changeBilltypes"));
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IDataModel model = this.getModel();
        if ("changeBilltypes".equals(messageBoxClosedEvent.getCallBackId())) {
            String result = messageBoxClosedEvent.getResult().name();
            if (result.equals("Yes")) {
                String deleteRowsStr = this.getPageCache().get("deleteRows");
                List deleteRows = (List)GLUtil.fromSerializedString((String)deleteRowsStr);
                Collections.sort(deleteRows);
                for (int i = deleteRows.size() - 1; i >= 0; --i) {
                    model.deleteEntryRow(ENTRY_FIELDMAPENTRY, ((Integer)deleteRows.get(i)).intValue());
                }
                DynamicObjectCollection col = model.getEntryEntity(ENTRY_FIELDMAPENTRY);
                StringBuilder actorName = new StringBuilder();
                StringBuilder actorNumber = new StringBuilder();
                StringBuilder baseDataEntity = new StringBuilder();
                StringBuilder asstDataEntity = new StringBuilder();
                String type = "";
                for (DynamicObject dyn : col) {
                    String fieldname;
                    actorNumber.append(dyn.getString("entityid")).append(',');
                    type = dyn.getString("datatype");
                    if ("0".equals(type)) {
                        fieldname = FahEntityMetaHelper.getEntityName((Object)dyn.getString("entityid"));
                        baseDataEntity.append(dyn.getString("entityid")).append(',');
                    } else if ("1".equals(type)) {
                        fieldname = FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)dyn.getString("entityid")));
                        asstDataEntity.append(dyn.getString("entityid")).append(',');
                    } else {
                        fieldname = dyn.getString("fieldname");
                    }
                    actorName.append(fieldname).append(',');
                }
                if (actorNumber.length() > 0) {
                    actorNumber.deleteCharAt(actorNumber.length() - 1);
                    actorName.deleteCharAt(actorName.length() - 1);
                }
                if (baseDataEntity.length() > 0) {
                    baseDataEntity.deleteCharAt(baseDataEntity.length() - 1);
                }
                if (asstDataEntity.length() > 0) {
                    asstDataEntity.deleteCharAt(asstDataEntity.length() - 1);
                }
                model.setValue(Key_FactorF7, (Object)actorName.toString());
                model.setValue(Key_FactorValue, (Object)actorNumber.toString());
                model.setValue(Key_FactorValue_BaseData, (Object)baseDataEntity.toString());
                model.setValue(Key_FactorValue_AsstData, (Object)asstDataEntity.toString());
            } else if (result.equals("No")) {
                String oldValueStr = this.getPageCache().get("oldValue");
                List oldValue = (List)GLUtil.fromSerializedString((String)oldValueStr);
                model.setValue("billtypes", (Object)oldValue.toArray());
            }
        }
    }

    private Set<String> getpropEntitys(Object[] fbasedataid) {
        Set<String> propEntitys = null;
        if (fbasedataid.length == 1) {
            propEntitys = DapUtil.getBillPropEntitys((String)fbasedataid[0].toString());
        } else if (fbasedataid.length > 1) {
            for (Object billType : fbasedataid) {
                Set propEntitysTmp = DapUtil.getBillPropEntitys((String)billType.toString());
                if (propEntitys == null) {
                    propEntitys = propEntitysTmp;
                    continue;
                }
                propEntitys.retainAll(propEntitysTmp);
            }
        }
        DynamicObject[] dataMappings = BusinessDataServiceHelper.load((String)"ai_basedatamapping", (String)"id,destbasedata.id", null);
        if (null == propEntitys && dataMappings != null && dataMappings.length > 0) {
            propEntitys = new HashSet(dataMappings.length);
            for (DynamicObject dataMap : dataMappings) {
                propEntitys.add(dataMap.getString("destbasedata.id"));
            }
        }
        return propEntitys;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType entitytype = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)entitytype.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException(e1.getMessage());
        }
        if (this.getPageCache().get("inited") == null) {
            BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pk = baseparam.getPkId();
            if (pk != null) {
                DynamicObject editdata = BusinessDataServiceHelper.loadSingle((Object)pk, (String)newMainType.getName());
                DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection(ENTRY_FIELDMAPENTRY);
                ArrayList<DSField> list = new ArrayList<DSField>();
                for (DynamicObject map : mapdatas) {
                    DSField sd = new DSField();
                    sd.setDataType(map.getString("datatype"));
                    sd.setEntityId(map.getString("entityid"));
                    sd.setFieldKey(map.getString("fieldkey"));
                    if (sd.getFieldKey().startsWith(BASEFACTORSHOW)) {
                        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sd.getEntityId());
                        sd.setFieldName(dataEntityType.getDisplayName());
                    } else if (sd.getFieldKey().startsWith(ASSTFACTORSHOW)) {
                        String name = FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)sd.getEntityId()));
                        sd.setFieldName(new LocaleString(name));
                    } else {
                        sd.setFieldName(new LocaleString(map.getString("fieldname")));
                    }
                    list.add(sd);
                }
                DynamicObjectCollection acctMapdatas = editdata.getDynamicObjectCollection(ENTRY_ACCTMAPENTRY);
                ArrayList<AcctTableField> acctTblist = new ArrayList<AcctTableField>();
                for (DynamicObject map : acctMapdatas) {
                    AcctTableField field = new AcctTableField();
                    DynamicObject acctTb = map.getDynamicObject("entryaccttable");
                    if (acctTb == null) continue;
                    field.setAcctTableId(acctTb.getLong("id"));
                    field.setAcctTableName(acctTb.getString("name"));
                    field.setFieldKey(map.getString("acctfieldkey"));
                    acctTblist.add(field);
                }
                this.reBuildModelAndGrid(list, acctTblist, newMainType, true);
                e.setNewEntityType(newMainType);
            }
            this.getPageCache().put("inited", "true");
        } else {
            List<DSField> list = this.getDsFieldFromModel();
            List<AcctTableField> acctTblist = this.getAcctTableFieldFromModel();
            this.reBuildModelAndGrid(list, acctTblist, newMainType, false);
            e.setNewEntityType(newMainType);
        }
    }

    private List<DSField> getDsFieldFromModel() {
        DynamicObjectCollection mapdatas = this.getModel().getEntryEntity(ENTRY_FIELDMAPENTRY);
        ArrayList<DSField> list = new ArrayList<DSField>();
        for (DynamicObject map : mapdatas) {
            DSField sd = new DSField();
            sd.setDataType(map.getString("datatype"));
            sd.setEntityId(map.getString("entityid"));
            sd.setFieldKey(map.getString("fieldkey"));
            if (sd.getFieldKey().startsWith(BASEFACTORSHOW)) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sd.getEntityId());
                sd.setFieldName(dataEntityType.getDisplayName());
            } else if (sd.getFieldKey().startsWith(ASSTFACTORSHOW)) {
                String name = FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)sd.getEntityId()));
                sd.setFieldName(new LocaleString(name));
            } else {
                sd.setFieldName(new LocaleString(map.getString("fieldname")));
            }
            if (!StringUtils.isNotBlank((CharSequence)map.getString("entityid"))) continue;
            list.add(sd);
        }
        return list;
    }

    private List<AcctTableField> getAcctTableFieldFromModel() {
        DynamicObjectCollection acctMapdatas = this.getModel().getEntryEntity(ENTRY_ACCTMAPENTRY);
        ArrayList<AcctTableField> acctTblist = new ArrayList<AcctTableField>();
        for (DynamicObject map : acctMapdatas) {
            AcctTableField field = new AcctTableField();
            DynamicObject acctTb = map.getDynamicObject("entryaccttable");
            if (acctTb != null) {
                field.setAcctTableId(acctTb.getLong("id"));
                field.setAcctTableName(acctTb.getString("name"));
            }
            field.setFieldKey(map.getString("acctfieldkey"));
            acctTblist.add(field);
        }
        return acctTblist;
    }

    private Map<Long, String> getAcctTableFieldMapFromModel() {
        DynamicObjectCollection acctMapdatas = this.getModel().getEntryEntity(ENTRY_ACCTMAPENTRY);
        HashMap<Long, String> accFieldMap = new HashMap<Long, String>(16);
        for (DynamicObject map : acctMapdatas) {
            DynamicObject acctTb = map.getDynamicObject("entryaccttable");
            if (acctTb == null) continue;
            accFieldMap.put(acctTb.getLong("id"), map.getString("acctfieldkey"));
        }
        return accFieldMap;
    }

    private void reBuildModelAndGrid(List<DSField> list, List<AcctTableField> acctTbList, MainEntityType mainEntityType, boolean rebuildGrid) {
        try {
            DynamicModifyViewAndModelUtil.rebuildEntityType(mainEntityType, ENTRY_SHOWENTITY, list, acctTbList);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
        this.drawGrid(list, acctTbList, mainEntityType, rebuildGrid);
        mainEntityType.createPropIndexsNoCache();
        this.getPageCache().put(DS_FIELDS, SerializationUtils.toJsonString(list));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty p = e.getProperty();
        String pName = p.getName();
        ChangeData[] cdata = e.getChangeSet();
        ChangeData changeData = cdata[0];
        IDataModel model = this.getModel();
        if ("org".equalsIgnoreCase(pName)) {
            DynamicObject newAcctOrg = (DynamicObject)changeData.getNewValue();
            if (newAcctOrg == null) {
                model.setValue("booktype", null);
                return;
            }
            this.getPageCache().put("orgID", newAcctOrg.getPkValue().toString());
        } else if ("accttable".equalsIgnoreCase(pName)) {
            int entryCount = model.getEntryRowCount(ENTRY_SHOWENTITY);
            for (int i = 0; i < entryCount; ++i) {
                model.setValue(ACCFIELDSHOW, null, i);
            }
        } else if ("booktype".equalsIgnoreCase(pName)) {
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org != null) {
                DynamicObject newBookType;
                QFilter k;
                QFilter h = new QFilter("org", "=", org.getPkValue());
                DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,bookstype.id,accounttable.id", (QFilter[])new QFilter[]{h, k = new QFilter("bookstype", "=", (newBookType = (DynamicObject)changeData.getNewValue()).getPkValue())});
                if (books != null && books.size() > 0) {
                    model.setValue("accttable", (Object)((DynamicObject)books.get(0)).getLong("accounttable.id"));
                    model.setValue("booktype", (Object)((DynamicObject)books.get(0)).getLong("bookstype.id"));
                } else {
                    model.setValue("accttable", (Object)0L);
                    model.setValue("booktype", (Object)0L);
                }
            }
        } else if (Key_FactorF7.equals(pName)) {
            if (StringUtils.isBlank((Object)changeData.getNewValue())) {
                ArrayList<DSField> list = new ArrayList<DSField>();
                this.saveFactorDataToModel(list);
                List<AcctTableField> acctList = this.getAcctTableFieldFromModel();
                this.reBuildModelAndGrid(list, acctList, this.getModel().getDataEntityType(), true);
                model.deleteEntryData(ENTRY_SHOWENTITY);
                model.createNewEntryRow(ENTRY_SHOWENTITY);
            }
        } else if (KEY_MULACCTTABLE.equals(pName)) {
            ArrayList<AcctTableField> acctTbList = new ArrayList<AcctTableField>();
            DynamicObjectCollection mulaccttable = (DynamicObjectCollection)changeData.getNewValue();
            int accStartIndex = 0;
            for (DynamicObject accttable : mulaccttable) {
                AcctTableField field = new AcctTableField();
                DynamicObject acctTb = accttable.getDynamicObject("fbasedataid");
                long acctTabId = acctTb.getLong("id");
                field.setAcctTableId(acctTabId);
                String fieldKey = ACCFIELDSHOW + accStartIndex++;
                field.setFieldKey(fieldKey);
                field.setAcctTableName(acctTb.getString("name"));
                acctTbList.add(field);
            }
            this.saveAcctTableMapToModel(acctTbList);
            this.rebuildDataEntity(this.getDsFieldFromModel(), acctTbList);
        }
    }

    private void saveAcctTableMapToModel(List<AcctTableField> acctList) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ACCTMAPENTRY);
        for (AcctTableField acctTableField : acctList) {
            int rowIndex = model.createNewEntryRow(ENTRY_ACCTMAPENTRY);
            model.setValue("entryaccttable", (Object)acctTableField.getAcctTableId(), rowIndex);
            model.setValue("acctfieldkey", (Object)acctTableField.getFieldKey(), rowIndex);
        }
    }

    private void saveFactorDataToModel(List<DSField> refList) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_FIELDMAPENTRY);
        for (DSField field : refList) {
            int rowIndex = model.createNewEntryRow(ENTRY_FIELDMAPENTRY);
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void drawGrid(List<DSField> refList, List<AcctTableField> acctTbList, MainEntityType mainEntityType, boolean rebuildGrid) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createSeqColumn());
        EntryAp entryAp = DynamicModifyViewAndModelUtil.createDynamicEntryAp(ENTRY_SHOWENTITY, refList, acctTbList);
        List newColumns = (List)entryAp.createControl().get("columns");
        cols.addAll(newColumns);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_SHOWENTITY);
        List items = entryGrid.getItems();
        items.clear();
        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            items.add(fieldEdit);
        }
        if (rebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(ENTRY_SHOWENTITY, "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "seq");
        col.put("width", 60);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AccountMapTypeEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", Boolean.TRUE);
        return col;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if (key != null && key.startsWith(ACCFIELDSHOW)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            List<AcctTableField> acctTableFieldList = this.getAcctTableFieldFromModel();
            Long acctTableId = this.getAcctTableByFieldKey(acctTableFieldList, key);
            if (acctTableId == null) {
                arg0.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"AccountMapTypeEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            AccountMapTypeService typeService = new AccountMapTypeService();
            showParameter.getTreeFilterParameter().getQFilters().add(new QFilter("accounttype", "not in", typeService.getAccountType()));
            List qFilters = filterParam.getQFilters();
            qFilters.add(new QFilter("accounttable", "=", (Object)acctTableId));
            qFilters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            qFilters.add(new QFilter("accounttype", "in", typeService.getAccountTypeIds(acctTableId)));
            Long createorg = (Long)this.getModel().getValue("createorg_id");
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)createorg));
        }
        if (KEY_MULACCTTABLE.equals(key) && this.getModel().getEntryRowCount(ENTRY_SAVEENTITY) > 1000) {
            arg0.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5904\u7406\u91cf\u8d85\u8fc71000\u884c\uff0c\u8bf7\u901a\u8fc7\u5bfc\u51fa\u5bfc\u5165\u6570\u636e\u65b9\u5f0f\u6dfb\u52a0\u5f71\u54cd\u56e0\u7d20\u6216\u79d1\u76ee\u8868\u3002", (String)"AccountMapTypeEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private Long getAcctTableByFieldKey(List<AcctTableField> acctTableFieldList, String key) {
        for (AcctTableField acctTableField : acctTableFieldList) {
            if (acctTableField == null || !acctTableField.getFieldKey().equals(key)) continue;
            return acctTableField.getAcctTableId();
        }
        return null;
    }

    private Map<String, String> getFieldMap(List<Map<String, String>> factorItems) {
        HashMap<String, String> factors = new HashMap<String, String>(16);
        DynamicObjectCollection fieldMaps = this.getModel().getEntryEntity(ENTRY_FIELDMAPENTRY);
        for (DynamicObject fieldMap : fieldMaps) {
            factors.put(fieldMap.getString("entityid"), fieldMap.getString("fieldkey"));
        }
        HashSet<String> fieldS = new HashSet<String>(16);
        for (Map<String, String> factorItem : factorItems) {
            fieldS.add(factorItem.get("fsrcentitynumber"));
        }
        factors.keySet().retainAll(fieldS);
        return factors;
    }

    private void clearEntryPkValue(DynamicObject entity, String entryKey) {
        DynamicObjectCollection coll = entity.getDynamicObjectCollection(entryKey);
        if (coll != null && !coll.isEmpty()) {
            ISimpleProperty prop = coll.getDynamicObjectType().getPrimaryKey();
            for (DynamicObject row : coll) {
                row.set((IDataEntityProperty)prop, null);
            }
        }
    }
}

