/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.ai.formplugin.MapTypeListDataProvider;
import kd.fi.ai.formplugin.service.TemplateConnectUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class AccountMapTypeList
extends AbstractListPlugin {
    private MapTypeListDataProvider provider = new MapTypeListDataProvider();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)this.provider);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String errMsg = this.provider.getErrMsg();
        if (StringUtils.isNotEmpty((String)errMsg)) {
            this.getView().showErrorNotification(errMsg);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] queryVals;
        super.afterQueryOfExport(e);
        for (DynamicObject queryVal : queryVals = e.getQueryValues()) {
            DynamicObjectCollection entryEntity = queryVal.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection factorImportEntity = queryVal.getDynamicObjectCollection("factorimport");
            for (DynamicObject entryRow : entryEntity) {
                String bdInfoImport;
                DynamicObject accField = entryRow.getDynamicObject("accfield");
                if (accField != null) {
                    entryRow.set("accfieldtable", (Object)accField.getDynamicObject("accounttable"));
                }
                if (!StringUtils.isEmpty((String)(bdInfoImport = entryRow.getString("bdinfoimport")))) {
                    DynamicObject factorRow = factorImportEntity.addNew();
                    int size = factorRow.getDynamicObjectType().getProperties().size() / 2;
                    String[] bdInfoImportRow = bdInfoImport.split(",");
                    int count = Math.min(size, bdInfoImportRow.length);
                    for (int i = 0; i < count; ++i) {
                        String[] factor = bdInfoImportRow[i].split(":");
                        int index = i + 1;
                        factorRow.set("factornumber" + index, (Object)factor[0]);
                        if (factor.length <= 1) continue;
                        factorRow.set("factorvalue" + index, (Object)factor[1]);
                    }
                }
                entryRow.set("bdinfoimport", null);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("tbltemplateconnect".equals(evt.getItemKey())) {
            TemplateConnectUtil templateUtil = new TemplateConnectUtil();
            templateUtil.showTemplateConnectEditView(this.getView(), this.getModel());
        }
    }
}

