/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.ai.AiBillStructure;
import kd.fi.ai.cache.AiEntityMetadataLocalCache;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.util.AiEventClassEditUtil;
import kd.fi.ai.util.GLUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.utils.StringUtils;

public class AiEventClassEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
CellClickListener {
    private static final String ORG = "org";
    private static final String NUMBER = "number";
    private static final String BATCH_ADD = "batch_add";
    private static final String TEMPELTENO = "templateno";

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"sonflex"});
        view.setVisible(Boolean.TRUE, new String[]{"blankflex"});
        this.initUserInfo();
        String id = (String)this.getView().getFormShowParameter().getCustomParam("group_id");
        if (!StringUtils.isEmpty((String)id)) {
            long groupId = Long.parseLong(id);
            this.getModel().setValue("group", (Object)groupId);
        }
        this.getModel().setValue("appversion", (Object)AppVersionEnum.OLD_APP.getCode());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getCustomParam("isCopy") != null) {
            this.getView().invokeOperation("copy");
        }
    }

    public void afterCopyData(EventObject e) {
        this.getView().getFormShowParameter().setCustomParam("isCopy", null);
        this.initUserInfo();
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        DynamicObjectCollection dyns = this.getModel().getEntryEntity("fieldentryentity");
        if (dyns == null || dyns.isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"sonflex"});
            view.setVisible(Boolean.TRUE, new String[]{"blankflex"});
        } else {
            this.setEntryFlex("fieldtype", 0);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void afterLoadData(EventObject e) {
        this.initUserInfo();
    }

    private void initUserInfo() {
        long id = (Long)this.getModel().getValue("id");
        DynamicObject user = null;
        if (id != 0L) {
            user = (DynamicObject)this.getModel().getValue("modifier");
            this.getView().setVisible(Boolean.TRUE, new String[]{"creatoravatar"});
        } else {
            user = (DynamicObject)this.getModel().getValue("creator");
            this.getView().setVisible(Boolean.TRUE, new String[]{"creatoravatar"});
        }
        if (user == null) {
            return;
        }
        user = (DynamicObject)this.getModel().getValue("creator");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"gl.GLIndexPlugin.getMyVoucher", (String)"bos_user", (String)"id,name,phone,picturefield,entryentity.dpt.id,entryentity.dpt.name", (QFilter[])new QFilter[]{new QFilter("id", "=", user.get("id"))}, null);
        if (cols == null || cols.isEmpty()) {
            return;
        }
        DynamicObject userInfo = (DynamicObject)cols.get(0);
        ((Label)this.getControl("personname")).setText(userInfo.getString("name"));
        ((Label)this.getControl("persondpt")).setText(userInfo.getString("entryentity.dpt.name"));
        ((Label)this.getControl("personphone")).setText(userInfo.getString("phone"));
    }

    public void closedCallBack(ClosedCallBackEvent backEvent) {
        super.closedCallBack(backEvent);
        IDataModel model = this.getModel();
        if ("closeform".equals(backEvent.getActionId())) {
            EntryGrid preEvtGrid = (EntryGrid)this.getView().getControl("preevent");
            Object val = backEvent.getReturnData();
            if (val != null) {
                AbstractGrid.GridState gridState = preEvtGrid.getEntryState();
                int rowIndex = gridState.getFocusRow();
                String fieldName = gridState.getFocusField();
                model.setValue(fieldName, val, rowIndex);
            }
        } else if ("fieldentryentity".equals(backEvent.getActionId())) {
            if (backEvent.getReturnData() != null) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)backEvent.getReturnData().toString(), CRCondition.class);
                model.setValue("mustinputformula", (Object)condition.getExprDesc());
                model.setValue("mustinputformuladesc_tag", backEvent.getReturnData());
            }
        } else if ("entryentity".equals(backEvent.getActionId())) {
            if (backEvent.getReturnData() != null) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)backEvent.getReturnData().toString(), CRCondition.class);
                model.setValue("entrymustinputformula", (Object)condition.getExprDesc());
                model.setValue("entrymustinputformuladesc_tag", backEvent.getReturnData());
            }
        } else if (BATCH_ADD.equals(backEvent.getActionId()) && backEvent.getReturnData() != null) {
            List list = SerializationUtils.fromJsonStringToList((String)backEvent.getReturnData().toString(), AiBillStructure.class);
            this.createEntry(list);
            this.setEntryFlex("fieldtype", 0);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid fieldGrid = (EntryGrid)this.getView().getControl("fieldentryentity");
        fieldGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid sonGrid = (EntryGrid)this.getView().getControl("entryentity");
        sonGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit refobjEdit = (BasedataEdit)this.getControl("refobj");
        refobjEdit.addBeforeF7SelectListener(evt -> {
            QFilter filter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
            List<String> numbers = AiEventClassEditUtil.getBasedataInfoWithoutExt(this.getView().getPageId());
            QFilter typeFilter = new QFilter(NUMBER, "not in", numbers);
            filter.and(typeFilter);
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit entryrefobjEdit = (BasedataEdit)this.getControl("entryrefobj");
        entryrefobjEdit.addBeforeF7SelectListener(evt -> {
            QFilter filter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().setFilter(filter);
        });
        EntryGrid preEvtGrid = (EntryGrid)this.getView().getControl("preevent");
        preEvtGrid.addCellClickListener((CellClickListener)this);
        Toolbar mbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        mbar.addItemClickListener((ItemClickListener)this);
        BasedataEdit preeventclass = (BasedataEdit)this.getView().getControl("preeventclass");
        preeventclass.addBeforeF7SelectListener(evt -> {
            QFilter filter = new QFilter("appversion", "=", (Object)"0");
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().setFilter(filter);
        });
        this.addClickListeners(new String[]{"mustinputformula", "entrymustinputformula"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        DynamicObjectCollection fieldDyns = this.getModel().getEntryEntity("fieldentryentity");
        for (DynamicObject fielddyn : fieldDyns) {
            String fieldname = fielddyn.getString("fieldname");
            String fieldtype = fielddyn.getString("fieldtype");
            if (kd.bos.util.StringUtils.isEmpty((String)fieldname) && kd.bos.util.StringUtils.isNotEmpty((String)fieldtype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AiEventClassEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("basedata".equals(fieldtype) || "event".equals(fieldtype)) {
                String refobj = fielddyn.getString("refobj");
                if (!kd.bos.util.StringUtils.isEmpty((String)refobj)) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u884c\u672a\u9009\u62e9\u57fa\u7840\u8d44\u6599\u3002", (String)"AiEventClassEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                return;
            }
            if ("assistant".equals(fieldtype)) {
                String assistant = fielddyn.getString("assistant");
                if (!kd.bos.util.StringUtils.isEmpty((String)assistant)) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u884c\u672a\u9009\u62e9\u8f85\u52a9\u8d44\u6599\u3002", (String)"AiEventClassEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                return;
            }
            if (!"entry".equals(fieldtype)) continue;
            DynamicObjectCollection entryFieldDyns = fielddyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryFieldDyn : entryFieldDyns) {
                String entryassistant;
                String entryfieldname = entryFieldDyn.getString("entryfieldname");
                String entryfieldtype = entryFieldDyn.getString("entryfieldtype");
                if ("basedata".equals(entryfieldtype)) {
                    String entryrefobj = entryFieldDyn.getString("entryrefobj");
                    if (!kd.bos.util.StringUtils.isEmpty((String)entryrefobj)) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u5bf9\u5e94\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u884c\u672a\u9009\u62e9\u57fa\u7840\u8d44\u6599\u3002", (String)"AiEventClassEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname, entryfieldname));
                    return;
                }
                if (!"assistant".equals(entryfieldtype) || !kd.bos.util.StringUtils.isEmpty((String)(entryassistant = entryFieldDyn.getString("entryassistant")))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u5bf9\u5e94\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u884c\u672a\u9009\u62e9\u8f85\u52a9\u8d44\u6599\u3002", (String)"AiEventClassEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname, entryfieldname));
                return;
            }
        }
        if ("mustinputformula".equalsIgnoreCase(ctlSource.getKey())) {
            this.showConditionForm("fieldentryentity", "false");
        } else if ("entrymustinputformula".equalsIgnoreCase(ctlSource.getKey())) {
            this.showConditionForm("entryentity", "true");
        }
    }

    private void showConditionForm(String entityKey, String readEntry) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_eventformula");
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entityKey);
        String conditionJson = "fieldentryentity".equals(entityKey) ? (String)this.getModel().getValue("mustinputformuladesc_tag", rowIndex) : (String)this.getModel().getValue("entrymustinputformuladesc_tag", rowIndex);
        showParameter.getCustomParams().put("readentry", readEntry);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entityInfo", DynamicObjectSerializeUtil.serialize((Object[])new Object[]{this.getModel().getDataEntity(true)}, (DynamicObjectType)this.getModel().getDataEntityType()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void cellClick(CellClickEvent clickEvent) {
        if ("preevtfield".equals(clickEvent.getFieldKey()) || "evtfield".equals(clickEvent.getFieldKey())) {
            DynamicObject eventClass = (DynamicObject)this.getModel().getValue("preeventclass", clickEvent.getRow());
            if (eventClass == null) {
                return;
            }
            FormShowParameter param = new FormShowParameter();
            param.setFormId("ai_eventfieldsel");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeform"));
            param.getOpenStyle().setShowType(ShowType.Modal);
            if ("preevtfield".equals(clickEvent.getFieldKey())) {
                param.setCustomParam("eventclass", eventClass.getPkValue());
                param.setCustomParam("showentry", (Object)Boolean.FALSE);
            } else {
                param.setCustomParam("showentry", (Object)Boolean.TRUE);
            }
            this.getView().showForm(param);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "fieldtype": 
            case "entryfieldtype": {
                this.setBaseDataIsEnable(propName);
                break;
            }
            case "mustinputformula": 
            case "entrymustinputformula": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isEmpty((Object)newValue)) break;
                this.clearEventFilter(Objects.equals(propName, "mustinputformula") ? "entryentity" : "subentryentity");
                break;
            }
            case "entryismustinput": 
            case "ismustinput": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!Objects.equals(Boolean.FALSE, newValue)) break;
                this.clearEventFilter(Objects.equals(propName, "ismustinput") ? "entryentity" : "subentryentity");
                break;
            }
            case "templateno": {
                this.clearEntry();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        int row = this.getModel().getEntryCurrentRowIndex(entryname);
        switch (entryname) {
            case "fieldentryentity": {
                this.setEntryFlex(entryname, row);
                break;
            }
        }
    }

    private void setEntryFlex(String entryname, int row) {
        DynamicObjectCollection dyns = this.getModel().getEntryEntity("fieldentryentity");
        if (dyns == null || dyns.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sonflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"blankflex"});
            return;
        }
        DynamicObject dyn = (DynamicObject)dyns.get(row);
        this.getView().setVisible(Boolean.valueOf("entry".equals(dyn.getString("fieldtype"))), new String[]{"sonflex"});
        this.getView().setVisible(Boolean.valueOf(!"entry".equals(dyn.getString("fieldtype"))), new String[]{"blankflex"});
    }

    private void setBaseDataIsEnable(String propName) {
        String value = "";
        if ("fieldtype".equals(propName)) {
            int row = this.getModel().getEntryCurrentRowIndex("fieldentryentity");
            value = (String)this.getModel().getValue("fieldtype", row);
            if (!("event".equals(value) || "basedata".equals(value) || "assistant".equals(value))) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("refobj");
                basedataEdit.setEnable(null, false, row);
                BasedataEdit assistantEdit = (BasedataEdit)this.getView().getControl("assistant");
                assistantEdit.setEnable(null, false, row);
                this.getModel().setValue("assistant", null, row);
                this.getModel().setValue("refobj", null, row);
                if (!"entry".equals(value)) {
                    this.getModel().deleteEntryData("entryentity");
                }
            } else if ("event".equals(value)) {
                this.getModel().setValue("refobj", (Object)"ai_eventclass", row);
                BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("refobj");
                basedataEdit.setEnable(null, false, row);
                this.getModel().deleteEntryData("entryentity");
            } else if ("basedata".equals(value)) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("refobj");
                basedataEdit.setEnable(null, true, row);
                this.getModel().setValue("assistant", null, row);
                this.getModel().deleteEntryData("entryentity");
            } else if ("assistant".equals(value)) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("assistant");
                basedataEdit.setEnable(null, true, row);
                this.getModel().setValue("refobj", null, row);
                this.getModel().deleteEntryData("entryentity");
            }
            this.getView().setVisible(Boolean.valueOf("entry".equals(value)), new String[]{"sonflex"});
            this.getView().setVisible(Boolean.valueOf(!"entry".equals(value)), new String[]{"blankflex"});
        } else if ("entryfieldtype".equals(propName)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            value = (String)this.getModel().getValue("entryfieldtype", row);
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("entryrefobj");
            basedataEdit.setEnable(null, "basedata".equals(value), row);
            if (!"basedata".equals(value)) {
                this.getModel().setValue("entryrefobj", null, row);
            }
            BasedataEdit assistantEdit = (BasedataEdit)this.getView().getControl("entryassistant");
            assistantEdit.setEnable(null, "assistant".equals(value), row);
            if (!"assistant".equals(value)) {
                this.getModel().setValue("entryassistant", null, row);
            }
        }
    }

    private void clearLocalCache() {
        IDataModel model = this.getModel();
        Object pkValue = model.getValue("id");
        if (pkValue != null) {
            String cacheKey = CacheKey.getKey((Object)"ai-eventclass-cache", (Object)pkValue);
            LocalMemoryCache localCache = AiEntityMetadataLocalCache.getLocalCache();
            localCache.remove(new String[]{cacheKey});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.clearLocalCache();
            DynamicObjectCollection fieldDyns = this.getModel().getEntryEntity("fieldentryentity");
            HashSet<String> nameSet = new HashSet<String>();
            for (DynamicObject fielddyn : fieldDyns) {
                String fieldname = fielddyn.getString("fieldname");
                if (kd.bos.util.StringUtils.isEmpty((String)fieldname)) continue;
                if (!this.isAllinEnglish(fieldname)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u201c%s\u201d\u53ea\u652f\u6301\u6570\u5b57\u3001\u82f1\u6587\u548c\u4e0b\u5212\u7ebf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AiEventClassEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                    args.setCancel(true);
                    return;
                }
                if (ORG.equals(fieldname) || NUMBER.equals(fieldname)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u201corg\u201d\u548c\u201cnumber\u201d\u3002", (String)"AiEventClassEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String fieldtype = fielddyn.getString("fieldtype");
                if (nameSet.contains(fieldname)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u7f16\u7801\u201c%s\u201d\u3002", (String)"AiEventClassEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                    args.setCancel(true);
                    return;
                }
                if (!kd.bos.util.StringUtils.isEmpty((String)fieldname)) {
                    nameSet.add(fieldname);
                }
                if ("basedata".equals(fieldtype) || "event".equals(fieldtype)) {
                    String eventclass;
                    String refobj = fielddyn.getString("refobj");
                    if (kd.bos.util.StringUtils.isEmpty((String)refobj)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u884c\u672a\u9009\u62e9\u57fa\u7840\u8d44\u6599\u3002", (String)"AiEventClassEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                        args.setCancel(true);
                        return;
                    }
                    if (!"event".equals(fieldtype) || !kd.bos.util.StringUtils.isEmpty((String)(eventclass = fielddyn.getString("eventclass")))) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u884c\u672a\u9009\u62e9\u4f1a\u8ba1\u4e8b\u4ef6\u3002", (String)"AiEventClassEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                    args.setCancel(true);
                    return;
                }
                if ("assistant".equals(fieldtype)) {
                    String assistant = fielddyn.getString("assistant");
                    if (!kd.bos.util.StringUtils.isEmpty((String)assistant)) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u884c\u672a\u9009\u62e9\u8f85\u52a9\u8d44\u6599\u3002", (String)"AiEventClassEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname));
                    args.setCancel(true);
                    return;
                }
                if (!"entry".equals(fieldtype)) continue;
                DynamicObjectCollection entryFieldDyns = fielddyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryFieldDyn : entryFieldDyns) {
                    String entryassistant;
                    String entryfieldname = entryFieldDyn.getString("entryfieldname");
                    if (kd.bos.util.StringUtils.isBlank((String)entryfieldname)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"AiEventClassEdit_13", (String)"fi-ai-formplugin", (Object[])new Object[0]), entryfieldname));
                        args.setCancel(true);
                        return;
                    }
                    if (!this.isAllinEnglish(entryfieldname)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u201c%s\u201d\u53ea\u652f\u6301\u6570\u5b57\u3001\u82f1\u6587\u548c\u4e0b\u5212\u7ebf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AiEventClassEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), entryfieldname));
                        args.setCancel(true);
                        return;
                    }
                    String entryfieldtype = entryFieldDyn.getString("entryfieldtype");
                    if (ORG.equals(entryfieldname) || NUMBER.equals(entryfieldname)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u201corg\u201d\u548c\u201cnumber\u201d\u3002", (String)"AiEventClassEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (nameSet.contains(entryfieldname)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u7f16\u7801\u201c%s\u201d\u3002", (String)"AiEventClassEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), entryfieldname));
                        args.setCancel(true);
                        return;
                    }
                    if (!kd.bos.util.StringUtils.isEmpty((String)entryfieldname)) {
                        nameSet.add(entryfieldname);
                    }
                    if ("basedata".equals(entryfieldtype)) {
                        String entryrefobj = entryFieldDyn.getString("entryrefobj");
                        if (!kd.bos.util.StringUtils.isEmpty((String)entryrefobj)) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u5bf9\u5e94\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u884c\u672a\u9009\u62e9\u57fa\u7840\u8d44\u6599\u3002", (String)"AiEventClassEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname, entryfieldname));
                        args.setCancel(true);
                        return;
                    }
                    if (!"assistant".equals(entryfieldtype) || !kd.bos.util.StringUtils.isEmpty((String)(entryassistant = entryFieldDyn.getString("entryassistant")))) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u5bf9\u5e94\u5206\u5f55\u7684\u5b57\u6bb5\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u884c\u672a\u9009\u62e9\u8f85\u52a9\u8d44\u6599\u3002", (String)"AiEventClassEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldname, entryfieldname));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    private boolean isAllinEnglish(String field) {
        Pattern p = Pattern.compile("^[A-Za-z0-9_]+$");
        Matcher m = p.matcher(field);
        return m.matches();
    }

    private void clearEventFilter(String entityName) {
        IDataModel model = this.getModel();
        if ("entryentity".equals(entityName)) {
            model.setValue("mustinputformula", (Object)"");
            model.setValue("mustinputformuladesc_tag", (Object)"");
        } else {
            model.setValue("entrymustinputformula", (Object)"");
            model.setValue("entrymustinputformuladesc_tag", (Object)"");
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("fieldentryentity");
        this.getModel().deleteEntryData("entryentity");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BATCH_ADD.equals(evt.getItemKey())) {
            DynamicObject object = (DynamicObject)this.getModel().getValue(TEMPELTENO);
            if (object == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u6a21\u677f\u3002", (String)"AiEventClassEdit_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("operation", BATCH_ADD);
            param.put("id", object.getString("id"));
            DynamicObjectCollection collections = this.getModel().getEntryEntity("fieldentryentity");
            ArrayList list = new ArrayList(8);
            if (collections.size() != 0) {
                AiBillStructure structure = null;
                for (DynamicObject dyn : collections) {
                    structure = new AiBillStructure();
                    structure.setNumber(dyn.getString("fieldname"));
                    if ("entry".equals(dyn.get("fieldtype"))) {
                        ArrayList<AiBillStructure> entryList = new ArrayList<AiBillStructure>(8);
                        DynamicObjectCollection collectionEntry = (DynamicObjectCollection)dyn.get("entryentity");
                        if (collectionEntry != null) {
                            for (DynamicObject entry : collectionEntry) {
                                AiBillStructure entryStructure = new AiBillStructure();
                                entryStructure.setNumber(entry.getString("entryfieldname"));
                                entryList.add(entryStructure);
                            }
                        }
                        list.addAll(entryList);
                    }
                    list.add(structure);
                }
            }
            param.put("relation_mapping", GLUtil.toSerializedString(list));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ai_meta_property_tree");
            showParameter.setCustomParams(param);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BATCH_ADD));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void createEntry(List<AiBillStructure> list) {
        if (!list.isEmpty()) {
            ArrayList<AiBillStructure> listHead = new ArrayList<AiBillStructure>(8);
            ArrayList<AiBillStructure> listEntry = new ArrayList<AiBillStructure>(8);
            for (AiBillStructure structure : list) {
                if (kd.bos.util.StringUtils.isBlank((String)structure.getNumber()) || kd.bos.util.StringUtils.isBlank((String)structure.getGroupNumber())) continue;
                if (structure.getNumber().equals(structure.getGroupNumber())) {
                    listHead.add(structure);
                    continue;
                }
                listEntry.add(structure);
            }
            this.getModel().deleteEntryData("fieldentryentity");
            if (listHead == null || listHead.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u5206\u5f55\u4f53\u5b57\u6bb5\u65e0\u5bf9\u5e94\u5355\u636e\u4f53\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7ed3\u6784\u3002", (String)"AiEventClassEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<String> set = new HashSet<String>(8);
            for (AiBillStructure structure : listHead) {
                set.add(structure.getGroupNumber());
            }
            if (!set.isEmpty() && !listEntry.isEmpty() && listEntry.size() > 0) {
                for (AiBillStructure structure : listEntry) {
                    if (set.contains(structure.getGroupNumber())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u5206\u5f55\u4f53\u5b57\u6bb5\u65e0\u5bf9\u5e94\u5355\u636e\u4f53\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7ed3\u6784\u3002", (String)"AiEventClassEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.getModel().batchCreateNewEntryRow("fieldentryentity", listHead.size());
            int i = 0;
            for (AiBillStructure structure : listHead) {
                this.getModel().setValue("fieldname", (Object)structure.getNumber(), i);
                this.getModel().setValue("fieldalias", (Object)structure.getName(), i);
                this.getModel().setValue("fieldtype", (Object)structure.getData_type(), i);
                if ("assistant".equals(structure.getData_type())) {
                    this.getModel().setValue("assistant", (Object)structure.getData_schema(), i);
                } else if ("basedata".equals(structure.getData_type())) {
                    this.getModel().setValue("refobj", (Object)structure.getData_schema(), i);
                }
                this.getModel().setValue("ismustinput", (Object)structure.getRequired(), i);
                ++i;
            }
            this.createSubEntry(listHead, listEntry);
            this.getView().updateView();
        }
    }

    private void createSubEntry(List<AiBillStructure> listHead, List<AiBillStructure> listEntry) {
        ORM orm = ORM.create();
        DynamicObjectType newType = orm.newDynamicObject("ai_eventclass").getDynamicObjectType();
        for (int i = 0; i < listHead.size(); ++i) {
            if (!"entry".equals(listHead.get(i).getData_type())) continue;
            ArrayList<AiBillStructure> newListEntry = new ArrayList<AiBillStructure>(8);
            for (AiBillStructure entry : listEntry) {
                if (!entry.getGroupNumber().equals(listHead.get(i).getGroupNumber())) continue;
                newListEntry.add(entry);
            }
            DynamicObjectCollection collections = this.getModel().getEntryEntity("fieldentryentity");
            if (newListEntry.isEmpty()) continue;
            DynamicObject dynObject = (DynamicObject)collections.get(i);
            EntryProp ep = (EntryProp)newType.getProperty("fieldentryentity");
            EntryType et = (EntryType)ep.getItemType();
            EntryProp ep1 = (EntryProp)et.getProperty("entryentity");
            EntryType et1 = (EntryType)ep1.getItemType();
            DynamicObjectCollection collection = new DynamicObjectCollection();
            for (int row = 0; row < newListEntry.size(); ++row) {
                DynamicObject billObject;
                AiBillStructure entry = (AiBillStructure)newListEntry.get(row);
                DynamicObject object = new DynamicObject((DynamicObjectType)et1);
                object.set("entryfieldname", (Object)entry.getNumber());
                object.set("entryfieldalias", (Object)entry.getName());
                object.set("entryfieldtype", (Object)entry.getData_type());
                if ("assistant".equals(entry.getData_type())) {
                    billObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_assistantdatagroup"));
                    DynamicObject bosAssistant = BusinessDataServiceHelper.loadSingle((Object)entry.getData_schema(), (String)"bos_assistantdatagroup");
                    if (bosAssistant != null) {
                        billObject.set("id", bosAssistant.get("id"));
                        billObject.set(NUMBER, bosAssistant.get(NUMBER));
                        object.set("entryassistant", (Object)billObject);
                    }
                } else if ("basedata".equals(entry.getData_type())) {
                    billObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_objecttype"));
                    billObject.set("id", (Object)entry.getData_schema());
                    billObject.set(NUMBER, (Object)entry.getData_schema());
                    object.set("entryrefobj", (Object)billObject);
                }
                object.set("entryismustinput", (Object)entry.getRequired());
                collection.add((Object)object);
            }
            dynObject.set("entryentity", (Object)collection);
        }
    }
}

