/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.formplugin.AiEventListProvider;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.TraceSingleVoucherUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.dao.biz.ExtDataQueryHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.sqlbuilder.qfilters.FahQFilterBuilder;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class AiEventList
extends AbstractListPlugin {
    private static final String algoKey = "kd.fi.ai.formplugin.AiEventList";
    private static final String SYSTEM_TYPE = "fi-ai-formplugin";
    private static final String PAGEID = "pageid";
    private static final String TB_HISTORY_DATA_UPGRADE = "tbhisdataupgrade";
    private static final String BILL_LIST_AP = "billlistap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (null != args.getFieldName() && args.getFieldName().startsWith("eventclass")) {
            QFilter qf = new QFilter("appversion", "=", (Object)"0");
            qf.or(new QFilter("appversion", "=", (Object)"1").and("latestversion", "=", (Object)"1"));
            args.addCustomQFilter(qf);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (showParameter.isLookUp() && "true".equals(showParameter.getCustomParam("isVchTemplatePreView"))) {
            return;
        }
        List listFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : listFilterColumns) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)filterColumn;
            switch (fieldName = commFilter.getFieldName()) {
                case "org.name": {
                    long bussOrg = RequestContext.get().getOrgId();
                    List<ComboItem> comboItems = this.getOrgComboItems();
                    if (comboItems != null && comboItems.size() > 0) {
                        commFilter.setComboItems(this.getOrgComboItems());
                        HashSet orgIds = new HashSet((Collection)SerializationUtils.fromJsonString((String)this.getPageCache().get("orglist"), List.class));
                        if (!orgIds.contains(bussOrg)) {
                            bussOrg = Long.parseLong(comboItems.get(0).getValue());
                        }
                    } else if (comboItems != null && comboItems.size() == 0) {
                        bussOrg = 0L;
                    }
                    commFilter.setDefaultValue(String.valueOf(bussOrg));
                    break;
                }
                case "eventclass.number": {
                    if (commFilter.getComboItems() == null || commFilter.getComboItems().isEmpty()) break;
                    commFilter.setDefaultValue(((ComboItem)commFilter.getComboItems().get(0)).getValue());
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            Object value;
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest next : nests) {
                Object value2;
                QFilter filter1 = next.getFilter();
                boolean isQEmptyValue = filter1.getValue() instanceof QEmptyValue;
                if (!"eventclass.id".equals(filter1.getProperty()) || (value2 = this.transValue(filter1.getValue())) == null || value2 instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value2))) continue;
                filter1.__setProperty("eventclass.number");
                filter1.__setCP(this.transCP(filter1.getCP(), isQEmptyValue));
                filter1.__setValue(value2);
            }
            boolean isQEmptyValue = qFilter.getValue() instanceof QEmptyValue;
            if (!"eventclass.id".equals(qFilter.getProperty()) || (value = this.transValue(qFilter.getValue())) == null || value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) continue;
            qFilter.__setProperty("eventclass.number");
            qFilter.__setCP(this.transCP(qFilter.getCP(), isQEmptyValue));
            qFilter.__setValue(value);
        }
        e.getQFilters().add(new QFilter("paging", "!=", (Object)EventPagingEnum.NO_COMMIT.getStatus()));
        FahQFilterBuilder.mergeDuplicateFilters((Collection)e.getQFilters());
    }

    private Object transValue(Object value) {
        if (value instanceof Long) {
            return DataModelDaoImpl.queryDataModelNumberCommon(Collections.singletonList(value));
        }
        if (value instanceof Collection) {
            return DataModelDaoImpl.queryDataModelNumberCommon((Collection)((Collection)value));
        }
        if (null != value && value.getClass().isArray()) {
            return DataModelDaoImpl.queryDataModelNumberCommon(Arrays.asList((Long[])value));
        }
        return value;
    }

    private String transCP(String cp, boolean isQEmptyValue) {
        String newCp;
        if (isQEmptyValue) {
            return cp;
        }
        switch (cp) {
            case "=": {
                newCp = "in";
                break;
            }
            case "!=": 
            case "<>": {
                newCp = "not in";
                break;
            }
            default: {
                newCp = cp;
            }
        }
        return newCp;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (TB_HISTORY_DATA_UPGRADE.equals(itemKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"AiEventList_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            } else {
                List eventIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                HashSet<Long> hasVchIds = new HashSet<Long>();
                Map groupByBillType = ExtDataQueryHelper.groupByBillType(eventIds);
                for (Map.Entry group : groupByBillType.entrySet()) {
                    List ids = (List)group.getValue();
                    QFilter billTypeNumFilter = new QFilter("billtype.number", "=", group.getKey());
                    if (ids.size() > 1998) {
                        List partition = DapBuildVoucherCommonUtil.splitbatch((List)ids, (int)999);
                        for (List prtIds : partition) {
                            QFilter srcBillIdFilter = new QFilter("sourcebillid", "in", (Object)prtIds);
                            DataSet rows = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{billTypeNumFilter, srcBillIdFilter}, null);
                            Throwable throwable = null;
                            try {
                                for (Row row2 : rows) {
                                    if (row2.getLong("voucherid") == 0L) continue;
                                    hasVchIds.add(row2.getLong("sourcebillid"));
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (rows == null) continue;
                                if (throwable != null) {
                                    try {
                                        rows.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                rows.close();
                            }
                        }
                        continue;
                    }
                    QFilter srcBillIdFilter = new QFilter("sourcebillid", "in", (Object)ids);
                    DataSet rows = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{billTypeNumFilter, srcBillIdFilter}, null);
                    Throwable throwable = null;
                    try {
                        for (Row row3 : rows) {
                            if (row3.getLong("voucherid") == 0L) continue;
                            hasVchIds.add(row3.getLong("sourcebillid"));
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rows == null) continue;
                        if (throwable != null) {
                            try {
                                rows.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rows.close();
                    }
                }
                AiEventUtil.updateHasVoucher(new ArrayList(hasVchIds), (boolean)true);
                List notHasVoucherIds = eventIds.stream().filter(id -> !hasVchIds.contains(id)).collect(Collectors.toList());
                AiEventUtil.updateHasVoucher(notHasVoucherIds, (boolean)false);
                ((BillList)this.getControl(BILL_LIST_AP)).refresh();
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new AiEventListProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject event;
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)this.getControl("BillListAp");
        Object primaryKey = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
        if ("vounchernumber".equals(hyperClick.getFieldName())) {
            args.setCancel(true);
            DynamicObjectCollection dyns = AiEventUtil.queryDapRelationById((Long)((Long)primaryKey));
            if (dyns == null || dyns.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0d\u5b58\u5728\u3002", (String)"AiEventList_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (dyns.size() == 1) {
                TraceSingleVoucherUtil.showVoucher((Long)((DynamicObject)dyns.get(0)).getLong("voucherid"), (Long)((DynamicObject)dyns.get(0)).getLong("org"), (IFormView)this.getView());
            } else {
                HashSet<Long> voucherids = new HashSet<Long>(dyns.size());
                for (Object o : dyns) {
                    voucherids.add(o.getLong("voucherid"));
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("gl_voucher");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                for (Long pkid : voucherids) {
                    showParameter.addLinkQueryPkId((Object)pkid);
                }
                showParameter.getCustomParams().put("org", "");
                showParameter.getCustomParams().put("booktype", "");
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("bizvoucherid".equals(hyperClick.getFieldName())) {
            args.setCancel(true);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("fsourcebill.number", "=", (Object)"ai_event"));
            filters.add(new QFilter("sourcebillid", "=", primaryKey));
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_bizvoucher", (QFilter[])filters.toArray(new QFilter[0]));
            if (dyn == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u51ed\u8bc1\u4e0d\u5b58\u5728\u3002", (String)"AiEventList_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            BillShowParameter bizvou = new BillShowParameter();
            bizvou.setFormId("ai_bizvoucher");
            bizvou.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bizvou.setPkId(dyn.getPkValue());
            bizvou.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)bizvou);
        } else if ("number".equals(hyperClick.getFieldName())) {
            DynamicObject event2 = QueryServiceHelper.queryOne((String)"ai_event", (String)"eventclass.id,eventclass.number,eventclass.appversion", (QFilter[])new QFilter("id", "=", primaryKey).toArray());
            if (null != event2 && String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(event2.getString("eventclass.appversion"))) {
                args.setCancel(true);
                if (!LicenseUtil.hasFahLicense()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u8bb8\u53ef\u3002", (String)"AiEventList_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(primaryKey);
                showParameter.setFormId(DataModelDaoImpl.getMetaEntityNumber((String)event2.getString("eventclass.number")));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setCustomParam("modelId", (Object)event2.getLong("eventclass.id"));
                showParameter.setCustomParam("showError", (Object)"true");
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("versionnum".equals(hyperClick.getFieldName()) && null != (event = QueryServiceHelper.queryOne((String)"ai_event", (String)"eventclass.id eventclass,eventclass.appversion", (QFilter[])new QFilter("id", "=", primaryKey).toArray()))) {
            args.setCancel(true);
            BillShowParameter showParameter = new BillShowParameter();
            Map<Object, String> pageIdMap = this.getPageId();
            Long eventClassId = event.getLong("eventclass");
            String pageId = pageIdMap.get(eventClassId);
            if (!StringUtils.isEmpty((String)pageId) && this.getView().getViewNoPlugin(pageId) != null) {
                showParameter.setPageId(pageId);
            }
            if (String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(event.getString("eventclass.appversion"))) {
                showParameter.setFormId("fah_ext_datamodel");
                showParameter.setCustomParam("id", (Object)event.getLong("eventclass"));
            } else {
                showParameter.setPkId((Object)event.getLong("eventclass"));
                showParameter.setFormId("ai_eventclass");
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
            pageIdMap.put(eventClassId, showParameter.getPageId());
            this.cachePageId(pageIdMap);
        }
    }

    private Map<Object, String> getPageId() {
        Map<Object, String> pageIdMap;
        if (!StringUtils.isEmpty((String)this.getPageCache().get(PAGEID))) {
            pageIdMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(PAGEID));
        } else {
            pageIdMap = new HashMap<Object, String>();
            this.cachePageId(pageIdMap);
        }
        return pageIdMap;
    }

    private void cachePageId(Map<Object, String> pageIdMap) {
        this.getPageCache().put(PAGEID, SerializationUtils.serializeToBase64(pageIdMap));
    }

    private List<ComboItem> getOrgComboItems() {
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"ai_event", (String)PermissonType.VIEW.getPermId());
        if (!permOrgRs.hasAllOrgPerm()) {
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", (Object)permOrgRs.getHasPermOrgs()).toArray());
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dyns.size());
            ArrayList<Long> orgIds = new ArrayList<Long>(dyns.size());
            for (DynamicObject dyn : dyns) {
                ComboItem c = new ComboItem();
                c.setCaption(new LocaleString(dyn.getString("name")));
                c.setValue(dyn.getString("id"));
                orgIds.add(dyn.getLong("id"));
                comboItems.add(c);
            }
            this.getPageCache().put("orglist", SerializationUtils.toJsonString(orgIds));
            return comboItems;
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("recalibration".equals(key) || "delete".equals(key)) {
            this.getView().invokeOperation("refresh");
            OperationResult result = args.getOperationResult();
            if (result != null && result.isSuccess()) {
                if ("recalibration".equals(key)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u6821\u9a8c\u6210\u529f\u3002", (String)"AiEventList_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AiEventList_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        }
    }
}

