/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.threads.ThreadPools;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldUtil;

public class AiFormulaEdit
extends FormulaEdit
implements TreeNodeQueryListener,
SearchEnterListener {
    private static final String BUILD = "build";
    private static final String READ_CHILD = "readChild";
    private static final String INCLUDE_ID = "inCludeId";
    private static final String FALSE = "false";
    private static final String EXPRESSION = "expression";

    public void initialize() {
        super.initialize();
        TreeView tv = (TreeView)this.getView().getControl("tv_fields");
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getView().getControl("searchfield");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (StringUtils.isNotBlank((CharSequence)str)) {
            CRFormula crformula = (CRFormula)SerializationUtils.fromJsonString((String)str, CRFormula.class);
            String expression = crformula.getExpression();
            this.getModel().setValue("fexpression", (Object)expression);
            String exprTran = BuildTree.tranExpression((String)expression, (MainEntityType)this.getEntityType());
            this.getModel().setValue("fdescription", (Object)crformula.getDescription());
            this.getModel().setValue("ftranexpr", (Object)exprTran);
        }
    }

    public void afterBindData(EventObject e) {
        String id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        MainEntityType srcMainET = this.getEntityType();
        String srcMainEntityType = (String)this.getView().getFormShowParameter().getCustomParam("srcMainEntityType");
        TreeNode rootNode = new TreeNode();
        if ("dateHead".equals(srcMainEntityType)) {
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)false, DateTimeProp.class, (boolean)true);
            this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)rootNode));
        } else if ("dateBody".equals(srcMainEntityType)) {
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)true, DateTimeProp.class, (boolean)true);
            this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)rootNode));
        } else if ("VchTemplateRateEdit".equals(srcMainEntityType)) {
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)true, DecimalProp.class, (boolean)false);
            this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)rootNode));
        } else if ("VchCreatorEdit".equals(srcMainEntityType)) {
            this.getPageCache().put(READ_CHILD, FALSE);
            rootNode = this.getTreeNode(srcMainET);
        } else if ("VchReCommonFieldPlugin".equals(srcMainEntityType)) {
            this.getPageCache().put(READ_CHILD, FALSE);
            this.getPageCache().put(INCLUDE_ID, FALSE);
            rootNode = this.getTreeNode(srcMainET);
        } else if ("formulaForm".equals(srcMainEntityType)) {
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)"flocalamount", (ExpressionType)ExpressionType.Formula, (boolean)true, DecimalProp.class, (boolean)false);
            this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)rootNode));
        } else if ("AiStandardeventEdit".equals(srcMainEntityType)) {
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)true, null, (boolean)true, (boolean)false);
            this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)rootNode));
        } else if ("FahReferenceFieldEdit".equals(srcMainEntityType)) {
            String entrySetStr = (String)this.getView().getFormShowParameter().getCustomParam("entryFilterSet");
            Set entrySet = null;
            if (StringUtils.isNotEmpty((CharSequence)entrySetStr)) {
                entrySet = (Set)SerializationUtils.deSerializeFromBase64((String)entrySetStr);
            }
            ThreadPools.executeOnce((String)"expressionEditGetTree", () -> {
                TreeNode buildTree = BuildTree.buildTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)true, null, (boolean)false, null);
                this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)buildTree));
            });
            rootNode = BuildTree.buildSimpleTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)true, null, (boolean)false, (Set)entrySet, (boolean)false);
        } else {
            rootNode = this.getTreeNode(srcMainET);
        }
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(rootNode);
    }

    private MainEntityType getEntityType() {
        String id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD);
        String isEvent = (String)this.getView().getFormShowParameter().getCustomParam("event");
        MainEntityType srcMainET = BuildTree.getMainType((String)isEvent, (String)id);
        return srcMainET;
    }

    private TreeNode getTreeNode(MainEntityType srcMainET) {
        boolean inCludeId = this.getBuildTreeParam(INCLUDE_ID);
        boolean readChild = this.getBuildTreeParam(READ_CHILD);
        ThreadPools.executeOnce((String)"aiFormulaEditGetTree", () -> {
            TreeNode buildTree = BuildTree.buildTree((MainEntityType)this.getEntityType(), (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)readChild, null, (boolean)inCludeId);
            this.getPageCache().put("treenodes", SerializationUtils.toJsonString((Object)buildTree));
        });
        TreeNode rootNode = BuildTree.buildSimpleTree((MainEntityType)srcMainET, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)readChild, null, (boolean)inCludeId);
        return rootNode;
    }

    private boolean getBuildTreeParam(String param) {
        String value = this.getPageCache().get(param);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        return !FALSE.equals(value);
    }

    public void click(EventObject evt) {
        block12: {
            try {
                Control ctlSource = (Control)evt.getSource();
                if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
                    String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
                    CRFormula formulaObj = this.deserialize(conditonJson);
                    this.getFormulaObj(formulaObj);
                    String desc = (String)this.getModel().getValue("fdescription");
                    formulaObj.getDescription().setItem(Lang.get().toString(), (Object)desc);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)formulaObj.getExpression()) && !"@autoCal".equalsIgnoreCase(formulaObj.getExpression())) {
                            FormulaEngine.extractVariables((String)formulaObj.getExpression());
                        }
                        if (StringUtils.isBlank((Object)this.getModel().getValue("ftranexpr"))) {
                            String tranExpr = BuildTree.tranExpression((String)formulaObj.getExpression(), (MainEntityType)this.getEntityType());
                            formulaObj.setExprTran(tranExpr);
                        } else {
                            formulaObj.setExprTran((String)this.getModel().getValue("ftranexpr"));
                        }
                    }
                    catch (FormulaException exp) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"AiFormulaEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
                        return;
                    }
                    catch (Throwable exp) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"AiFormulaEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getMessage()));
                        return;
                    }
                    String currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key");
                    String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
                    String cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView());
                    VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)formulaObj, (String)currentFormId, (String)entitynumber, (String)cacheValue);
                    if (returnData.isStatus()) {
                        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                        this.getPageCache().remove("treenodes");
                        this.getView().close();
                    } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                        this.getView().showTipNotification(returnData.getMessage());
                    }
                    break block12;
                }
                this.getView().getFormShowParameter().setCustomParam("treenodes", (Object)this.getPageCache().get("treenodes"));
                super.click(evt);
            }
            catch (Throwable e) {
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase("fexpression")) {
            String expression = (String)this.getModel().getValue("fexpression");
            if (StringUtils.isBlank((CharSequence)expression)) {
                this.getModel().setValue("ftranexpr", (Object)"");
                this.getModel().setValue("fdescription", (Object)"");
                return;
            }
            String tranExpr = "";
            try {
                String json = this.getPageCache().get("treenodes");
                MainEntityType etp = this.getEntityType();
                if (null == json) {
                    TreeNode buildTree = BuildTree.buildTree((MainEntityType)etp, (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)this.getBuildTreeParam(READ_CHILD), null, (boolean)this.getBuildTreeParam(INCLUDE_ID));
                    json = SerializationUtils.toJsonString((Object)buildTree);
                    this.getPageCache().put("treenodes", json);
                }
                tranExpr = BuildTree.tranExpression((String)expression, (MainEntityType)etp);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getMessage();
            }
            catch (Throwable exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u51fa\u9519\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"AiFormulaEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue("ftranexpr", (Object)tranExpr);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeID = e.getNodeId().toString();
        String[] split = nodeID.replace("{", "").replace("}", "").split("#");
        String expression = split[split.length - 1];
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)expression);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String json = this.getPageCache().get("treenodes");
        if (StringUtils.equals((CharSequence)"searchfield", (CharSequence)search.getKey()) && StringUtils.isNotBlank((CharSequence)json)) {
            String searchText = evt.getText();
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            TreeView tree = (TreeView)this.getView().getControl("tv_fields");
            tree.updateNode(BuildTree.searchTree((String)searchText, (TreeNode)rootNode));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        TreeView treeView = (TreeView)arg0.getSource();
        String nodeId = (String)arg0.getNodeId();
        List treeNodes = BuildTree.buildSimpleLevelTree((MainEntityType)this.getEntityType(), (String)EXPRESSION, (ExpressionType)ExpressionType.Formula, (boolean)this.getBuildTreeParam(READ_CHILD), null, (boolean)this.getBuildTreeParam(INCLUDE_ID), (String)nodeId);
        treeView.addNodes(treeNodes);
    }
}

