/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.enums.AssistantTypeEnum;
import kd.fi.ai.enums.BillTypeEnum;
import kd.fi.ai.event.AiEventProp;
import kd.fi.ai.formplugin.AiStandard;
import kd.fi.ai.formplugin.AiStandardProperty;
import kd.fi.ai.formplugin.BillType;
import kd.fi.ai.formplugin.importhandler.StandardEventHandler;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityFieldUtil;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.ai.util.GLUtil;

public class AiStandardeventEdit
extends AbstractFormPlugin
implements IConfirmCallBack,
TreeNodeClickListener {
    private static final String BILLTYPE = "billtype";
    private static final String EVENTTYPE = "eventtype";
    private static final String BILL = "bill";
    private static final String ASSTACTTYPE = "asstacttype";
    private static final String STANDARDENTRY = "entryentity";
    private static final String ASSTACTTYPEID = "asstacttypeid";
    private static final String BILLNO = "billno";
    private static final String BILLTYPENAME = "billtypename";
    private static final String EXPDESC = "expdesc";
    private static final String EXP = "exp";
    private static final String FULLFIELD = "fullfield";
    private static final String FIELD = "field";
    private static final String ROWFIELD = "rowfield";
    private static final String ENTITYBILLTYPE = "billorevent";
    private static final String BILLID = "billid";
    private static final String HIDENENTRY = "entryentityhiden";
    private static final String HIDENENTITYID = "entityid";
    private static final String HIDENENTITYNUMBER = "entitynumber";
    private static final String HIDENENTITYNAME = "entityname";
    private static final String HIDENENTITYTYPE = "entitytype";
    private static final String Key_AsstFieldExpDesc = "asstfieldexpdesc";
    protected static final String NON_FIELDS = "nonFields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{EXPDESC});
        TreeView fieldTree = (TreeView)this.getControl("treeviewap");
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        OperationStatus stat = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)stat)) {
            this.addClickListeners(new String[]{BILL});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        AiStandard aiStandard = new AiStandard();
        TreeNode node = this.getRoot();
        TreeView treev = (TreeView)this.getControl("treeviewap");
        treev.addNode(node);
        treev.updateNode(node);
        String nodeId = this.getPageCache().get("firstid");
        treev.focusNode(node.getTreeNode(nodeId));
        this.getPageCache().put("lastNodeId", treev.getTreeState().getFocusNodeId());
        StringBuilder entityNameBuffer = new StringBuilder();
        DynamicObjectCollection standards = model.getEntryEntity(STANDARDENTRY);
        if (!standards.isEmpty()) {
            ArrayList<AiStandardProperty> list = new ArrayList<AiStandardProperty>(standards.size());
            String types = "";
            int[] index = new int[standards.size()];
            for (int i = 0; i < standards.size(); ++i) {
                index[i] = i;
                List<Object> listRows = new ArrayList(16);
                DynamicObject object = (DynamicObject)model.getValue(ASSTACTTYPEID, i);
                if (object == null) {
                    this.getView().showErrMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e1a\u52a1\u7ef4\u5ea6\u6570\u636e\u7684\u662f\u5426\u6b63\u786e\u3002", (String)"AiStandardeventEdit_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), "");
                    return;
                }
                AiStandardProperty aiProperty = new AiStandardProperty();
                aiProperty.setAsstacttypeid(object.getLong("id"));
                aiProperty.setBillno((String)model.getValue(BILLNO, i));
                aiProperty.setBilltypename((String)model.getValue(BILLTYPENAME, i));
                aiProperty.setExpdesc((String)model.getValue(EXPDESC, i));
                aiProperty.setExp((String)model.getValue(EXP, i));
                aiProperty.setFullfield((String)model.getValue(FULLFIELD, i));
                aiProperty.setField((String)model.getValue(FIELD, i));
                aiProperty.setBilltype((String)model.getValue(ENTITYBILLTYPE, i));
                aiProperty.setBillid((String)model.getValue(BILLID, i));
                if (BillTypeEnum.BILL.getValue().equals((String)model.getValue(ENTITYBILLTYPE, i))) {
                    listRows = this.fillAsstSourceFieldsByRow(aiProperty.getBillno(), aiProperty.getAsstacttypeid() + "", (String)model.getValue(ENTITYBILLTYPE, i));
                } else if (BillTypeEnum.EVENT.getValue().equals((String)model.getValue(ENTITYBILLTYPE, i))) {
                    listRows = this.fillAsstSourceFieldsByRow(aiProperty.getBillid(), aiProperty.getAsstacttypeid() + "", (String)model.getValue(ENTITYBILLTYPE, i));
                }
                aiProperty.setRowfield(((Object)listRows).toString());
                list.add(aiProperty);
                types = (String)model.getValue(ENTITYBILLTYPE, i);
            }
            model.deleteEntryRows(STANDARDENTRY, index);
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(ASSTACTTYPEID, new Object[0]);
            vs.addField(BILLNO, new Object[0]);
            vs.addField(BILLTYPENAME, new Object[0]);
            vs.addField(FULLFIELD, new Object[0]);
            vs.addField(FIELD, new Object[0]);
            vs.addField(ROWFIELD, new Object[0]);
            vs.addField(EXPDESC, new Object[0]);
            vs.addField(EXP, new Object[0]);
            vs.addField(ENTITYBILLTYPE, new Object[0]);
            vs.addField(BILLID, new Object[0]);
            ArrayList<String> bills = new ArrayList<String>(16);
            list.stream().filter(a -> nodeId.equals(a.getAsstacttypeid() + "")).forEach(dynamic -> {
                if (BillTypeEnum.BILL.getValue().equals(dynamic.getBilltype())) {
                    bills.add(dynamic.getBillno());
                } else if (BillTypeEnum.EVENT.getValue().equals(dynamic.getBilltype())) {
                    bills.add(dynamic.getBillid());
                }
                vs.addRow(new Object[]{dynamic.getAsstacttypeid(), dynamic.getBillno(), dynamic.getBilltypename(), dynamic.getFullfield(), dynamic.getField(), dynamic.getRowfield(), dynamic.getExpdesc(), dynamic.getExp(), dynamic.getBilltype(), dynamic.getBillid()});
            });
            this.fillAsstSourceFields(bills, nodeId, types);
            model.batchCreateNewEntryRow(STANDARDENTRY, vs);
            TableValueSetter vs1 = new TableValueSetter(new String[0]);
            vs1.addField(HIDENENTITYID, new Object[0]);
            vs1.addField(HIDENENTITYNUMBER, new Object[0]);
            vs1.addField(HIDENENTITYNAME, new Object[0]);
            vs1.addField(HIDENENTITYTYPE, new Object[0]);
            list.stream().filter(a -> nodeId.equals(a.getAsstacttypeid() + "")).forEach(dynamic -> {
                entityNameBuffer.append(dynamic.getBilltypename()).append(",");
                vs1.addRow(new Object[]{dynamic.getBillid(), dynamic.getBillno(), dynamic.getBilltypename(), dynamic.getBilltype()});
            });
            model.batchCreateNewEntryRow(HIDENENTRY, vs1);
            model.endInit();
            aiStandard.setList(list);
            this.getPageCache().put("aiStandard", SerializationUtils.toJsonString((Object)aiStandard));
        }
        if (StringUtils.isNotBlank((CharSequence)entityNameBuffer)) {
            String entityName = entityNameBuffer.toString();
            entityName = entityName.substring(0, entityName.lastIndexOf(","));
            this.getModel().setValue(BILL, (Object)entityName);
        }
        this.getPageCache().get("aiStandard");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IDataModel dataModel = this.getModel();
        Long id = (Long)this.getModel().getValue("id");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        AbstractOperate sourceOperate = (AbstractOperate)args.getSource();
        String key = sourceOperate.getOperateKey();
        if ("save".equals(key)) {
            DynamicObjectCollection hidenStandards = model.getEntryEntity(HIDENENTRY);
            ArrayList<String> billList = new ArrayList<String>(16);
            if (id == 0L && hidenStandards != null) {
                for (DynamicObject object : hidenStandards) {
                    billList.add(object.getString(HIDENENTITYID));
                }
                String sql = "";
                ArrayList<String> allList = new ArrayList<String>(16);
                if (BillTypeEnum.BILL.getValue().equals(((DynamicObject)hidenStandards.get(0)).get(HIDENENTITYTYPE))) {
                    sql = "select fbasedataid baseid from t_ai_morebilltype";
                } else if (BillTypeEnum.EVENT.getValue().equals(((DynamicObject)hidenStandards.get(0)).get(HIDENENTITYTYPE))) {
                    sql = "select fbasedataid baseid from t_ai_moreeventtype";
                } else {
                    args.setCancel(true);
                    return;
                }
                DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.AiStandardeventEdit", (DBRoute)DBRoute.of((String)"ai"), (String)sql);
                Iterator iterator = null;
                try {
                    for (Row row : queryDataSet) {
                        String baseid = row.getString("baseid");
                        allList.add(baseid);
                    }
                }
                catch (Throwable iterator2) {
                    iterator = iterator2;
                    throw iterator2;
                }
                finally {
                    if (queryDataSet != null) {
                        if (iterator != null) {
                            try {
                                queryDataSet.close();
                            }
                            catch (Throwable iterator2) {
                                ((Throwable)((Object)iterator)).addSuppressed(iterator2);
                            }
                        } else {
                            queryDataSet.close();
                        }
                    }
                }
                if (!allList.isEmpty()) {
                    HashSet allSet = new HashSet(allList);
                    for (String s : billList) {
                        if (!allSet.contains(s)) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AiStandardeventEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
            }
            AiStandard aiStandard = null;
            DynamicObjectCollection standards = model.getEntryEntity(STANDARDENTRY);
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get("aiStandard"))) {
                aiStandard = new AiStandard();
                ArrayList<AiStandardProperty> newList = new ArrayList<AiStandardProperty>(standards.size());
                for (DynamicObject object : standards) {
                    AiStandardProperty aiProperty = new AiStandardProperty();
                    aiProperty.setAsstacttypeid((Long)object.get("asstacttypeid.id"));
                    aiProperty.setBillno((String)object.get(BILLNO));
                    aiProperty.setBilltypename((String)object.get(BILLTYPENAME));
                    aiProperty.setExpdesc((String)object.get(EXPDESC));
                    aiProperty.setExp((String)object.get(EXP));
                    aiProperty.setFullfield((String)object.get(FULLFIELD));
                    aiProperty.setBilltype((String)object.get(ENTITYBILLTYPE));
                    aiProperty.setBillid((String)object.get(BILLID));
                    String field = (String)object.get(FIELD);
                    if (StringUtils.isNotBlank((CharSequence)field)) {
                        String[] strs;
                        if (field.contains(aiProperty.getBillno() + ".") && (strs = field.split(aiProperty.getBillno() + ".")).length > 1) {
                            field = strs[1];
                        }
                        aiProperty.setField(field);
                    }
                    newList.add(aiProperty);
                }
                aiStandard.setList(newList);
                this.getPageCache().put("aiStandard", SerializationUtils.toJsonString((Object)aiStandard));
                this.getPageCache().put("create", SerializationUtils.toJsonString(newList));
            } else {
                aiStandard = (AiStandard)SerializationUtils.fromJsonString((String)this.getPageCache().get("aiStandard"), AiStandard.class);
                List<AiStandardProperty> list = aiStandard.getList();
                ArrayList<AiStandardProperty> newList = new ArrayList<AiStandardProperty>(standards.size());
                HashMap<String, AiStandardProperty> map = new HashMap<String, AiStandardProperty>();
                for (AiStandardProperty ai : list) {
                    map.put(ai.getAsstacttypeid() + ai.getBillno(), ai);
                }
                int[] index = new int[standards.size()];
                for (int i = 0; i < standards.size(); ++i) {
                    index[i] = i;
                    String rowFields = (String)model.getValue(ROWFIELD, i);
                    String fullfield = (String)model.getValue(FULLFIELD, i);
                    DynamicObject object = (DynamicObject)model.getValue(ASSTACTTYPEID, i);
                    Long asstacttypeid = object.getLong("id");
                    if (StringUtils.isBlank((CharSequence)rowFields)) {
                        if (BillTypeEnum.BILL.getValue().equals((String)((DynamicObject)standards.get(i)).get(ENTITYBILLTYPE))) {
                            rowFields = this.fillAsstSourceFieldsByRow((String)model.getValue(BILLNO, i), asstacttypeid + "", (String)((DynamicObject)standards.get(i)).get(ENTITYBILLTYPE)).toString();
                        } else if (BillTypeEnum.EVENT.getValue().equals((String)((DynamicObject)standards.get(i)).get(ENTITYBILLTYPE))) {
                            rowFields = this.fillAsstSourceFieldsByRow((String)model.getValue(BILLID, i), asstacttypeid + "", (String)((DynamicObject)standards.get(i)).get(ENTITYBILLTYPE)).toString();
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)fullfield) && StringUtils.isNotBlank((CharSequence)rowFields) && !rowFields.contains(fullfield)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7b2c\u201c%1$s\u201d\u884c\u6570\u636e\uff0c\u5b57\u6bb5\u53d6\u503c\u6765\u6e90\u9700\u53d6\u503c\u81ea\u5355\u636e\u201c%2$s\u201d\u3002", (String)"AiStandardeventEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), i + 1, (String)model.getValue(BILLTYPENAME, i)));
                        args.setCancel(true);
                        return;
                    }
                    AiStandardProperty aiProperty = new AiStandardProperty();
                    aiProperty.setAsstacttypeid(asstacttypeid);
                    aiProperty.setBillno((String)model.getValue(BILLNO, i));
                    aiProperty.setBilltypename((String)model.getValue(BILLTYPENAME, i));
                    aiProperty.setExpdesc((String)model.getValue(EXPDESC, i));
                    aiProperty.setExp((String)model.getValue(EXP, i));
                    aiProperty.setFullfield((String)model.getValue(FULLFIELD, i));
                    aiProperty.setBilltype((String)model.getValue(ENTITYBILLTYPE, i));
                    aiProperty.setBillid((String)model.getValue(BILLID, i));
                    String field = (String)model.getValue(FULLFIELD, i);
                    if (StringUtils.isNotBlank((CharSequence)field)) {
                        String[] strs;
                        if (field.contains(aiProperty.getBillno() + ".") && (strs = field.split(aiProperty.getBillno() + ".")).length > 1) {
                            field = strs[1];
                        }
                        aiProperty.setField(field);
                    }
                    if (map.containsKey(aiProperty.getAsstacttypeid() + aiProperty.getBillno())) {
                        list.remove(map.get(aiProperty.getAsstacttypeid() + aiProperty.getBillno()));
                    }
                    list.add(aiProperty);
                    newList.add(aiProperty);
                }
                aiStandard.setList(list);
                this.getPageCache().put("aiStandard", SerializationUtils.toJsonString((Object)aiStandard));
                this.getPageCache().put("create", SerializationUtils.toJsonString(newList));
                model.deleteEntryRows(STANDARDENTRY, index);
                model.deleteEntryRows(HIDENENTRY, index);
                if (list != null && list.size() > 0) {
                    model.beginInit();
                    TableValueSetter vs = new TableValueSetter(new String[0]);
                    vs.addField(ASSTACTTYPEID, new Object[0]);
                    vs.addField(BILLNO, new Object[0]);
                    vs.addField(BILLTYPENAME, new Object[0]);
                    vs.addField(FULLFIELD, new Object[0]);
                    vs.addField(FIELD, new Object[0]);
                    vs.addField(EXPDESC, new Object[0]);
                    vs.addField(EXP, new Object[0]);
                    vs.addField(ENTITYBILLTYPE, new Object[0]);
                    vs.addField(BILLID, new Object[0]);
                    list.stream().forEach(dynamic -> vs.addRow(new Object[]{dynamic.getAsstacttypeid(), dynamic.getBillno(), dynamic.getBilltypename(), dynamic.getFullfield(), dynamic.getField(), dynamic.getExpdesc(), dynamic.getExp(), dynamic.getBilltype(), dynamic.getBillid()}));
                    model.batchCreateNewEntryRow(STANDARDENTRY, vs);
                    model.endInit();
                }
            }
        } else if ("close".equals(key)) {
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView treev = (TreeView)this.getControl("treeviewap");
        treev.addNode(this.getRoot());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        DynamicObjectCollection standards = model.getEntryEntity(STANDARDENTRY);
        if (standards != null && standards.size() > 0) {
            int[] index = new int[standards.size()];
            for (int i = 0; i < standards.size(); ++i) {
                index[i] = i;
            }
            model.deleteEntryRows(STANDARDENTRY, index);
        }
        String entry = this.getPageCache().get("create");
        this.getPageCache().remove("create");
        List list = SerializationUtils.fromJsonStringToList((String)entry, AiStandardProperty.class);
        if (list != null && list.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(ASSTACTTYPEID, new Object[0]);
            vs.addField(BILLNO, new Object[0]);
            vs.addField(BILLTYPENAME, new Object[0]);
            vs.addField(FULLFIELD, new Object[0]);
            vs.addField(FIELD, new Object[0]);
            vs.addField(EXPDESC, new Object[0]);
            vs.addField(EXP, new Object[0]);
            vs.addField(ENTITYBILLTYPE, new Object[0]);
            vs.addField(BILLID, new Object[0]);
            list.stream().forEach(dynamic -> vs.addRow(new Object[]{dynamic.getAsstacttypeid(), dynamic.getBillno(), dynamic.getBilltypename(), dynamic.getFullfield(), dynamic.getField(), dynamic.getExpdesc(), dynamic.getExp(), dynamic.getBilltype(), dynamic.getBillid()}));
            model.batchCreateNewEntryRow(STANDARDENTRY, vs);
            TableValueSetter vs1 = new TableValueSetter(new String[0]);
            vs1.addField(HIDENENTITYID, new Object[0]);
            vs1.addField(HIDENENTITYNUMBER, new Object[0]);
            vs1.addField(HIDENENTITYNAME, new Object[0]);
            vs1.addField(HIDENENTITYTYPE, new Object[0]);
            list.stream().forEach(dynamic -> vs1.addRow(new Object[]{dynamic.getBillid(), dynamic.getBillno(), dynamic.getBilltypename(), dynamic.getBilltype()}));
            model.batchCreateNewEntryRow(HIDENENTRY, vs1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(STANDARDENTRY);
        String nodeId = this.getPageCache().get("nodeId");
        TreeView treev = (TreeView)this.getControl("treeviewap");
        AiStandard aiStandard = null;
        List<AiStandardProperty> listStandard = new ArrayList<AiStandardProperty>();
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("aiStandard"))) {
            aiStandard = (AiStandard)SerializationUtils.fromJsonString((String)this.getPageCache().get("aiStandard"), AiStandard.class);
            listStandard = aiStandard.getList();
        }
        if (ASSTACTTYPE.equals(name)) {
            DynamicObjectCollection asstacttypes = (DynamicObjectCollection)model.getValue(ASSTACTTYPE);
            HashMap<String, DynamicObject> map1 = new HashMap<String, DynamicObject>(16);
            for (DynamicObject asstacttype : asstacttypes) {
                map1.put(asstacttype.getString("fbasedataid.id"), asstacttype);
            }
            TreeNode node = this.getRoot();
            treev.addNode(node);
            treev.updateNode(node);
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                nodeId = ((DynamicObject)asstacttypes.get(0)).getString("fbasedataid.id");
            }
            treev.focusNode(node.getTreeNode(nodeId));
            this.getPageCache().put("lastNodeId", treev.getTreeState().getFocusNodeId());
            if (listStandard != null && listStandard.size() > 0) {
                HashMap<String, DynamicObject> newAddAssMap = new HashMap<String, DynamicObject>(map1);
                for (int i = listStandard.size() - 1; i >= 0; --i) {
                    String key = listStandard.get(i).getAsstacttypeid() + "";
                    if (!map1.containsKey(key)) {
                        listStandard.remove(i);
                        continue;
                    }
                    newAddAssMap.remove(key);
                }
                LinkedList newStdProps = new LinkedList();
                DynamicObjectCollection hiddenEntry = this.getModel().getEntryEntity(HIDENENTRY);
                newAddAssMap.forEach((bdId, asst) -> hiddenEntry.forEach(row -> {
                    String type = row.getString(HIDENENTITYTYPE);
                    String billNo = row.getString(HIDENENTITYNUMBER);
                    String billName = row.getString(HIDENENTITYNAME);
                    String billId = row.getString(HIDENENTITYID);
                    AiStandardProperty aiProperty = new AiStandardProperty();
                    aiProperty.setAsstacttypeid(asst.getLong("fbasedataid.id"));
                    aiProperty.setBillno(billNo);
                    aiProperty.setBilltypename(billName);
                    aiProperty.setExpdesc(null);
                    aiProperty.setExp(null);
                    aiProperty.setFullfield(null);
                    aiProperty.setField(null);
                    aiProperty.setBilltype(type);
                    aiProperty.setBillid(billId);
                    newStdProps.add(aiProperty);
                }));
                listStandard.addAll(newStdProps);
                this.getPageCache().put("aiStandard", SerializationUtils.toJsonString((Object)aiStandard));
            }
            this.setModels(listStandard, nodeId, model);
        } else if (BILLTYPE.equals(name)) {
            this.updateCache(listStandard, model, aiStandard);
        } else if (EVENTTYPE.equals(name)) {
            this.updateCache(listStandard, model, aiStandard);
        } else if (BILL.equals(name)) {
            if (StringUtils.isBlank((Object)model.getValue(BILL))) {
                model.setValue(BILLTYPE, (Object)"");
                model.setValue(EVENTTYPE, (Object)"");
                DynamicObjectCollection standards = model.getEntryEntity(STANDARDENTRY);
                if (standards != null && standards.size() > 0) {
                    int[] args = new int[standards.size()];
                    for (int i = 0; i < standards.size(); ++i) {
                        args[i] = i;
                    }
                    model.deleteEntryRows(STANDARDENTRY, args);
                    model.deleteEntryRows(HIDENENTRY, args);
                }
            }
            DynamicObjectCollection asstacttypes = (DynamicObjectCollection)model.getValue(ASSTACTTYPE);
            TreeNode node = this.getRoot();
            treev.addNode(node);
            treev.updateNode(node);
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                nodeId = ((DynamicObject)asstacttypes.get(0)).getString("fbasedataid.id");
            }
            treev.focusNode(node.getTreeNode(nodeId));
            this.setModels(listStandard, nodeId, model);
        } else if (EXP.equals(name)) {
            if (StringUtils.isNotBlank((Object)model.getValue(EXP, rowIndex))) {
                model.setValue(FULLFIELD, (Object)"", rowIndex);
                model.setValue(FIELD, (Object)"", rowIndex);
            }
        } else if (EXPDESC.equals(name)) {
            if (StringUtils.isBlank((Object)model.getValue(EXPDESC, rowIndex))) {
                model.setValue(EXP, (Object)"", rowIndex);
                model.setValue(FIELD, (Object)"", rowIndex);
            }
        } else if (FULLFIELD.equals(name)) {
            String[] strs;
            model.setValue(EXP, (Object)"", rowIndex);
            model.setValue(EXPDESC, (Object)"", rowIndex);
            String field = (String)model.getValue(FULLFIELD, rowIndex);
            if (StringUtils.isNotBlank((CharSequence)field) && field.contains(model.getValue(BILLNO, rowIndex) + ".") && (strs = field.split(model.getValue(BILLNO, rowIndex) + ".")).length > 1) {
                field = strs[1];
            }
            model.setValue(FIELD, (Object)field, rowIndex);
        }
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        TreeView treev = (TreeView)this.getControl("treeviewap");
        if (EXPDESC.equals(key)) {
            if (ASSTACTTYPEID.equals(treev.getTreeState().getFocusNodeId())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u8bf7\u9009\u62e9\u5b50\u8282\u70b9\u3002", (String)"AiStandardeventEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(STANDARDENTRY);
            String no = (String)this.getModel().getValue(BILLNO, rowIndex);
            String id = (String)this.getModel().getValue(BILLID, rowIndex);
            String type = (String)this.getModel().getValue(ENTITYBILLTYPE, rowIndex);
            if (BillTypeEnum.EVENT.getValue().equals(type)) {
                this.showFormulaForm(STANDARDENTRY, EXP, EXPDESC, null, id, type);
            } else if (BillTypeEnum.BILL.getValue().equals(type)) {
                this.showFormulaForm(STANDARDENTRY, EXP, EXPDESC, null, no, type);
            }
        } else if (BILL.equals(key)) {
            DynamicObjectCollection types = (DynamicObjectCollection)this.getModel().getValue(ASSTACTTYPE);
            if (types == null || types.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7ef4\u5ea6\u3002", (String)"AiStandardeventEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showBillsList();
        }
    }

    private void showBillsList() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_billslistf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection entryentityhides = this.getModel().getEntryEntity(HIDENENTRY);
        if (entryentityhides.size() != 0) {
            HashMap<String, BillType> billTypeInfoMap = new HashMap<String, BillType>();
            BillType billType = null;
            for (DynamicObject dyn : entryentityhides) {
                billType = new BillType();
                billType.setId(dyn.getString(HIDENENTITYID));
                billType.setName(dyn.getString(HIDENENTITYNAME));
                billType.setNumber(dyn.getString(HIDENENTITYNUMBER));
                billType.setType(dyn.getString(HIDENENTITYTYPE));
                billTypeInfoMap.put(dyn.getString(HIDENENTITYID), billType);
            }
            if (!billTypeInfoMap.isEmpty()) {
                showParameter.setCustomParam("baseInfo", (Object)GLUtil.toSerializedString(billTypeInfoMap));
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ai_billslistf7");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private TreeNode getRoot() {
        TreeNode root = new TreeNode();
        root.setId(ASSTACTTYPEID);
        root.setIsOpened(true);
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6", (String)"AiStandardeventEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection asstacttypes = (DynamicObjectCollection)this.getModel().getValue(ASSTACTTYPE);
        if (asstacttypes != null && asstacttypes.size() > 0) {
            for (int i = 0; i < asstacttypes.size(); ++i) {
                TreeNode node = new TreeNode();
                node.setId(((DynamicObject)asstacttypes.get(i)).getLong("fbasedataid.id") + "");
                if (i == 0) {
                    this.getPageCache().remove("firstid");
                    this.getPageCache().put("firstid", ((DynamicObject)asstacttypes.get(i)).getLong("fbasedataid.id") + "");
                }
                node.setText(((DynamicObject)asstacttypes.get(i)).getString("fbasedataid.name"));
                root.addChild(node);
            }
        }
        return root;
    }

    protected void showFormulaForm(String entityKey, String expressionFldKey, String sourceCtrlKey, String fieldNodes, String sourceBill, String type) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_formula");
        String expression = (String)this.getModel().getValue(expressionFldKey);
        String descFldValue = (String)this.getModel().getValue(sourceCtrlKey);
        VchTplExpression exprObj = new VchTplExpression();
        exprObj.setExprType(ExpressionType.Formula);
        exprObj.setExpression(expression);
        LocaleString description = new LocaleString();
        description.put(Lang.defaultLang().toString(), (Object)descFldValue);
        exprObj.setDescription(description);
        String formulaJson = SerializationUtils.toJsonString((Object)exprObj);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_vchacct-faccountdesc");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("srcMainEntityType", "AiStandardeventEdit");
        showParameter.getCustomParams().put("build", sourceBill);
        showParameter.getCustomParams().put(HIDENENTITYNUMBER, sourceBill);
        if (BillTypeEnum.EVENT.getValue().equals(type)) {
            showParameter.getCustomParams().put("event", "true");
        }
        if (BillTypeEnum.BILL.getValue().equals(type)) {
            String funcsXML = this.getPageCache().get("functiontypes");
            if (StringUtils.isBlank((CharSequence)funcsXML)) {
                FunctionTypes functionTypes = DapFunctionTypes.get();
                funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
                this.getPageCache().put("functiontypes", funcsXML);
            }
            showParameter.getCustomParams().put("functiontypes", funcsXML);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, descFldValue));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("ai_billslistf7".equals(closedCallBackEvent.getActionId())) {
            List list = (List)closedCallBackEvent.getReturnData();
            if (list != null) {
                this.genBills(list);
            }
        } else {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(STANDARDENTRY);
            if (StringUtils.isNotBlank((CharSequence)str)) {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)str, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(EXP, (Object)filterObj.getExpression(), row);
                this.getModel().setValue(EXPDESC, (Object)desp, row);
                this.getModel().setValue(EXP, (Object)filterObj.getExpression(), row);
                this.getModel().setValue(FULLFIELD, (Object)"", row);
            }
        }
    }

    private void genBills(List<Map<String, String>> list) {
        String entityName = "";
        DynamicObjectCollection bills = new DynamicObjectCollection();
        DynamicObjectCollection events = new DynamicObjectCollection();
        DynamicObjectCollection entryentityhidens = this.getModel().getEntryEntity(HIDENENTRY);
        if (entryentityhidens != null && entryentityhidens.size() > 0) {
            int[] args = new int[entryentityhidens.size()];
            for (int i = 0; i < entryentityhidens.size(); ++i) {
                args[i] = i;
            }
            this.getModel().deleteEntryRows(HIDENENTRY, args);
            this.getModel().deleteEntryRows(STANDARDENTRY, args);
            this.getModel().setValue(BILL, (Object)"");
        }
        int rowIndex = 0;
        if (list != null && list.size() > 0) {
            this.getModel().batchCreateNewEntryRow(HIDENENTRY, list.size());
            for (Map<String, String> map : list) {
                this.getModel().setValue(HIDENENTITYID, (Object)map.get("id"), rowIndex);
                this.getModel().setValue(HIDENENTITYNUMBER, (Object)map.get("number"), rowIndex);
                this.getModel().setValue(HIDENENTITYNAME, (Object)map.get("name"), rowIndex);
                this.getModel().setValue(HIDENENTITYTYPE, (Object)map.get("type"), rowIndex);
                if (BillTypeEnum.BILL.getValue().equals(map.get("type"))) {
                    DynamicObject billObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_entityobject"));
                    billObject.set("id", (Object)map.get("id"));
                    billObject.set("number", (Object)map.get("number"));
                    bills.add((Object)billObject);
                    entityName = entityName + map.get("name") + ",";
                } else if (BillTypeEnum.EVENT.getValue().equals(map.get("type"))) {
                    DynamicObject eventObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ai_eventclass"));
                    eventObject.set("id", (Object)map.get("id"));
                    eventObject.set("number", (Object)map.get("number"));
                    events.add((Object)eventObject);
                    entityName = entityName + map.get("name") + ",";
                }
                ++rowIndex;
            }
            if (StringUtils.isNotBlank((CharSequence)entityName)) {
                if (entityName.length() > 2000) {
                    entityName = entityName.substring(0, 2000);
                }
                entityName = entityName.substring(0, entityName.lastIndexOf(","));
            }
            if (!bills.isEmpty()) {
                this.getModel().setValue(BILLTYPE, (Object)bills);
            }
            if (!events.isEmpty()) {
                this.getModel().setValue(EVENTTYPE, (Object)events);
            }
            this.getModel().setValue(BILL, (Object)entityName);
        }
    }

    private List<String> fillAsstSourceFieldsByRow(String sourceBill, String id, String type) {
        ArrayList<String> list = new ArrayList<String>(16);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ai_asstacttype");
        String dataType = (String)dynamicObject.get("datatype");
        MainEntityType srcMainEntityType = null;
        List<Object> items = new ArrayList(16);
        if (AssistantTypeEnum.ASSIST.getValue().equals(dataType) || AssistantTypeEnum.BASIC.getValue().equals(dataType)) {
            HashSet<String> entityIds = this.getAsstEntityIds(id);
            if (BillTypeEnum.BILL.getValue().equals(type)) {
                srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
                items = this.buildPropComboItems(entityIds, srcMainEntityType, null, sourceBill);
            } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBill));
                items = this.buildPropComboItems(entityIds, srcMainEntityType, null, srcMainEntityType.getName());
            }
        } else if (AssistantTypeEnum.NUMBER.getValue().equals(dataType)) {
            if (BillTypeEnum.BILL.getValue().equals(type)) {
                srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBill));
            }
            items.addAll(this.getItems(DecimalProp.class, srcMainEntityType));
        } else if (AssistantTypeEnum.DATE.getValue().equals(dataType)) {
            if (BillTypeEnum.BILL.getValue().equals(type)) {
                srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBill));
            }
            items.addAll(this.getItems(DateTimeProp.class, srcMainEntityType));
        } else if (AssistantTypeEnum.BOOLEAN.getValue().equals(dataType)) {
            if (BillTypeEnum.BILL.getValue().equals(type)) {
                srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
            } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBill));
            }
            items.addAll(this.getItems(BooleanProp.class, srcMainEntityType));
        }
        if (items != null && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                String value = ((ComboItem)items.get(i)).getValue();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                list.add(value);
            }
        }
        return list;
    }

    private void fillAsstSourceFields(List<String> sourceBills, String id, String type) {
        ArrayList items = new ArrayList(16);
        MainEntityType srcMainEntityType = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ai_asstacttype");
        String dataType = (String)dynamicObject.get("datatype");
        if (AssistantTypeEnum.ASSIST.getValue().equals(dataType) || AssistantTypeEnum.BASIC.getValue().equals(dataType)) {
            HashSet<String> entityIds = this.getAsstEntityIds(id);
            if (sourceBills != null && sourceBills.size() > 0) {
                for (int i = 0; i < sourceBills.size(); ++i) {
                    List<Object> itemsTmp;
                    if (BillTypeEnum.BILL.getValue().equals(type)) {
                        srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBills.get(i));
                        itemsTmp = new ArrayList(16);
                        String sourceBillname = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceBills.get(i), (String)"bos_entityobject").getString("name");
                        itemsTmp = this.buildPropComboItems(entityIds, srcMainEntityType, sourceBillname, sourceBills.get(i));
                        items.addAll(itemsTmp);
                        continue;
                    }
                    if (!BillTypeEnum.EVENT.getValue().equals(type)) continue;
                    srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBills.get(i)));
                    itemsTmp = new ArrayList(16);
                    ArrayList<QFilter> qfList = new ArrayList<QFilter>();
                    QFilter qf = new QFilter("id", "=", (Object)Long.parseLong(sourceBills.get(i)));
                    qfList.add(qf);
                    DynamicObject object = QueryServiceHelper.queryOne((String)"ai_eventclass", (String)"name", (QFilter[])qfList.toArray(new QFilter[qfList.size()]));
                    if (object == null) continue;
                    String sourceBillname = object.getString("name");
                    itemsTmp = this.buildPropComboItems(entityIds, srcMainEntityType, sourceBillname, srcMainEntityType.getName());
                    items.addAll(itemsTmp);
                }
            }
        } else if (AssistantTypeEnum.NUMBER.getValue().equals(dataType)) {
            if (sourceBills != null && sourceBills.size() > 0) {
                for (int i = 0; i < sourceBills.size(); ++i) {
                    if (BillTypeEnum.BILL.getValue().equals(type)) {
                        srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBills.get(i));
                    } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                        srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBills.get(i)));
                    }
                    items.addAll(this.getItems(DecimalProp.class, srcMainEntityType));
                }
            }
        } else if (AssistantTypeEnum.DATE.getValue().equals(dataType)) {
            if (sourceBills != null && sourceBills.size() > 0) {
                for (int i = 0; i < sourceBills.size(); ++i) {
                    if (BillTypeEnum.BILL.getValue().equals(type)) {
                        srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBills.get(i));
                    } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                        srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBills.get(i)));
                    }
                    items.addAll(this.getItems(DateTimeProp.class, srcMainEntityType));
                }
            }
        } else if (AssistantTypeEnum.BOOLEAN.getValue().equals(dataType) && sourceBills != null && sourceBills.size() > 0) {
            for (int i = 0; i < sourceBills.size(); ++i) {
                if (BillTypeEnum.BILL.getValue().equals(type)) {
                    srcMainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBills.get(i));
                } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                    srcMainEntityType = AiEventMetaUtil.getEntityType((Object)Long.parseLong(sourceBills.get(i)));
                }
                items.addAll(this.getItems(BooleanProp.class, srcMainEntityType));
            }
        }
        ComboEdit fieldEditor = (ComboEdit)this.getControl(FULLFIELD);
        fieldEditor.setComboItems(items);
    }

    protected HashSet<String> getAsstEntityIds(String id) {
        HashSet<String> entityIds = new HashSet<String>();
        DynamicObjectCollection asstacttypes = (DynamicObjectCollection)this.getModel().getValue(ASSTACTTYPE);
        DynamicObject asstItem = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            for (int i = 0; i < asstacttypes.size(); ++i) {
                if (!id.equals(((DynamicObject)asstacttypes.get(i)).getString("fbasedataid.id"))) continue;
                asstItem = (DynamicObject)asstacttypes.get(i);
            }
        }
        if (asstItem != null) {
            Object valueSource = asstItem.get("fbasedataid.valuesource");
            if (StringUtils.isBlank((Object)valueSource)) {
                entityIds.add("bos_assistantdata_detail");
            }
            if (valueSource instanceof DynamicObject) {
                DynamicObject typeSource = asstItem.getDynamicObject("fbasedataid.valuesource");
                if (StringUtils.isBlank((Object)typeSource)) {
                    typeSource = asstItem.getDynamicObject("fbasedataid.assistanttype");
                }
                if (typeSource != null) {
                    String number = typeSource.getString("number");
                    entityIds.add(number);
                    if ("bos_adminorg".equals(number)) {
                        entityIds.add("bos_org");
                    }
                }
            }
        }
        return entityIds;
    }

    private List<ComboItem> buildPropComboItems(Set<String> entityIds, MainEntityType srcMainEntityType, String parentName, String parentKey) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        this.searchBDField(entityIds, (EntityType)srcMainEntityType, items, parentName, parentKey, true, true);
        this.searchBDFieldSecond(entityIds, (EntityType)srcMainEntityType, items, null, null, true, true);
        return items;
    }

    private void searchBDFieldSecond(Set<String> entityIds, EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry) {
        if (entityType instanceof BillEntityType) {
            this.getPageCache().put("parentName", entityType.getDisplayName() + "");
        }
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (!(prop instanceof EntryProp)) continue;
            EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
            String parentNameSub = null;
            parentNameSub = StringUtils.isNotBlank((CharSequence)this.getPageCache().get("parentName")) ? this.getPageCache().get("parentName") + "." + subEntityType.getDisplayName().toString() : subEntityType.getDisplayName().toString();
            this.searchBDField(entityIds, subEntityType, items, parentNameSub, null, true, searchSubEntry);
        }
    }

    protected void searchBDField(Set<String> entityIds, EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry) {
        if (entityType instanceof BillEntityType && !(entityType instanceof BasedataEntityType)) {
            this.getPageCache().put("parentName", entityType.getDisplayName() + "");
        }
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String parentNameNext;
            if ("id".equals(prop.getName()) && searchSubEntry && parentKey != null) {
                this.getPageCache().put("parentKey", parentKey + ".");
            }
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                String parentKeySub = null;
                String parentNameSub = subEntityType.getDisplayName().toString();
                if (prop instanceof SubEntryProp) {
                    parentNameSub = parentName + "." + parentNameSub;
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                }
                this.searchBDField(entityIds, subEntityType, items, parentNameSub, parentKeySub, true, searchSubEntry);
            }
            if (!(prop instanceof BasedataProp) || !StringUtils.isNotBlank((CharSequence)prop.getAlias())) continue;
            BasedataProp bdProp = (BasedataProp)prop;
            if (StringUtils.isBlank((CharSequence)parentName)) {
                parentNameNext = bdProp.getDisplayName().toString();
            } else {
                StringBuilder sbName = new StringBuilder();
                sbName.append(parentName).append('.').append(bdProp.getDisplayName());
                parentNameNext = sbName.toString();
                if (StringUtils.isNotBlank((Object)bdProp.getDisplayName()) && !parentNameNext.contains(bdProp.getDisplayName().toString())) {
                    parentNameNext = bdProp.getDisplayName().toString() + "." + parentNameNext;
                }
            }
            if (entityIds.contains(bdProp.getBaseEntityId()) && StringUtils.isNotEmpty((CharSequence)prop.getAlias())) {
                ComboItem item = new ComboItem();
                if (parentKey != null) {
                    item.setValue(parentKey + "." + bdProp.getName());
                } else {
                    item.setValue(bdProp.getName());
                }
                if (parentName != null) {
                    item.setCaption(new LocaleString(Lang.get().toString(), parentNameNext));
                } else {
                    StringBuilder sbName = new StringBuilder();
                    sbName.append(entityType.getDisplayName()).append('.').append(bdProp.getDisplayName());
                    parentNameNext = sbName.toString();
                    item.setCaption(new LocaleString(Lang.get().toString(), parentNameNext));
                }
                if (item.getValue() == null || !StringUtils.isNotBlank((CharSequence)this.getPageCache().get("parentKey"))) continue;
                if (!"null.".equals(this.getPageCache().get("parentKey")) && !item.getValue().contains(this.getPageCache().get("parentKey"))) {
                    item.setValue(this.getPageCache().get("parentKey") + item.getValue());
                }
                items.add(item);
                continue;
            }
            if (!searchSubEntity || bdProp instanceof FlexProp) continue;
            if (bdProp instanceof AiEventProp) {
                bdProp.getName();
                DynamicObject one = QueryServiceHelper.queryOne((String)"ai_eventclass", (String)"id", (QFilter[])new QFilter("number", "=", (Object)bdProp.getComplexType().getName()).toArray());
                if (one == null) continue;
                this.searchBDField(entityIds, (EntityType)AiEventMetaUtil.getEntityType((Object)one.get("id")), items, parentNameNext, bdProp.getName(), false, false);
                continue;
            }
            this.searchBDField(entityIds, (EntityType)EntityMetadataCache.getDataEntityType((String)bdProp.getComplexType().getName()), items, parentNameNext, bdProp.getName(), false, false);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        DynamicObjectCollection entryentityhidens;
        super.treeNodeClick(evt);
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        String nodeId = (String)evt.getNodeId();
        TreeView treev = (TreeView)this.getControl("treeviewap");
        treev.getTreeState().getFocusNodeId();
        TreeNode node = this.getRoot();
        treev.addNode(node);
        String types = "";
        if (ASSTACTTYPEID.equals(nodeId)) {
            treev.updateNode(node);
            treev.focusNode(node.getTreeNode(this.getPageCache().get("lastNodeId")));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection standards = model.getEntryEntity(STANDARDENTRY);
        AiStandard aiStandard = new AiStandard();
        List<Object> list = new ArrayList();
        ArrayList<AiStandardProperty> list1 = new ArrayList<AiStandardProperty>();
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("aiStandard"))) {
            aiStandard = (AiStandard)SerializationUtils.fromJsonString((String)this.getPageCache().get("aiStandard"), AiStandard.class);
            list = aiStandard.getList();
        }
        if (standards != null && standards.size() > 0) {
            int i2;
            int[] args = new int[standards.size()];
            for (int i3 = 0; i3 < standards.size(); ++i3) {
                args[i3] = i3;
                List<Object> listRows = new ArrayList(16);
                DynamicObject asstacttype = (DynamicObject)model.getValue(ASSTACTTYPEID, i3);
                Long asstacttypeId = asstacttype.getLong("id");
                AiStandardProperty aiProperty = new AiStandardProperty();
                aiProperty.setAsstacttypeid(asstacttypeId);
                aiProperty.setBillno((String)model.getValue(BILLNO, i3));
                aiProperty.setBilltypename((String)model.getValue(BILLTYPENAME, i3));
                aiProperty.setExp((String)model.getValue(EXP, i3));
                aiProperty.setExpdesc((String)model.getValue(EXPDESC, i3));
                aiProperty.setExp((String)model.getValue(EXP, i3));
                aiProperty.setFullfield((String)model.getValue(FULLFIELD, i3));
                aiProperty.setBillid((String)model.getValue(BILLID, i3));
                aiProperty.setBilltype((String)model.getValue(ENTITYBILLTYPE, i3));
                String field = (String)model.getValue(FULLFIELD, i3);
                if (StringUtils.isNotBlank((CharSequence)field)) {
                    String[] strs;
                    if (field.contains(aiProperty.getBillno() + ".") && (strs = field.split(aiProperty.getBillno() + ".")).length > 1) {
                        field = strs[1];
                    }
                    aiProperty.setField(field);
                }
                if (BillTypeEnum.BILL.getValue().equals((String)model.getValue(HIDENENTITYTYPE, i3))) {
                    listRows = this.fillAsstSourceFieldsByRow((String)model.getValue(BILLNO, i3), asstacttypeId + "", (String)model.getValue(HIDENENTITYTYPE, i3));
                    aiProperty.setRowfield(listRows.toString());
                } else if (BillTypeEnum.EVENT.getValue().equals((String)model.getValue(HIDENENTITYTYPE, i3))) {
                    listRows = this.fillAsstSourceFieldsByRow((String)model.getValue(BILLID, i3), asstacttypeId + "", (String)model.getValue(HIDENENTITYTYPE, i3));
                    aiProperty.setRowfield(listRows.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)aiProperty.getRowfield()) && StringUtils.isNotBlank((CharSequence)aiProperty.getFullfield()) && !aiProperty.getRowfield().contains(aiProperty.getFullfield())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7b2c\u201c%1$s\u201d\u884c\u6570\u636e\uff0c\u5b57\u6bb5\u53d6\u503c\u6765\u6e90\u9700\u53d6\u503c\u81ea\u5355\u636e\u201c%2$s\u201d\u3002", (String)"AiStandardeventEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), i3 + 1, aiProperty.getBilltypename()));
                    treev.updateNode(node);
                    treev.focusNode(node.getTreeNode(asstacttypeId + ""));
                    evt.setCancel(true);
                    return;
                }
                list1.add(aiProperty);
            }
            HashMap<String, String> map = new HashMap<String, String>(list1.size());
            for (i2 = 0; i2 < list1.size(); ++i2) {
                map.put(((AiStandardProperty)list1.get(i2)).getAsstacttypeid() + ((AiStandardProperty)list1.get(i2)).getBillno(), ((AiStandardProperty)list1.get(i2)).getBillno());
            }
            if (map != null && map.size() > 0) {
                for (i2 = list.size() - 1; i2 >= 0; --i2) {
                    if (!map.containsKey(((AiStandardProperty)list.get(i2)).getAsstacttypeid() + ((AiStandardProperty)list.get(i2)).getBillno())) continue;
                    list.remove(i2);
                }
            }
            list.addAll(list1);
            aiStandard.setList(list);
            dataModel.deleteEntryRows(STANDARDENTRY, args);
        }
        if ((entryentityhidens = model.getEntryEntity(HIDENENTRY)) != null && entryentityhidens.size() > 0) {
            types = (String)((DynamicObject)entryentityhidens.get(0)).get(HIDENENTITYTYPE);
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(ASSTACTTYPEID, new Object[0]);
            vs.addField(BILLNO, new Object[0]);
            vs.addField(BILLTYPENAME, new Object[0]);
            vs.addField(FULLFIELD, new Object[0]);
            vs.addField(FIELD, new Object[0]);
            vs.addField(ROWFIELD, new Object[0]);
            vs.addField(EXPDESC, new Object[0]);
            vs.addField(EXP, new Object[0]);
            vs.addField(ENTITYBILLTYPE, new Object[0]);
            vs.addField(BILLID, new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i4 = 0; i4 < list.size(); ++i4) {
                if (!nodeId.equals(((AiStandardProperty)list.get(i4)).getAsstacttypeid() + "")) continue;
                map.put(((AiStandardProperty)list.get(i4)).getBillno(), list.get(i4));
            }
            ArrayList<String> bills = new ArrayList<String>(16);
            Stream.iterate(0, i -> i + 1).limit(entryentityhidens.size()).forEach(i -> {
                String type = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYTYPE);
                String billNo = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYNUMBER);
                String billName = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYNAME);
                String billId = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYID);
                if (BillTypeEnum.BILL.getValue().equals(type)) {
                    bills.add(billNo);
                } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                    bills.add(billId);
                }
                vs.addRow(new Object[]{nodeId, billNo, billName, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getFullfield() : null, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getField() : null, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getRowfield() : null, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getExpdesc() : null, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getExp() : null, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getBilltype() : type, map.get(billNo) != null ? ((AiStandardProperty)map.get(billNo)).getBillid() : billId});
            });
            this.fillAsstSourceFields(bills, nodeId, types);
            model.batchCreateNewEntryRow(STANDARDENTRY, vs);
            model.endInit();
            this.getView().updateView(STANDARDENTRY);
        }
        this.getPageCache().put("aiStandard", SerializationUtils.toJsonString((Object)aiStandard));
        this.getPageCache().put("lastNodeId", treev.getTreeState().getFocusNodeId());
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        new StandardEventHandler().beforeImporChecktData(e);
    }

    private void setModels(List<AiStandardProperty> listStandard, String nodeId, IDataModel IDatamodel) {
        DynamicObjectCollection entryentityhidens;
        DynamicObjectCollection standards;
        AbstractFormDataModel model = (AbstractFormDataModel)IDatamodel;
        HashMap<String, AiStandardProperty> map = new HashMap<String, AiStandardProperty>(16);
        String types = "";
        if (listStandard != null && listStandard.size() > 0) {
            for (AiStandardProperty property : listStandard) {
                map.put(property.getAsstacttypeid() + property.getBillno(), property);
            }
        }
        if ((standards = model.getEntryEntity(STANDARDENTRY)) != null && standards.size() > 0) {
            int[] args = new int[standards.size()];
            for (int i2 = 0; i2 < standards.size(); ++i2) {
                args[i2] = i2;
            }
            model.deleteEntryRows(STANDARDENTRY, args);
        }
        if ((entryentityhidens = model.getEntryEntity(HIDENENTRY)) != null && entryentityhidens.size() > 0) {
            types = (String)((DynamicObject)entryentityhidens.get(0)).get(HIDENENTITYTYPE);
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(ASSTACTTYPEID, new Object[0]);
            vs.addField(BILLNO, new Object[0]);
            vs.addField(BILLTYPENAME, new Object[0]);
            vs.addField(FULLFIELD, new Object[0]);
            vs.addField(FIELD, new Object[0]);
            vs.addField(ROWFIELD, new Object[0]);
            vs.addField(EXPDESC, new Object[0]);
            vs.addField(EXP, new Object[0]);
            vs.addField(ENTITYBILLTYPE, new Object[0]);
            vs.addField(BILLID, new Object[0]);
            ArrayList<String> bills = new ArrayList<String>(16);
            Stream.iterate(0, i -> i + 1).limit(entryentityhidens.size()).forEach(i -> {
                String key = nodeId + ((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYNUMBER);
                String type = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYTYPE);
                String billNo = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYNUMBER);
                String billName = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYNAME);
                String billId = (String)((DynamicObject)entryentityhidens.get(i.intValue())).get(HIDENENTITYID);
                if (BillTypeEnum.BILL.getValue().equals(type)) {
                    bills.add(billNo);
                } else if (BillTypeEnum.EVENT.getValue().equals(type)) {
                    bills.add(billId);
                }
                vs.addRow(new Object[]{nodeId, billNo, billName, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getFullfield() : null, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getField() : null, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getRowfield() : null, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getExpdesc() : null, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getExp() : null, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getBilltype() : type, map.get(key) != null ? ((AiStandardProperty)map.get(key)).getBillid() : billId});
            });
            this.fillAsstSourceFields(bills, nodeId, types);
            model.batchCreateNewEntryRow(STANDARDENTRY, vs);
            model.endInit();
            this.getView().updateView(STANDARDENTRY);
        }
    }

    private void updateCache(List<AiStandardProperty> listStandard, IDataModel model, AiStandard aiStandard) {
        if (listStandard != null && listStandard.size() > 0) {
            String billtype = listStandard.get(0).getBilltype();
            HashMap<String, DynamicObject> map1 = new HashMap<String, DynamicObject>(16);
            if (BillTypeEnum.BILL.getValue().equals(billtype)) {
                DynamicObjectCollection billtypes = (DynamicObjectCollection)model.getValue(BILLTYPE);
                for (DynamicObject type : billtypes) {
                    map1.put(type.getString("fbasedataid.id"), type);
                }
            } else if (BillTypeEnum.EVENT.getValue().equals(billtype)) {
                DynamicObjectCollection eventtypes = (DynamicObjectCollection)model.getValue(EVENTTYPE);
                for (DynamicObject type : eventtypes) {
                    map1.put(type.getString("fbasedataid.id"), type);
                }
            }
            for (int i = listStandard.size() - 1; i >= 0; --i) {
                String key = listStandard.get(i).getBillid();
                if (map1.isEmpty() || map1.containsKey(key)) continue;
                listStandard.remove(i);
            }
            this.getPageCache().put("aiStandard", SerializationUtils.toJsonString((Object)aiStandard));
        }
    }

    private List<ComboItem> getItems(Class<?> fieldType, MainEntityType srcMainEntityType) {
        String currLCId = Lang.get().toString();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainEntityType);
        option.setReadEntryEntity(true);
        option.setExprType(ExpressionType.Condition);
        option.setFieldType(fieldType);
        option.setIncludeHead(false);
        option.setAddDate(false);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        List listNodes = result.getNodes();
        if (!listNodes.isEmpty() && listNodes.size() > 1) {
            String parentName = ((TreeNode)listNodes.get(0)).getText();
            String parentNo = ((TreeNode)listNodes.get(0)).getId();
            for (TreeNode node : listNodes) {
                if (parentNo.equals(node.getId())) continue;
                ComboItem item = new ComboItem();
                item.setValue(parentNo + "." + node.getId());
                node.setText(node.getText().replace(ResManager.loadKDString((String)"\u5355\u636e\u5934.", (String)"AiStandardeventEdit_16", (String)"fi-ai-formplugin", (Object[])new Object[0]), ""));
                item.setCaption(new LocaleString(currLCId, parentName + "." + node.getText()));
                items.add(item);
            }
        }
        return items;
    }
}

