/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.constant.AsstDimConstant;
import kd.fi.ai.formplugin.DSField;
import kd.fi.ai.formplugin.MapTypeListDataProvider;
import kd.fi.ai.formplugin.service.TemplateConnectUtil;

public class AsstDimMapTypeList
extends AbstractListPlugin {
    private MapTypeListDataProvider provider = new MapTypeListDataProvider();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)this.provider);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String errMsg = this.provider.getErrMsg();
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            this.getView().showErrorNotification(errMsg);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryVals = e.getQueryValues();
        MainEntityType vchTemplateType = EntityMetadataCache.getDataEntityType((String)"ai_asstdimmaptype");
        this.setExportData(queryVals, vchTemplateType);
    }

    public void setExportData(DynamicObject[] queryVals, MainEntityType vchTemplateType) {
        for (DynamicObject queryVal : queryVals) {
            DynamicObjectCollection mapdatas = queryVal.getDynamicObjectCollection("fieldmapentry");
            ArrayList<DSField> list = new ArrayList<DSField>();
            ArrayList<Long> asstLong = new ArrayList<Long>();
            for (DynamicObject map : mapdatas) {
                DSField sd = new DSField();
                String datatype = map.getString("datatype");
                sd.setDataType(datatype);
                if ("1".equals(datatype)) {
                    asstLong.add(Long.valueOf(map.getString("entityid")));
                }
                sd.setEntityId(map.getString("entityid"));
                sd.setFieldKey(map.getString("fieldkey"));
                sd.setFieldName(new LocaleString(map.getString("fieldname")));
                list.add(sd);
            }
            Map assistantMap = new HashMap(16);
            if (asstLong != null && !asstLong.isEmpty()) {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
                filterList.add(new QFilter("id", "in", asstLong));
                assistantMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdatagroup", (String)"id,number,name", (QFilter[])filterList.toArray(new QFilter[0]));
            }
            DynamicObject asstacttype = queryVal.getDynamicObject("asstacttype");
            this.reBuildModelAndGrid(list, vchTemplateType, asstacttype);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)queryVal.get("id"), (String)"ai_asstdimmaptype");
            DynamicObjectCollection dynamicCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection factorImpEntity = queryVal.getDynamicObjectCollection("factorimport");
            for (DynamicObject dynamic : dynamicCollection) {
                DynamicObject importRow = factorImpEntity.addNew();
                int i = 0;
                DynamicObject asstBaseDyn = (DynamicObject)dynamic.get("asstfield");
                DynamicObject asstAsstDyn = (DynamicObject)dynamic.get("asstfield_asst");
                String asstText = (String)dynamic.get("asstfield_text");
                if (null != asstBaseDyn) {
                    importRow.set("asstvalue", asstBaseDyn.get("number"));
                    importRow.set("asstname", asstBaseDyn.get("name"));
                } else if (null != asstAsstDyn) {
                    importRow.set("asstvalue", asstAsstDyn.get("number"));
                    importRow.set("asstname", asstAsstDyn.get("name"));
                } else if (StringUtils.isNotBlank((CharSequence)asstText)) {
                    importRow.set("asstvalue", (Object)asstText);
                }
                for (DynamicObject map : mapdatas) {
                    DynamicObject dyn = (DynamicObject)dynamic.get(map.getString("fieldkey"));
                    String datatype = map.getString("datatype");
                    if ("1".equals(datatype)) {
                        Long entityId = map.getLong("entityid");
                        importRow.set("factornumber" + i, (Object)("[2]" + ((DynamicObject)assistantMap.get(entityId)).getString("number")));
                    }
                    if ("0".equals(datatype)) {
                        importRow.set("factornumber" + i, (Object)map.getString("entityid"));
                    }
                    if (null != dyn) {
                        importRow.set("factorvalue" + i, dyn.get("number"));
                        importRow.set("factorname" + i, dyn.get("name"));
                    }
                    ++i;
                }
            }
            mapdatas.clear();
        }
    }

    private void reBuildModelAndGrid(List<DSField> list, MainEntityType mainEntityType, DynamicObject asstacttype) {
        String entityNumber;
        String valuetype;
        BasedataProp prop;
        EntryProp entry = (EntryProp)mainEntityType.getProperty("entryentity");
        for (DSField field : list) {
            if (!"0".equals(field.getDataType())) continue;
            prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
            if ("bos_adminorg_structure".equalsIgnoreCase(field.getEntityId())) {
                prop.setBaseEntityId("bos_org");
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                continue;
            }
            prop.setBaseEntityId(field.getEntityId());
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)field.getEntityId()));
        }
        if (asstacttype != null && "1".equals(valuetype = asstacttype.getString("valuetype")) && (entityNumber = AsstDimConstant.getAsstactTypeEntityNumber((DynamicObject)asstacttype)) != null) {
            prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("asstfield");
            prop.setBaseEntityId(entityNumber);
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("tbltemplateconnect".equals(evt.getItemKey())) {
            TemplateConnectUtil templateUtil = new TemplateConnectUtil();
            templateUtil.showTemplateConnectEditView(this.getView(), this.getModel());
        }
    }
}

